/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter12Byte;

public class CharacterConverterShift
extends CharacterConverter12Byte {
    public final byte SHIFT_OUT = (byte)14;
    public final byte SHIFT_IN = (byte)15;

    public CharacterConverterShift() {
        this.m_groupId = 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 15;
        int n5 = 0;
        while (n5 < n2) {
            char c2;
            if (cArray[n5] >= '\ud800' && cArray[n5] < '\udc00') {
                if (n5 + 1 >= n2 || cArray[n5 + 1] < '\udc00' || cArray[n5 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                c2 = this.toOracleCharacterWithReplacement(cArray[n5], cArray[n5 + 1]);
                ++n5;
            } else {
                c2 = this.toOracleCharacter(cArray[n5], '\u0000');
            }
            int n6 = c2 & 0xFF00;
            if (n6 != 0) {
                if (n4 == 15) {
                    n4 = 14;
                    byArray[n3++] = 14;
                }
                byArray[n3++] = (byte)(n6 >> 8);
                byArray[n3++] = (byte)c2;
            } else {
                if (n4 == 14) {
                    n4 = 15;
                    byArray[n3++] = 15;
                }
                byArray[n3++] = (byte)c2;
            }
            ++n5;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 65535;
        int n4 = 0;
        int n5 = 15;
        int n6 = 0;
        while (n6 < n2) {
            if (cArray[n6] >= '\ud800' && cArray[n6] < '\udc00') {
                if (n6 + 1 < n2 && cArray[n6 + 1] >= '\udc00' && cArray[n6 + 1] <= '\udfff') {
                    n3 = this.toOracleCharacterWithReplacement(cArray[n6], cArray[n6 + 1]);
                    ++n6;
                } else {
                    byArray[n4++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                    byArray[n4++] = (byte)this.m_2ByteOraCharReplacement;
                }
            } else {
                n3 = this.toOracleCharacterWithReplacement(cArray[n6], '\u0000');
            }
            int n7 = n3 & 0xFF00;
            if (n7 != 0) {
                if (n5 == 15) {
                    n5 = 14;
                    byArray[n4++] = 14;
                }
                byArray[n4++] = (byte)(n7 >> 8);
                byArray[n4++] = (byte)n3;
            } else {
                if (n5 == 14) {
                    n5 = 15;
                    byArray[n4++] = 15;
                }
                byArray[n4++] = (byte)n3;
            }
            ++n6;
        }
        if (n5 == 14) {
            n5 = 15;
            byArray[n4++] = 15;
        }
        if (n4 < byArray.length) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return byArray;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        char[] cArray = new char[n3 * 2];
        int n5 = 0;
        int n6 = n2;
        int n7 = 15;
        while (n6 < n4) {
            int n8;
            int n9;
            if (byArray[n6] == 15) {
                n7 = 15;
                ++n6;
                continue;
            }
            if (byArray[n6] == 14) {
                n7 = 14;
                ++n6;
                continue;
            }
            if (n7 == 15) {
                n9 = byArray[n6] & 0xFF;
                n8 = this.toUnicode(n9);
                if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n5++] = (char)(n8 >>> 16);
                    cArray[n5++] = (char)(n8 & 0xFFFF);
                } else {
                    cArray[n5++] = (char)n8;
                }
                ++n6;
                continue;
            }
            if (n6 < n4 - 1) {
                n9 = byArray[n6] << 8 & 0xFF00 | byArray[n6 + 1] & 0xFF;
                n8 = this.toUnicode(n9);
                if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n5++] = (char)(n8 >>> 16);
                    cArray[n5++] = (char)(n8 & 0xFFFF);
                } else {
                    cArray[n5++] = (char)n8;
                }
                n6 += 2;
                continue;
            }
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return new String(cArray, 0, n5);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        char[] cArray = new char[n3 * 2];
        int n5 = 0;
        int n6 = n2;
        int n7 = 15;
        while (n6 < n4) {
            int n8;
            int n9;
            if (byArray[n6] == 15) {
                n7 = 15;
                ++n6;
                continue;
            }
            if (byArray[n6] == 14) {
                n7 = 14;
                ++n6;
                continue;
            }
            if (n7 == 15) {
                n9 = byArray[n6] & 0xFF;
                n8 = this.toUnicodeWithReplacement(n9);
                if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n5++] = (char)(n8 >>> 16);
                    cArray[n5++] = (char)(n8 & 0xFFFF);
                } else {
                    cArray[n5++] = (char)n8;
                }
                ++n6;
                continue;
            }
            if (n6 >= n4 - 1) break;
            n9 = byArray[n6] << 8 & 0xFF00 | byArray[n6 + 1] & 0xFF;
            n8 = this.toUnicodeWithReplacement(n9);
            if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                cArray[n5++] = (char)(n8 >>> 16);
                cArray[n5++] = (char)(n8 & 0xFFFF);
            } else {
                cArray[n5++] = (char)n8;
            }
            n6 += 2;
        }
        return new String(cArray, 0, n5);
    }
}

