/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public abstract class CharacterConverterLC
extends CharacterConverter {
    static final int MAX_7BIT = 127;
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int ORACHARWITHLCWIDTH = 32;
    static final int BYTEWIDTH = 8;
    static final int HIBYTEMASK = 65280;
    static final int LOWBYTEMASK = 255;
    static final int LOW16BITMASK = 65535;
    static final int BELOW_CJK = 12287;
    static final int LEADINGCODEWIDTH = 16;
    static final int LEADINGCODESHIFT = 16;
    static final int LEADINGCODEMASK = 65535;
    static final int LCINDEXWIDTH = 4;
    static final int LCINDEXMASK = 15;
    static final int LCINDEXFACTOR = 2;
    static final int MAXBYTEPERCHAR = 4;
    public char[][] m_ucsCharLeadingCode = null;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    public char[] m_oraCharLevel1 = null;
    public int[] m_oraCharLevel2 = null;
    public char[] m_oraCharSurrogateLevel = null;

    CharacterConverterLC() {
        this.m_groupId = 8;
    }

    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        int n6;
        int n7;
        Object object;
        int n8;
        this.m_oraCharLevel1 = new char[256];
        char[] cArray2 = null;
        int[] nArray = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        char c2 = '\u0000';
        char c3 = '\u0000';
        int n9 = 0;
        while (n9 < 256) {
            this.m_oraCharLevel1[n9] = 65535;
            ++n9;
        }
        int n10 = 0;
        while (n10 < this.m_ucsCharLeadingCode.length) {
            int n11 = this.m_ucsCharLeadingCode[n10][0] << 16;
            n8 = 0;
            while (n8 < 65535) {
                int n12 = this.toUnicodeWithReplacement(n11 | n8);
                if (n12 != this.m_ucsCharReplacement) {
                    object = new int[2];
                    object[0] = n12;
                    object[1] = n11 | n8;
                    vector.addElement(object);
                    this.storeMappingRange(n12, hashtable, hashtable2);
                }
                ++n8;
            }
            ++n10;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            n8 = 0;
            while (n8 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n8][0];
                this.storeMappingRange(n6, hashtable, hashtable2);
                ++n8;
            }
        }
        Enumeration enumeration = hashtable.keys();
        int n13 = 0;
        int n14 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n13 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n14 += 256;
        }
        if (n13 != 0) {
            cArray2 = new char[n13];
        }
        if (n14 != 0) {
            nArray = new int[n14];
        }
        int n15 = 0;
        while (n15 < n13) {
            cArray2[n15] = 65535;
            ++n15;
        }
        int n16 = 0;
        while (n16 < n14) {
            nArray[n16] = -1;
            ++n16;
        }
        int n17 = 0;
        while (n17 < vector.size()) {
            int[] nArray2 = (int[])vector.elementAt(n17);
            n5 = nArray2[0] >>> 24 & 0xFF;
            n4 = nArray2[0] >>> 16 & 0xFF;
            n3 = nArray2[0] >>> 8 & 0xFF;
            n2 = nArray2[0] & 0xFF;
            if (n5 >= 216 && n5 < 220) {
                if (this.m_oraCharLevel1[n5] == '\uffff') {
                    this.m_oraCharLevel1[n5] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (cArray2[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                    cArray2[this.m_oraCharLevel1[n5] + n4] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (cArray2[cArray2[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                    cArray2[cArray2[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (nArray[cArray2[cArray2[this.m_oraCharLevel1[n5] + n4] + n3] + n2] == -1) {
                    nArray[cArray2[cArray2[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = nArray2[1];
                }
            } else {
                if (this.m_oraCharLevel1[n3] == '\uffff') {
                    this.m_oraCharLevel1[n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (nArray[this.m_oraCharLevel1[n3] + n2] == -1) {
                    nArray[this.m_oraCharLevel1[n3] + n2] = nArray2[1];
                }
            }
            ++n17;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            int n18 = 0;
            while (n18 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n18][0];
                n5 = n6 >>> 24 & 0xFF;
                n4 = n6 >>> 16 & 0xFF;
                n3 = n6 >>> 8 & 0xFF;
                n2 = n6 & 0xFF;
                if (n5 >= 216 && n5 < 220) {
                    if (this.m_oraCharLevel1[n5] == '\uffff') {
                        this.m_oraCharLevel1[n5] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (cArray2[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                        cArray2[this.m_oraCharLevel1[n5] + n4] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (cArray2[cArray2[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                        cArray2[cArray2[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    nArray[cArray2[cArray2[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = this.extraUnicodeToOracleMapping[n18][1];
                } else {
                    if (this.m_oraCharLevel1[n3] == '\uffff') {
                        this.m_oraCharLevel1[n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    nArray[this.m_oraCharLevel1[n3] + n2] = this.extraUnicodeToOracleMapping[n18][1];
                }
                ++n18;
            }
        }
        this.m_oraCharLevel2 = nArray;
        this.m_oraCharSurrogateLevel = cArray2;
    }

    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        while (n2 < this.m_ucsCharLeadingCode.length) {
            char c2 = this.m_ucsCharLeadingCode[n2][0];
            int n3 = c2 << 16;
            int n4 = n3 + 65535;
            int n5 = n3;
            while (n5 <= n4) {
                try {
                    int[] nArray = new int[]{n5, this.toUnicode(n5)};
                    vector.addElement(nArray);
                }
                catch (SQLException sQLException) {}
                ++n5;
            }
            ++n2;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.extraUnicodeToOracleMapping.length) {
            vector.addElement(this.extraUnicodeToOracleMapping[n2]);
            ++n2;
        }
    }

    public char[] getLeadingCodes() {
        char[] cArray = new char[this.m_ucsCharLeadingCode.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = this.m_ucsCharLeadingCode[n2][0];
            ++n2;
        }
        return cArray;
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    int toOracleCharacter(char c2, char c3) throws SQLException {
        int n2 = -1;
        if (c3 != '\u0000') {
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = c3 >>> 8 & 0xFF;
            int n6 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6];
            }
        } else {
            int n7 = c2 >>> 8 & 0xFF;
            int n8 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n7] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8];
            }
        }
        if (n2 == -1) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return n2;
    }

    int toOracleCharacterWithReplacement(char c2, char c3) {
        int n2 = -1;
        if (c3 != '\u0000') {
            int n3 = c2 >>> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = c3 >>> 8 & 0xFF;
            int n6 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n3] + n4] + n5] + n6];
            }
        } else {
            int n7 = c2 >>> 8 & 0xFF;
            int n8 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n7] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8] != -1) {
                n2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n7] + n8];
            }
        }
        if (n2 == -1) {
            if (c2 > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 >= n2 || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                n5 = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                ++n4;
            } else {
                n5 = this.toOracleCharacter(cArray[n4], '\u0000');
            }
            if (n5 >> 24 != 0) {
                byArray[n3++] = (byte)(n5 >> 24);
                byArray[n3++] = (byte)(n5 >> 16);
                byArray[n3++] = (byte)(n5 >> 8);
                byArray[n3++] = (byte)n5;
            } else if (n5 >> 16 != 0) {
                byArray[n3++] = (byte)(n5 >> 16);
                byArray[n3++] = (byte)(n5 >> 8);
                byArray[n3++] = (byte)n5;
            } else if (n5 >> 8 != 0) {
                byArray[n3++] = (byte)(n5 >> 8);
                byArray[n3++] = (byte)n5;
            } else {
                byArray[n3++] = (byte)n5;
            }
            ++n4;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            block12: {
                int n5;
                block11: {
                    block9: {
                        block10: {
                            if (cArray[n4] < '\ud800' || cArray[n4] > '\udbff') break block9;
                            if (n4 + 1 >= n2 || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') break block10;
                            n5 = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                            ++n4;
                            break block11;
                        }
                        byArray[n3++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n3++] = (byte)this.m_2ByteOraCharReplacement;
                        break block12;
                    }
                    n5 = this.toOracleCharacterWithReplacement(cArray[n4], '\u0000');
                }
                if (n5 >> 24 != 0) {
                    byArray[n3++] = (byte)(n5 >> 24);
                    byArray[n3++] = (byte)(n5 >> 16);
                    byArray[n3++] = (byte)(n5 >> 8);
                    byArray[n3++] = (byte)n5;
                } else if (n5 >> 16 != 0) {
                    byArray[n3++] = (byte)(n5 >> 16);
                    byArray[n3++] = (byte)(n5 >> 8);
                    byArray[n3++] = (byte)n5;
                } else if (n5 >> 8 != 0) {
                    byArray[n3++] = (byte)(n5 >> 8);
                    byArray[n3++] = (byte)n5;
                } else {
                    byArray[n3++] = (byte)n5;
                }
            }
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    int toUnicode(int n2) throws SQLException {
        int n3 = 0;
        int n4 = n2 >> 16 & 0xFFFF;
        int n5 = 0;
        while (n5 < this.m_ucsCharLeadingCode.length) {
            if (n4 == this.m_ucsCharLeadingCode[n5][0]) {
                n3 = this.m_ucsCharLeadingCode[n5][1];
                break;
            }
            ++n5;
        }
        if (n5 == this.m_ucsCharLeadingCode.length) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        int n6 = (n2 >> 8 & 0xFF) + n3;
        int n7 = n2 & 0xFF;
        if (this.m_ucsCharLevel1[n6] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] == -1) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        int n8 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7];
        return n8;
    }

    int toUnicodeWithReplacement(int n2) {
        int n3 = 0;
        int n4 = n2 >> 16 & 0xFFFF;
        int n5 = 0;
        while (n5 < this.m_ucsCharLeadingCode.length) {
            if (n4 == this.m_ucsCharLeadingCode[n5][0]) {
                n3 = this.m_ucsCharLeadingCode[n5][1];
                break;
            }
            ++n5;
        }
        if (n5 == this.m_ucsCharLeadingCode.length) {
            return this.m_ucsCharReplacement;
        }
        int n6 = (n2 >> 8 & 0xFF) + n3;
        int n7 = n2 & 0xFF;
        int n8 = this.m_ucsCharLevel1[n6] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] : this.m_ucsCharReplacement;
        return n8;
    }
}

