/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter12Byte;

public class CharacterConverter2ByteFixed
extends CharacterConverter12Byte {
    public CharacterConverter2ByteFixed() {
        this.m_groupId = 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2;
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 >= n2 || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                c2 = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                ++n4;
            } else {
                c2 = this.toOracleCharacter(cArray[n4], '\u0000');
            }
            byArray[n3++] = (byte)(c2 >> 8);
            byArray[n3++] = (byte)c2;
            ++n4;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 2];
        int n3 = 65535;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            block6: {
                block5: {
                    block3: {
                        block4: {
                            if (cArray[n5] < '\ud800' || cArray[n5] >= '\udc00') break block3;
                            if (n5 + 1 >= n2 || cArray[n5 + 1] < '\udc00' || cArray[n5 + 1] > '\udfff') break block4;
                            n3 = this.toOracleCharacterWithReplacement(cArray[n5], cArray[n5 + 1]);
                            ++n5;
                            break block5;
                        }
                        byArray[n4++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n4++] = (byte)this.m_2ByteOraCharReplacement;
                        break block6;
                    }
                    n3 = this.toOracleCharacterWithReplacement(cArray[n5], '\u0000');
                }
                byArray[n4++] = (byte)(n3 >> 8);
                byArray[n4++] = (byte)n3;
            }
            ++n5;
        }
        if (n4 < byArray.length) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return byArray;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        char[] cArray = new char[n3];
        int n5 = 0;
        int n6 = n2;
        while (n6 < n4) {
            int n7 = byArray[n6] & 0xFF;
            if (n6 < n4 - 1) {
                n7 = byArray[n6] << 8 & 0xFF00 | byArray[n6 + 1] & 0xFF;
                ++n6;
            } else {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            int n8 = this.toUnicode(n7);
            if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                cArray[n5++] = (char)(n8 >>> 16);
                cArray[n5++] = (char)(n8 & 0xFFFF);
            } else {
                cArray[n5++] = (char)n8;
            }
            ++n6;
        }
        return new String(cArray, 0, n5);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        char[] cArray = new char[n3];
        int n5 = 0;
        int n6 = n2;
        int n7 = 0;
        while (n6 < n4) {
            int n8;
            n7 = byArray[n6] & 0xFF;
            if (n6 < n4 - 1) {
                n7 = byArray[n6] << 8 & 0xFF00 | byArray[n6 + 1] & 0xFF;
                ++n6;
            }
            if (((long)(n8 = this.toUnicodeWithReplacement(n7)) & 0xFFFFFFFFL) > 65535L) {
                cArray[n5++] = (char)(n8 >>> 16);
                cArray[n5++] = (char)(n8 & 0xFFFF);
            } else {
                cArray[n5++] = (char)n8;
            }
            ++n6;
        }
        return new String(cArray, 0, n5);
    }
}

