/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ArrayDescriptor;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public abstract class TypeDescriptor
implements Serializable {
    public static boolean DEBUG_SERIALIZATION = false;
    static final long serialVersionUID = 2022598722047823723L;
    SQLName m_sqlName;
    OracleNamedType m_pickler;
    transient oracle.jdbc.internal.OracleConnection m_conn;

    protected TypeDescriptor() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.TypeDescriptor(): return");
        }
    }

    protected TypeDescriptor(String name, Connection connection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.TypeDescriptor( name=" + name + ", connection=" + connection + ")"));
        }
        if (name == null || connection == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"TypeDescriptor.TypeDescriptor: Invalid arguments, 'name' should not be an empty string and conn should not be null. An exception is thrown.");
            }
            DBError.check_error((int)60, (Object)"Invalid arguments");
        }
        this.setPhysicalConnectionOf(connection);
        this.m_sqlName = new SQLName(name, this.getInternalConnection());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.TypeDescriptor: return");
        }
    }

    protected TypeDescriptor(SQLName name, Connection connection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.TypeDescriptor( name=" + name + ", connection=" + connection + ")"));
        }
        if (name == null || connection == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"TypeDescriptor.TypeDescriptor: Invalid arguments, 'name' and  'connection'  should not be null. An exception is thrown.");
            }
            DBError.check_error((int)60, (Object)"Invalid arguments");
        }
        this.m_sqlName = name;
        this.setPhysicalConnectionOf(connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.TypeDescriptor: return");
        }
    }

    protected TypeDescriptor(SQLName name, OracleTypeADT type, Connection connection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.TypeDescriptor( name=" + name + ", type=" + type + ", connection=" + connection + ")"));
        }
        if (name == null || type == null || connection == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"TypeDescriptor.TypeDescriptor: Invalid arguments, 'name', 'type' and  'connection'  should not be null. An exception is thrown.");
            }
            DBError.check_error((int)60, (Object)"Invalid arguments");
        }
        this.m_sqlName = name;
        this.setPhysicalConnectionOf(connection);
        this.m_pickler = type;
        this.m_pickler.setDescriptor(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.TypeDescriptor: return");
        }
    }

    protected TypeDescriptor(OracleTypeADT type, Connection connection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.TypeDescriptor( type=" + type + ", connection=" + connection + ")"));
        }
        if (type == null || connection == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"TypeDescriptor.TypeDescriptor: Invalid arguments, 'type' and  'connection'  should not be null. An exception is thrown.");
            }
            DBError.check_error((int)60, (Object)"Invalid arguments");
        }
        this.setPhysicalConnectionOf(connection);
        this.m_sqlName = null;
        this.m_pickler = type;
        this.m_pickler.setDescriptor(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.TypeDescriptor: return");
        }
    }

    public synchronized String getName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.getName()");
        }
        if (this.m_sqlName == null) {
            this.initSQLName();
        }
        String ret = this.m_sqlName.getName();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.getName: return: " + ret));
        }
        return ret;
    }

    public synchronized SQLName getSQLName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.getSQLName()");
        }
        if (this.m_sqlName == null) {
            this.initSQLName();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.getSQLName: return: " + this.m_sqlName));
        }
        return this.m_sqlName;
    }

    void initSQLName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.initSQLName()");
        }
        if (this.m_pickler == null || this.getInternalConnection() == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"TypeDescriptor.initSQLName: Internal error. An exception is thrown.");
            }
            DBError.throwSqlException((int)1);
        }
        this.m_sqlName = new SQLName(this.m_pickler.getFullName(), this.getInternalConnection());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.initSQLName: return");
        }
    }

    public String getSchemaName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.getSchemaName()");
        }
        String ret = this.getSQLName().getSchema();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.getSchemaName: return: " + ret));
        }
        return ret;
    }

    public String getTypeName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.getTypeName()");
        }
        String ret = this.getSQLName().getSimpleName();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.getTypeName: return: " + ret));
        }
        return ret;
    }

    public OracleNamedType getPickler() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.getPickler: return");
        }
        return this.m_pickler;
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.getInternalConnection: return");
        }
        return this.m_conn;
    }

    public void setPhysicalConnectionOf(Connection conn) {
        this.m_conn = OracleConnection.physicalConnectionWithin((Connection)conn);
    }

    public abstract int getTypeCode() throws SQLException;

    public static TypeDescriptor getTypeDescriptor(String name, oracle.jdbc.OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("TypeDescriptor.getTypeDescriptor( name=" + name + ", conn=" + conn + ")"));
        }
        TypeDescriptor descriptor = null;
        try {
            SQLName sqlName = new SQLName(name, conn);
            String qname = sqlName.getName();
            descriptor = (TypeDescriptor)conn.getDescriptor(qname);
            if (descriptor == null) {
                OracleTypeADT otype = new OracleTypeADT(qname, conn);
                ((OracleConnection)conn).db_access.getOracleTypeADT(otype);
                otype.init((OracleConnection)conn);
                OracleNamedType realType = otype.cleanup();
                switch (realType.getTypeCode()) {
                    case 2002: 
                    case 2008: {
                        descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                        break;
                    }
                    case 2003: {
                        descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                        break;
                    }
                    case 2007: {
                        descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                        break;
                    }
                    default: {
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)2, (String)"TypeDescriptor.getTypeDescriptor: The real type should be either STRUCT, JAVA_STRUCT, ARRAY or OPAQUE. An exception is thrown.");
                        }
                        DBError.throwSqlException((int)1);
                    }
                }
                conn.putDescriptor(qname, descriptor);
                realType.setDescriptor(descriptor);
            }
        }
        catch (Exception e2) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)("TypeDescriptor.getTypeDescriptor: Exception caught and thrown." + e2.getMessage()));
            }
            if (e2 instanceof SQLException) {
                DBError.throwSqlException((SQLException)((SQLException)e2), (int)60, (Object)("Unable to resolve type \"" + name + "\""));
            }
            DBError.throwSqlException((int)60, (Object)("Unable to resolve type \"" + name + "\""));
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"TypeDescriptor.getTypeDescriptor: return");
        }
        return descriptor;
    }

    public static TypeDescriptor getTypeDescriptor(String qualifiedName, oracle.jdbc.OracleConnection conn, byte[] image, long offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("TypeDescriptor.getTypeDescriptor( qualifiedName=" + qualifiedName + ", conn=" + conn + ", image=" + image + ", offset=" + offset + ")"));
        }
        TypeDescriptor descriptor = null;
        byte[][] hashKey = new byte[1][];
        String qname = TypeDescriptor.getSubtypeName(conn, image, offset);
        if (qname == null) {
            qname = qualifiedName;
        }
        if ((descriptor = (TypeDescriptor)conn.getDescriptor(qname)) == null) {
            SQLName sqlName = new SQLName(qname, conn);
            OracleTypeADT otype = new OracleTypeADT(qname, conn);
            ((OracleConnection)conn).db_access.getOracleTypeADT(otype);
            otype.init((OracleConnection)conn);
            OracleNamedType realType = otype.cleanup();
            switch (realType.getTypeCode()) {
                case 2002: 
                case 2008: {
                    descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                    break;
                }
                case 2003: {
                    descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                    break;
                }
                case 2007: {
                    descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                    break;
                }
                default: {
                    if (OracleLog.TRACE) {
                        OracleLog.print(null, (int)64, (int)2, (String)"TypeDescriptor.getTypeDescriptor: The real type should be either STRUCT, JAVA_STRUCT, ARRAY or OPAQUE. An exception is thrown.");
                    }
                    DBError.throwSqlException((int)1);
                }
            }
            conn.putDescriptor(qname, descriptor);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("TypeDescriptor.getTypeDescriptor: return: " + descriptor));
        }
        return descriptor;
    }

    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.isInHierarchyOf( checkThisName=" + checkThisName + "): return: false(always)"));
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.writeObject( out=" + out + ")"));
        }
        try {
            if (this.m_sqlName == null) {
                this.initSQLName();
            }
        }
        catch (SQLException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("TypeDescriptor.writeObject: Exception caught and thrown." + e2.getMessage()));
            }
            DBError.SQLToIOException((SQLException)e2);
        }
        out.writeObject(this.m_sqlName);
        out.writeObject(this.m_pickler);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.writeObject: return");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.readObject( in=" + in + ")"));
        }
        this.m_sqlName = (SQLName)in.readObject();
        this.m_pickler = (OracleNamedType)in.readObject();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.readObject: return");
        }
    }

    public void setConnection(Connection connection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("TypeDescriptor.setConnection( connection=" + connection + ")"));
        }
        this.setPhysicalConnectionOf(connection);
        this.m_pickler.setConnection(this.getInternalConnection());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"TypeDescriptor.setConnection: return");
        }
    }

    public static String getSubtypeName(oracle.jdbc.OracleConnection conn, byte[] image, long offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("TypeDescriptor.getSubtypeName( conn=" + conn + ", image=" + image + ", offset=" + offset + ")"));
        }
        if (image == null || image.length == 0 || conn == null) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)"TypeDescriptor.getSubtypeName: Invalid arguments, 'image' should not be empty and 'conn' should not be null. An exception is thrown.");
            }
            DBError.throwSqlException((int)68);
        }
        String ret = OracleTypeADT.getSubtypeName(conn, image, offset);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("TypeDescriptor.getSubtypeName: return: " + ret));
        }
        return ret;
    }

    static {
        serialVersionUID = 2022598722047823723L;
    }
}

