/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    transient Boolean m_isInstanciable = null;
    transient String m_supertype = null;
    transient int m_numLocalAttrs = -1;
    transient String[] m_subtypes = null;
    transient String[] m_attrJavaNames = null;
    final int LOCAL_TYPE = 0;
    final int LOOK_FOR_USER_SYNONYM = 1;
    final int LOOK_FOR_PUBLIC_SYNONYM = 2;
    final String[] initMetaData1_9_0_SQL = new String[]{"SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;"};

    public static StructDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        SQLName sqlName;
        String qualifiedName;
        StructDescriptor descriptor;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("StructDescriptor.createDescriptor( name=" + name + ", conn=" + conn + ")"));
        }
        if (name == null || name.length() == 0 || conn == null) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)"StructDescriptor.createDescriptor: Invalid arguments, 'name' should not be an empty string and conn should not be null. An exception is thrown.");
            }
            DBError.check_error((int)60, (Object)"Invalid arguments");
        }
        if ((descriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName = (sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn)).getName())) == null) {
            descriptor = new StructDescriptor(sqlName, conn);
            ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"StructDescriptor.createDescriptor: return");
        }
        return descriptor;
    }

    public StructDescriptor(String name, Connection connection) throws SQLException {
        super(name, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.StructDescriptor( name=" + name + ", connection=" + connection + ")" + " -- after super() -- no return trace --"));
        }
        this.initPickler();
    }

    public StructDescriptor(SQLName name, Connection connection) throws SQLException {
        super(name, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.StructDescriptor( name=" + name + ", connection=" + connection + ")" + " -- after super() -- no return trace --"));
        }
        this.initPickler();
    }

    public StructDescriptor(SQLName name, OracleTypeADT type, Connection connection) throws SQLException {
        super(name, type, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.StructDescriptor( name=" + name + ", type=" + type + ", connection=" + connection + "): return -- after super() --"));
        }
    }

    private void initPickler() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initPickler()");
        }
        try {
            this.m_pickler = new OracleTypeADT(this.getName(), (Connection)this.m_conn);
            ((OracleTypeADT)this.m_pickler).init((OracleConnection)this.m_conn);
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("StructDescriptor.initPickler: Fail to create descriptor. Exception caught and thrown." + e2.getMessage()));
            }
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.throwSqlException((int)60, (Object)("Unable to resolve type \"" + this.getName() + "\""));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initPickler: return");
        }
    }

    public StructDescriptor(OracleTypeADT type, Connection connection) throws SQLException {
        super(type, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.StructDescriptor( type=" + type + ", connection=" + connection + "): return -- after super() --"));
        }
    }

    public int getTypeCode() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getTypeCode()");
        }
        int typeCode = this.m_pickler.getTypeCode();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getTypeCode: return: " + typeCode));
        }
        return typeCode;
    }

    public int getTypeVersion() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getTypeVersion()");
        }
        int typeVersion = this.m_pickler.getTypeVersion();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getTypeVersion: return: " + typeVersion));
        }
        return typeVersion;
    }

    byte[] toBytes(STRUCT s2, boolean keepLocalCopy) throws SQLException {
        byte[] bytes;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toBytes( s=" + s2 + ", keepLocalCopy=" + keepLocalCopy + ")"));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)32, (String)("StructDescriptor.toBytes: name of this =  " + this.getName() + " typeCode = " + this.getTypeCode()));
        }
        if ((bytes = s2.shareBytes()) == null) {
            if (s2.m_datumArray != null) {
                bytes = this.m_pickler.linearize(s2);
                if (!keepLocalCopy) {
                    s2.setShareBytes(null);
                }
            } else if (s2.m_objArray != null) {
                s2.m_datumArray = this.toOracleArray(s2.m_objArray);
                bytes = this.m_pickler.linearize(s2);
                if (!keepLocalCopy) {
                    s2.m_datumArray = null;
                    s2.setShareBytes(null);
                }
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"StructDescriptor.toBytes: EOJ error. An exception is thrown.");
                }
                DBError.throwSqlException((int)1);
            }
        } else if (s2.m_imgLength != 0L && (s2.m_imgOffset != 0L || s2.m_imgLength != (long)bytes.length)) {
            byte[] image = new byte[(int)s2.m_imgLength];
            System.arraycopy(bytes, (int)s2.m_imgOffset, image, 0, (int)s2.m_imgLength);
            s2.setImage(image, 0L, 0L);
            bytes = image;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.toBytes: return");
        }
        return bytes;
    }

    Datum[] toOracleArray(STRUCT s2, boolean keepLocalCopy) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toOracleArray( s=" + s2 + ", keepLocalCopy=" + keepLocalCopy + ")"));
        }
        Datum[] datumArray = s2.m_datumArray;
        Datum[] ret = null;
        if (datumArray == null) {
            if (s2.m_objArray != null) {
                datumArray = this.toOracleArray(s2.m_objArray);
            } else if (s2.shareBytes() != null) {
                if ((s2.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.m_pickler).isEmbeddedADT()) {
                    this.m_pickler = OracleTypeADT.shallow_clone((OracleTypeADT)((OracleTypeADT)this.m_pickler));
                }
                this.m_pickler.unlinearize(s2.shareBytes(), s2.m_imgOffset, s2, 1, null);
                datumArray = s2.m_datumArray;
                if (!keepLocalCopy) {
                    s2.m_datumArray = null;
                }
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"StructDescriptor.toOracleArray: EOJ error. An exception is thrown.");
                }
                DBError.throwSqlException((int)1);
            }
        }
        if (keepLocalCopy) {
            s2.m_datumArray = datumArray;
            ret = (Datum[])datumArray.clone();
        } else {
            ret = datumArray;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.toOracleArray: return");
        }
        return ret;
    }

    Object[] toArray(STRUCT s2, Map map, boolean saveLocalCopy) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toArray( s=" + s2 + ", map=" + map + ", saveLocalCopy=" + saveLocalCopy + ")"));
        }
        Object[] objArray = null;
        if (s2.m_objArray == null) {
            if (s2.m_datumArray != null) {
                objArray = new Object[s2.m_datumArray.length];
                int i2 = 0;
                while (i2 < s2.m_datumArray.length) {
                    if (s2.m_datumArray[i2] != null) {
                        objArray[i2] = s2.m_datumArray[i2] instanceof STRUCT ? ((STRUCT)s2.m_datumArray[i2]).toJdbc(map) : s2.m_datumArray[i2].toJdbc();
                    }
                    ++i2;
                }
            } else if (s2.shareBytes() != null) {
                if ((s2.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.m_pickler).isEmbeddedADT()) {
                    this.m_pickler = OracleTypeADT.shallow_clone((OracleTypeADT)((OracleTypeADT)this.m_pickler));
                }
                this.m_pickler.unlinearize(s2.shareBytes(), s2.m_imgOffset, s2, 2, map);
                objArray = s2.m_objArray;
                s2.m_objArray = null;
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"StructDescriptor.toArray: EOJ error. An exception is thrown.");
                }
                DBError.throwSqlException((int)1);
            }
        } else {
            objArray = (Object[])s2.m_objArray.clone();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.toArray: return");
        }
        return objArray;
    }

    public int getLength() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getLength()");
        }
        int ret = this.getFieldTypes().length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getLength: return: " + ret));
        }
        return ret;
    }

    public OracleTypeADT getOracleTypeADT() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getOracleTypeADT() -- no return trace --");
        }
        OracleTypeADT ret = (OracleTypeADT)this.m_pickler;
        return ret;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getFieldTypes()");
        }
        OracleType[] ret = ((OracleTypeADT)this.m_pickler).getAttrTypes();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getFieldTypes: return");
        }
        return ret;
    }

    public SQLInput toJdbc2SQLInput(STRUCT s2, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toJdbc2SQLInput( s=" + s2 + ", map=" + map + ")"));
        }
        OracleJdbc2SQLInput ret = new OracleJdbc2SQLInput(this.toOracleArray(s2, false), map, this.m_conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.toJdbc2SQLInput: return");
        }
        return ret;
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.toJdbc2SQLOutput()");
        }
        OracleSQLOutput ret = new OracleSQLOutput(this, this.m_conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.toJdbc2SQLOutput: return");
        }
        return ret;
    }

    public Datum[] toOracleArray(Object[] attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toOracleArray( attributes=" + attributes + ")"));
        }
        Datum[] datum = null;
        if (attributes != null) {
            OracleType[] oracleTypes = this.getFieldTypes();
            int oracleTypesLen = oracleTypes.length;
            if (attributes.length != oracleTypesLen) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"StructDescriptor.toOracleArray: Inconsistent ADT. An exception in thrown.");
                }
                DBError.check_error((int)49, null);
            }
            datum = new Datum[oracleTypesLen];
            int i2 = 0;
            while (i2 < oracleTypesLen) {
                datum[i2] = oracleTypes[i2].toDatum(attributes[i2], (OracleConnection)this.m_conn);
                ++i2;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.toOracleArray: return");
        }
        return datum;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getMetaData()");
        }
        StructMetaData ret = new StructMetaData(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getMetaData: return");
        }
        return ret;
    }

    public boolean isFinalType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.isFinalType()");
        }
        boolean ret = this.getOracleTypeADT().isFinalType();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.isFinalType: return: " + ret));
        }
        return ret;
    }

    public boolean isSubtype() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.isSubtype()");
        }
        boolean ret = this.getOracleTypeADT().isSubType();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.isSubtype: return: " + ret));
        }
        return ret;
    }

    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.isInHierarchyOf( checkThisName=" + checkThisName + ")"));
        }
        StructDescriptor currentDescriptor = this;
        String currentName = currentDescriptor.getName();
        boolean ret = false;
        if (checkThisName.equals(currentName)) {
            ret = true;
        } else {
            while (true) {
                if ((currentName = currentDescriptor.getSupertypeName()) == null) {
                    ret = false;
                    break;
                }
                if (checkThisName.equals(currentName)) {
                    ret = true;
                    break;
                }
                currentDescriptor = StructDescriptor.createDescriptor(currentName, (Connection)this.m_conn);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.isInHierarchyOf: return: " + ret));
        }
        return ret;
    }

    public boolean isInstantiable() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.isInstantiable()");
        }
        if (this.m_isInstanciable == null) {
            this.initMetaData1();
        }
        boolean ret = this.m_isInstanciable;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.isInstantiable: return: " + ret));
        }
        return ret;
    }

    public boolean isJavaObject() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.isJavaObject()");
        }
        boolean ret = this.getOracleTypeADT().isJavaObject();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.isJavaObject: return: " + ret));
        }
        return ret;
    }

    public String getSupertypeName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getSupertypeName()");
        }
        String ret = null;
        if (this.isSubtype()) {
            if (this.m_supertype == null) {
                this.initMetaData1();
            }
            ret = this.m_supertype;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getSupertypeName: return: " + ret));
        }
        return ret;
    }

    public int getLocalAttributeCount() throws SQLException {
        int ret;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getLocalAttributeCount()");
        }
        if (!this.isSubtype()) {
            ret = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.m_numLocalAttrs == -1) {
                this.initMetaData1();
            }
            ret = this.m_numLocalAttrs;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getLocalAttributeCount: return: " + ret));
        }
        return ret;
    }

    public String[] getSubtypeNames() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getSubtypeNames()");
        }
        if (this.m_subtypes == null) {
            this.initMetaData2();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getSubtypeNames: return");
        }
        return this.m_subtypes;
    }

    public String getJavaClassName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getJavaClassName()");
        }
        String ret = null;
        if (this.isJavaObject()) {
            ret = StructDescriptor.getJavaObjectClassName(this.m_conn, this);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getJavaClassName: return: " + ret));
        }
        return ret;
    }

    public String getAttributeJavaName(int column) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getAttributeJavaName( column=" + column + ")"));
        }
        String ret = null;
        if (this.isJavaObject()) {
            if (this.m_attrJavaNames == null) {
                this.initMetaData3();
            }
            ret = this.m_attrJavaNames[column];
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getAttributeJavaName: return: " + ret));
        }
        return ret;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getAttributeJavaNames()");
        }
        String[] ret = null;
        if (this.isJavaObject()) {
            if (this.m_attrJavaNames == null) {
                this.initMetaData3();
            }
            ret = this.m_attrJavaNames;
        } else {
            ret = new String[]{};
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getAttributeJavaNames: return: " + ret));
        }
        return ret;
    }

    public String getLanguage() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getLanguage()");
        }
        String ret = null;
        ret = this.isJavaObject() ? "JAVA" : "SQL";
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getLanguage: return: " + ret));
        }
        return ret;
    }

    public Class getClass(Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.getClass( map=" + map + ")"));
        }
        String qualifiedName = this.getName();
        Class c2 = (Class)map.get(qualifiedName);
        String schema = this.getSchemaName();
        String type = this.getTypeName();
        if (c2 == null && this.m_conn.getUserName().equals(schema)) {
            c2 = (Class)map.get(type);
        }
        if (SQLName.s_parseAllFormat) {
            if (c2 == null && this.m_conn.getUserName().equals(schema)) {
                c2 = (Class)map.get("\"" + type + "\"");
            }
            if (c2 == null) {
                c2 = (Class)map.get("\"" + schema + "\"" + "." + "\"" + type + "\"");
            }
            if (c2 == null) {
                c2 = (Class)map.get("\"" + schema + "\"" + "." + type);
            }
            if (c2 == null) {
                c2 = (Class)map.get(schema + "." + "\"" + type + "\"");
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.getClass: return");
        }
        return c2;
    }

    public static String getJavaObjectClassName(Connection conn, StructDescriptor desc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("StructDescriptor.getJavaObjectClassName( conn=" + conn + ", desc=" + desc + ")"));
        }
        String ret = StructDescriptor.getJavaObjectClassName(conn, desc.getSchemaName(), desc.getTypeName());
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("StructDescriptor.getJavaObjectClassName: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJavaObjectClassName(Connection conn, String schema, String typename) throws SQLException {
        String ret;
        block16: {
            PreparedStatement pstmt;
            block17: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)16, (String)("StructDescriptor.getJavaObjectClassName( conn=" + conn + ", schema=" + schema + ", typename=" + typename + ")"));
                }
                pstmt = null;
                ResultSet rset = null;
                ret = null;
                try {
                    try {
                        pstmt = conn.prepareStatement("select external_name from all_sqlj_types where owner = ? and type_name = ?");
                        pstmt.setString(1, schema);
                        pstmt.setString(2, typename);
                        rset = pstmt.executeQuery();
                        if (rset.next()) {
                            ret = rset.getString(1);
                        } else {
                            if (OracleLog.TRACE) {
                                OracleLog.print(null, (int)64, (int)2, (String)"StructDescriptor.getJavaObjectClassName: Invalid Java object. An excption is thrown.");
                            }
                            DBError.throwSqlException((int)100);
                        }
                    }
                    catch (SQLException e2) {
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)4, (String)("StructDescriptor.getJavaObjectClassName: SQL exception caught." + e2.getMessage()));
                        }
                        Object var8_7 = null;
                        if (rset != null) {
                            rset.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                        break block16;
                    }
                    Object var8_6 = null;
                    if (rset == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (rset != null) {
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    throw throwable;
                }
                rset.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("StructDescriptor.getJavaObjectClassName: return: " + ret));
        }
        return ret;
    }

    public String descType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.descType() -- no return trace --");
        }
        StringBuffer strBuf = new StringBuffer();
        return this.descType(strBuf, 0);
    }

    String descType(StringBuffer strBuf, int level) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.descType( strBuf=" + strBuf + ", level=" + level + ")"));
        }
        String level_one = "";
        int i2 = 0;
        while (i2 < level) {
            level_one = level_one + "  ";
            ++i2;
        }
        String level_two = level_one + "  ";
        strBuf.append(level_one);
        strBuf.append(this.getTypeName());
        strBuf.append("\n");
        strBuf.append(level_one);
        strBuf.append("Subtype=" + this.getOracleTypeADT().isSubType());
        strBuf.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        strBuf.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        strBuf.append("\n");
        ResultSetMetaData md = this.getMetaData();
        int numCols = md.getColumnCount();
        int i3 = 0;
        while (i3 < numCols) {
            int tcode = md.getColumnType(i3 + 1);
            if (tcode == 2002 || tcode == 2008) {
                StructDescriptor adt_desc = StructDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.m_conn);
                adt_desc.descType(strBuf, level + 1);
            } else if (tcode == 2003) {
                ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.m_conn);
                array_desc.descType(strBuf, level + 1);
            } else if (tcode == 2007) {
                OpaqueDescriptor opq_desc = OpaqueDescriptor.createDescriptor(md.getColumnTypeName(i3 + 1), (Connection)this.m_conn);
                opq_desc.descType(strBuf, level + 1);
            } else {
                strBuf.append(level_two);
                strBuf.append(md.getColumnTypeName(i3 + 1));
                strBuf.append("\n");
            }
            ++i3;
        }
        String ret = strBuf.toString();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.descType: return: " + ret));
        }
        return ret;
    }

    public byte[] toBytes(Object[] attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toBytes( attributes=" + attributes + ") -- no return trace --"));
        }
        Datum[] datums = this.toOracleArray(attributes);
        return this.toBytes(datums);
    }

    public byte[] toBytes(Datum[] attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toBytes( attributes=" + attributes + ") -- DEPRECATED --" + " no return trace --"));
        }
        STRUCT s2 = new STRUCT(this, (byte[])null, this.m_conn);
        s2.setDatumArray(attributes);
        return this.m_pickler.linearize(s2);
    }

    public Datum[] toArray(Object[] attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toArray( attributes=" + attributes + ") --" + " no return trace --"));
        }
        return this.toOracleArray(attributes);
    }

    public Datum[] toArray(byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.toArray( bytes=" + bytes + ") -- no return trace --"));
        }
        STRUCT s2 = new STRUCT(this, bytes, this.m_conn);
        return this.toOracleArray(s2, false);
    }

    private void initMetaData1() throws SQLException {
        short version;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData1() -- no return trace --");
        }
        if ((version = this.m_conn.getVersionNumber()) >= 9000) {
            this.initMetaData1_9_0();
        } else {
            this.initMetaData1_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0() throws SQLException {
        block29: {
            int state = 0;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData1_9_0()");
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.m_conn;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    int temp_numLocalAttrs;
                    OracleCallableStatement cstmt;
                    PreparedStatement pstmt;
                    block28: {
                        if (this.m_numLocalAttrs != -1) break block29;
                        pstmt = null;
                        cstmt = null;
                        ResultSet rset = null;
                        temp_numLocalAttrs = -1;
                        try {
                            block14: while (true) {
                                switch (state) {
                                    case 0: {
                                        pstmt = this.m_conn.prepareStatement(this.initMetaData1_9_0_SQL[state]);
                                        pstmt.setString(1, this.getTypeName());
                                        pstmt.setString(2, this.getSchemaName());
                                        rset = pstmt.executeQuery();
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        try {
                                            cstmt = (OracleCallableStatement)this.m_conn.prepareCall(this.initMetaData1_9_0_SQL[state]);
                                            cstmt.setString(1, this.getTypeName());
                                            cstmt.registerOutParameter(2, -10);
                                            cstmt.execute();
                                            rset = cstmt.getCursor(2);
                                            break;
                                        }
                                        catch (SQLException ea) {
                                            if (ea.getErrorCode() == 1403) {
                                                if (state == 1) {
                                                    cstmt.close();
                                                    ++state;
                                                    continue block14;
                                                }
                                                if (OracleLog.TRACE) {
                                                    OracleLog.print((Object)this, (int)64, (int)2, (String)"StructDescriptor.initMetaData1_9_0: Inconsistent catalog. An exception is thrown.");
                                                }
                                                DBError.throwSqlException((int)1, (Object)"Inconsistent catalog view");
                                                break;
                                            }
                                            throw ea;
                                        }
                                    }
                                }
                                if (rset.next()) break;
                                if (state == 2) {
                                    if (OracleLog.TRACE) {
                                        OracleLog.print((Object)this, (int)64, (int)2, (String)"StructDescriptor.initMetaData1_9_0: Inconsistent catalog. An exception is thrown.");
                                    }
                                    DBError.throwSqlException((int)1, (Object)"Inconsistent catalog view");
                                    continue;
                                }
                                rset.close();
                                if (cstmt != null) {
                                    cstmt.close();
                                }
                                ++state;
                            }
                            this.m_isInstanciable = new Boolean(rset.getString(1).equals("YES"));
                            this.m_supertype = rset.getString(2) + "." + rset.getString(3);
                            temp_numLocalAttrs = rset.getInt(4);
                            Object var10_9 = null;
                            if (rset == null) break block28;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            if (rset != null) {
                                rset.close();
                            }
                            if (pstmt != null) {
                                pstmt.close();
                            }
                            if (cstmt != null) {
                                cstmt.close();
                            }
                            throw throwable;
                        }
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (cstmt != null) {
                        cstmt.close();
                    }
                    this.m_numLocalAttrs = temp_numLocalAttrs;
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData1_9_0: return");
        }
    }

    private synchronized void initMetaData1_pre_9_0() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData1_pre_9_0(): return");
        }
        this.m_isInstanciable = new Boolean(true);
        this.m_supertype = "";
        this.m_numLocalAttrs = 0;
    }

    private void initMetaData2() throws SQLException {
        short version;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData2() -- no return trace --");
        }
        if ((version = this.m_conn.getVersionNumber()) >= 9000) {
            this.initMetaData2_9_0();
        } else {
            this.initMetaData2_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_9_0() throws SQLException {
        block16: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData2_9_0()");
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.m_conn;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    String[] temp_names_array;
                    PreparedStatement pstmt;
                    block15: {
                        if (this.m_subtypes != null) break block16;
                        pstmt = null;
                        ResultSet rset = null;
                        temp_names_array = null;
                        try {
                            pstmt = this.m_conn.prepareStatement("select owner, type_name from all_types where supertype_name = ? and supertype_owner = ?");
                            pstmt.setString(1, this.getTypeName());
                            pstmt.setString(2, this.getSchemaName());
                            rset = pstmt.executeQuery();
                            Vector<String> _vector = new Vector<String>();
                            while (rset.next()) {
                                _vector.addElement(rset.getString(1) + "." + rset.getString(2));
                            }
                            temp_names_array = new String[_vector.size()];
                            int i2 = 0;
                            while (i2 < temp_names_array.length) {
                                temp_names_array[i2] = (String)_vector.elementAt(i2);
                                ++i2;
                            }
                            _vector.removeAllElements();
                            _vector = null;
                            Object var9_8 = null;
                            if (rset == null) break block15;
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (rset != null) {
                                rset.close();
                            }
                            if (pstmt != null) {
                                pstmt.close();
                            }
                            throw throwable;
                        }
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    this.m_subtypes = temp_names_array;
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData2_9_0: return");
        }
    }

    private void initMetaData2_pre_9_0() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData2_pre_9_0(): return");
        }
        this.m_subtypes = new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        block15: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData3()");
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.m_conn;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    PreparedStatement pstmt;
                    String[] temp_attrJavaNames;
                    block14: {
                        if (this.m_attrJavaNames != null) break block15;
                        temp_attrJavaNames = null;
                        pstmt = null;
                        ResultSet rset = null;
                        try {
                            pstmt = this.m_conn.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = ? and type_name = ?");
                            pstmt.setString(1, this.getSchemaName());
                            pstmt.setString(2, this.getTypeName());
                            rset = pstmt.executeQuery();
                            temp_attrJavaNames = new String[this.getOracleTypeADT().getAttrTypes().length];
                            int i2 = 0;
                            while (rset.next()) {
                                temp_attrJavaNames[i2] = rset.getString(1);
                                ++i2;
                            }
                            Object var8_7 = null;
                            if (rset == null) break block14;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (rset != null) {
                                rset.close();
                            }
                            if (pstmt != null) {
                                pstmt.close();
                            }
                            throw throwable;
                        }
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    this.m_attrJavaNames = temp_attrJavaNames;
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"StructDescriptor.initMetaData3: return");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.writeObject( out=" + out + "): return -- do nothing --"));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("StructDescriptor.readObject( in=" + in + "): return -- do nothing --"));
        }
    }

    static {
        DEBUG = false;
        serialVersionUID = 1013921343538311063L;
    }
}

