/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection
implements Struct {
    StructDescriptor m_descriptor;
    Datum[] m_datumArray;
    Object[] m_objArray;
    boolean m_enableLocalCache = false;
    long m_imgOffset;
    long m_imgLength;
    static /* synthetic */ Class class$oracle$sql$STRUCT;
    static /* synthetic */ Class class$java$sql$Struct;

    public STRUCT(StructDescriptor type, Connection conn, Object[] attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.STRUCT( type=" + type + ", conn=" + conn + ", attributes=" + attributes + ")"));
        }
        DatumWithConnection.assertNotNull(conn);
        DatumWithConnection.assertNotNull(type);
        if (!type.getInternalConnection().isDescriptorSharable(OracleConnection.physicalConnectionWithin((Connection)conn))) {
            throw new SQLException("Cannot construct STRUCT instance, invalid connection");
        }
        type.setConnection(conn);
        this.setPhysicalConnectionOf(conn);
        this.m_descriptor = type;
        if (!this.m_descriptor.isInstantiable()) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"STRUCT.STRUCT: Cannot construct STRUCT instance for a non-instantiable object type. An exception is thrown.");
            }
            throw new SQLException("Cannot construct STRUCT instance for a non-instantiable object type");
        }
        this.m_datumArray = attributes != null ? this.m_descriptor.toArray(attributes) : new Datum[0];
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.STRUCT: return");
        }
    }

    public STRUCT(StructDescriptor type, byte[] elements, Connection conn) throws SQLException {
        super(elements);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.STRUCT( type=" + type + ", elements=" + elements + ", conn=" + conn + ") -- after super() --"));
        }
        DatumWithConnection.assertNotNull(conn);
        DatumWithConnection.assertNotNull(type);
        if (!type.getInternalConnection().isDescriptorSharable(OracleConnection.physicalConnectionWithin((Connection)conn))) {
            throw new SQLException("Cannot construct STRUCT instance, invalid connection");
        }
        type.setConnection(conn);
        this.m_descriptor = type;
        this.setPhysicalConnectionOf(conn);
        this.m_datumArray = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.STRUCT: return");
        }
    }

    public synchronized String getSQLTypeName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getSQLTypeName()");
        }
        String ret = this.m_descriptor.getName();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getSQLTypeName: return: " + ret));
        }
        return ret;
    }

    public synchronized Object[] getAttributes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getAttributes()");
        }
        Object[] ret = this.getAttributes(this.getMap());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getAttributes: return");
        }
        return ret;
    }

    public synchronized Object[] getAttributes(Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getAttributes( map=" + map + ")"));
        }
        Object[] ret = this.m_descriptor.toArray(this, map, this.m_enableLocalCache);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getAttributes: return");
        }
        return ret;
    }

    public synchronized StructDescriptor getDescriptor() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getDescriptor(): return: " + this.m_descriptor));
        }
        return this.m_descriptor;
    }

    public synchronized void setDescriptor(StructDescriptor desc) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.setDescriptor( desc=" + desc + "): return"));
        }
        this.m_descriptor = desc;
    }

    public synchronized Datum[] getOracleAttributes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getOracleAttributes()");
        }
        Datum[] ret = this.m_descriptor.toOracleArray(this, this.m_enableLocalCache);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getOracleAttributes: return");
        }
        return ret;
    }

    public Map getMap() {
        Map ret;
        block4: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getMap()");
            }
            ret = null;
            try {
                ret = this.getConnection().getTypeMap();
            }
            catch (SQLException ex) {
                if (!OracleLog.TRACE) break block4;
                OracleLog.print((Object)this, (int)64, (int)4, (String)("STRUCT.getMap: Internal error. " + ex.getMessage()));
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getMap: return");
        }
        return ret;
    }

    public synchronized byte[] toBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.toBytes()");
        }
        byte[] ret = this.m_descriptor.toBytes(this, this.m_enableLocalCache);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.toBytes: return");
        }
        return ret;
    }

    public synchronized void setDatumArray(Datum[] darray) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.setDatumArray( darray=" + darray + ") -- no return trace --"));
        }
        this.m_datumArray = darray == null ? new Datum[]{} : darray;
    }

    public synchronized void setObjArray(Object[] oarray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.setObjArray( oarray=" + oarray + ")"));
        }
        Object[] objectArray = this.m_objArray = oarray == null ? new Object[]{} : oarray;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.setObjArray: return");
        }
    }

    public static STRUCT toSTRUCT(Object obj, oracle.jdbc.OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("STRUCT.toSTRUCT( obj=" + obj + ", conn=" + conn + ")"));
        }
        STRUCT s2 = null;
        if (obj != null) {
            if (obj instanceof STRUCT) {
                s2 = (STRUCT)obj;
            } else if (obj instanceof ORAData) {
                s2 = (STRUCT)((ORAData)obj).toDatum(conn);
            } else if (obj instanceof CustomDatum) {
                s2 = (STRUCT)((CustomDatum)obj).toDatum((OracleConnection)conn);
            } else if (obj instanceof SQLData) {
                SQLData sqldataObj = (SQLData)obj;
                StructDescriptor desc = StructDescriptor.createDescriptor(sqldataObj.getSQLTypeName(), (Connection)conn);
                SQLOutput sqlOutput = desc.toJdbc2SQLOutput();
                sqldataObj.writeSQL(sqlOutput);
                s2 = ((OracleSQLOutput)sqlOutput).getSTRUCT();
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)"STRUCT.toSTRUCT: Conversion error. 'obj' should be an instance of  STRUCT or ORAData or CustomDatum or SQLData. An exception is thrown.");
                }
                DBError.check_error((int)59, (Object)obj);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"STRUCT.toSTRUCT: return");
        }
        return s2;
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.toJdbc()");
        }
        Map map = this.getMap();
        Object ret = this.toJdbc(map);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.toJdbc: return");
        }
        return ret;
    }

    public Object toJdbc(Map map) throws SQLException {
        Class c2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.toJdbc( map=" + map + ")"));
        }
        Object jdbcObject = this;
        if (map != null && (c2 = this.m_descriptor.getClass(map)) != null) {
            jdbcObject = this.toClass(c2, map);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.toJdbc: return");
        }
        return jdbcObject;
    }

    public Object toClass(Class clazz) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.toClass( clazz=" + clazz + ")"));
        }
        Object ret = this.toClass(clazz, this.getMap());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.toClass: return");
        }
        return ret;
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.toClass( clazz=" + clazz + ", map=" + map + ")"));
        }
        Object obj = null;
        try {
            if (clazz == null || clazz == (class$oracle$sql$STRUCT == null ? (class$oracle$sql$STRUCT = STRUCT.class$((String)"oracle.sql.STRUCT")) : class$oracle$sql$STRUCT) || clazz == (class$java$sql$Struct == null ? (class$java$sql$Struct = STRUCT.class$((String)"java.sql.Struct")) : class$java$sql$Struct)) {
                obj = this;
            } else {
                Object i2 = clazz.newInstance();
                if (i2 instanceof SQLData) {
                    ((SQLData)i2).readSQL(this.m_descriptor.toJdbc2SQLInput(this, map), this.m_descriptor.getName());
                    obj = i2;
                } else if (i2 instanceof ORADataFactory) {
                    ORADataFactory f2 = (ORADataFactory)i2;
                    obj = f2.create(this, 2002);
                } else if (i2 instanceof CustomDatumFactory) {
                    CustomDatumFactory f3 = (CustomDatumFactory)i2;
                    obj = f3.create(this, 2002);
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)2, (String)"STRUCT.toClass: Fail to convert. An exception is thrown.");
                    }
                    DBError.throwSqlException((int)49, (Object)this.m_descriptor.getName());
                }
            }
        }
        catch (InstantiationException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("STRUCT.toClass: Instantiation exception caught and thrown." + ex.getMessage()));
            }
            DBError.throwSqlException((int)49, (Object)("InstantiationException: " + ex.getMessage()));
        }
        catch (IllegalAccessException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("STRUCT.toClass: IllegalAccess exception caught and thrown." + ex.getMessage()));
            }
            DBError.throwSqlException((int)49, (Object)("IllegalAccessException: " + ex.getMessage()));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.toClass: return");
        }
        return obj;
    }

    public boolean isConvertibleTo(Class jClass) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.isConvertibleTo( jClass=" + jClass + "): return : false (allways)"));
        }
        return false;
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.makeJdbcArray( arraySize=" + arraySize + "): return"));
        }
        return new Object[arraySize];
    }

    public synchronized void setAutoBuffering(boolean enable) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.setAutoBuffering( enable=" + enable + "): return"));
        }
        this.m_enableLocalCache = enable;
    }

    public synchronized boolean getAutoBuffering() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getAutoBuffering(): return: " + this.m_enableLocalCache));
        }
        return this.m_enableLocalCache;
    }

    public void setImage(byte[] image, long offset, long length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.setImage( image=" + image + ", offset=" + offset + ", length=" + length + ")"));
        }
        this.setShareBytes(image);
        this.m_imgOffset = offset;
        this.m_imgLength = length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.setImage: return");
        }
    }

    public void setImageLength(long length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.setImageLength( length=" + length + "): return"));
        }
        this.m_imgLength = length;
    }

    public long getImageOffset() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getImageOffset(): return: " + this.m_imgOffset));
        }
        return this.m_imgOffset;
    }

    public long getImageLength() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getImageLength(): return: " + this.m_imgLength));
        }
        return this.m_imgLength;
    }

    public CustomDatumFactory getFactory(Hashtable map, String classname) throws SQLException {
        String sqlTypeName;
        Object factory;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getFactory( map=" + map + ", classname=" + classname + ")"));
        }
        if ((factory = map.get(sqlTypeName = this.getSQLTypeName())) == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"STRUCT.getFactory: An exception is thrown.");
            }
            throw new SQLException("Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"");
        }
        CustomDatumFactory ret = (CustomDatumFactory)factory;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getFactory: return");
        }
        return ret;
    }

    public ORADataFactory getORADataFactory(Hashtable map, String classname) throws SQLException {
        String sqlTypeName;
        Object factory;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.getORADataFactory( map=" + map + ", classname=" + classname + ")"));
        }
        if ((factory = map.get(sqlTypeName = this.getSQLTypeName())) == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"STRUCT.getORADataFactory: An exception is thrown.");
            }
            throw new SQLException("Unable to convert a \"" + sqlTypeName + "\" to a \"" + classname + "\" or a subclass of \"" + classname + "\"");
        }
        ORADataFactory ret = (ORADataFactory)factory;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.getORADataFactory: return");
        }
        return ret;
    }

    public String debugString() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"STRUCT.debugString()");
        }
        StringWriter result = new StringWriter();
        String ret = null;
        try {
            StructDescriptor desc = this.getDescriptor();
            result.write("name = " + desc.getName());
            int length = desc.getLength();
            result.write(" length = " + length);
            Object[] attr = this.getAttributes();
            int i2 = 0;
            while (i2 < length) {
                result.write(" attribute[" + i2 + "] = " + attr[i2]);
                ++i2;
            }
        }
        catch (SQLException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"STRUCT.debugString: StructDescriptor missing or bad formatted.");
            }
            ret = "StructDescriptor missing or bad";
        }
        ret = result.toString();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.debugString: return: " + ret));
        }
        return ret;
    }

    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.isInHierarchyOf( checkThisName=" + checkThisName + ")"));
        }
        boolean ret = this.getDescriptor().isInHierarchyOf(checkThisName);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("STRUCT.isInHierarchyOf: return: " + ret));
        }
        return ret;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

