/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import oracle.gss.util.NLSCharacter;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class SQLUtil {
    private static final int CLASS_NOT_FOUND = -1;
    private static final int CLASS_STRING = 0;
    private static final int CLASS_BOOLEAN = 1;
    private static final int CLASS_INTEGER = 2;
    private static final int CLASS_LONG = 3;
    private static final int CLASS_FLOAT = 4;
    private static final int CLASS_DOUBLE = 5;
    private static final int CLASS_BIGDECIMAL = 6;
    private static final int CLASS_DATE = 7;
    private static final int CLASS_TIME = 8;
    private static final int CLASS_TIMESTAMP = 9;
    private static final int TOTAL_CLASSES = 10;
    private static Hashtable s_classTbl;

    public static Object SQLToJava(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, Class javaClass, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.SQLToJava( connection=" + connection + ", sqlData=" + sqlData + ", sqlTypeCode=" + sqlTypeCode + ", sqlTypeName=" + sqlTypeName + ", javaClass=" + javaClass + ", map=" + map + ")"));
        }
        Datum datum = SQLUtil.makeDatum((OracleConnection)connection, (byte[])sqlData, (int)sqlTypeCode, (String)sqlTypeName, (int)0);
        Object ret = SQLUtil.SQLToJava((OracleConnection)connection, (Datum)datum, (Class)javaClass, (Map)map);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.SQLToJava: return: " + ret));
        }
        return ret;
    }

    public static CustomDatum SQLToJava(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, CustomDatumFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.SQLToJava( connection=" + connection + ", sqlData=" + sqlData + ", sqlTypeCode=" + sqlTypeCode + ", sqlTypeName=" + sqlTypeName + ", factory=" + factory + ")"));
        }
        Datum datum = SQLUtil.makeDatum((OracleConnection)connection, (byte[])sqlData, (int)sqlTypeCode, (String)sqlTypeName, (int)0);
        CustomDatum ret = factory.create(datum, sqlTypeCode);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.SQLToJava: return: " + ret));
        }
        return ret;
    }

    public static ORAData SQLToJava(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, ORADataFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.SQLToJava( connection=" + connection + ", sqlData=" + sqlData + ", sqlTypeCode=" + sqlTypeCode + ", sqlTypeName=" + sqlTypeName + ", factory=" + factory + ")"));
        }
        Datum datum = SQLUtil.makeDatum((OracleConnection)connection, (byte[])sqlData, (int)sqlTypeCode, (String)sqlTypeName, (int)0);
        ORAData ret = factory.create(datum, sqlTypeCode);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.SQLToJava: return: " + ret));
        }
        return ret;
    }

    public static Object SQLToJava(OracleConnection connection, Datum datum, Class javaClass, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.SQLToJava( connection=" + connection + ", datum=" + datum + ", javaClass=" + javaClass + ", map=" + map + ")"));
        }
        Object ret_obj = null;
        if (datum instanceof STRUCT) {
            ret_obj = javaClass == null ? (map != null ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc()) : (map != null ? ((STRUCT)datum).toClass(javaClass, map) : ((STRUCT)datum).toClass(javaClass));
        } else if (javaClass == null) {
            ret_obj = datum.toJdbc();
        } else {
            int class_num = SQLUtil.classNumber((Class)javaClass);
            switch (class_num) {
                case 0: {
                    ret_obj = datum.stringValue();
                    break;
                }
                case 1: {
                    ret_obj = new Boolean(datum.longValue() != 0L);
                    break;
                }
                case 2: {
                    ret_obj = new Integer((int)datum.longValue());
                    break;
                }
                case 3: {
                    ret_obj = new Long(datum.longValue());
                    break;
                }
                case 4: {
                    ret_obj = new Float(datum.bigDecimalValue().floatValue());
                    break;
                }
                case 5: {
                    ret_obj = new Double(datum.bigDecimalValue().doubleValue());
                    break;
                }
                case 6: {
                    ret_obj = datum.bigDecimalValue();
                    break;
                }
                case 7: {
                    ret_obj = datum.dateValue();
                    break;
                }
                case 8: {
                    ret_obj = datum.timeValue();
                    break;
                }
                case 9: {
                    ret_obj = datum.timestampValue();
                    break;
                }
                default: {
                    ret_obj = datum.toJdbc();
                    if (ret_obj.getClass() == javaClass || javaClass.isInterface() && SQLUtil.implementsInterface(ret_obj.getClass(), javaClass)) break;
                    if (OracleLog.TRACE) {
                        OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.SQLToJava: Invalid data conversion. An exception is thrown.");
                    }
                    DBError.check_error((int)59, (Object)"invalid data conversion");
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"SQLUtil.SQLToJava: return");
        }
        return ret_obj;
    }

    public static byte[] JavaToSQL(OracleConnection connection, Object inObject, int sqlTypeCode, String sqlTypeName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.JavaToSQL( connection=" + connection + ", inObject=" + inObject + ", sqlTypeCode=" + sqlTypeCode + ", sqlTypeName=" + sqlTypeName + ")"));
        }
        if (inObject == null) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)"SQLUtil.JavaToSQL: return: null");
            }
            return null;
        }
        Datum datum = null;
        if (inObject instanceof Datum) {
            datum = (Datum)inObject;
        } else if (inObject instanceof ORAData) {
            datum = ((ORAData)inObject).toDatum(connection);
        } else if (inObject instanceof CustomDatum) {
            datum = ((CustomDatum)inObject).toDatum(connection);
        } else if (inObject instanceof SQLData) {
            datum = STRUCT.toSTRUCT(inObject, connection);
        }
        if (datum != null) {
            if (!SQLUtil.checkDatumType(datum, sqlTypeCode, sqlTypeName)) {
                datum = null;
            }
        } else {
            datum = SQLUtil.makeDatum((OracleConnection)connection, (Object)inObject, (int)sqlTypeCode, (String)sqlTypeName);
        }
        byte[] ret = null;
        if (datum != null) {
            ret = datum instanceof STRUCT ? ((STRUCT)datum).toBytes() : (datum instanceof ARRAY ? ((ARRAY)datum).toBytes() : (datum instanceof OPAQUE ? ((OPAQUE)datum).toBytes() : datum.shareBytes()));
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.JavaToSQL: Attempt to convert a Datum to incompatible SQL type. An exception is thrown.");
            }
            DBError.check_error((int)1, (Object)"attempt to convert a Datum to incompatible SQL type");
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.JavaToSQL: return: " + ret));
        }
        return ret;
    }

    public static Datum makeDatum(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, int maxLen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.makeDatum( connection=" + connection + ", sqlData=" + sqlData + ", sqlTypeCode=" + sqlTypeCode + ", sqlTypeName=" + sqlTypeName + ", maxLen=" + maxLen + ")"));
        }
        Datum ret_datum = null;
        switch (sqlTypeCode) {
            case 96: 
            case 999: {
                boolean thin = connection.getProtocolType().equals("thin");
                if (thin && maxLen != 0) {
                    char[] c2;
                    int charLength = connection.conversion.CHARBytesToJavaChars(sqlData, sqlData.length, c2 = new char[sqlData.length]);
                    String s2 = new String(c2, 0, charLength < maxLen ? charLength : maxLen);
                    try {
                        ret_datum = new CHAR(s2, connection.conversion.getAccessCharSetObj());
                    }
                    catch (SQLException ea) {
                        byte[] b2 = new byte[sqlData.length * NLSCharacter.getRatio((int)connection.getDbCsId(), (int)1)];
                        int len = connection.conversion.javaCharsToCHARBytes(c2, charLength, b2);
                        ret_datum = new CHAR(b2, 0, len, connection.conversion.getAccessCharSetObj());
                    }
                    break;
                }
                ret_datum = new CHAR(sqlData, CharacterSet.make(connection.getJdbcCsId()));
                break;
            }
            case 1: 
            case 8: {
                ret_datum = new CHAR(sqlData, CharacterSet.make(connection.getJdbcCsId()));
                break;
            }
            case 2: 
            case 6: {
                ret_datum = new NUMBER(sqlData);
                break;
            }
            case 23: 
            case 24: {
                ret_datum = new RAW(sqlData);
                break;
            }
            case 104: {
                ret_datum = new ROWID(sqlData);
                break;
            }
            case 102: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.makeDatum: DBType.RESULT_SET type is not handled. An exception is thrown.");
                }
                DBError.check_error((int)1, (Object)"need resolution: do we want to handle ResultSet?");
                break;
            }
            case 12: {
                ret_datum = new DATE(sqlData);
                break;
            }
            case 182: {
                ret_datum = new INTERVALYM(sqlData);
                break;
            }
            case 180: {
                ret_datum = new TIMESTAMP(sqlData);
                break;
            }
            case 181: {
                ret_datum = new TIMESTAMPTZ(sqlData);
                break;
            }
            case 231: {
                ret_datum = new TIMESTAMPLTZ(sqlData);
                break;
            }
            case 113: {
                ret_datum = new BLOB(connection, sqlData);
                break;
            }
            case 112: {
                ret_datum = new CLOB(connection, sqlData);
                break;
            }
            case 114: {
                ret_datum = new BFILE(connection, sqlData);
                break;
            }
            case 109: {
                TypeDescriptor desc = TypeDescriptor.getTypeDescriptor(sqlTypeName, connection, sqlData, 0L);
                if (desc instanceof StructDescriptor) {
                    ret_datum = new STRUCT((StructDescriptor)desc, sqlData, connection);
                    break;
                }
                if (desc instanceof ArrayDescriptor) {
                    ret_datum = new ARRAY((ArrayDescriptor)desc, sqlData, connection);
                    break;
                }
                if (!(desc instanceof OpaqueDescriptor)) break;
                ret_datum = new OPAQUE((OpaqueDescriptor)desc, sqlData, connection);
                break;
            }
            case 111: {
                Object desc = SQLUtil.getTypeDescriptor((String)sqlTypeName, (OracleConnection)connection);
                if (desc instanceof StructDescriptor) {
                    ret_datum = new REF((StructDescriptor)desc, (Connection)connection, sqlData);
                    break;
                }
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.makeDatum: REF points to a non-STRUCT. An exception is thrown.");
                }
                DBError.check_error((int)1, (Object)"program error: REF points to a non-STRUCT");
                break;
            }
            default: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)16, (String)"SQLUtil.makeDatum: Invalid SQL type code. An exception is thrown.");
                }
                DBError.check_error((int)1, (Object)"program error: invalid SQL type code");
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.makeDatum: return: " + ret_datum));
        }
        return ret_datum;
    }

    public static Datum makeNDatum(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, short form, int maxLen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.makeNDatum( connection=" + connection + ", sqlData=" + sqlData + ", sqlTypeCode=" + sqlTypeCode + ", sqlTypeName=" + sqlTypeName + ", form=" + form + ", maxLen=" + maxLen + ")"));
        }
        Datum ret_datum = null;
        switch (sqlTypeCode) {
            case 96: 
            case 999: {
                boolean thin = connection.getProtocolType().equals("thin");
                if (thin && maxLen != 0) {
                    char[] c2;
                    int charLength = connection.conversion.NCHARBytesToJavaChars(sqlData, sqlData.length, c2 = new char[sqlData.length]);
                    String s2 = new String(c2, 0, charLength < maxLen ? charLength : maxLen);
                    try {
                        ret_datum = new CHAR(s2, connection.conversion.getAccessNCharSetObj());
                    }
                    catch (SQLException ea) {
                        byte[] b2 = new byte[sqlData.length * NLSCharacter.getRatio((int)connection.getNCsId(), (int)1)];
                        int len = connection.conversion.javaCharsToNCHARBytes(c2, charLength, b2);
                        ret_datum = new CHAR(b2, 0, len, connection.conversion.getAccessNCharSetObj());
                    }
                    break;
                }
                ret_datum = new CHAR(sqlData, CharacterSet.make(connection.conversion.getNCharSet()));
                break;
            }
            case 1: 
            case 8: {
                ret_datum = new CHAR(sqlData, CharacterSet.make(connection.conversion.getNCharSet()));
                break;
            }
            case 112: {
                ret_datum = new CLOB((oracle.jdbc.OracleConnection)connection, sqlData, form);
                break;
            }
            default: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.makeNDatum: Invalid SQL type code. An exception is thrown.");
                }
                DBError.check_error((int)1, (Object)"program error: invalid SQL type code");
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.makeNDatum: return: " + ret_datum));
        }
        return ret_datum;
    }

    public static Datum makeDatum(OracleConnection connection, Object inObject, int sqlTypeCode, String sqlTypeName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.makeDatum( connection=" + connection + ", inObject=" + inObject + ", sqlTypeCode=" + sqlTypeCode + ", sqlTypeName=" + sqlTypeName + ")"));
        }
        Datum ret_datum = null;
        switch (sqlTypeCode) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                ret_datum = new CHAR(inObject, CharacterSet.make(connection.getJdbcCsId()));
                break;
            }
            case 2: 
            case 6: {
                ret_datum = new NUMBER(inObject);
                break;
            }
            case 23: 
            case 24: {
                ret_datum = new RAW(inObject);
                break;
            }
            case 104: {
                ret_datum = new ROWID((byte[])inObject);
                break;
            }
            case 102: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.makeDatum: DBType.RESULT_SET type is not handled. An exception is thrown.");
                }
                DBError.check_error((int)1, (Object)"need resolution: do we want to handle ResultSet");
                break;
            }
            case 12: {
                ret_datum = new DATE(inObject);
                break;
            }
            case 180: {
                if (!(inObject instanceof TIMESTAMP)) break;
                ret_datum = (Datum)inObject;
                break;
            }
            case 181: {
                if (!(inObject instanceof TIMESTAMPTZ)) break;
                ret_datum = (Datum)inObject;
                break;
            }
            case 231: {
                if (!(inObject instanceof TIMESTAMPLTZ)) break;
                ret_datum = (Datum)inObject;
                break;
            }
            case 113: {
                if (!(inObject instanceof BLOB)) break;
                ret_datum = (Datum)inObject;
                break;
            }
            case 112: {
                if (!(inObject instanceof CLOB)) break;
                ret_datum = (Datum)inObject;
                break;
            }
            case 114: {
                if (!(inObject instanceof BFILE)) break;
                ret_datum = (Datum)inObject;
                break;
            }
            case 109: {
                if (!(inObject instanceof STRUCT) && !(inObject instanceof ARRAY) && !(inObject instanceof OPAQUE)) break;
                ret_datum = (Datum)inObject;
                break;
            }
            case 111: {
                if (!(inObject instanceof REF)) break;
                ret_datum = (Datum)inObject;
                break;
            }
        }
        if (ret_datum == null) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.makeDatum: Unable to construct a Datum from the specified input. An exception is thrown.");
            }
            DBError.check_error((int)1, (Object)"Unable to construct a Datum from the specified input");
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.makeDatum: return: " + ret_datum));
        }
        return ret_datum;
    }

    private static int classNumber(Class inClass) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.classNumber( inClass=" + inClass + ")"));
        }
        int ret = -1;
        Integer class_num = (Integer)s_classTbl.get(inClass);
        if (class_num != null) {
            ret = class_num;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.classNumber: return: " + ret));
        }
        return ret;
    }

    public static Object getTypeDescriptor(String name, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.getTypeDescriptor( name=" + name + ", conn=" + conn + ")"));
        }
        Object descriptor = null;
        SQLName sqlName = new SQLName(name, conn);
        String qname = sqlName.getName();
        descriptor = conn.getDescriptor(qname);
        if (descriptor != null) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)"SQLUtil.getTypeDescriptor: return");
            }
            return descriptor;
        }
        OracleTypeADT otype = new OracleTypeADT(qname, (Connection)conn);
        conn.db_access.getOracleTypeADT(otype);
        otype.init(conn);
        OracleNamedType realType = otype.cleanup();
        switch (realType.getTypeCode()) {
            case 2003: {
                descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                break;
            }
            case 2002: 
            case 2008: {
                descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                break;
            }
            case 2007: {
                descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                break;
            }
            default: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)"SQLUtil.getTypeDescriptor: Unrecognized type code. An exception is thrown.");
                }
                DBError.throwSqlException((int)1, (Object)"Unrecognized type code");
            }
        }
        conn.putDescriptor(qname, descriptor);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"SQLUtil.getTypeDescriptor: return");
        }
        return descriptor;
    }

    public static boolean checkDatumType(Datum datum, int sqlType, String sqlTypeName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.checkDatumType( datum=" + datum + ", sqlType=" + sqlType + ", sqlTypeName=" + sqlTypeName + ")"));
        }
        boolean ret = false;
        switch (sqlType) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                ret = datum instanceof CHAR;
                break;
            }
            case 2: 
            case 6: {
                ret = datum instanceof NUMBER;
                break;
            }
            case 23: 
            case 24: {
                ret = datum instanceof RAW;
                break;
            }
            case 104: {
                ret = datum instanceof ROWID;
                break;
            }
            case 12: {
                ret = datum instanceof DATE;
                break;
            }
            case 180: {
                ret = datum instanceof TIMESTAMP;
                break;
            }
            case 181: {
                ret = datum instanceof TIMESTAMPTZ;
                break;
            }
            case 231: {
                ret = datum instanceof TIMESTAMPLTZ;
                break;
            }
            case 113: {
                ret = datum instanceof BLOB;
                break;
            }
            case 112: {
                ret = datum instanceof CLOB;
                break;
            }
            case 114: {
                ret = datum instanceof BFILE;
                break;
            }
            case 111: {
                ret = datum instanceof REF && ((REF)datum).getBaseTypeName().equals(sqlTypeName);
                break;
            }
            case 109: {
                if (datum instanceof STRUCT) {
                    ret = ((STRUCT)datum).isInHierarchyOf(sqlTypeName);
                    break;
                }
                if (datum instanceof ARRAY) {
                    ret = ((ARRAY)datum).getSQLTypeName().equals(sqlTypeName);
                    break;
                }
                if (!(datum instanceof OPAQUE)) break;
                ret = ((OPAQUE)datum).getSQLTypeName().equals(sqlTypeName);
                break;
            }
            default: {
                ret = false;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.checkDatumType: return: " + ret));
        }
        return ret;
    }

    public static boolean implementsInterface(Class clazz, Class interfaze) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.implementsInterface( clazz=" + clazz + ", interfaze=" + interfaze + ") -- no return trace --"));
        }
        if (clazz == null) {
            return false;
        }
        if (clazz == interfaze) {
            return true;
        }
        Class<?>[] interfazes = clazz.getInterfaces();
        int i2 = 0;
        while (i2 < interfazes.length) {
            if (SQLUtil.implementsInterface(interfazes[i2], interfaze)) {
                return true;
            }
            ++i2;
        }
        return SQLUtil.implementsInterface(clazz.getSuperclass(), interfaze);
    }

    public static Datum makeOracleDatum(OracleConnection connection, Object inObject, int typeCode, String sqlTypeName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.makeOracleDatum( connection=" + connection + ", inObject=" + inObject + ", typeCode=" + typeCode + ", sqlTypeName=" + sqlTypeName + ")"));
        }
        Datum ret = SQLUtil.makeDatum((OracleConnection)connection, (Object)inObject, (int)SQLUtil.get_internal_type(typeCode), (String)sqlTypeName);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"SQLUtil.makeOracleDatum: return");
        }
        return ret;
    }

    public static int get_internal_type(int external_type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.get_internal_type( external_type=" + external_type + ")"));
        }
        int ret = 0;
        switch (external_type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ret = 6;
                break;
            }
            case 999: {
                ret = 999;
                break;
            }
            case 1: {
                ret = 96;
                break;
            }
            case 12: {
                ret = 1;
                break;
            }
            case -1: {
                ret = 8;
                break;
            }
            case 91: 
            case 92: {
                ret = 12;
                break;
            }
            case -100: 
            case 93: {
                ret = 180;
                break;
            }
            case -101: {
                ret = 181;
                break;
            }
            case -102: {
                ret = 231;
                break;
            }
            case -104: {
                ret = 183;
                break;
            }
            case -103: {
                ret = 182;
                break;
            }
            case -3: 
            case -2: {
                ret = 23;
                break;
            }
            case -4: {
                ret = 24;
                break;
            }
            case -8: {
                ret = 104;
                break;
            }
            case 2004: {
                ret = 113;
                break;
            }
            case 2005: {
                ret = 112;
                break;
            }
            case -13: {
                ret = 114;
                break;
            }
            case -10: {
                ret = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                ret = 109;
                break;
            }
            case 2006: {
                ret = 111;
                break;
            }
            default: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)4, (String)"SQLUtil.get_internal_type: Invalid column type. An exception is thrown.");
                }
                DBError.check_error((int)4, (Object)"get_internal_type");
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLUtil.get_internal_type: return: " + ret));
        }
        return ret;
    }

    static {
        block2: {
            CLASS_NOT_FOUND = -1;
            CLASS_STRING = 0;
            CLASS_BOOLEAN = 1;
            CLASS_INTEGER = 2;
            CLASS_LONG = 3;
            CLASS_FLOAT = 4;
            CLASS_DOUBLE = 5;
            CLASS_BIGDECIMAL = 6;
            CLASS_DATE = 7;
            CLASS_TIME = 8;
            CLASS_TIMESTAMP = 9;
            TOTAL_CLASSES = 10;
            s_classTbl = new Hashtable(10);
            try {
                s_classTbl.put(Class.forName("java.lang.String"), new Integer(0));
                s_classTbl.put(Class.forName("java.lang.Boolean"), new Integer(1));
                s_classTbl.put(Class.forName("java.lang.Integer"), new Integer(2));
                s_classTbl.put(Class.forName("java.lang.Long"), new Integer(3));
                s_classTbl.put(Class.forName("java.lang.Float"), new Integer(4));
                s_classTbl.put(Class.forName("java.lang.Double"), new Integer(5));
                s_classTbl.put(Class.forName("java.math.BigDecimal"), new Integer(6));
                s_classTbl.put(Class.forName("java.sql.Date"), new Integer(7));
                s_classTbl.put(Class.forName("java.sql.Time"), new Integer(8));
                s_classTbl.put(Class.forName("java.sql.Timestamp"), new Integer(9));
            }
            catch (ClassNotFoundException e2) {
                if (!OracleLog.TRACE) break block2;
                OracleLog.print(null, (int)64, (int)4, (String)"SQLUtil :  Unexpected ClassNotFoundException in static bloc");
            }
        }
    }
}

