/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;

public class SQLName
implements Serializable {
    static boolean DEBUG = false;
    static boolean s_parseAllFormat = false;
    static final long serialVersionUID = 2266340348729491526L;
    String name;
    String schema;
    String simple;
    int version;
    boolean synonym;

    protected SQLName() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"SQLName.SQLName(): return");
        }
    }

    public SQLName(String name, OracleConnection connection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.SQLName( name=" + name + ", connection=" + connection + ")"));
        }
        this.init(name, connection);
        this.version = 2;
        this.synonym = false;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"SQLName.SQLName: return");
        }
    }

    protected SQLName(String schema, String typename, OracleConnection connection) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.SQLName( schema=" + schema + ", typename=" + typename + ", connection=" + connection + ")"));
        }
        this.schema = schema;
        this.simple = typename;
        this.name = this.schema + "." + this.simple;
        this.version = 2;
        this.synonym = false;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"SQLName.SQLName: return");
        }
    }

    private void init(String sql_name, OracleConnection conn) throws SQLException {
        String[] _type;
        String[] _schema;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.init( sql_name=" + sql_name + ", conn=" + conn + ")"));
        }
        if (SQLName.parse(sql_name, _schema = new String[1], _type = new String[1])) {
            this.schema = _schema[0];
            this.simple = _type[0];
        } else {
            this.schema = conn.getUserName();
            this.simple = _type[0];
        }
        this.name = this.schema + "." + this.simple;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"SQLName.init: return");
        }
    }

    public String getName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.getName(): return: " + this.name));
        }
        return this.name;
    }

    public String getSchema() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.getSchema(): return: " + this.schema));
        }
        return this.schema;
    }

    public String getSimpleName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.getSimpleName(): return: " + this.simple));
        }
        return this.simple;
    }

    public int getVersion() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.getVersion(): return: " + this.version));
        }
        return this.version;
    }

    public static boolean parse(String sql_name, String[] schema_name, String[] type_name) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLName.parse( sql_name=" + sql_name + ", schema_name=" + schema_name + ", type_name=" + type_name + ") -- no return trace --"));
        }
        if (sql_name == null) {
            return false;
        }
        if (schema_name == null || schema_name.length < 1 || type_name == null || type_name.length < 1) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)"SQLName.parse: Invalid argument, 'type_name' and 'schema_name' should not be empty strings. An exception is thrown.");
            }
            DBError.throwSqlException((int)68);
        }
        if (!s_parseAllFormat) {
            int idxDot = sql_name.indexOf(".");
            if (idxDot < 0) {
                type_name[0] = sql_name;
                return false;
            }
            schema_name[0] = sql_name.substring(0, idxDot);
            type_name[0] = sql_name.substring(idxDot + 1);
            return true;
        }
        int length = sql_name.length();
        int idxOpenQuote = sql_name.indexOf("\"");
        int idxCloseQuote = sql_name.indexOf("\"", idxOpenQuote + 1);
        int idxDot = -1;
        if (idxOpenQuote < 0) {
            idxDot = sql_name.indexOf(".");
            if (idxDot < 0) {
                type_name[0] = sql_name;
                return false;
            }
            schema_name[0] = sql_name.substring(0, idxDot);
            type_name[0] = sql_name.substring(idxDot + 1);
            return true;
        }
        if (idxOpenQuote == 0) {
            if (idxCloseQuote == length - 1) {
                type_name[0] = sql_name.substring(idxOpenQuote + 1, idxCloseQuote);
                return false;
            }
            idxDot = sql_name.indexOf(".", idxCloseQuote);
            schema_name[0] = sql_name.substring(idxOpenQuote + 1, idxCloseQuote);
            idxOpenQuote = sql_name.indexOf("\"", idxDot);
            idxCloseQuote = sql_name.indexOf("\"", idxOpenQuote + 1);
            if (idxOpenQuote < 0) {
                type_name[0] = sql_name.substring(idxDot + 1);
                return true;
            }
            type_name[0] = sql_name.substring(idxOpenQuote + 1, idxCloseQuote);
            return true;
        }
        idxDot = sql_name.indexOf(".");
        schema_name[0] = sql_name.substring(0, idxDot);
        type_name[0] = sql_name.substring(idxOpenQuote + 1, idxCloseQuote);
        return true;
    }

    public static void setHandleDoubleQuote(boolean enable) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLName.setHandleDoubleQuote( enable=" + enable + "): return"));
        }
        s_parseAllFormat = enable;
    }

    public static boolean getHandleDoubleQuote() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("SQLName.getHandleDoubleQuote(): return: " + s_parseAllFormat));
        }
        return s_parseAllFormat;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.writeObject( out=" + out + ")"));
        }
        out.writeUTF(this.name);
        out.writeUTF(this.schema);
        out.writeUTF(this.simple);
        out.writeInt(this.version);
        out.writeBoolean(this.synonym);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"SQLName.writeObject: return");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("SQLName.readObject( in=" + in + ")"));
        }
        this.name = in.readUTF();
        this.schema = in.readUTF();
        this.simple = in.readUTF();
        this.version = in.readInt();
        this.synonym = in.readBoolean();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"SQLName.readObject: return");
        }
    }

    static {
        serialVersionUID = 2266340348729491526L;
    }
}

