/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.DatumWithConnection;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class REF
extends DatumWithConnection
implements Ref,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    String m_typename;
    transient StructDescriptor m_descriptor;

    public String getBaseTypeName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getBaseTypeName()");
        }
        if (this.m_typename == null) {
            if (this.m_descriptor != null) {
                this.m_typename = this.m_descriptor.getName();
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"REF.getBaseTypeName: this object is not valid because m_typename and m_descriptor are null. An exception is thrown.");
                }
                DBError.throwSqlException((int)52);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.getBaseTypeName: return: " + this.m_typename));
        }
        return this.m_typename;
    }

    public REF(String typename, Connection conn, byte[] bytes) throws SQLException {
        super(bytes);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.REF( typename=" + typename + ", conn=" + conn + ", bytes=" + bytes + ")" + " -- after super() -- "));
        }
        if (conn == null || typename == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"REF.REF: Invalid argument, 'conn' and 'typename' should not be null. An exception is thrown.");
            }
            DBError.throwSqlException((int)68);
        }
        this.m_typename = typename;
        this.m_descriptor = null;
        this.setPhysicalConnectionOf(conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.REF: return");
        }
    }

    public REF(StructDescriptor desc, Connection conn, byte[] bytes) throws SQLException {
        super(bytes);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.REF( desc=" + desc + ", conn=" + conn + ", bytes=" + bytes + ") -- after super() --"));
        }
        if (conn == null || desc == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"REF.REF: Invalid argument, 'conn' and 'desc' should not be null. An exception is thrown.");
            }
            DBError.check_error((int)68);
        }
        this.m_descriptor = desc;
        this.setPhysicalConnectionOf(conn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.REF: return");
        }
    }

    public Object getValue(Map map) throws SQLException {
        STRUCT s2;
        Object ret;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.getValue( map=" + map + ")"));
        }
        Object object = ret = (s2 = this.getSTRUCT()) != null ? s2.toJdbc(map) : null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getValue: return");
        }
        return ret;
    }

    public Object getValue() throws SQLException {
        STRUCT s2;
        Object ret;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getValue()");
        }
        Object object = ret = (s2 = this.getSTRUCT()) != null ? s2.toJdbc() : null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getValue: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized STRUCT getSTRUCT() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getSTRUCT()");
        }
        STRUCT ret = null;
        OraclePreparedStatement pstmt = (OraclePreparedStatement)this.getInternalConnection().prepareStatement("select deref(?) from dual");
        pstmt.setRowPrefetch(1);
        pstmt.setREF(1, this);
        OracleResultSet rset = (OracleResultSet)pstmt.executeQuery();
        try {
            if (rset.next()) {
                ret = rset.getSTRUCT(1);
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"REF.getSTRUCT: Invalid REF. An exception is thrown.");
                }
                DBError.throwSqlException((int)52);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            rset.close();
            rset = null;
            pstmt.close();
            pstmt = null;
            throw throwable;
        }
        rset.close();
        rset = null;
        pstmt.close();
        pstmt = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getSTRUCT: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setValue(Object value) throws SQLException {
        CallableStatement cstmt;
        block11: {
            STRUCT struct;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.setValue( value=" + value + ")"));
            }
            if ((struct = STRUCT.toSTRUCT(value, this.getInternalConnection())).getInternalConnection() != this.getInternalConnection()) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"REF.setValue: Incompatible connection object. An exception is thrown.");
                }
                DBError.throwSqlException((int)77, (Object)"Incompatible connection object");
            }
            if (!this.getBaseTypeName().equals(struct.getSQLTypeName())) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"REF.setValue: Incompatible type. An exception is thrown.");
                }
                DBError.throwSqlException((int)77, (Object)"Incompatible type");
            }
            byte[] pickled_bytes = struct.toBytes();
            byte[] toid_bytes = struct.getDescriptor().getOracleTypeADT().getTOID();
            cstmt = null;
            try {
                cstmt = this.getInternalConnection().prepareCall("begin ? := dbms_pickler.update_through_ref (?, ?, ?, ?); end;");
                cstmt.registerOutParameter(1, 2);
                cstmt.setBytes(2, this.shareBytes());
                cstmt.setInt(3, 0);
                cstmt.setBytes(4, toid_bytes);
                cstmt.setBytes(5, pickled_bytes);
                cstmt.execute();
                int result = 0;
                result = cstmt.getInt(1);
                if (result != 0) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)2, (String)("REF.setValue: Error ORA-" + result + ". An exception is thrown."));
                    }
                    DBError.throwSqlException((int)77, (Object)("ORA-" + result));
                }
                Object var8_7 = null;
                if (cstmt == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (cstmt != null) {
                    cstmt.close();
                }
                cstmt = null;
                throw throwable;
            }
            cstmt.close();
        }
        cstmt = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.setValue: return");
        }
    }

    public StructDescriptor getDescriptor() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getDescriptor()");
        }
        if (this.m_descriptor == null) {
            this.m_descriptor = StructDescriptor.createDescriptor(this.m_typename, (Connection)this.getInternalConnection());
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getDescriptor: return");
        }
        return this.m_descriptor;
    }

    public String getSQLTypeName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.getSQLTypeName()");
        }
        String ret = this.getBaseTypeName();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.getSQLTypeName: return: " + ret));
        }
        return ret;
    }

    public Object getObject(Map map) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Object getObject() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void setObject(Object value) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.toJdbc(): return");
        }
        return this;
    }

    public boolean isConvertibleTo(Class jClass) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.isConvertibleTo( jClass=" + jClass + "): return: false (always)"));
        }
        return false;
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.makeJdbcArray( arraySize=" + arraySize + "): return"));
        }
        return new REF[arraySize];
    }

    public Object clone() throws CloneNotSupportedException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.clone()");
        }
        REF ret = null;
        try {
            ret = new REF(this.getBaseTypeName(), (Connection)this.getInternalConnection(), this.getBytes());
        }
        catch (SQLException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("REF.clone: An exception is caught and thrown. " + e2.getMessage()));
            }
            throw new CloneNotSupportedException(e2.getMessage());
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.clone: return");
        }
        return ret;
    }

    public boolean equals(Object obj) {
        boolean ret;
        block4: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.equals( obj=" + obj + ")"));
            }
            ret = false;
            try {
                ret = obj instanceof REF && super.equals(obj) && this.getBaseTypeName().equals(((REF)obj).getSQLTypeName());
            }
            catch (Exception e2) {
                if (!OracleLog.TRACE) break block4;
                OracleLog.print((Object)this, (int)64, (int)2, (String)("REF.equals: An exception has been caught. " + e2.getMessage()));
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.equals: return: " + ret));
        }
        return ret;
    }

    public int hashCode() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.hashCode()");
        }
        byte[] pref = this.shareBytes();
        int hashcode = 0;
        if ((pref[2] & 5) == 5) {
            int i2 = 0;
            while (i2 < 4) {
                hashcode *= 256;
                hashcode += pref[8 + i2] & 0xFF;
                ++i2;
            }
        } else if ((pref[2] & 3) == 3) {
            int i3 = 0;
            while (i3 < 4 && i3 < pref.length) {
                hashcode *= 256;
                hashcode += pref[6 + i3] & 0xFF;
                ++i3;
            }
        } else if ((pref[2] & 2) == 2) {
            int i4 = 0;
            while (i4 < 4) {
                hashcode *= 256;
                hashcode += pref[8 + i4] & 0xFF;
                ++i4;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.hashCode: return: " + hashcode));
        }
        return hashcode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.writeObject( out=" + out + ")"));
        }
        out.writeObject(this.shareBytes());
        try {
            out.writeUTF(this.getBaseTypeName());
        }
        catch (SQLException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("REF.writeObject: Exception caught and thrown." + e2.getMessage()));
            }
            throw new IOException("SQLException ORA-" + e2.getErrorCode() + " " + e2.getMessage());
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.writeObject: return");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("REF.readObject( in=" + in + ")"));
        }
        this.setBytes((byte[])in.readObject());
        this.m_typename = in.readUTF();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"REF.readObject: return");
        }
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    static {
        DEBUG = false;
        serialVersionUID = 1328446996944583167L;
    }
}

