/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    static int hexDigit2Nibble(char hex) throws SQLException {
        int result;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.hexDigit2Nibble(" + hex + ")"));
        }
        if ((result = Character.digit(hex, 16)) == -1) {
            throw new SQLException("Invalid hex digit: " + hex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.hexDigit2Nibble:return: " + result));
        }
        return result;
    }

    public static byte[] hexString2Bytes(String hexString) throws SQLException {
        byte[] bytes;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.hexString2Bytes(" + hexString + ")"));
        }
        int len = hexString.length();
        char[] hexChars = new char[len];
        hexString.getChars(0, len, hexChars, 0);
        int i2 = 0;
        int j2 = 0;
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 > 0) {
            bytes = new byte[(len + 1) / 2];
            bytes[i2++] = (byte)RAW.hexDigit2Nibble(hexChars[j2++]);
        } else {
            bytes = new byte[len / 2];
        }
        while (i2 < bytes.length) {
            bytes[i2] = (byte)(RAW.hexDigit2Nibble(hexChars[j2++]) << 4 | RAW.hexDigit2Nibble(hexChars[j2++]));
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.hexString2Bytes:return: " + bytes));
        }
        return bytes;
    }

    public static RAW newRAW(Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.newRAW(" + obj + ")"));
        }
        RAW result = obj instanceof String ? new RAW(RAW.hexString2Bytes((String)obj)) : new RAW(obj);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.newRAW:return: " + result));
        }
        return result;
    }

    public static RAW oldRAW(Object obj) throws SQLException {
        RAW result;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.oldRAW(" + obj + ")"));
        }
        if (obj instanceof String) {
            String s2 = (String)obj;
            byte[] bytes = null;
            try {
                bytes = s2.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException e2) {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)("RAW.oldRAW: Exception caught and thrown." + e2.getMessage()));
                }
                DBError.throwSqlException((int)109, (Object)"ISO8859_1 character encoding not found");
            }
            result = new RAW(bytes);
        } else {
            result = new RAW(obj);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("RAW.oldRAW:return: " + result));
        }
        return result;
    }

    public RAW() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.RAW(): return");
        }
    }

    public RAW(byte[] raw_bytes) {
        super(raw_bytes);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("RAW.RAW( raw_bytes=" + raw_bytes + "): return -- after super() --"));
        }
    }

    public RAW(Object val) throws SQLException {
        this();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("RAW.RAW( val=" + val + ") -- after this() --"));
        }
        if (val instanceof byte[]) {
            this.setShareBytes((byte[])val);
        } else if (val instanceof String) {
            String s2 = (String)val;
            byte[] byteArray = null;
            try {
                byteArray = s2.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException e2) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)("RAW.RAW: Exception caught and thrown." + e2.getMessage()));
                }
                DBError.throwSqlException((int)109, (Object)"ISO8859_1 character encoding not found");
            }
            this.setShareBytes(byteArray);
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"RAW.RAW: will throw an exception because the type of the argument is not expected. The possible object types are java.lang.String and byte[].");
            }
            DBError.check_error((int)59, (Object)val);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("RAW.RAW( val=" + val + "): return"));
        }
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.toJdbc() -- no return trace --");
        }
        return this.getBytes();
    }

    public boolean isConvertibleTo(Class jClass) {
        String class_name;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("RAW.isConvertibleTo( jClass=" + jClass + ") -- no return trace --"));
        }
        return (class_name = jClass.getName()).compareTo("java.lang.String") == 0 || class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    public String stringValue() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.stringValue()");
        }
        String ret = RepConversion.bArray2String(this.getBytes());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)64, (String)("RAW.stringValue: return: " + ret));
        }
        return ret;
    }

    public Reader characterStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.characterStreamValue()");
        }
        int nbytes = (int)this.getLength();
        char[] chars = new char[nbytes * 2];
        byte[] bytes = this.shareBytes();
        DBConversion.RAWBytesToHexChars((byte[])bytes, (int)nbytes, (char[])chars);
        CharArrayReader ret = new CharArrayReader(chars);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.characterStreamValue: return");
        }
        return ret;
    }

    public InputStream asciiStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.asciiStreamValue()");
        }
        int nbytes = (int)this.getLength();
        char[] chars = new char[nbytes * 2];
        byte[] bytes = this.shareBytes();
        DBConversion.RAWBytesToHexChars((byte[])bytes, (int)nbytes, (char[])chars);
        byte[] buf = new byte[nbytes * 2];
        DBConversion.javaCharsToAsciiBytes((char[])chars, (int)(nbytes * 2), (byte[])buf);
        ByteArrayInputStream ret = new ByteArrayInputStream(buf);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.asciiStreamValue: return");
        }
        return ret;
    }

    public InputStream binaryStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"RAW.binaryStreamValue() -- no return trace --");
        }
        return this.getStream();
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("RAW.makeJdbcArray( arraySize=" + arraySize + ") -- no return trace --"));
        }
        return new byte[arraySize][];
    }
}

