/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleSQLOutput
implements SQLOutput {
    private StructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private OracleConnection conn;

    public OracleSQLOutput(StructDescriptor descriptor, OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.OracleSQLOutput( descriptor=" + descriptor + ", conn=" + conn + ")"));
        }
        this.descriptor = descriptor;
        this.attributes = new Object[descriptor.getLength()];
        this.conn = conn;
        this.index = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleSQLOutput.OracleSQLOutput: return");
        }
    }

    public STRUCT getSTRUCT() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleSQLOutput.getSTRUCT() -- no return trace --");
        }
        return new STRUCT(this.descriptor, (Connection)this.conn, this.attributes);
    }

    public void writeString(String x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeString( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeBoolean(boolean x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeBoolean( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = new Boolean(x);
    }

    public void writeByte(byte x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeByte( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = new Integer(x);
    }

    public void writeShort(short x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeShort( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = new Integer(x);
    }

    public void writeInt(int x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeInt( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = new Integer(x);
    }

    public void writeLong(long x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeLong( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = new Long(x);
    }

    public void writeFloat(float x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeFloat( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = new Float(x);
    }

    public void writeDouble(double x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeDouble( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = new Double(x);
    }

    public void writeBigDecimal(BigDecimal x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeBigDecimal( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeBytes(byte[] x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeBytes( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeDate(Date x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeDate( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeTime(Time x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeTime( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeTimestamp(Timestamp x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeTimestamp( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeCharacterStream(Reader x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeCharacterStream( x=" + x + ")"));
        }
        StringBuffer stringBuf = new StringBuffer();
        char[] charBuf = new char[100];
        int count = 0;
        try {
            while ((count = x.read(charBuf)) != -1) {
                stringBuf.append(charBuf, 0, count);
            }
        }
        catch (IOException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("OracleSQLOutput.writeCharacterStream: an IO exception has been caught while reading in 'x'. The exception is thrown." + e2.getMessage()));
            }
            DBError.check_error((IOException)e2);
        }
        String s2 = stringBuf.toString();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)64, (String)("OracleSQLOutput.writeCharacterStream: Here is what will be written: " + s2));
        }
        this.attributes[this.index++] = s2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleSQLOutput.writeCharacterStream: return");
        }
    }

    public void writeAsciiStream(InputStream x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeAsciiStream( x=" + x + ")"));
        }
        StringBuffer stringBuf = new StringBuffer();
        byte[] binaryBuf = new byte[100];
        char[] charBuf = new char[100];
        int count = 0;
        try {
            while ((count = x.read(binaryBuf)) != -1) {
                int i2 = 0;
                while (i2 < count) {
                    charBuf[i2] = (char)binaryBuf[i2];
                    ++i2;
                }
                stringBuf.append(charBuf, 0, count);
            }
        }
        catch (IOException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("OracleSQLOutput.writeAsciiStream: an IO exception has been caught while reading in 'x'. The exception is thrown." + e2.getMessage()));
            }
            DBError.check_error((IOException)e2);
        }
        String s2 = stringBuf.toString();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)64, (String)("OracleSQLOutput.writeAsciiStream: Here is what will be written: " + s2));
        }
        this.attributes[this.index++] = s2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleSQLOutput.writeAsciiStream: return");
        }
    }

    public void writeBinaryStream(InputStream x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeBinaryStream( x=" + x + ") -- no return trace --"));
        }
        this.writeAsciiStream(x);
    }

    public void writeObject(SQLData x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeObject( x=" + x + ")"));
        }
        STRUCT s2 = null;
        if (x != null) {
            StructDescriptor desc = StructDescriptor.createDescriptor(x.getSQLTypeName(), (Connection)this.conn);
            SQLOutput sqlOutput = desc.toJdbc2SQLOutput();
            x.writeSQL(sqlOutput);
            s2 = ((OracleSQLOutput)sqlOutput).getSTRUCT();
        }
        this.writeStruct(s2);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleSQLOutput.writeObject: return");
        }
    }

    public void writeObject(Object x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeObject( x=" + x + ")"));
        }
        if (x != null && x instanceof SQLData) {
            this.writeObject((SQLData)x);
        } else {
            this.attributes[this.index++] = x;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleSQLOutput.writeObject: return");
        }
    }

    public void writeRef(Ref x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeRef( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeBlob(Blob x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeBlob( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeClob(Clob x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeClob( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeStruct(Struct x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeStruct( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeArray(Array x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeArray( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeOracleObject(Datum x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeOracleObject( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeRef(REF x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeRef( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeBlob(BLOB x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeBlob( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeBfile(BFILE x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeBfile( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeClob(CLOB x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeClob( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeStruct(STRUCT x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeStruct( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeArray(ARRAY x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeArray( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeNUMBER(NUMBER x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeNUMBER( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeCHAR(CHAR x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeCHAR( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeDATE(DATE x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeDATE( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeRAW(RAW x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeRAW( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeROWID(ROWID x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleSQLOutput.writeROWID( x=" + x + ") -- no return trace --"));
        }
        this.attributes[this.index++] = x;
    }

    public void writeURL(URL x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }
}

