/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class OracleJdbc2SQLInput
implements SQLInput {
    private int index;
    private Datum[] attributes;
    private Map map;
    private OracleConnection conn;

    public OracleJdbc2SQLInput(Datum[] attributes, Map map, OracleConnection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.OracleJdbc2SQLInput( attributes=" + attributes + ", map=" + map + ", conn=" + conn + "): return"));
        }
        this.attributes = attributes;
        this.map = map;
        this.conn = conn;
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readString()");
        }
        String ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].stringValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readString: return:" + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readBoolean() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBoolean()");
        }
        boolean ret = false;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].booleanValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readBoolean: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readByte()");
        }
        byte ret = 0;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].byteValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readByte: return: " + ret));
        }
        return ret;
    }

    public short readShort() throws SQLException {
        long result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readShort()");
        }
        if ((result = this.readLong()) > 65537L || result < -65538L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)32, (String)"OracleJdbc2SQLInput.readShort: numeric overflow, the result is either > 65537 or < -65538. An exception is thrown.");
            }
            DBError.check_error((int)26, (Object)"readShort");
        }
        short ret = (short)result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readShort: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readInt()");
        }
        int ret = 0;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].intValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readInt: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readLong()");
        }
        long ret = 0L;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].longValue();
            }
            Object var4_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readLong: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readFloat() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readFloat()");
        }
        float ret = 0.0f;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].floatValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readFloat: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readDouble()");
        }
        double ret = 0.0;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].doubleValue();
            }
            Object var4_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readDouble: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal readBigDecimal() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBigDecimal()");
        }
        BigDecimal ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].bigDecimalValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBigDecimal: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBytes()");
        }
        byte[] ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof RAW) {
                    ret = ((RAW)this.attributes[this.index]).shareBytes();
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)4, (String)("OracleJdbc2SQLInput.readBytes: invalid column type, it should be RAW. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBytes: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date readDate() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readDate()");
        }
        Date ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].dateValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readDate: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time readTime() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readTime()");
        }
        Time ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].timeValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readTime: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp readTimestamp() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readTimestamp()");
        }
        Timestamp ret = null;
        try {
            if (this.attributes[this.index] != null) {
                ret = this.attributes[this.index].timestampValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readTimestamp()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader readCharacterStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readCharacterStream()");
        }
        Reader ret = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                ret = datum.characterStreamValue();
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readCharacterStream: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readAsciiStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readAsciiStream()");
        }
        InputStream ret = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                ret = datum.asciiStreamValue();
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readAsciiStream: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readBinaryStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBinaryStream()");
        }
        InputStream ret = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                ret = datum.binaryStreamValue();
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBinaryStream: return");
        }
        return ret;
    }

    public Object readObject() throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readObject() -- no return trace --");
        }
        if ((datum = (Datum)this.readOracleObject()) != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(this.map);
            }
            datum.toJdbc();
        }
        return null;
    }

    public Ref readRef() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readRef() -- no return trace --");
        }
        return this.readREF();
    }

    public Blob readBlob() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBlob() -- no return trace --");
        }
        return this.readBLOB();
    }

    public Clob readClob() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readClob() -- no return trace --");
        }
        return this.readCLOB();
    }

    public Array readArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readArray() -- no return trace --");
        }
        return this.readARRAY();
    }

    public Struct readStruct() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readStruct() -- no return trace --");
        }
        return this.readSTRUCT();
    }

    public boolean wasNull() throws SQLException {
        boolean ret;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.wasNull()");
        }
        if (this.index == 0) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)32, (String)"OracleJdbc2SQLInput.wasNull: an exception is thrown because 'index' = 0.");
            }
            DBError.throwSqlException((int)24);
        }
        boolean bl = ret = this.attributes[this.index - 1] == null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.wasNull: return: " + ret));
        }
        return ret;
    }

    public Object readOracleObject() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readOracleObject()");
        }
        Datum ret = this.attributes[this.index++];
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readOracleObject: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER readNUMBER() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readNUMBER()");
        }
        NUMBER ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof NUMBER) {
                    ret = (NUMBER)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readNUMBER: invalid column type, it should be NUMBER. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readNUMBER: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR readCHAR() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readCHAR()");
        }
        CHAR ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof CHAR) {
                    ret = (CHAR)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readCHAR: invalid column type, it should be CHAR. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readCHAR: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE readDATE() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readDATE()");
        }
        DATE ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof DATE) {
                    ret = (DATE)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readDATE: invalid column type, it should be DATE. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OracleJdbc2SQLInput.readDATE: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE readBFILE() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBFILE()");
        }
        BFILE ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof BFILE) {
                    ret = (BFILE)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readBFILE: invalid column type, it should be BFILE. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBFILE: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB readBLOB() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBLOB()");
        }
        BLOB ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof BLOB) {
                    ret = (BLOB)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readBLOB: invalid column type, it should be BLOB. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readBLOB: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB readCLOB() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readCLOB()");
        }
        CLOB ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof CLOB) {
                    ret = (CLOB)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readCLOB: invalid column type, it should be CLOB. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readCLOB: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW readRAW() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readRAW()");
        }
        RAW ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof RAW) {
                    ret = (RAW)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readRAW: invalid column type, it should be RAW. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readRAW: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF readREF() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readREF()");
        }
        REF ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof REF) {
                    ret = (REF)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readREF: invalid column type, it should be REF. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readREF: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID readROWID() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readROWID()");
        }
        ROWID ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof ROWID) {
                    ret = (ROWID)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readROWID: invalid column type, it should be ROWID. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readROWID: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY readARRAY() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readARRAY()");
        }
        ARRAY ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof ARRAY) {
                    ret = (ARRAY)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readARRAY: invalid column type, it should be ARRAY. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readARRAY: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT readSTRUCT() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readSTRUCT()");
        }
        STRUCT ret = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof STRUCT) {
                    ret = (STRUCT)this.attributes[this.index];
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)32, (String)("OracleJdbc2SQLInput.readSTRUCT: invalid column type, it should be STRUCT. attributes[index=" + this.index + "]=" + this.attributes[this.index] + ". An exception is thrown."));
                    }
                    DBError.check_error((int)4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OracleJdbc2SQLInput.readSTRUCT: return");
        }
        return ret;
    }

    public URL readURL() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }
}

