/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OpaqueDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;

    public static OpaqueDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        SQLName sqlName;
        String qualifiedName;
        OpaqueDescriptor descriptor;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("OpaqueDescriptor.createDescriptor( name=" + name + ", conn=" + conn + ")"));
        }
        if (name == null || name.length() == 0 || conn == null) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)"OpaqueDescriptor.createDescriptor: Invalid argument, 'name' shouldn't be null nor an empty string and 'conn' should not be null as well. An exception is thrown.");
            }
            DBError.check_error((int)60, (Object)"Invalid arguments");
        }
        if ((descriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName = (sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn)).getName())) == null) {
            descriptor = new OpaqueDescriptor(sqlName, conn);
            ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"OpaqueDescriptor.createDescriptor: return");
        }
        return descriptor;
    }

    public OpaqueDescriptor(String name, Connection connection) throws SQLException {
        super(name, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.OpaqueDescriptor( name=" + name + ", connection=" + connection + ") " + "-- after super() --"));
        }
        this.initPickler();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.OpaqueDescriptor: return");
        }
    }

    public OpaqueDescriptor(SQLName name, Connection connection) throws SQLException {
        super(name, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.OpaqueDescriptor( name=" + name + ", connection=" + connection + ") " + "-- after super() --"));
        }
        this.initPickler();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.OpaqueDescriptor: return");
        }
    }

    public OpaqueDescriptor(SQLName name, OracleTypeOPAQUE type, Connection connection) throws SQLException {
        super(name, (OracleTypeADT)type, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.OpaqueDescriptor( name=" + name + ", type=" + type + ", connection=" + connection + ")" + " -- after super() -- return"));
        }
    }

    private void initPickler() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.initPickler()");
        }
        try {
            this.m_pickler = new OracleTypeADT(this.getName(), (Connection)this.m_conn);
            ((OracleTypeADT)this.m_pickler).init((OracleConnection)this.m_conn);
            this.m_pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.m_pickler).cleanup();
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("OpaqueDescriptor.initPickler: exception caught and thrown." + e2.getMessage()));
            }
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.throwSqlException((int)60, (Object)("Unable to resolve type \"" + this.getName() + "\""));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.initPickler: return");
        }
    }

    public OpaqueDescriptor(OracleTypeADT type, Connection connection) throws SQLException {
        super(type, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.OpaqueDescriptor( type=" + type + ", connection=" + connection + ")" + ": return -- after super() --"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] toBytes(OPAQUE obj, boolean keepLocalCopy) throws SQLException {
        byte[] ret;
        block7: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.toBytes( obj=" + obj + ", keepLocalCopy=" + keepLocalCopy + ")"));
            }
            ret = null;
            if (obj.shareBytes() != null) {
                ret = obj.shareBytes();
            } else {
                try {
                    ret = this.m_pickler.linearize(obj);
                    Object var5_4 = null;
                    if (keepLocalCopy) break block7;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!keepLocalCopy) {
                        obj.setShareBytes(null);
                    }
                    throw throwable;
                }
                obj.setShareBytes(null);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.toBytes: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE obj, boolean keepLocalCopy) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.toValue( obj=" + obj + ", keepLocalCopy=" + keepLocalCopy + ")"));
        }
        byte[] ret = null;
        if (obj.m_value != null) {
            ret = obj.m_value;
        } else {
            try {
                this.m_pickler.unlinearize(obj.shareBytes(), 0L, obj, 1, null);
                ret = obj.m_value;
                Object var5_4 = null;
                if (!keepLocalCopy) {
                    obj.m_value = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!keepLocalCopy) {
                    obj.m_value = null;
                }
                throw throwable;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.toValue: return");
        }
        return ret;
    }

    public int getTypeCode() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.getTypeCode(): return: 2007");
        }
        return 2007;
    }

    public long getMaxLength() throws SQLException {
        long ret;
        long l2 = ret = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.m_pickler).getMaxLength();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.getMaxLength(): return: " + ret));
        }
        return ret;
    }

    public boolean isTrustedLibrary() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.isTrustedLibrary() -- no return trace --");
        }
        return ((OracleTypeOPAQUE)this.m_pickler).isTrustedLibrary();
    }

    public boolean isModeledInC() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.isModeledInC() -- no return trace --");
        }
        return ((OracleTypeOPAQUE)this.m_pickler).isModeledInC();
    }

    public boolean hasUnboundedSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.hasUnboundedSize() -- no return trace --");
        }
        return ((OracleTypeOPAQUE)this.m_pickler).isUnboundedSized();
    }

    public boolean hasFixedSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.hasFixedSize() -- no return trace --");
        }
        return ((OracleTypeOPAQUE)this.m_pickler).isFixedSized();
    }

    public String descType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OpaqueDescriptor.descType()");
        }
        StringBuffer strBuf = new StringBuffer();
        String ret = this.descType(strBuf, 0);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.descType: return: " + ret));
        }
        return ret;
    }

    String descType(StringBuffer strBuf, int level) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.descType( strBuf=" + strBuf + ", level=" + level + ")"));
        }
        String level_one = "";
        int i2 = 0;
        while (i2 < level) {
            level_one = level_one + "  ";
            ++i2;
        }
        String level_two = level_one + "  ";
        strBuf.append(level_one);
        strBuf.append(this.getTypeName());
        strBuf.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        strBuf.append("\n");
        String ret = strBuf.toString();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.descType: return: " + ret));
        }
        return ret;
    }

    public Class getClass(Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.getClass( map=" + map + ")"));
        }
        Class ret = null;
        String qualifiedName = this.getName();
        Class c2 = (Class)map.get(qualifiedName);
        String schema = this.getSchemaName();
        String type = this.getTypeName();
        if (c2 == null && this.m_conn.getUserName().equals(schema)) {
            c2 = (Class)map.get(type);
        }
        if (!SQLName.s_parseAllFormat) {
            ret = c2;
        } else {
            if (c2 == null && this.m_conn.getUserName().equals(schema)) {
                c2 = (Class)map.get("\"" + type + "\"");
            }
            if (c2 == null) {
                c2 = (Class)map.get("\"" + schema + "\"" + "." + "\"" + type + "\"");
            }
            if (c2 == null) {
                c2 = (Class)map.get("\"" + schema + "\"" + "." + type);
            }
            if (c2 == null) {
                c2 = (Class)map.get(schema + "." + "\"" + type + "\"");
            }
            ret = c2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.getClass: return: " + ret));
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.writeObject( out=" + out + ") -- this does nothing --"));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("OpaqueDescriptor.readObject( in=" + in + ") -- this does nothing --"));
        }
    }

    static {
        DEBUG = false;
        serialVersionUID = 1013921343538311063L;
    }
}

