/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;

    public static long plsql_read(BLOB blob, long pos, long length, byte[] bytes_read) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_read( blob=" + blob + ", pos=" + pos + ", length=" + length + ", bytes_read=" + bytes_read + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_read((OracleConnection)blob.getConnection(), (Datum)blob, (int)2004, (long)pos, (long)length, (byte[])bytes_read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_write(BLOB blob, long pos, byte[] bytes, int totalSize) throws SQLException {
        int totalSizeWritten;
        block7: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_write( blob=" + blob + ", pos=" + pos + ", bytes=" + bytes + ", totalSize=" + totalSize + ")"));
            }
            OracleCallableStatement cstmt = null;
            totalSizeWritten = 0;
            cstmt = (OracleCallableStatement)blob.getConnection().prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
            try {
                int chunkSize = Math.min(totalSize, 32512);
                byte[] data = new byte[chunkSize];
                cstmt.registerOutParameter(1, 2004);
                while (true) {
                    if (totalSizeWritten >= totalSize) {
                        Object var10_8 = null;
                        if (cstmt == null) break block7;
                        break;
                    }
                    chunkSize = Math.min(totalSize - totalSizeWritten, 32512);
                    System.arraycopy(bytes, totalSizeWritten, data, 0, chunkSize);
                    cstmt.setBLOB(1, blob);
                    cstmt.setInt(2, chunkSize);
                    cstmt.setLong(3, pos + (long)totalSizeWritten);
                    cstmt.setBytes(4, data);
                    cstmt.execute();
                    totalSizeWritten += chunkSize;
                    blob.setLocator(cstmt.getBLOB(1).getLocator());
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_write: return: " + totalSizeWritten));
        }
        return totalSizeWritten;
    }

    public static long plsql_length(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_length( blob=" + blob + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_length((OracleConnection)blob.getConnection(), (Datum)blob, (int)2004);
    }

    public static long plsql_hasPattern(BLOB blob, byte[] pattern, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_hasPattern( blob=" + blob + ", pattern=" + pattern + ", startPos=" + startPos + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_hasPattern((OracleConnection)blob.getConnection(), (Datum)blob, (int)2004, (byte[])pattern, (long)startPos);
    }

    public static long plsql_isSubLob(BLOB blob, BLOB subLob, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isSubLob( blob=" + blob + ", subLob=" + subLob + ", startPos=" + startPos + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_isSubLob((OracleConnection)blob.getConnection(), (Datum)blob, (int)2004, (Datum)subLob, (long)startPos);
    }

    public static long plsql_getChunkSize(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_getChunkSize( blob=" + blob + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_getChunkSize((OracleConnection)blob.getConnection(), (Datum)blob, (int)2004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_read(CLOB clob, long pos, long length, char[] buffer) throws SQLException {
        int totalSizeRead;
        block16: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_read( clob=" + clob + ", pos=" + pos + ", length=" + length + ", buffer=" + buffer + ")"));
            }
            OracleStatement cstmt = null;
            totalSizeRead = 0;
            int nlsratio = 1;
            try {
                try {
                    Object data = null;
                    boolean numCharsToWrite = false;
                    OracleConnection conn = clob.getConnection();
                    DBConversion dbconv = conn.conversion;
                    boolean isCharSetMultibyte = DBConversion.isCharSetMultibyte((short)dbconv.getAccessCharSet());
                    if (isCharSetMultibyte) {
                        nlsratio = conn.db_access.getMaxCharSize();
                    }
                    cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.read(?, ?, ?, ?); end;");
                    int readThisTime = 0;
                    int chunkSize = 0;
                    byte[] bytesThisTime = null;
                    char[] charsThisTime = new char[32512];
                    if (clob.isNCLOB()) {
                        ((OraclePreparedStatement)cstmt).setFormOfUse(1, (short)2);
                        ((OraclePreparedStatement)cstmt).setFormOfUse(4, (short)2);
                        if (dbconv.IsNCharFixedWith()) {
                            nlsratio = 2;
                        }
                    }
                    ((OracleCallableStatement)cstmt).setCLOB(1, clob);
                    ((OracleCallableStatement)cstmt).registerOutParameter(2, 2);
                    ((OracleCallableStatement)cstmt).registerOutParameter(4, 12);
                    while ((long)totalSizeRead < length) {
                        chunkSize = (int)Math.min(length - (long)totalSizeRead, (long)(32512 / nlsratio));
                        ((OracleCallableStatement)cstmt).setInt(2, chunkSize);
                        ((OracleCallableStatement)cstmt).setLong(3, pos + (long)totalSizeRead);
                        ((OracleCallableStatement)cstmt).execute();
                        readThisTime = ((OracleCallableStatement)cstmt).getInt(2);
                        bytesThisTime = ((OracleCallableStatement)cstmt).getBytes(4);
                        int numConvs = 0;
                        numConvs = clob.isNCLOB() ? dbconv.NCHARBytesToJavaChars(bytesThisTime, bytesThisTime.length, charsThisTime) : dbconv.CHARBytesToJavaChars(bytesThisTime, bytesThisTime.length, charsThisTime);
                        if (numConvs != readThisTime) {
                            if (OracleLog.TRACE) {
                                OracleLog.print(null, (int)64, (int)4, (String)"LobPlsqlUtil.plsql_read: Conversion from UTF8 to UCS2 failed");
                            }
                            DBError.check_error((int)37, null);
                        }
                        System.arraycopy(charsThisTime, 0, buffer, totalSizeRead, readThisTime);
                        totalSizeRead += readThisTime;
                    }
                }
                catch (SQLException e2) {
                    if (e2.getErrorCode() != 1403) {
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)4, (String)("LobPlsqlUtil.plsql_read: exception caught and thrown." + e2.getMessage()));
                        }
                        throw e2;
                    }
                    Object var20_19 = null;
                    if (cstmt != null) {
                        cstmt.close();
                        cstmt = null;
                    }
                    break block16;
                }
                Object var20_18 = null;
                if (cstmt == null) break block16;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_read: return: " + totalSizeRead));
        }
        return totalSizeRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static long plsql_write(CLOB clob, long pos, char[] chars, int requireSize) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_write( clob=" + clob + ", pos=" + pos + ", chars=" + chars + ", requireSize=" + requireSize + ")"));
        }
        cstmt = null;
        conn = clob.getConnection();
        numCharsWritten = 0;
        charsConverted = false;
        nextCharConvertSize = false;
        try {
            data = null;
            numCharsToWrite = 0;
            dbconv = conn.conversion;
            isCharSetMultibyte = DBConversion.isCharSetMultibyte((short)dbconv.getAccessCharSet());
            cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.write (?, ?, ?, ?); end;");
            if (clob.isNCLOB()) {
                cstmt.setFormOfUse(1, (short)2);
            }
            cstmt.registerOutParameter(1, 2005);
            if (!isCharSetMultibyte && !clob.isNCLOB()) {
                while (numCharsWritten < requireSize) {
                    cstmt.setCLOB(1, clob);
                    cstmt.setLong(3, pos + (long)numCharsWritten);
                    numCharsToWrite = Math.min(requireSize - numCharsWritten, 32512);
                    data = new String(chars, numCharsWritten, numCharsToWrite);
                    cstmt.setInt(2, numCharsToWrite);
                    cstmt.setString(4, data);
                    cstmt.execute();
                    numCharsWritten += numCharsToWrite;
                    clob.setLocator(cstmt.getCLOB(1).getLocator());
                }
            } else {
                nlsratio = conn.db_access.getC2SNlsRatio();
                maxCharbyteSize = dbconv.getMaxCharbyteSize();
                if (clob.isNCLOB()) {
                    maxCharbyteSize = dbconv.getMaxNCharbyteSize();
                    if (dbconv.IsNCharFixedWith()) {
                        nlsratio = 2;
                    }
                }
                maxChunkSize = 32512 / nlsratio;
                firstConvSize = Math.min(maxChunkSize / maxCharbyteSize, requireSize);
                eachConvSize = firstConvSize / 3;
                lastConvSize = 100;
                convbuf = new byte[firstConvSize * maxCharbyteSize];
                charbuf = new char[firstConvSize];
                beginConvPos = 0;
                numConvBytes = 0;
                numConvChars = 0;
                numTotalConvBytes = 0;
                numTotalConvChars = 0;
                done = false;
                isFirst = true;
                while (numCharsWritten < requireSize) {
                    cstmt.setCLOB(1, clob);
                    cstmt.setLong(3, pos + (long)numCharsWritten);
                    done = false;
                    numTotalConvBytes = 0;
                    numTotalConvChars = 0;
                    ostream = new ByteArrayOutputStream();
                    isFirst = true;
                    while (!done) {
                        if (numConvBytes != 0) {
                            isFirst = false;
                            ostream.write(convbuf, 0, numConvBytes);
                            numTotalConvBytes += numConvBytes;
                            numConvBytes = 0;
                            numTotalConvChars += numConvChars;
                            numConvChars = 0;
                        }
                        if (isFirst) {
                            numConvChars = Math.min(firstConvSize, requireSize - beginConvPos);
                            isFirst = false;
                        } else {
                            numConvChars = Math.min(eachConvSize, requireSize - beginConvPos);
                            if (numConvChars * maxCharbyteSize + numTotalConvBytes > maxChunkSize && numConvChars > lastConvSize) {
                                numConvChars = lastConvSize;
                            }
                        }
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)64, (String)("LobPlsqlUtil.plsql_write: while !done  " + numConvChars + " " + numTotalConvChars));
                        }
                        if (numConvChars > 0) {
                            i = 0;
                            while (i < numConvChars) {
                                charbuf[i] = chars[beginConvPos + i];
                                ++i;
                            }
                            beginConvPos += numConvChars;
                            numConvBytes = clob.isNCLOB() != false ? dbconv.javaCharsToNCHARBytes(charbuf, numConvChars, convbuf) : dbconv.javaCharsToCHARBytes(charbuf, numConvChars, convbuf);
                            if (numTotalConvBytes + numConvBytes <= maxChunkSize) {
                                ostream.write(convbuf, 0, numConvBytes);
                                numTotalConvChars += numConvChars;
                                numTotalConvBytes += numConvBytes;
                                numConvBytes = 0;
                                numConvChars = 0;
                                if (numTotalConvBytes != maxChunkSize) continue;
                                done = true;
                                continue;
                            }
                            done = true;
                            continue;
                        }
                        done = true;
                    }
                    if (numTotalConvChars > 0) {
                        bytes = ostream.toByteArray();
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)64, (String)("LobPlsqlUtil.plsql_write: execute  .... " + numTotalConvChars + " " + bytes.length + " " + maxChunkSize));
                        }
                        cstmt.setInt(2, numTotalConvChars);
                        if (clob.isNCLOB()) {
                            cstmt.setFormOfUse(4, (short)2);
                        }
                        cstmt.setInternalBytes(4, bytes, 1);
                        cstmt.execute();
                        numCharsWritten += numTotalConvChars;
                        clob.setLocator(cstmt.getCLOB(1).getLocator());
                        continue;
                    }
                    if (numCharsWritten >= requireSize) continue;
                    if (OracleLog.TRACE) {
                        OracleLog.print(null, (int)64, (int)4, (String)"LobPlsqlUtil.plsql_write: Error while processing");
                    }
                    DBError.throwSqlException((int)1);
                }
            }
            var32_31 = null;
            ** if (cstmt == null) goto lbl-1000
        }
        catch (Throwable var31_33) {
            var32_32 = null;
            if (cstmt != null) {
                cstmt.close();
                cstmt = null;
            }
            throw var31_33;
        }
lbl-1000:
        // 1 sources

        {
            cstmt.close();
            cstmt = null;
        }
lbl-1000:
        // 2 sources

        {
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_write: return: " + numCharsWritten));
        }
        return numCharsWritten;
    }

    public static long plsql_length(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_length( clob=" + clob + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_length((OracleConnection)clob.getConnection(), (Datum)clob, (int)2005);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long plsql_hasPattern(CLOB clob, char[] pattern, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_hasPattern( clob=" + clob + ", pattern=" + pattern + ", startPos=" + startPos + ") -- no return trace --"));
        }
        if (pattern == null || startPos <= 0L) {
            return 0L;
        }
        OracleConnection conn = clob.getConnection();
        long patternLen = pattern.length;
        long lobLen = LobPlsqlUtil.plsql_length((OracleConnection)conn, (Datum)clob, (int)2005);
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize((OracleConnection)conn)) {
            long l2;
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                cstmt.registerOutParameter(1, 2);
                if (clob.isNCLOB()) {
                    cstmt.setFormOfUse(2, (short)2);
                    cstmt.setFormOfUse(3, (short)2);
                }
                cstmt.setCLOB(2, clob);
                cstmt.setString(3, new String(pattern));
                cstmt.setLong(4, startPos);
                cstmt.execute();
                l2 = cstmt.getLong(1);
                Object var13_10 = null;
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                cstmt.close();
                cstmt = null;
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
            return l2;
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize((OracleConnection)conn), patternLen - (long)matchedLen);
            char[] subPattern = new char[subPatternLen];
            System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
            long subMatchedPos = LobPlsqlUtil.plsql_hasPattern((CLOB)clob, (char[])subPattern, (long)subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize((OracleConnection)conn), patternLen - (long)matchedLen);
                subPattern = new char[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.plsql_hasPattern((CLOB)clob, (char[])subPattern, (long)subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    public static long plsql_isSubLob(CLOB clob, CLOB subLob, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isSubLob( clob=" + clob + ", subLob=" + subLob + ", startPos=" + startPos + ") -- no return trace --"));
        }
        if (subLob == null || startPos <= 0L) {
            return 0L;
        }
        OracleConnection conn = clob.getConnection();
        long patternLen = LobPlsqlUtil.plsql_length((OracleConnection)conn, (Datum)subLob, (int)2005);
        long lobLen = LobPlsqlUtil.plsql_length((OracleConnection)conn, (Datum)clob, (int)2005);
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize((OracleConnection)conn)) {
            char[] pattern = new char[(int)patternLen];
            subLob.getChars(1L, (int)patternLen, pattern);
            return LobPlsqlUtil.plsql_hasPattern((CLOB)clob, (char[])pattern, (long)startPos);
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize((OracleConnection)conn), patternLen - (long)matchedLen);
            char[] subPattern = new char[subPatternLen];
            subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
            long subMatchedPos = LobPlsqlUtil.plsql_hasPattern((CLOB)clob, (char[])subPattern, (long)subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize((OracleConnection)conn), patternLen - (long)matchedLen);
                subPattern = new char[subPatternLen];
                subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
                subMatchedPos = LobPlsqlUtil.plsql_hasPattern((CLOB)clob, (char[])subPattern, (long)subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    public static long plsql_getChunkSize(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_getChunkSize( clob=" + clob + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_getChunkSize((OracleConnection)clob.getConnection(), (Datum)clob, (int)2005);
    }

    public static long plsql_read(BFILE bfile, long pos, long length, byte[] bytes_read) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_read( bfile=" + bfile + ", pos=" + pos + ", length=" + length + ", bytes_read=" + bytes_read + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_read((OracleConnection)bfile.getConnection(), (Datum)bfile, (int)-13, (long)pos, (long)length, (byte[])bytes_read);
    }

    public static long plsql_length(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_length( bfile=" + bfile + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_length((OracleConnection)bfile.getConnection(), (Datum)bfile, (int)-13);
    }

    public static long plsql_hasPattern(BFILE bfile, byte[] pattern, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_hasPattern( bfile=" + bfile + ", pattern=" + pattern + ", startPos=" + startPos + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_hasPattern((OracleConnection)bfile.getConnection(), (Datum)bfile, (int)-13, (byte[])pattern, (long)startPos);
    }

    public static long plsql_isSubLob(BFILE bfile, BFILE subLob, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isSubLob( bfile=" + bfile + ", subLob=" + subLob + ", startPos=" + startPos + ") -- no return trace --"));
        }
        return LobPlsqlUtil.plsql_isSubLob((OracleConnection)bfile.getConnection(), (Datum)bfile, (int)-13, (Datum)subLob, (long)startPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void plsql_fileOpen(BFILE bfile) throws SQLException {
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileOpen( bfile=" + bfile + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getConnection().prepareCall("begin dbms_lob.fileopen (?, ?); end;");
                cstmt.setBFILE(1, bfile);
                cstmt.setInt(2, 0);
                cstmt.registerOutParameter(1, -13);
                cstmt.execute();
                bfile.setLocator(cstmt.getBFILE(1).getLocator());
                Object var3_2 = null;
                if (cstmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"LobPlsqlUtil.plsql_fileOpen: return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean plsql_fileIsOpen(BFILE bfile) throws SQLException {
        boolean ret;
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileIsOpen( bfile=" + bfile + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getConnection().prepareCall("begin ? := dbms_lob.fileIsOpen(?); end; ");
                cstmt.registerOutParameter(1, 2);
                cstmt.setBFILE(2, bfile);
                cstmt.execute();
                ret = cstmt.getBoolean(1);
                Object var4_3 = null;
                if (cstmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileIsOpen: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean plsql_fileExists(BFILE bfile) throws SQLException {
        boolean ret;
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileExists( bfile=" + bfile + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getConnection().prepareCall("begin ? := dbms_lob.fileExists(?); end; ");
                cstmt.registerOutParameter(1, 2);
                cstmt.setBFILE(2, bfile);
                cstmt.execute();
                ret = cstmt.getBoolean(1);
                Object var4_3 = null;
                if (cstmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileExists: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String plsql_fileGetName(BFILE bfile) throws SQLException {
        String ret;
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileGetName( bfile=" + bfile + ")"));
            }
            OracleCallableStatement cstmt = null;
            ret = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getConnection().prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
                cstmt.setBFILE(1, bfile);
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 12);
                cstmt.execute();
                ret = cstmt.getString(3);
                Object var4_3 = null;
                if (cstmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileGetName: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String plsql_fileGetDirAlias(BFILE bfile) throws SQLException {
        String ret;
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileGetDirAlias( bfile=" + bfile + ")"));
            }
            OracleCallableStatement cstmt = null;
            ret = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getConnection().prepareCall("begin dbms_lob.fileGetName(?, ?, ?); end; ");
                cstmt.setBFILE(1, bfile);
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 12);
                cstmt.execute();
                ret = cstmt.getString(2);
                Object var4_3 = null;
                if (cstmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileGetDirAlias: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void plsql_fileClose(BFILE bfile) throws SQLException {
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_fileClose( bfile=" + bfile + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getConnection().prepareCall("begin dbms_lob.fileclose (?); end;");
                cstmt.setBFILE(1, bfile);
                cstmt.registerOutParameter(1, -13);
                cstmt.execute();
                bfile.setLocator(cstmt.getBFILE(1).getLocator());
                Object var3_2 = null;
                if (cstmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"LobPlsqlUtil.plsql_fileClose: return");
        }
    }

    private static int getPlsqlMaxInstrSize(OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.getPlsqlMaxInstrSize( conn=" + conn + ")"));
        }
        DBConversion dbconv = conn.conversion;
        boolean isCharSetMultibyte = DBConversion.isCharSetMultibyte((short)dbconv.getAccessCharSet());
        int maxCharbyteSize = dbconv.getMaxCharbyteSize();
        int ret = 32512;
        if (isCharSetMultibyte) {
            ret = 32512 / (conn.db_access.getC2SNlsRatio() * maxCharbyteSize);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.getPlsqlMaxInstrSize: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_read(OracleConnection conn, Datum lob, int type, long pos, long length, byte[] bytes_read) throws SQLException {
        int totalSizeRead;
        block15: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_read( conn=" + conn + ", lob=" + lob + ", type=" + type + ", pos=" + pos + ", length=" + length + ", bytes_read=" + bytes_read + ")"));
            }
            OracleCallableStatement cstmt = null;
            totalSizeRead = 0;
            try {
                try {
                    cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.read (?, ?, ?, ?); end;");
                    int readThisTime = 0;
                    int chunkSize = 0;
                    if (LobPlsqlUtil.isNCLOB(lob)) {
                        cstmt.setFormOfUse(1, (short)2);
                        cstmt.setFormOfUse(4, (short)2);
                    }
                    cstmt.setObject(1, (Object)lob, type);
                    cstmt.registerOutParameter(2, 2);
                    cstmt.registerOutParameter(4, -3);
                    while ((long)totalSizeRead < length) {
                        chunkSize = Math.min((int)length, 32512);
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)64, (String)("LobPlsqlUtil.plsql_read: read chunks: chunkSize=" + chunkSize));
                        }
                        cstmt.setInt(2, chunkSize);
                        cstmt.setInt(3, (int)pos + totalSizeRead);
                        cstmt.execute();
                        readThisTime = cstmt.getInt(2);
                        byte[] bytesThisTime = cstmt.getBytes(4);
                        System.arraycopy(bytesThisTime, 0, bytes_read, totalSizeRead, readThisTime);
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)64, (String)("LobPlsqlUtil.plsql_read: ==> sizeRead=" + readThisTime));
                        }
                        totalSizeRead += readThisTime;
                        length -= (long)readThisTime;
                    }
                }
                catch (SQLException e2) {
                    if (e2.getErrorCode() != 1403) {
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)4, (String)("LobPlsqlUtil.plsql_read: exception caught and thrown." + e2.getMessage()));
                        }
                        throw e2;
                    }
                    if (OracleLog.TRACE) {
                        OracleLog.print(null, (int)64, (int)4, (String)"LobPlsqlUtil.plsql_read: ORA-1403 No data found, end of file");
                    }
                    Object var14_13 = null;
                    if (cstmt != null) {
                        cstmt.close();
                        cstmt = null;
                    }
                    break block15;
                }
                Object var14_12 = null;
                if (cstmt == null) break block15;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_read: return: " + (long)totalSizeRead));
        }
        return totalSizeRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_length(OracleConnection conn, Datum lob, int type) throws SQLException {
        long lob_length;
        block6: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_length( conn=" + conn + ", lob=" + lob + ", type=" + type + ")"));
            }
            lob_length = 0L;
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin ? := dbms_lob.getLength (?); end;");
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(2, (short)2);
                }
                cstmt.setObject(2, (Object)lob, type);
                cstmt.registerOutParameter(1, 2);
                cstmt.execute();
                lob_length = cstmt.getLong(1);
                Object var7_5 = null;
                if (cstmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_length: return: " + lob_length));
        }
        return lob_length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long plsql_hasPattern(OracleConnection conn, Datum lob, int type, byte[] pattern, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_hasPattern( conn=" + conn + ", lob=" + lob + ", type=" + type + ", pattern=" + pattern + ", startPos=" + startPos + ") -- no return trace --"));
        }
        if (pattern == null || startPos <= 0L) {
            return 0L;
        }
        long patternLen = pattern.length;
        long lobLen = LobPlsqlUtil.plsql_length((OracleConnection)conn, (Datum)lob, (int)type);
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= 32512L) {
            long l2;
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin ? := dbms_lob.instr(?, ?, ?); end;");
                cstmt.registerOutParameter(1, 2);
                cstmt.setObject(2, (Object)lob, type);
                cstmt.setBytes(3, pattern);
                cstmt.setLong(4, startPos);
                cstmt.execute();
                l2 = cstmt.getLong(1);
                Object var14_11 = null;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                cstmt.close();
                cstmt = null;
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
            return l2;
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
            byte[] subPattern = new byte[subPatternLen];
            System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
            long subMatchedPos = LobPlsqlUtil.plsql_hasPattern((OracleConnection)conn, (Datum)lob, (int)type, (byte[])subPattern, (long)subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                subPattern = new byte[subPatternLen];
                System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                subMatchedPos = LobPlsqlUtil.plsql_hasPattern((OracleConnection)conn, (Datum)lob, (int)type, (byte[])subPattern, (long)subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    public static long plsql_isSubLob(OracleConnection conn, Datum lob, int type, Datum subLob, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isSubLob( conn=" + conn + ", lob=" + lob + ", type=" + type + ", subLob=" + subLob + ", startPos=" + startPos + ") -- no return trace --"));
        }
        if (subLob == null || startPos <= 0L) {
            return 0L;
        }
        long patternLen = LobPlsqlUtil.plsql_length((OracleConnection)conn, (Datum)subLob, (int)type);
        long lobLen = LobPlsqlUtil.plsql_length((OracleConnection)conn, (Datum)lob, (int)type);
        if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
            return 0L;
        }
        if (patternLen <= 32512L) {
            byte[] pattern = new byte[(int)patternLen];
            LobPlsqlUtil.plsql_read((OracleConnection)conn, (Datum)subLob, (int)type, (long)1L, (long)patternLen, (byte[])pattern);
            return LobPlsqlUtil.plsql_hasPattern((OracleConnection)conn, (Datum)lob, (int)type, (byte[])pattern, (long)startPos);
        }
        int matchedLen = 0;
        long subStartPos = startPos;
        boolean done = false;
        long matchedPos = 0L;
        while (!done) {
            if (patternLen > lobLen - subStartPos + 1L) {
                return 0L;
            }
            matchedLen = 0;
            int subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
            byte[] subPattern = new byte[subPatternLen];
            LobPlsqlUtil.plsql_read((OracleConnection)conn, (Datum)subLob, (int)type, (long)(matchedLen + 1), (long)subPatternLen, (byte[])subPattern);
            long subMatchedPos = LobPlsqlUtil.plsql_hasPattern((OracleConnection)conn, (Datum)lob, (int)type, (byte[])subPattern, (long)subStartPos);
            if (subMatchedPos == 0L) {
                return 0L;
            }
            matchedPos = subMatchedPos;
            matchedLen += subPatternLen;
            subStartPos = subMatchedPos + (long)subPatternLen;
            boolean moreChunks = true;
            while (moreChunks) {
                subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                subPattern = new byte[subPatternLen];
                LobPlsqlUtil.plsql_read((OracleConnection)conn, (Datum)subLob, (int)type, (long)(matchedLen + 1), (long)subPatternLen, (byte[])subPattern);
                subMatchedPos = LobPlsqlUtil.plsql_hasPattern((OracleConnection)conn, (Datum)lob, (int)type, (byte[])subPattern, (long)subStartPos);
                if (subMatchedPos == subStartPos) {
                    subStartPos += (long)subPatternLen;
                    if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                    moreChunks = false;
                    done = true;
                    continue;
                }
                if (subMatchedPos == 0L) {
                    return 0L;
                }
                subStartPos = subMatchedPos - (long)matchedLen;
                moreChunks = false;
            }
        }
        return matchedPos;
    }

    private static boolean isNCLOB(Datum lob) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.isNCLOB( lob=" + lob + ") -- no return trace --"));
        }
        Class<?> cl = null;
        try {
            cl = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException exp) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)32, (String)"LobPlsqlUtil.isNCLOB: Could not find class oracle.sql.CLOB ");
            }
            return false;
        }
        if (!cl.isInstance(lob)) {
            return false;
        }
        CLOB clob = (CLOB)lob;
        return clob.isNCLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_getChunkSize(OracleConnection conn, Datum lob, int type) throws SQLException {
        long lob_length;
        block12: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_getChunkSize( conn=" + conn + ", lob=" + lob + ", type=" + type + ")"));
            }
            lob_length = 0L;
            OracleCallableStatement cstmt = null;
            try {
                try {
                    cstmt = (OracleCallableStatement)conn.prepareCall("begin ? := dbms_lob.getchunksize(?); end;");
                    cstmt.registerOutParameter(1, 2);
                    if (LobPlsqlUtil.isNCLOB(lob)) {
                        cstmt.setFormOfUse(2, (short)2);
                    }
                    cstmt.setObject(2, (Object)lob, type);
                    cstmt.execute();
                    lob_length = cstmt.getLong(1);
                }
                catch (SQLException e2) {
                    if (e2.getErrorCode() != 6550) {
                        if (OracleLog.TRACE) {
                            OracleLog.print(null, (int)64, (int)32, (String)("LobPlsqlUtil.plsql_getChunkSize: Exception caught and thrown. " + e2.getMessage()));
                        }
                        throw e2;
                    }
                    if (OracleLog.TRACE) {
                        OracleLog.print(null, (int)64, (int)32, (String)"LobPlsqlUtil.plsql_getChunkSize: ORA-650 (GETCHUNKSIZE must be declared) ignored for old database");
                    }
                    lob_length = 32512L;
                    Object var8_6 = null;
                    if (cstmt != null) {
                        cstmt.close();
                        cstmt = null;
                    }
                    break block12;
                }
                Object var8_5 = null;
                if (cstmt == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_getChunkSize: return: " + lob_length));
        }
        return lob_length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void plsql_trimLob(Connection conn, Datum lob, int type, long length) throws SQLException {
        block6: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_trimLob( conn=" + conn + ", lob=" + lob + ", type=" + type + ", length=" + length + ")"));
            }
            long lob_length = 0L;
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.trim (?, ?); end;");
                cstmt.registerOutParameter(1, type);
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(1, (short)2);
                }
                cstmt.setObject(1, (Object)lob, type);
                cstmt.setLong(2, length);
                cstmt.execute();
                lob.setShareBytes(cstmt.getBytes(1));
                Object var9_6 = null;
                if (cstmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"LobPlsqlUtil.plsql_trimLob: return");
        }
    }

    public static long plsql_write(Connection conn, Datum lob, int type, long pos, byte[] bytes, long offset, long len) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_write( conn=" + conn + ", lob=" + lob + ", type=" + type + ", pos=" + pos + ", bytes=" + bytes + ", offset=" + offset + ", len=" + len + "): return: 0 (do nothing and always return 0)"));
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Datum plsql_createTemporaryLob(Connection conn, boolean cache, int duration, int type, short form) throws SQLException {
        Datum ret;
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_createTemporaryLob( conn=" + conn + ", cache=" + cache + ", duration=" + duration + ", type=" + type + ", form=" + form + ")"));
            }
            OracleStatement cstmt = null;
            ret = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.createTemporary (?," + (cache ? "TRUE" : "FALSE") + ", ?); end;");
                ((OracleCallableStatement)cstmt).registerOutParameter(1, type);
                ((OracleCallableStatement)cstmt).setInt(2, duration);
                ((OracleCallableStatement)cstmt).execute();
                ret = ((OracleCallableStatement)cstmt).getOracleObject(1);
                Object var8_7 = null;
                if (cstmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"LobPlsqlUtil.plsql_createTemporaryLob: return");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void plsql_freeTemporaryLob(Connection conn, Datum temp_lob, int type) throws SQLException {
        block6: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_freeTemporaryLob( conn=" + conn + ", temp_lob=" + temp_lob + ", type=" + type + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.freeTemporary (?); end;");
                cstmt.registerOutParameter(1, type);
                if (LobPlsqlUtil.isNCLOB(temp_lob)) {
                    cstmt.setFormOfUse(1, (short)2);
                }
                cstmt.setOracleObject(1, temp_lob);
                cstmt.execute();
                temp_lob.setShareBytes(cstmt.getBytes(1));
                Object var5_4 = null;
                if (cstmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"LobPlsqlUtil.plsql_freeTemporaryLob: return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean plsql_isTemporaryLob(Connection conn, Datum lob, int type) throws SQLException {
        boolean ret;
        block6: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isTemporaryLob( conn=" + conn + ", lob=" + lob + ", type=" + type + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin ? := dbms_lob.isTemporary (?); end;");
                cstmt.registerOutParameter(1, 2);
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(2, (short)2);
                }
                cstmt.setOracleObject(2, lob);
                cstmt.execute();
                ret = cstmt.getBoolean(1);
                Object var6_5 = null;
                if (cstmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isTemporaryLob: return: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void plsql_openLob(Connection conn, Datum lob, int mode, int type) throws SQLException {
        block6: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_openLob( conn=" + conn + ", lob=" + lob + ", mode=" + mode + ", type=" + type + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.open (?, ?); end;");
                cstmt.registerOutParameter(1, type);
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(1, (short)2);
                }
                cstmt.setOracleObject(1, lob);
                cstmt.setInt(2, mode);
                cstmt.execute();
                lob.setShareBytes(cstmt.getOracleObject(1).shareBytes());
                Object var6_5 = null;
                if (cstmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"LobPlsqlUtil.plsql_openLob: return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void plsql_closeLob(Connection conn, Datum lob, int type) throws SQLException {
        block6: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_closeLob( conn=" + conn + ", lob=" + lob + ", type=" + type + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.close (?); end;");
                cstmt.registerOutParameter(1, type);
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(1, (short)2);
                }
                cstmt.setOracleObject(1, lob);
                cstmt.execute();
                lob.setShareBytes(cstmt.getOracleObject(1).shareBytes());
                Object var5_4 = null;
                if (cstmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"LobPlsqlUtil.plsql_closeLob: return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean plsql_isLobOpen(Connection conn, Datum lob, int type) throws SQLException {
        boolean ret;
        block6: {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isLobOpen( conn=" + conn + ", lob=" + lob + ", type=" + type + ")"));
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin ? := dbms_lob.isOpen(?); end; ");
                cstmt.registerOutParameter(1, 2);
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(2, (short)2);
                }
                cstmt.setOracleObject(2, lob);
                cstmt.execute();
                ret = cstmt.getBoolean(1);
                Object var6_5 = null;
                if (cstmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
                throw throwable;
            }
            cstmt.close();
            cstmt = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("LobPlsqlUtil.plsql_isLobOpen: return: " + ret));
        }
        return ret;
    }

    static {
        MAX_PLSQL_SIZE = 32512;
        MAX_PLSQL_INSTR_SIZE = 32512;
        MAX_CHUNK_SIZE = 32512;
    }
}

