/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.Datum;

public class LobDBAccessImpl
implements BlobDBAccess,
ClobDBAccess,
BfileDBAccess {
    OracleConnection m_conn;
    DBAccess m_dbaccess;

    public LobDBAccessImpl(OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.LobDBAccessImpl( conn=" + conn + ")"));
        }
        if (conn == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.lobDBAccessImpl: Invalid argument, 'conn' should not be null. An exception is thrown.");
            }
            DBError.throwSqlException((int)68, (Object)"connection is null");
        }
        this.m_conn = conn;
        this.m_dbaccess = conn.db_access;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"LobDBAccessImpl.LobDBAccessImpl: return");
        }
    }

    public synchronized long length(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.length( blob=" + blob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.lobLength(blob);
    }

    public synchronized long position(BLOB blob, byte[] pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position( blob=" + blob + ", pattern=" + pattern + ", start=" + start + ")"));
        }
        if (start < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.position: Invalid argument, 'start' should not be <1.  An exception is thrown.");
            }
            DBError.throwSqlException((int)68, (Object)"position()");
        }
        long ret = -1L;
        if (pattern != null && pattern.length != 0) {
            this.m_conn.needLine();
            long _pos = this.m_dbaccess.hasPattern(blob, pattern, start);
            long l2 = ret = _pos == 0L ? -1L : _pos;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position: return: " + ret));
        }
        return ret;
    }

    public synchronized long position(BLOB blob, BLOB pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position( blob=" + blob + ", pattern=" + pattern + ", start=" + start + ")"));
        }
        if (start < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.position: Invalid argument, 'start' should not be <1. An exception is thrown.");
            }
            DBError.throwSqlException((int)68, (Object)"position()");
        }
        long ret = -1L;
        if (pattern != null) {
            this.m_conn.needLine();
            long _pos = this.m_dbaccess.isSubLob(blob, pattern, start);
            long l2 = ret = _pos == 0L ? -1L : _pos;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position: return: " + ret));
        }
        return ret;
    }

    public synchronized int getBytes(BLOB blob, long pos, int length, byte[] buf) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getBytes( blob=" + blob + ", pos=" + pos + ", length=" + length + ", buf=" + buf + ")"));
        }
        if (length < 0 || pos < 1L || buf == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.getBytes: Invalid argument, 'length' should be >= 0, 'pos'>=1 and 'buf' not null. An exception is thrown.");
            }
            DBError.throwSqlException((int)68, (Object)"getBytes()");
        }
        int ret = 0;
        if (length != 0) {
            this.m_conn.needLine();
            ret = (int)this.m_dbaccess.lobRead(blob, pos, (long)length, buf);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getBytes: return: " + ret));
        }
        return ret;
    }

    public synchronized int putBytes(BLOB blob, long pos, byte[] bytes, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.putBytes( blob=" + blob + ", pos=" + pos + ", bytes=" + bytes + ", length=" + length + ")"));
        }
        if (pos < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.putBytes: Invalid argument, 'pos' should not be <1. An exception is thrown.");
            }
            DBError.throwSqlException((int)68, (Object)"putBytes()");
        }
        int ret = 0;
        if (bytes == null || bytes.length == 0 || length <= 0) {
            ret = 0;
        } else {
            this.m_conn.needLine();
            ret = (int)this.m_dbaccess.lobWrite(blob, pos, bytes, length);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.putBytes: return: " + ret));
        }
        return ret;
    }

    public synchronized int getChunkSize(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getChunkSize( blob=" + blob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return (int)this.m_dbaccess.getLobChunkSize(blob);
    }

    public synchronized void trim(BLOB blob, long newlen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.trim( blob=" + blob + ", newlen=" + newlen + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.trimLob((Connection)blob.getConnection(), (Datum)blob, 2004, newlen);
    }

    public synchronized BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.createTemporaryBlob( conn=" + conn + ", cache=" + cache + ", duration=" + duration + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return (BLOB)this.m_dbaccess.createTemporaryLob(conn, cache, duration, 2004);
    }

    public synchronized void freeTemporary(BLOB temp_lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.freeTemporary( temp_lob=" + temp_lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.freeTemporaryLob((Connection)temp_lob.getConnection(), (Datum)temp_lob, 2004);
    }

    public synchronized boolean isTemporary(BLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.isTemporary( lob=" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.isTemporaryLob((Connection)lob.getConnection(), (Datum)lob, 2004);
    }

    public synchronized void open(BLOB lob, int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.open( lob=" + lob + ", mode=" + mode + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.openLob((Connection)lob.getConnection(), (Datum)lob, mode, 2004);
    }

    public synchronized void close(BLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.close( lob=" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.closeLob((Connection)lob.getConnection(), (Datum)lob, 2004);
    }

    public synchronized boolean isOpen(BLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.isOpen( lob" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.isLobOpen((Connection)lob.getConnection(), (Datum)lob, 2004);
    }

    public synchronized long length(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.length( clob=" + clob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.lobLength(clob);
    }

    public synchronized long position(CLOB clob, String searchstr, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position( clob=" + clob + ", searchstr=" + searchstr + ", start=" + start + ")"));
        }
        if (start < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.position: Invalid argument, 'start' should not be <1. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"position()");
        }
        long ret = -1L;
        if (searchstr != null && searchstr.length() != 0) {
            this.m_conn.needLine();
            long _pos = this.m_dbaccess.hasPattern(clob, searchstr.toCharArray(), start);
            long l2 = ret = _pos == 0L ? -1L : _pos;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position: return: " + ret));
        }
        return ret;
    }

    public synchronized long position(CLOB clob, CLOB searchstr, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position( clob=" + clob + ", searchstr=" + searchstr + ", start=" + start + ")"));
        }
        if (start < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.position: Invalid argument, 'start' should not be <1. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"position");
        }
        long ret = -1L;
        if (searchstr != null) {
            this.m_conn.needLine();
            long _pos = this.m_dbaccess.isSubLob(clob, searchstr, start);
            long l2 = ret = _pos == 0L ? -1L : _pos;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position: return: " + ret));
        }
        return ret;
    }

    public synchronized int getChars(CLOB clob, long pos, int length, char[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getChars( clob=" + clob + ", pos=" + pos + ", length=" + length + ", buffer=" + buffer + ")"));
        }
        if (length < 0 || pos < 1L || buffer == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.getChars: Invalid argument, 'length' should be >=0, 'pos'>=1 and 'buffer' not null. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"getChars()");
        }
        int ret = 0;
        if (length != 0) {
            this.m_conn.needLine();
            ret = (int)this.m_dbaccess.lobRead(clob, pos, (long)length, buffer);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getChars: return: " + ret));
        }
        return ret;
    }

    public synchronized int putChars(CLOB clob, long pos, char[] chars, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.putChars( clob=" + clob + ", pos=" + pos + ", chars=" + chars + ", length=" + length + ")"));
        }
        if (pos < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.putChars: Invalid argument, 'pos' should not be <1. An  exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"putChars()");
        }
        int ret = 0;
        if (chars == null || chars.length < 0 || length <= 0) {
            ret = 0;
        } else {
            this.m_conn.needLine();
            ret = (int)this.m_dbaccess.lobWrite(clob, pos, chars, length);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.putChars: return: " + ret));
        }
        return ret;
    }

    public synchronized int getChunkSize(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getChunkSize( clob=" + clob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return (int)this.m_dbaccess.getLobChunkSize(clob);
    }

    public synchronized void trim(CLOB clob, long newlen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.trim( clob=" + clob + ", newlen=" + newlen + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.trimLob((Connection)clob.getConnection(), (Datum)clob, 2005, newlen);
    }

    public synchronized CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.createTemporaryClob( conn=" + conn + ", cache=" + cache + ", duration=" + duration + ", form=" + form + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return (CLOB)this.m_dbaccess.createTemporaryLob(conn, cache, duration, 2005, form);
    }

    public synchronized void freeTemporary(CLOB temp_lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.freeTemporary( lob=" + temp_lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.freeTemporaryLob((Connection)temp_lob.getConnection(), (Datum)temp_lob, 2005);
    }

    public synchronized boolean isTemporary(CLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.isTemporary( lob=" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.isTemporaryLob((Connection)lob.getConnection(), (Datum)lob, 2005);
    }

    public synchronized void open(CLOB lob, int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.open( lob=" + lob + ", mode=" + mode + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.openLob((Connection)lob.getConnection(), (Datum)lob, mode, 2005);
    }

    public synchronized void close(CLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.close( lob=" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.closeLob((Connection)lob.getConnection(), (Datum)lob, 2005);
    }

    public synchronized boolean isOpen(CLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.isOpen( lob=" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.isLobOpen((Connection)lob.getConnection(), (Datum)lob, 2005);
    }

    public synchronized long length(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.length( bfile=" + bfile + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.lobLength(bfile);
    }

    public synchronized int getBytes(BFILE bfile, long pos, int length, byte[] buf) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getBytes( bfile=" + bfile + ", pos=" + pos + ", length=" + length + ", buf=" + buf + ")"));
        }
        if (pos < 1L || length < 0 || buf == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.getBytes: Invalid argument, 'start' should be >=1, 'length'>=0 and 'buf' not null. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"getBytes()");
        }
        int ret = 0;
        if (length != 0) {
            this.m_conn.needLine();
            ret = (int)this.m_dbaccess.lobRead(bfile, pos, (long)length, buf);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getBytes: return: " + ret));
        }
        return ret;
    }

    public synchronized long position(BFILE bfile, byte[] pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position( bfile=" + bfile + ", pattern=" + pattern + ", start=" + start + ")"));
        }
        if (start < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.position: Invalid argument, 'start' should not be <1. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"position()");
        }
        long ret = -1L;
        if (pattern != null && pattern.length != 0) {
            this.m_conn.needLine();
            long _pos = this.m_dbaccess.hasPattern(bfile, pattern, start);
            long l2 = ret = _pos == 0L ? -1L : _pos;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position: return: " + ret));
        }
        return ret;
    }

    public synchronized long position(BFILE bfile, BFILE pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position( bfile=" + bfile + ", pattern=" + pattern + ", start=" + start + ")"));
        }
        if (start < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"LobDBAccessImpl.position: Invalid argument, 'start' should not be <1. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"position()");
        }
        long ret = -1L;
        if (pattern != null) {
            this.m_conn.needLine();
            long _pos = this.m_dbaccess.isSubLob(bfile, pattern, start);
            long l2 = ret = _pos == 0L ? -1L : _pos;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.position: return: " + ret));
        }
        return ret;
    }

    public synchronized String getName(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getName( bfile=" + bfile + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.fileGetName(bfile);
    }

    public synchronized String getDirAlias(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.getDirAlias( bfile=" + bfile + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.fileGetDirAlias(bfile);
    }

    public synchronized void openFile(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.openFile( bfile=" + bfile + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.fileOpen(bfile);
    }

    public synchronized boolean isFileOpen(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.isFileOpen( bfile=" + bfile + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.fileIsOpen(bfile);
    }

    public synchronized boolean fileExists(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.fileExists( bfile=" + bfile + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.fileExists(bfile);
    }

    public synchronized void closeFile(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.closeFile( bfile=" + bfile + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.fileClose(bfile);
    }

    public synchronized void open(BFILE lob, int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.open( lob=" + lob + ", mode=" + mode + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.openLob((Connection)lob.getConnection(), (Datum)lob, mode, -13);
    }

    public synchronized void close(BFILE lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.close( lob=" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        this.m_dbaccess.closeLob((Connection)lob.getConnection(), (Datum)lob, -13);
    }

    public synchronized boolean isOpen(BFILE lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.isOpen( lob=" + lob + ") -- no return trace --"));
        }
        this.m_conn.needLine();
        return this.m_dbaccess.isLobOpen((Connection)lob.getConnection(), (Datum)lob, -13);
    }

    public InputStream newInputStream(BFILE bfile, int chunkSize, long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newInputStream( bfile=" + bfile + ", chunkSize=" + chunkSize + ", pos=" + pos + ") -- no return trace --"));
        }
        if (pos == 0L) {
            return new OracleBlobInputStream(bfile, chunkSize);
        }
        return new OracleBlobInputStream(bfile, chunkSize, pos);
    }

    public InputStream newConversionInputStream(BFILE bfile, int conversionType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newConversionInputStream( bfile=" + bfile + ", conversionType=" + conversionType + ")"));
        }
        OracleConversionInputStream ret = new OracleConversionInputStream(bfile.getConnection().conversion, bfile.getBinaryStream(), conversionType);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"LobDBAccessImpl.newConversionInputStream: return");
        }
        return ret;
    }

    public Reader newConversionReader(BFILE bfile, int conversionType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newConversionReader( bfile=" + bfile + ", conversionType=" + conversionType + ")"));
        }
        OracleConversionReader ret = new OracleConversionReader(bfile.getConnection().conversion, bfile.getBinaryStream(), conversionType);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"LobDBAccessImpl.newConversionReader: return");
        }
        return ret;
    }

    public InputStream newInputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newInputStream( blob=" + blob + ", chunkSize=" + chunkSize + ", pos=" + pos + ") -- no return trace --"));
        }
        if (pos == 0L) {
            return new OracleBlobInputStream(blob, chunkSize);
        }
        return new OracleBlobInputStream(blob, chunkSize, pos);
    }

    public OutputStream newOutputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newOutputStream( blob=" + blob + ", chunkSize=" + chunkSize + ", pos=" + pos + ") -- no return trace --"));
        }
        if (pos == 0L) {
            return new OracleBlobOutputStream(blob, chunkSize);
        }
        return new OracleBlobOutputStream(blob, chunkSize, pos);
    }

    public InputStream newConversionInputStream(BLOB blob, int conversionType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newConversionInputStream( blob=" + blob + ", conversionType=" + conversionType + ")"));
        }
        OracleConversionInputStream ret = new OracleConversionInputStream(blob.getConnection().conversion, blob.getBinaryStream(), conversionType);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"LobDBAccessImpl.newConversionInputStream: return");
        }
        return ret;
    }

    public Reader newConversionReader(BLOB blob, int conversionType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newConversionReader( blob=" + blob + ", conversionType=" + conversionType + ")"));
        }
        OracleConversionReader ret = new OracleConversionReader(blob.getConnection().conversion, blob.getBinaryStream(), conversionType);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"LobDBAccessImpl.newConversionReader: return");
        }
        return ret;
    }

    public InputStream newInputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newInputStream( clob=" + clob + ", chunkSize=" + chunkSize + ", pos=" + pos + ") -- no return trace --"));
        }
        if (pos == 0L) {
            return new OracleClobInputStream(clob, chunkSize);
        }
        return new OracleClobInputStream(clob, chunkSize, pos);
    }

    public OutputStream newOutputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newOutputStream( clob=" + clob + ", chunkSize=" + chunkSize + ", pos=" + pos + ") -- no return trace --"));
        }
        if (pos == 0L) {
            return new OracleClobOutputStream(clob, chunkSize);
        }
        return new OracleClobOutputStream(clob, chunkSize, pos);
    }

    public Reader newReader(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newReader( clob=" + clob + ", chunkSize=" + chunkSize + ", pos=" + pos + ") -- no return trace --"));
        }
        if (pos == 0L) {
            return new OracleClobReader(clob, chunkSize);
        }
        return new OracleClobReader(clob, chunkSize, pos);
    }

    public Writer newWriter(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("LobDBAccessImpl.newWriter( clob=" + clob + ", chunkSize=" + chunkSize + ", pos=" + pos + ") -- no return trace --"));
        }
        if (pos == 0L) {
            return new OracleClobWriter(clob, chunkSize);
        }
        return new OracleClobWriter(clob, chunkSize, pos);
    }
}

