/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;

    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        if (this.physicalConnection == null) {
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.physicalConnection;
    }

    public DatumWithConnection(byte[] elements) throws SQLException {
        super(elements);
    }

    public DatumWithConnection() {
    }

    public static void assertNotNull(Connection conn) throws SQLException {
        if (conn == null) {
            DBError.check_error((int)68, (Object)"Connection is null");
        }
    }

    public static void assertNotNull(TypeDescriptor desc) throws SQLException {
        if (desc == null) {
            DBError.check_error((int)61);
        }
    }

    public void setPhysicalConnectionOf(Connection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("DatumWithConnection.setPhysicalConnectionOf( conn=" + conn + ")"));
        }
        this.physicalConnection = OracleConnection.physicalConnectionWithin((Connection)conn);
    }

    public Connection getJavaSqlConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"DatumWithConnection.getJavaSqlConnection(): return");
        }
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"OPAQUE.getOracleConnection()");
        }
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getInternalConnection(): return");
        }
        return this.getPhysicalConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"DatumWithConnection.getConnection() --- DEPRECATED --- Use getJavaSqlConnection() or get instead.");
        }
        OracleConnection ret = null;
        try {
            ret = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
        }
        catch (ClassCastException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("DatumWithConnection.getConnection: Wrong connection type. An exception is thrown." + ex.getMessage()));
            }
            DBError.throwSqlException((int)103);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"DatumWithConnection.getConnection: return");
        }
        return ret;
    }
}

