/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverterShift;

class CharacterSetShift
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterShift";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static Class m_charConvSuperclass;

    CharacterSetShift(int n2, CharacterConverterShift characterConverterShift) {
        super(n2, (CharacterConverter)characterConverterShift);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 223 || n2 > 127 && n2 < 161) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return n2;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = characterBuffer.next;
        boolean bl = true;
        while (n3 <= 0) {
            CharacterConverterShift cfr_ignored_0 = (CharacterConverterShift)this.m_converter;
            if (characterBuffer.bytes[n3] == 15) {
                bl = true;
                break;
            }
            CharacterConverterShift cfr_ignored_1 = (CharacterConverterShift)this.m_converter;
            if (characterBuffer.bytes[n3] != 14) continue;
            bl = false;
            break;
        }
        int n4 = 0;
        int n5 = 1;
        while (n2 >> n4 != 0) {
            n4 = (short)(n4 + 8);
            n5 = (short)(n5 + 1);
        }
        if (n5 > 2) {
            throw new SQLException("Character invalid, too many bytes");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (n5 == 1 && !bl) {
            bl2 = true;
            n5 = (short)(n5 + 1);
        }
        if (n5 == 2 && bl) {
            bl3 = true;
            n5 = (short)(n5 + 1);
        }
        CharacterSet.need(characterBuffer, n5);
        if (bl2) {
            CharacterConverterShift cfr_ignored_2 = (CharacterConverterShift)this.m_converter;
            characterBuffer.bytes[characterBuffer.next++] = 15;
        }
        if (bl3) {
            CharacterConverterShift cfr_ignored_3 = (CharacterConverterShift)this.m_converter;
            characterBuffer.bytes[characterBuffer.next++] = 14;
        }
        while (n4 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n4 & 0xFF);
            n4 = (short)(n4 - 8);
        }
    }

    static CharacterSetShift getInstance(int n2, CharacterConverter characterConverter) {
        if (characterConverter.getGroupId() == 7) {
            return new CharacterSetShift(n2, (CharacterConverterShift)characterConverter);
        }
        return null;
    }
}

