/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UTFDataFormatException;
import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL32UTF8
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen;

    static {
        int[] nArray = new int[16];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 3;
        nArray[15] = 4;
        m_byteLen = nArray;
    }

    CharacterSetAL32UTF8(int n2) {
        super(n2);
        this.rep = 6;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToAL32UTF8(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 6) {
            byArray2 = CharacterSet.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSet.stringToAL32UTF8(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToAL32UTF8(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n2;
        byte[] byArray = characterWalker.bytes;
        int n3 = characterWalker.next;
        int n4 = characterWalker.end;
        if (n3 >= n4) {
            CharacterSet.failUTFConversion();
        }
        if ((n2 = CharacterSetAL32UTF8.getUTFByteLength(by = byArray[n3])) == 0 || n3 + (n2 - 1) >= n4) {
            CharacterSet.failUTFConversion();
        }
        try {
            char[] cArray = new char[2];
            int n5 = CharacterSet.AL32UTF8ToJavaChar((byte[])byArray, (int)n3, (int)n2, (char[])cArray, (CharacterSet.CharacterConverterBehavior)CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            characterWalker.next += n2;
            if (n5 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            CharacterSet.failUTFConversion();
            return 0;
        }
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3;
        if ((n2 & 0xFFFF0000) != 0) {
            CharacterSet.need(characterBuffer, 4);
            char[] cArray = new char[]{(char)(n2 >>> 16), (char)n2};
            n3 = CharacterSet.javaCharsToAL32UTF8((char[])cArray, (int)0, (int)2, (byte[])characterBuffer.bytes, (int)characterBuffer.next);
        } else {
            CharacterSet.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n2};
            n3 = CharacterSet.javaCharsToAL32UTF8((char[])cArray, (int)0, (int)1, (byte[])characterBuffer.bytes, (int)characterBuffer.next);
        }
        characterBuffer.next += n3;
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[by >>> 4 & 0xF];
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int n4 = CharacterSet.AL32UTF8ToJavaChar((byte[])byArray, (int)n2, (int)n3, (char[])cArray, (CharacterSet.CharacterConverterBehavior)CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n4);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            CharacterSet.failUTFConversion();
            return "";
        }
    }

    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            char[] cArray = new char[byArray.length];
            int n4 = CharacterSet.AL32UTF8ToJavaChar((byte[])byArray, (int)n2, (int)n3, (char[])cArray, (CharacterSet.CharacterConverterBehavior)CharacterSet.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n4);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return "";
        }
    }
}

