/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess m_dbaccess;
    private int m_dbChunkSize;
    private short csform;

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection conn) throws SQLException {
        this(conn, null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.CLOB( conn=" + conn + "): return -- after this() --"));
        }
    }

    public CLOB(oracle.jdbc.OracleConnection conn, short form) throws SQLException {
        this(conn, null);
        this.csform = form;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.CLOB( conn=" + conn + ", form=" + form + "): return -- after this() --"));
        }
    }

    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        if (lob_descriptor != null) {
            this.csform = (lob_descriptor[5] & 0xC0) == 64 ? (short)2 : (short)1;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.CLOB( conn=" + conn + ", lob_descriptor=" + lob_descriptor + ") " + "-- after super() -- csform = " + this.csform));
        }
        DatumWithConnection.assertNotNull(conn);
        this.setPhysicalConnectionOf(conn);
        this.m_dbaccess = ((oracle.jdbc.internal.OracleConnection)conn).createClobDBAccess();
        this.m_dbChunkSize = -1;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.CLOB: return");
        }
    }

    public CLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor, short csform) throws SQLException {
        this(conn, lob_descriptor);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.CLOB( conn=" + conn + ", lob_descriptor=" + lob_descriptor + ", csform=" + csform + "): return -- after this() --"));
        }
        this.csform = csform;
    }

    public boolean isNCLOB() {
        boolean ret;
        boolean bl = ret = this.csform == 2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.isNCLOB(): return: " + ret));
        }
        return ret;
    }

    public long length() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.length() -- no result trace --");
        }
        return this.getDBAccess().length(this);
    }

    public String getSubString(long pos, int length) throws SQLException {
        char[] chars_read;
        int num_chars_rd;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getSubString( pos=" + pos + ", length=" + length + ")"));
        }
        if (length < 0 || pos < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CLOB.getSubString: Invalid argument, 'length' should be >= 0 and 'pos' >=1. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"getSubString");
        }
        String ret = null;
        ret = length == 0 ? new String() : ((num_chars_rd = this.getChars(pos, length, chars_read = new char[length])) > 0 ? new String(chars_read, 0, num_chars_rd) : new String());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getSubString: return: " + ret));
        }
        return ret;
    }

    public Reader getCharacterStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getCharacterStream() -- no result trace --");
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getAsciiStream() -- no result trace --");
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(String searchstr, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.position( searchstr=" + searchstr + ", start=" + start + ") -- no result trace --"));
        }
        return this.getDBAccess().position(this, searchstr, start);
    }

    public long position(Clob searchstr, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.position( searchstr=" + searchstr + ", start=" + start + ") -- no result trace --"));
        }
        return this.getDBAccess().position(this, (CLOB)searchstr, start);
    }

    public int getChars(long pos, int length, char[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getChars( pos=" + pos + ", length=" + length + ", buffer=" + buffer + ") -- no result trace --"));
        }
        return this.getDBAccess().getChars(this, pos, length, buffer);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getCharacterOutputStream() -- no result trace --");
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), 0L);
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getAsciiOutputStream() -- no result trace --");
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), 0L);
    }

    public byte[] getLocator() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getLocator() -- no result trace --");
        }
        return this.getBytes();
    }

    public void setLocator(byte[] locator) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.setLocator( locator=" + locator + ") -- no result trace --"));
        }
        this.setBytes(locator);
    }

    public int putChars(long pos, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.putChars( pos=" + pos + ", chars=" + chars + ")"));
        }
        int ret = this.getDBAccess().putChars(this, pos, chars, chars != null ? chars.length : 0);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.putChars: return: " + ret));
        }
        return ret;
    }

    public int putChars(long pos, char[] chars, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.putChars( pos=" + pos + ", chars=" + chars + ", length=" + length + ") -- no return trace --"));
        }
        return this.getDBAccess().putChars(this, pos, chars, length);
    }

    public int putString(long pos, String str) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.putString( pos=" + pos + ", str=" + str + ")"));
        }
        if (pos < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CLOB.putString: Invalid argument, 'pos' should not be < 1. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"putString()");
        }
        int ret = 0;
        if (str != null && str.length() != 0) {
            ret = this.putChars(pos, str.toCharArray());
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.putString: return: " + ret));
        }
        return ret;
    }

    public int getChunkSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getChunkSize() -- no return trace --");
        }
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.m_dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getBufferSize()");
        }
        int size = this.getChunkSize();
        int ret = 0;
        ret = size >= 32768 || size <= 0 ? 32768 : 32768 / size * size;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getBufferSize: return: " + ret));
        }
        return ret;
    }

    public static CLOB empty_lob() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"CLOB.empty_lob() -- no return trace --");
        }
        byte[] locator = new byte[86];
        locator[1] = 84;
        locator[5] = 24;
        CLOB clob = new CLOB();
        clob.setShareBytes(locator);
        return clob;
    }

    public boolean isEmptyLob() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.isEmptyLob() -- no return trace --");
        }
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getAsciiOutputStream( pos=" + pos + ") -- no return trace --"));
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos);
    }

    public Writer getCharacterOutputStream(long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getCharacterOutputStream( pos=" + pos + ") -- no return trace --"));
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), pos);
    }

    public InputStream getAsciiStream(long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getAsciiStream( pos=" + pos + ") -- no return trace --"));
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), pos);
    }

    public Reader getCharacterStream(long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.getCharacterStream( pos=" + pos + ") -- no return trace --"));
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), pos);
    }

    public void trim(long newlen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.trim( newlen=" + newlen + ") -- no return trace --"));
        }
        if (newlen < 0L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CLOB.trim: Invalid argument, 'newlen' should not be < 0. An exception is thrown.");
            }
            DBError.throwSqlException((int)68);
        }
        this.getDBAccess().trim(this, newlen);
    }

    public static CLOB createTemporary(Connection conn, boolean cache, int duration) throws SQLException {
        return CLOB.createTemporary(conn, cache, duration, (short)1);
    }

    public static CLOB createTemporary(Connection conn, boolean cache, int _duration, short form) throws SQLException {
        int duration = _duration;
        if (_duration == 1) {
            duration = 10;
        }
        if (_duration == 2) {
            duration = 12;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("CLOB.createTemporary( conn=" + conn + ", cache=" + cache + "duration=" + duration + ", form=" + form + ") -- no return trace --"));
        }
        if (conn == null || duration != 10 && duration != 12) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)"CLOB.createTemporary: Invalid argument, 'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL. An exception is thrown.");
            }
            DBError.throwSqlException((int)68);
        }
        oracle.jdbc.internal.OracleConnection physConn = OracleConnection.physicalConnectionWithin((Connection)conn);
        return CLOB.getDBAccess(physConn).createTemporaryClob(physConn, cache, duration, form);
    }

    public static void freeTemporary(CLOB temp_lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("CLOB.freeTemporary( temp_lob=" + temp_lob + ") -- no return trace --"));
        }
        if (temp_lob == null) {
            return;
        }
        temp_lob.freeTemporary();
    }

    public static boolean isTemporary(CLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("CLOB.isTemporary( lob=" + lob + ") -- no return trace --"));
        }
        if (lob == null) {
            return false;
        }
        return lob.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.freeTemporary() -- no return trace --");
        }
        this.getDBAccess().freeTemporary(this);
    }

    public boolean isTemporary() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.isTemporary() -- no return trace --");
        }
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.open( mode=" + mode + ") -- no return trace --"));
        }
        this.getDBAccess().open(this, mode);
    }

    public void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.close() -- no return trace --");
        }
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.isOpen() -- no return trace --");
        }
        return this.getDBAccess().isOpen(this);
    }

    public int setString(long pos, String str) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void truncate(long len) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.toJdbc(): return");
        }
        return this;
    }

    public boolean isConvertibleTo(Class jClass) {
        String class_name;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.isConvertibleTo( jClass=" + jClass + ") -- no return trace --"));
        }
        return (class_name = jClass.getName()).compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.characterStreamValue() -- no return trace --");
        }
        return this.getCharacterStream();
    }

    public InputStream asciiStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.asciiStreamValue() -- no return trace --");
        }
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.binaryStreamValue() -- no return trace --");
        }
        return this.getAsciiStream();
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CLOB.makeJdbcArray( arraySize=" + arraySize + ") -- no return trace --"));
        }
        return new CLOB[arraySize];
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getDBAccess()");
        }
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)2, (String)"CLOB.getDBAccess: Invalid empty LOB. An exception is thrown.");
                }
                DBError.throwSqlException((int)98);
            }
            this.m_dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CLOB.getDBAccess: return");
        }
        return this.m_dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("CLOB.getDBAccess( conn=" + conn + ") -- no return trace --"));
        }
        return OracleConnection.physicalConnectionWithin((Connection)conn).createClobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    static {
        MAX_CHUNK_SIZE = 32768;
        DURATION_SESSION = 10;
        DURATION_CALL = 12;
        OLD_WRONG_DURATION_SESSION = 1;
        OLD_WRONG_DURATION_CALL = 2;
        MODE_READONLY = 0;
        MODE_READWRITE = 1;
    }
}

