/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class CHAR
extends Datum {
    public static final CharacterSet DEFAULT_CHARSET = CharacterSet.make(-1);
    private CharacterSet charSet;
    private int oracleId;
    private static byte[] empty = new byte[0];

    protected CHAR() {
    }

    public CHAR(byte[] bytes, CharacterSet charSet) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.CHAR( bytes=" + bytes + ", charSet=" + charSet + ") -- no return trace --"));
        }
        this.setValue(bytes, charSet);
    }

    public CHAR(byte[] bytes, int offset, int count, CharacterSet charSet) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.CHAR( bytes=" + bytes + ", offset=" + offset + ", count=" + count + ", charSet=" + charSet + ") -- no return trace --"));
        }
        byte[] data = new byte[count];
        System.arraycopy(bytes, offset, data, 0, count);
        this.setValue(data, charSet);
    }

    public CHAR(String str, CharacterSet charSet) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.CHAR( str=" + str + ", charSet=" + charSet + ") -- no return trace --"));
        }
        if (charSet == null) {
            charSet = DEFAULT_CHARSET;
        }
        this.setValue(charSet.convertWithReplacement(str), charSet);
    }

    public CHAR(Object obj, CharacterSet charSet) throws SQLException {
        this(obj.toString(), charSet);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.CHAR( obj=" + obj + ", charSet=" + charSet + "): return -- after this() --"));
        }
    }

    public CharacterSet getCharacterSet() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.getCharacterSet() -- no return trace --");
        }
        if (this.charSet == null) {
            if (this.oracleId == 0) {
                this.oracleId = -1;
            }
            this.charSet = CharacterSet.make(this.oracleId);
        }
        return this.charSet;
    }

    public String getString() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.getString()");
        }
        String ret = this.getCharacterSet().toString(this.shareBytes(), 0, (int)this.getLength());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.getString: return: " + ret));
        }
        return ret;
    }

    public String getStringWithReplacement() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.getStringWithReplacement()");
        }
        byte[] bytes = this.shareBytes();
        String ret = this.getCharacterSet().toStringWithReplacement(bytes, 0, bytes.length);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.getStringWithReplacement: return: " + ret));
        }
        return ret;
    }

    public String toString() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.toString()");
        }
        return this.getStringWithReplacement();
    }

    public boolean equals(Object other) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.equals( other=" + other + ") -- no return trace --"));
        }
        return other instanceof CHAR && this.getCharacterSet().equals(((CHAR)other).getCharacterSet()) && super.equals(other);
    }

    void setValue(byte[] bytes, CharacterSet charSet) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.setValue( bytes=" + bytes + ", charSet=" + charSet + ") -- no return trace --"));
        }
        this.charSet = charSet == null ? DEFAULT_CHARSET : charSet;
        this.oracleId = this.charSet.getOracleId();
        this.setShareBytes(bytes == null ? empty : bytes);
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.toJdbc()  -- no return trace --");
        }
        return this.stringValue();
    }

    public boolean isConvertibleTo(Class jClass) {
        String class_name;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.isConvertibleTo( jClass=" + jClass + ") -- no return trace --"));
        }
        return (class_name = jClass.getName()).compareTo("java.lang.String") == 0 || class_name.compareTo("java.lang.Long") == 0 || class_name.compareTo("java.math.BigDecimal") == 0 || class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.sql.Date") == 0 || class_name.compareTo("java.sql.Time") == 0 || class_name.compareTo("java.sql.Timestamp") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    public String stringValue() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.stringValue() -- no return trace --");
        }
        return this.toString();
    }

    public boolean booleanValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.booleanValue()");
        }
        boolean ret = false;
        String str = this.stringValue();
        ret = str == null ? false : str.length() != 1 || str.charAt(0) != '0';
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.booleanValue: return: " + ret));
        }
        return ret;
    }

    public int intValue() throws SQLException {
        long result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.intValue()");
        }
        if ((result = this.longValue()) > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CHAR.intValue: Numeric overflow in the calculation. An exception is thrown.");
            }
            DBError.throwSqlException((int)26);
        }
        int ret = (int)result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.intValue: return: " + ret));
        }
        return ret;
    }

    public long longValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.longValue()");
        }
        long ret_val = 0L;
        try {
            ret_val = Long.valueOf(this.stringValue());
        }
        catch (NumberFormatException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CHAR.longValue: Conversion Java error. An exception is thrown.");
            }
            DBError.throwSqlException((int)59);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.longValue: return: " + ret_val));
        }
        return ret_val;
    }

    public float floatValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.floatValue()");
        }
        float ret_val = 0.0f;
        try {
            ret_val = Float.valueOf(this.stringValue()).floatValue();
        }
        catch (NumberFormatException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CHAR.floatValue: Conversion Java error. An exception is thrown.");
            }
            DBError.throwSqlException((int)59);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.floatValue: return: " + ret_val));
        }
        return ret_val;
    }

    public double doubleValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.doubleValue()");
        }
        double ret_val = 0.0;
        try {
            ret_val = Double.valueOf(this.stringValue());
        }
        catch (NumberFormatException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CHAR.doubleValue: Conversion Java error. An exception is thrown.");
            }
            DBError.throwSqlException((int)59);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.doubleValue: return: " + ret_val));
        }
        return ret_val;
    }

    public byte byteValue() throws SQLException {
        long result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.byteValue()");
        }
        if ((result = this.longValue()) > 127L || result < -128L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CHAR.byteValue: Numeric overflow in the calculation. An exception is thrown.");
            }
            DBError.throwSqlException((int)26);
        }
        byte ret = (byte)result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.byteValue: return");
        }
        return ret;
    }

    public Date dateValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.dateValue()");
        }
        Date ret = Date.valueOf(this.stringValue());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.dateValue: return: " + ret));
        }
        return ret;
    }

    public Time timeValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.timeValue()");
        }
        Time ret = Time.valueOf(this.stringValue());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.timeValue: return: " + ret));
        }
        return ret;
    }

    public Timestamp timestampValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.timestampValue()");
        }
        Timestamp ret = Timestamp.valueOf(this.stringValue());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.timestampValue: return: " + ret));
        }
        return ret;
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.bigDecimalValue()");
        }
        BigDecimal big_dec_val = null;
        try {
            big_dec_val = new BigDecimal(this.stringValue());
        }
        catch (NumberFormatException e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"CHAR.bigDecimalValue: Type conflict. An exception is thrown.");
            }
            DBError.check_error((int)12, (Object)"bigDecimalValue");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.bigDecimalValue: return");
        }
        return big_dec_val;
    }

    public Reader characterStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.characterStreamValue()");
        }
        StringReader ret = new StringReader(this.getString());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.characterStreamValue: return");
        }
        return ret;
    }

    public InputStream asciiStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.asciiStreamValue() -- no return trace --");
        }
        return this.getStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"CHAR.binaryStreamValue() -- no return trace --");
        }
        return this.getStream();
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("CHAR.makeJdbcArray( arraySize=" + arraySize + ") -- no return trace --"));
        }
        return new String[arraySize];
    }
}

