/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.BlobDBAccess;
import oracle.sql.DatumWithConnection;

public class BLOB
extends DatumWithConnection
implements Blob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess m_dbaccess;
    int m_dbChunkSize;

    protected BLOB() {
    }

    public BLOB(oracle.jdbc.OracleConnection conn) throws SQLException {
        this(conn, null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.BLOB( conn=" + conn + "): return -- after this() --"));
        }
    }

    public BLOB(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.BLOB( conn=" + conn + ", lob_descriptor=" + lob_descriptor + ") -- no return trace --"));
        }
        DatumWithConnection.assertNotNull(conn);
        this.setPhysicalConnectionOf(conn);
        this.m_dbaccess = this.getPhysicalConnection().createBlobDBAccess();
        this.m_dbChunkSize = -1;
    }

    public long length() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.length() -- no return trace --");
        }
        return this.getDBAccess().length(this);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.getBytes( pos=" + pos + ", length=" + length + ")"));
        }
        if (length < 0 || pos < 1L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"BLOB.length: Invalid argument, 'length' should be >=0 and 'pos' >=1. An exception is thrown.");
            }
            DBError.throwSqlException((int)68, (Object)"getBytes()");
        }
        byte[] ret = null;
        if (length == 0) {
            ret = new byte[]{};
        } else {
            long num_bytes_read = 0L;
            byte[] bytes_read = new byte[length];
            num_bytes_read = this.getBytes(pos, length, bytes_read);
            if (num_bytes_read > 0L) {
                if (num_bytes_read == (long)length) {
                    ret = bytes_read;
                } else {
                    ret = new byte[(int)num_bytes_read];
                    System.arraycopy(bytes_read, 0, ret, 0, (int)num_bytes_read);
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getBytes: return");
        }
        return ret;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getBinaryStream() -- no return trace --");
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.position( pattern=" + pattern + ", start=" + start + ") -- no return trace --"));
        }
        return this.getDBAccess().position(this, pattern, start);
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.position( pattern=" + pattern + ", start=" + start + ") -- no return trace --"));
        }
        return this.getDBAccess().position(this, (BLOB)pattern, start);
    }

    public int getBytes(long pos, int length, byte[] buf) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.getBytes( pos=" + pos + ", length=" + length + ", buf=" + buf + ") -- no return trace --"));
        }
        return this.getDBAccess().getBytes(this, pos, length, buf);
    }

    public int putBytes(long pos, byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.putBytes( pos=" + pos + ", bytes=" + bytes + ") -- no return trace --"));
        }
        return this.getDBAccess().putBytes(this, pos, bytes, bytes != null ? bytes.length : 0);
    }

    public int putBytes(long pos, byte[] bytes, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.putBytes( pos=" + pos + ", bytes=" + bytes + ", length=" + length + ") -- no return trace --"));
        }
        return this.getDBAccess().putBytes(this, pos, bytes, length);
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getBinaryOutputStream() -- no return trace --");
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), 0L);
    }

    public byte[] getLocator() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getLocator() -- no return trace --");
        }
        return this.getBytes();
    }

    public void setLocator(byte[] locator) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.setLocator( locator=" + locator + ") -- no return trace --"));
        }
        this.setBytes(locator);
    }

    public int getChunkSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getChunkSize()");
        }
        if (this.m_dbChunkSize <= 0) {
            this.m_dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.getChunkSize: return: " + this.m_dbChunkSize));
        }
        return this.m_dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        int size;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getBufferSize()");
        }
        int ret = size = this.getChunkSize();
        ret = size >= 32768 || size <= 0 ? 32768 : 32768 / size * size;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.getBufferSize: return: " + ret));
        }
        return ret;
    }

    public static BLOB empty_lob() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"BLOB.empty_lob()");
        }
        byte[] locator = new byte[86];
        locator[1] = 84;
        locator[5] = 24;
        BLOB blob = new BLOB();
        blob.setShareBytes(locator);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"BLOB.empty_lob: return");
        }
        return blob;
    }

    public boolean isEmptyLob() throws SQLException {
        boolean ret;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.isEmptyLob()");
        }
        boolean bl = ret = (this.shareBytes()[5] & 0x10) != 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.isEmptyLob(): return: " + ret));
        }
        return ret;
    }

    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.getBinaryOutputStream( pos=" + pos + ") -- no return trace --"));
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos);
    }

    public InputStream getBinaryStream(long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.getBinaryStream( pos=" + pos + ") -- no return trace --"));
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), pos);
    }

    public void trim(long newlen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.trim( newlen=" + newlen + ") -- no return trace --"));
        }
        if (newlen < 0L) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"BLOB.trim: Invalid argument, 'newlen' should be >= 0. An exception is thrown.");
            }
            DBError.throwSqlException((int)68);
        }
        this.getDBAccess().trim(this, newlen);
    }

    public static BLOB createTemporary(Connection conn, boolean cache, int _duration) throws SQLException {
        int duration = _duration;
        if (_duration == 1) {
            duration = 10;
        }
        if (_duration == 2) {
            duration = 12;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("BLOB.createTemporary( conn=" + conn + ", cache=" + cache + ", duration=" + duration + ")" + " -- no return trace --"));
        }
        if (conn == null || duration != 10 && duration != 12) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)"BLOB.createTemporary: Invalid argument, 'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or to DURATION_CALL. An exception is thrown.");
            }
            DBError.throwSqlException((int)68);
        }
        oracle.jdbc.internal.OracleConnection physConn = OracleConnection.physicalConnectionWithin((Connection)conn);
        return BLOB.getDBAccess(physConn).createTemporaryBlob(physConn, cache, duration);
    }

    public static void freeTemporary(BLOB temp_lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("BLOB.freeTemporary( temp_lob=" + temp_lob + ") -- no return trace --"));
        }
        if (temp_lob == null) {
            return;
        }
        temp_lob.freeTemporary();
    }

    public static boolean isTemporary(BLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("BLOB.isTemporary( lob=" + lob + ") -- no return trace --"));
        }
        if (lob == null) {
            return false;
        }
        return lob.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.freeTemporary() -- no return trace --");
        }
        this.getDBAccess().freeTemporary(this);
    }

    public boolean isTemporary() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.isTemporary() -- no return trace --");
        }
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.open( mode=" + mode + ") -- no return trace --"));
        }
        this.getDBAccess().open(this, mode);
    }

    public void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.close() -- no return trace --");
        }
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.isOpen() -- no return trace --");
        }
        return this.getDBAccess().isOpen(this);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void truncate(long len) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.toJdbc(): return");
        }
        return this;
    }

    public boolean isConvertibleTo(Class jClass) {
        String class_name;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.isConvertibleTo( jClass=" + jClass + ") -- no return trace --"));
        }
        return (class_name = jClass.getName()).compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.characterStreamValue() -- no return trace --");
        }
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.asciiStreamValue() -- no return trace --");
        }
        BlobDBAccess blobDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return blobDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.binaryStreamValue() -- no return trace --");
        }
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BLOB.makeJdbcArray( arraySize=" + arraySize + "): return"));
        }
        return new BLOB[arraySize];
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getDBAccess()");
        }
        if (this.m_dbaccess == null) {
            if (this.isEmptyLob()) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)4, (String)"BLOB.getDBAccess: Invalid empty lob. En exception is thrown.");
                }
                DBError.throwSqlException((int)98);
            }
            this.m_dbaccess = this.getInternalConnection().createBlobDBAccess();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BLOB.getDBAccess: return");
        }
        return this.m_dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"BLOB.getDBAccess()  -- no return trace --");
        }
        return OracleConnection.physicalConnectionWithin((Connection)conn).createBlobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    static {
        MAX_CHUNK_SIZE = 32768;
        DURATION_SESSION = 10;
        DURATION_CALL = 12;
        OLD_WRONG_DURATION_SESSION = 1;
        OLD_WRONG_DURATION_CALL = 2;
        MODE_READONLY = 0;
        MODE_READWRITE = 1;
    }
}

