/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.BfileDBAccess;
import oracle.sql.DatumWithConnection;

public class BFILE
extends DatumWithConnection {
    static final int MAX_CHUNK_SIZE = 32512;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BfileDBAccess m_dbaccess;

    protected BFILE() {
    }

    public BFILE(oracle.jdbc.OracleConnection conn) throws SQLException {
        this(conn, null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.BFILE( conn=" + conn + ") -- after this() -- : return"));
        }
    }

    public BFILE(oracle.jdbc.OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.BFILE( conn=" + conn + ", lob_descriptor=" + lob_descriptor + ") -- after super() --"));
        }
        this.setPhysicalConnectionOf(conn);
        this.m_dbaccess = this.getInternalConnection().createBfileDBAccess();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.BFILE: return");
        }
    }

    public long length() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.length() -- no return trace --");
        }
        return this.getDBAccess().length(this);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.getBytes( pos=" + pos + ", length=" + length + ")"));
        }
        if (pos < 1L || length < 0) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"BFILE.getBytes: Invalid arguments, 'pos' and 'length' should be >0. An exception is thrown.");
            }
            DBError.check_error((int)68, null);
        }
        byte[] ret = null;
        if (length == 0) {
            ret = new byte[]{};
        } else {
            long num_bytes_read = 0L;
            byte[] bytes_read = new byte[length];
            num_bytes_read = this.getBytes(pos, length, bytes_read);
            if (num_bytes_read > 0L) {
                if (num_bytes_read == (long)length) {
                    ret = bytes_read;
                } else {
                    ret = new byte[(int)num_bytes_read];
                    System.arraycopy(bytes_read, 0, ret, 0, (int)num_bytes_read);
                }
            } else {
                ret = new byte[]{};
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.getBytes: return");
        }
        return ret;
    }

    public int getBytes(long pos, int length, byte[] buf) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.getBytes( pos=" + pos + ", length=" + length + ", buf=" + buf + ")"));
        }
        int ret = this.getDBAccess().getBytes(this, pos, length, buf);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.getBytes: return: " + ret));
        }
        return ret;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.getBinaryStream()");
        }
        InputStream ret = this.getDBAccess().newInputStream(this, 32512, 0L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.getBinaryStream: return");
        }
        return ret;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.position( pattern=" + pattern + ", start=" + start + ")"));
        }
        long ret = this.getDBAccess().position(this, pattern, start);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.position: return: " + ret));
        }
        return ret;
    }

    public long position(BFILE pattern, long start) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.position( pattern=" + pattern + ", start=" + start + ")"));
        }
        long ret = this.getDBAccess().position(this, pattern, start);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.position: return: " + ret));
        }
        return ret;
    }

    public String getName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.getName()");
        }
        String ret = this.getDBAccess().getName(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.getName: return: " + ret));
        }
        return ret;
    }

    public String getDirAlias() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.getDirAlias()");
        }
        String ret = this.getDBAccess().getDirAlias(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.getDirAlias: return: " + ret));
        }
        return ret;
    }

    public void openFile() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.openFile() -- no return trace --");
        }
        this.getDBAccess().openFile(this);
    }

    public boolean isFileOpen() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.isFileOpen()");
        }
        boolean ret = this.getDBAccess().isFileOpen(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.isFileOpen: return: " + ret));
        }
        return ret;
    }

    public boolean fileExists() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.fileExists()");
        }
        boolean ret = this.getDBAccess().fileExists(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.fileExists: return: " + ret));
        }
        return ret;
    }

    public void closeFile() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.closeFile() -- no return trace --");
        }
        this.getDBAccess().closeFile(this);
    }

    public byte[] getLocator() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.getLocator() -- no return trace --");
        }
        return this.getBytes();
    }

    public void setLocator(byte[] locator) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.setLocator( locator=" + locator + ") -- no return trace --"));
        }
        this.setBytes(locator);
    }

    public InputStream getBinaryStream(long pos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.getBinaryStream( pos=" + pos + ") -- no return trace --"));
        }
        return this.getDBAccess().newInputStream(this, 32512, pos);
    }

    public void open() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.open() -- no return trace --");
        }
        this.getDBAccess().open(this, 0);
    }

    public void open(int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.open( mode=" + mode + ") -- no return trace --"));
        }
        if (mode != 0) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"BFILE.open: LOB should be in READONLY mode. An exception is thrown.");
            }
            DBError.throwSqlException((int)102);
        }
        this.getDBAccess().open(this, mode);
    }

    public void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.close() -- no return trace --");
        }
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.isOpen() -- no return trace --");
        }
        return this.getDBAccess().isOpen(this);
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.toJdbc(): return");
        }
        return this;
    }

    public boolean isConvertibleTo(Class jClass) {
        String class_name;
        boolean ret;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.isConvertibleTo( jClass=" + jClass + ")"));
        }
        boolean bl = ret = (class_name = jClass.getName()).compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.isConvertibleTo: return: " + ret));
        }
        return ret;
    }

    public Reader characterStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.characterStreamValue() -- no return trace --");
        }
        BfileDBAccess bfileDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return bfileDBAccess.newConversionReader(this, 8);
    }

    public InputStream asciiStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.asciiStreamValue() -- no return trace --");
        }
        BfileDBAccess bfileDBAccess = this.getDBAccess();
        this.getInternalConnection();
        return bfileDBAccess.newConversionInputStream(this, 2);
    }

    public InputStream binaryStreamValue() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.binaryStreamValue() -- no return trace --");
        }
        return this.getBinaryStream();
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("BFILE.makeJdbcArray( arraySize=" + arraySize + ") -- no return trace --"));
        }
        return new BFILE[arraySize];
    }

    public BfileDBAccess getDBAccess() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"BFILE.getDBAccess() -- no return trace --");
        }
        if (this.m_dbaccess == null) {
            this.m_dbaccess = this.getInternalConnection().createBfileDBAccess();
        }
        return this.m_dbaccess;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    static {
        MAX_CHUNK_SIZE = 32512;
        MODE_READONLY = 0;
        MODE_READWRITE = 1;
    }
}

