/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.REF;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class ArrayDescriptor
extends TypeDescriptor
implements Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;

    public static ArrayDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        SQLName sqlName;
        String qualifiedName;
        ArrayDescriptor descriptor;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("ArrayDescriptor.createDescriptor( name=" + name + " conn=" + conn + ")"));
        }
        if (name == null || name.length() == 0 || conn == null) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)2, (String)"ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null. An exception is thrown.");
            }
            DBError.check_error((int)60, (Object)"Invalid arguments");
        }
        if ((descriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName = (sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn)).getName())) == null) {
            descriptor = new ArrayDescriptor(sqlName, conn);
            ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"ArrayDescriptor.createDescriptor: return");
        }
        return descriptor;
    }

    public ArrayDescriptor(String name, Connection connection) throws SQLException {
        super(name, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.ArrayDescriptor( name=" + name + ", connection=" + connection + ")" + " -- after super() --"));
        }
        this.initPickler();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.ArrayDescriptor: return");
        }
    }

    public ArrayDescriptor(SQLName sqlName, Connection connection) throws SQLException {
        super(sqlName, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.ArrayDescriptor( sqlName=" + sqlName + ", connection=" + connection + ") -- after super() --"));
        }
        this.initPickler();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.ArrayDescriptor: return");
        }
    }

    public ArrayDescriptor(SQLName sqlName, OracleTypeCOLLECTION type, Connection connection) throws SQLException {
        super(sqlName, (OracleTypeADT)type, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.ArrayDescriptor( sqlName=" + sqlName + ", type=" + type + ", connection=" + connection + ") -- after super() -- : return"));
        }
    }

    public ArrayDescriptor(OracleTypeCOLLECTION type, Connection connection) throws SQLException {
        super((OracleTypeADT)type, connection);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.ArrayDescriptor( type=" + type + ", connection=" + connection + ") -- after super() -- : return"));
        }
    }

    public int getBaseType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.getBaseType()");
        }
        int ret = ((OracleTypeCOLLECTION)this.m_pickler).getElementType().getTypeCode();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.getBaseType: return: " + ret));
        }
        return ret;
    }

    public String getBaseName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.getBaseName()");
        }
        String ret = null;
        switch (this.getBaseType()) {
            case 12: {
                ret = "VARCHAR";
                break;
            }
            case 1: {
                ret = "CHAR";
                break;
            }
            case -2: {
                ret = "RAW";
                break;
            }
            case 6: {
                ret = "FLOAT";
                break;
            }
            case 2: {
                ret = "NUMBER";
                break;
            }
            case 8: {
                ret = "DOUBLE";
                break;
            }
            case 3: {
                ret = "DECIMAL";
                break;
            }
            case 91: {
                ret = "DATE";
                break;
            }
            case 2004: {
                ret = "BLOB";
                break;
            }
            case 2005: {
                ret = "CLOB";
                break;
            }
            case -13: {
                ret = "BFILE";
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.m_pickler).getElementType();
                ret = otype.getFullName();
                break;
            }
            case 2006: {
                OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.m_pickler).getElementType();
                ret = "REF " + ((OracleTypeREF)otype).getFullName();
                break;
            }
            default: {
                ret = null;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.getBaseName: return: " + ret));
        }
        return ret;
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.OracleTypeCOLLECTION() -- no return trace --");
        }
        return (OracleTypeCOLLECTION)this.m_pickler;
    }

    public int getArrayType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.getArrayType()");
        }
        int ret = ((OracleTypeCOLLECTION)this.m_pickler).getUserCode();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.getArrayType: return: " + ret));
        }
        return ret;
    }

    public long getMaxLength() throws SQLException {
        long ret;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.getMaxLength()");
        }
        long l2 = ret = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.m_pickler).getMaxLength() : 0L;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.getMaxLength: return: " + ret));
        }
        return ret;
    }

    public String descType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.descType()");
        }
        String ret = null;
        StringBuffer strBuf = new StringBuffer();
        ret = this.descType(strBuf, 0);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.descType: return: " + ret));
        }
        return ret;
    }

    String descType(StringBuffer strBuf, int level) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.descType( strBuf=" + strBuf + ", level=" + level + ")"));
        }
        String level_one = "";
        int i2 = 0;
        while (i2 < level) {
            level_one = level_one + "  ";
            ++i2;
        }
        String level_two = level_one + "  ";
        strBuf.append(level_one);
        strBuf.append(this.getTypeName());
        strBuf.append("\n");
        int tcode = this.getBaseType();
        if (tcode == 2002 || tcode == 2008) {
            StructDescriptor adt_desc = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.m_conn);
            adt_desc.descType(strBuf, level + 1);
        } else if (tcode == 2003) {
            ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.m_conn);
            array_desc.descType(strBuf, level + 1);
        } else if (tcode == 2007) {
            OpaqueDescriptor opaque_desc = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.m_conn);
            opaque_desc.descType(strBuf, level + 1);
        } else {
            strBuf.append(level_two);
            strBuf.append(this.getBaseName());
            strBuf.append("\n");
        }
        String ret = strBuf.toString();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.descType: return: " + ret));
        }
        return ret;
    }

    int toLength(ARRAY array) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toLength( array=" + array + ")"));
        }
        if (array.m_numElems == -1) {
            if (array.m_datumArray != null) {
                array.m_numElems = array.m_datumArray.length;
            } else if (array.m_objArray != null) {
                if (array.m_objArray instanceof Object[]) {
                    array.m_numElems = ((Object[])array.m_objArray).length;
                } else if (array.m_objArray instanceof int[]) {
                    array.m_numElems = ((long[])array.m_objArray).length;
                } else if (array.m_objArray instanceof long[]) {
                    array.m_numElems = ((float[])array.m_objArray).length;
                } else if (array.m_objArray instanceof float[]) {
                    array.m_numElems = ((double[])array.m_objArray).length;
                } else if (array.m_objArray instanceof double[]) {
                    array.m_numElems = ((boolean[])array.m_objArray).length;
                } else if (array.m_objArray instanceof boolean[]) {
                    array.m_numElems = ((int[])array.m_objArray).length;
                } else if (array.m_objArray instanceof byte[]) {
                    array.m_numElems = ((byte[])array.m_objArray).length;
                } else if (array.m_objArray instanceof short[]) {
                    array.m_numElems = ((short[])array.m_objArray).length;
                } else if (array.m_objArray instanceof char[]) {
                    array.m_numElems = ((char[])array.m_objArray).length;
                }
            } else if (array.m_locator != null) {
                array.m_numElems = this.toLengthFromLocator(array.m_locator);
            } else if (array.shareBytes() != null) {
                this.m_pickler.unlinearize(array.shareBytes(), array.m_imgOffset, array, 0, null);
                if (array.m_numElems == -1) {
                    if (array.m_locator != null) {
                        array.m_numElems = this.toLengthFromLocator(array.m_locator);
                    } else {
                        if (OracleLog.TRACE) {
                            OracleLog.print((Object)this, (int)64, (int)2, (String)"ArrayDescriptor.toLength: Unable to get array length. An exception is thrown.");
                        }
                        DBError.throwSqlException((int)1, (Object)"Unable to get array length");
                    }
                }
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toLength: Array is in inconsistent status. An exception is thrown.");
                }
                DBError.check_error((int)1, (Object)"Array is in inconsistent status");
            }
        }
        int ret = array.m_numElems;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toLength: return: " + ret));
        }
        return ret;
    }

    byte[] toBytes(ARRAY s2, boolean keepLocalCopy) throws SQLException {
        byte[] bytes;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toBytes( s=" + s2 + ", keepLocalCopy=" + keepLocalCopy + ")"));
        }
        if ((bytes = s2.shareBytes()) == null) {
            if (s2.m_datumArray != null || s2.m_locator != null) {
                bytes = this.m_pickler.linearize(s2);
                if (!keepLocalCopy) {
                    s2.setShareBytes(null);
                }
            } else if (s2.m_objArray != null) {
                s2.m_datumArray = this.toOracleArray(s2.m_objArray, 1L, -1);
                bytes = this.m_pickler.linearize(s2);
                if (!keepLocalCopy) {
                    s2.m_datumArray = null;
                    s2.setShareBytes(null);
                }
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toBytes: Array is in inconsistent status. An exception is thrown.");
                }
                DBError.throwSqlException((int)1, (Object)"Array is in inconsistent status");
            }
        } else if (s2.m_imgLength != 0L && (s2.m_imgOffset != 0L || s2.m_imgLength != (long)bytes.length)) {
            byte[] image = new byte[(int)s2.m_imgLength];
            System.arraycopy(bytes, (int)s2.m_imgOffset, image, 0, (int)s2.m_imgLength);
            s2.setImage(image, 0L, 0L);
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toBytes: return");
            }
            return image;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toBytes: return");
        }
        return bytes;
    }

    Datum[] toOracleArray(ARRAY s2, long beginIdx, int count, boolean keepLocalCopy) throws SQLException {
        Datum[] datumArray;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toOracleArray( s=" + s2 + ", beginIdx=" + beginIdx + ", count=" + count + ", keepLocalCopy=" + keepLocalCopy + ")"));
        }
        if ((datumArray = s2.m_datumArray) == null) {
            if (s2.m_objArray != null) {
                datumArray = this.toOracleArray(s2.m_objArray, beginIdx, count);
            } else if (s2.m_locator != null) {
                datumArray = this.toOracleArrayFromLocator(s2.m_locator, beginIdx, count, null);
            } else if (s2.shareBytes() != null) {
                this.m_pickler.unlinearize(s2.shareBytes(), s2.m_imgOffset, s2, beginIdx, count, 1, null);
                datumArray = s2.m_locator != null ? this.toOracleArrayFromLocator(s2.m_locator, beginIdx, count, null) : s2.m_datumArray;
                if (!keepLocalCopy) {
                    s2.m_datumArray = null;
                }
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toOracleArray: Array is in inconsistent status. An exception is thrown.");
                }
                DBError.throwSqlException((int)1);
            }
        } else {
            if (beginIdx > (long)datumArray.length) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toOracleArray: return");
                }
                return new Datum[0];
            }
            int length = (int)(count == -1 ? (long)datumArray.length - beginIdx + 1L : Math.min((long)datumArray.length - beginIdx + 1L, (long)count));
            datumArray = new Datum[length];
            System.arraycopy(s2.m_datumArray, (int)beginIdx - 1, datumArray, 0, length);
        }
        Datum[] ret = null;
        if (keepLocalCopy) {
            s2.m_datumArray = datumArray;
            ret = (Datum[])datumArray.clone();
        } else {
            ret = datumArray;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toOracleArray: return");
        }
        return ret;
    }

    Object[] toJavaArray(ARRAY s2, long beginIdx, int count, Map map, boolean saveLocalCopy) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toJavaArray( s=" + s2 + ", beginIdx=" + beginIdx + ", count=" + count + ", map=" + map + ", saveLocalCopy=" + saveLocalCopy + ")"));
        }
        Object[] objArray = null;
        if (s2.m_objArray != null) {
            objArray = (Object[])((Object[])s2.m_objArray).clone();
            int nbElem = objArray.length;
            int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
            if (length <= 0) {
                Object[] ret = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toJavaArray: return");
                }
                return ret;
            }
            objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
            System.arraycopy(s2.m_objArray, (int)beginIdx - 1, objArray, 0, length);
        } else {
            if (s2.m_datumArray != null) {
                objArray = (Object[])this.toJavaArray(s2.m_datumArray, beginIdx, count, map);
            } else if (s2.m_locator != null) {
                objArray = this.toArrayFromLocator(s2.m_locator, beginIdx, count, map);
            } else if (s2.shareBytes() != null) {
                this.m_pickler.unlinearize(s2.shareBytes(), s2.m_imgOffset, s2, beginIdx, count, 2, map);
                objArray = s2.m_locator != null ? this.toArrayFromLocator(s2.m_locator, beginIdx, count, map) : (Object[])s2.m_objArray;
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toJavaArray: Array is in inconsistent status. An exception is thrown.");
                }
                DBError.throwSqlException((int)1);
            }
            s2.m_objArray = saveLocalCopy && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objArray != null ? objArray.clone() : null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toJavaArray: return");
        }
        return objArray;
    }

    private Datum[] toOracleArrayFromLocator(byte[] locator_bytes, long beginIdx, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toOracleArrayFromLocator( locator_bytes=" + locator_bytes + ", beginIdx=" + beginIdx + ", count=" + count + ", map=" + map + ")"));
        }
        int nbElem = this.toLengthFromLocator(locator_bytes);
        int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
        Datum[] datumArray = null;
        if (length <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[length];
            ResultSet rset = this.toResultSetFromLocator(locator_bytes, beginIdx, count, map);
            int i2 = 0;
            while (rset.next()) {
                datumArray[i2] = ((OracleResultSet)rset).getOracleObject(2);
                ++i2;
            }
            rset.close();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toOracleArrayFromLocator: return");
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] locator_bytes, long beginIdx, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toArrayFromLocator( locator_bytes=" + locator_bytes + ", beginIdx=" + beginIdx + ", count=" + count + ", map=" + map + ")"));
        }
        int nbElem = this.toLengthFromLocator(locator_bytes);
        int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
        Object[] objArray = null;
        if (length <= 0) {
            objArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
            ResultSet rset = this.toResultSetFromLocator(locator_bytes, beginIdx, count, map);
            int i2 = 0;
            while (rset.next()) {
                objArray[i2] = ((OracleResultSet)rset).getObject(2, map);
                ++i2;
            }
            rset.close();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toArrayFromLocator: return");
        }
        return objArray;
    }

    public ResultSet toResultSet(ARRAY array, long index, int count, Map map, boolean saveLocalCopy) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toResultSet( array=" + array + ", index=" + index + ", count=" + count + ", map=" + map + ", saveLocalCopy=" + saveLocalCopy + ")"));
        }
        ResultSet rset = null;
        if (array.m_datumArray != null) {
            rset = this.toResultSet(array.m_datumArray, index, count, map);
        } else if (array.m_locator != null) {
            rset = this.toResultSetFromLocator(array.m_locator, index, count, map);
        } else if (array.m_objArray != null) {
            rset = this.toResultSet(this.toOracleArray(array.m_objArray, index, count), 1L, -1, map);
        } else if (array.shareBytes() != null) {
            if (((OracleTypeCOLLECTION)this.m_pickler).isInlineImage(array.shareBytes(), (int)array.m_imgOffset)) {
                rset = this.toResultSetFromImage(array, index, count, map);
            } else {
                this.m_pickler.unlinearize(array.shareBytes(), array.m_imgOffset, array, 1, null);
                if (array.m_locator != null) {
                    rset = this.toResultSetFromLocator(array.m_locator, index, count, map);
                } else {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toResultSet: Array is in inconsistent status. An exception is thrown.");
                    }
                    DBError.throwSqlException((int)1);
                }
            }
        }
        if (rset == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"ArrayDescriptor.toResultSet: Unable to create array ResultSet. An exception is thrown.");
            }
            DBError.check_error((int)1, (Object)"Unable to create array ResultSet");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toResultSet: return");
        }
        return rset;
    }

    public ResultSet toResultSet(Datum[] data, long index, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toResultSet( data=" + data + ", index=" + index + ", count=" + count + ", map=" + map + ")"));
        }
        ArrayDataResultSet ret = null;
        ret = count == -1 ? new ArrayDataResultSet((OracleConnection)this.m_conn, data, index, data.length, map) : new ArrayDataResultSet((OracleConnection)this.m_conn, data, index, count, map);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toResultSet: return");
        }
        return ret;
    }

    public ResultSet toResultSetFromLocator(byte[] locator, long index, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toResultSetFromLocator( locator=" + locator + ", index=" + index + ", count=" + count + ", map=" + map + ")"));
        }
        ArrayLocatorResultSet ret = new ArrayLocatorResultSet((OracleConnection)this.m_conn, this, locator, index, count, map);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toResultSetFromLocator: return");
        }
        return ret;
    }

    public ResultSet toResultSetFromImage(ARRAY array, long index, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toResultSetFromImage( array=" + array + ", index=" + index + ", count=" + count + ", map=" + map + ")"));
        }
        ArrayDataResultSet ret = new ArrayDataResultSet((OracleConnection)this.m_conn, array, index, count, map);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toResultSetFromImage: return");
        }
        return ret;
    }

    public static Object[] makeJavaArray(int length, int otype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("ArrayDescriptor.makeJavaArray( length=" + length + ", otype=" + otype + ")"));
        }
        Object[] ret = null;
        switch (otype) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ret = new BigDecimal[length];
                break;
            }
            case 1: 
            case 12: {
                ret = new String[length];
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                ret = new Timestamp[length];
                break;
            }
            case 2002: 
            case 2008: {
                ret = new Object[length];
                break;
            }
            case -13: {
                ret = new BFILE[length];
                break;
            }
            case 2004: {
                ret = new BLOB[length];
                break;
            }
            case 2005: {
                ret = new CLOB[length];
                break;
            }
            case -3: 
            case -2: {
                ret = (Object[])new byte[length][];
                break;
            }
            case 2006: {
                ret = new REF[length];
                break;
            }
            case 2003: {
                ret = new Object[length];
                break;
            }
            default: {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)("ArrayDescriptor.makeJavaArray: makeJavaArray doesn't support type " + otype + ". An exception is thrown."));
                }
                DBError.check_error((int)1, (Object)("makeJavaArray doesn't support type " + otype));
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"ArrayDescriptor.makeJavaArray: return");
        }
        return ret;
    }

    private int toLengthFromLocator(byte[] locator_bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toLengthFromLocator( locator_bytes=" + locator_bytes + ")"));
        }
        ARRAY tmpObj = new ARRAY(this, this.m_conn, (Object)null);
        tmpObj.setLocator(locator_bytes);
        int numElems = 0;
        OraclePreparedStatement pstmt = null;
        OracleResultSet rs = null;
        pstmt = (OraclePreparedStatement)this.m_conn.prepareStatement("SELECT count(*) FROM TABLE( CAST(? AS " + this.getName() + ") )");
        pstmt.setArray(1, tmpObj);
        rs = (OracleResultSet)pstmt.executeQuery();
        if (rs.next()) {
            numElems = rs.getInt(1);
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toLengthFromLocator: Fail to access array storage table. An exception is thrown.");
            }
            DBError.check_error((int)1, (Object)"Fail to access array storage table");
        }
        rs.close();
        pstmt.close();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toLengthFromLocator: return: " + numElems));
        }
        return numElems;
    }

    Datum[] toOracleArray(Object elements, long beginIdx, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toOracle( elements=" + elements + ", beginIdx=" + beginIdx + ", count=" + count + ")"));
        }
        Datum[] ret = null;
        if (elements != null) {
            OracleType otype = this.getElementType();
            ret = otype.toDatumArray(elements, (OracleConnection)this.m_conn, beginIdx, count);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toOracle: return");
        }
        return ret;
    }

    private Object toJavaArray(Datum[] elements, long beginIdx, int count, Map map) throws SQLException {
        int length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toJavaArray( elements=" + elements + ", beginIdx=" + beginIdx + ", count=" + count + ", map=" + map + ")"));
        }
        if ((length = (int)(count == -1 ? (long)elements.length - beginIdx + 1L : Math.min((long)elements.length - beginIdx + 1L, (long)count))) < 0) {
            length = 0;
        }
        Object[] objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
        if (this.getBaseType() == 2002) {
            STRUCT s2 = null;
            int i2 = 0;
            while (i2 < length) {
                s2 = (STRUCT)elements[(int)beginIdx + i2 - 1];
                objArray[i2] = s2 != null ? s2.toJdbc(map) : null;
                ++i2;
            }
        } else {
            Datum d2 = null;
            int i3 = 0;
            while (i3 < length) {
                d2 = elements[(int)beginIdx + i3 - 1];
                objArray[i3] = d2 != null ? d2.toJdbc() : null;
                ++i3;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toJavaArray: return");
        }
        return objArray;
    }

    private Object toNumericArray(Datum[] darray, long beginIdx, int count, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toNumericArray( darray=" + darray + ", beginIdx=" + beginIdx + ", count=" + count + ", type=" + type + ")"));
        }
        Object[] ret = null;
        int length = (int)(count == -1 ? (long)darray.length - beginIdx + 1L : Math.min((long)darray.length - beginIdx + 1L, (long)count));
        if (length < 0) {
            length = 0;
        }
        if (type == 4) {
            int[] objArray = new int[length];
            int i2 = 0;
            while (i2 < length) {
                Datum d2 = darray[(int)beginIdx + i2 - 1];
                if (d2 != null) {
                    objArray[i2] = d2.intValue();
                }
                ++i2;
            }
            ret = objArray;
        } else if (type == 5) {
            double[] objArray = new double[length];
            int i3 = 0;
            while (i3 < length) {
                Datum d3 = darray[(int)beginIdx + i3 - 1];
                if (d3 != null) {
                    objArray[i3] = d3.doubleValue();
                }
                ++i3;
            }
            ret = objArray;
        } else if (type == 6) {
            float[] objArray = new float[length];
            int i4 = 0;
            while (i4 < length) {
                Datum d4 = darray[(int)beginIdx + i4 - 1];
                if (d4 != null) {
                    objArray[i4] = d4.floatValue();
                }
                ++i4;
            }
            ret = objArray;
        } else if (type == 7) {
            long[] objArray = new long[length];
            int i5 = 0;
            while (i5 < length) {
                Datum d5 = darray[(int)beginIdx + i5 - 1];
                if (d5 != null) {
                    objArray[i5] = d5.longValue();
                }
                ++i5;
            }
            ret = objArray;
        } else if (type == 8) {
            short[] objArray = new short[length];
            int i6 = 0;
            while (i6 < length) {
                Datum d6 = darray[(int)beginIdx + i6 - 1];
                if (d6 != null) {
                    objArray[i6] = ((NUMBER)d6).shortValue();
                }
                ++i6;
            }
            ret = objArray;
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toNumericArray: This feature is not supported. An exception is thrown.");
            }
            DBError.throwSqlException((int)23);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toNumericArray: return");
        }
        return ret;
    }

    private Object toNumericArrayFromLocator(byte[] locator_bytes, long beginIdx, int count, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toNumericArrayFromLocator( locator_bytes=" + locator_bytes + ", beginIdx=" + beginIdx + ", count=" + count + ", type=" + type + ")"));
        }
        Object[] ret = null;
        int nbElem = this.toLengthFromLocator(locator_bytes);
        ResultSet rs = this.toResultSetFromLocator(locator_bytes, beginIdx, count, null);
        int idx = 0;
        if (type == 4) {
            int[] objArray = new int[nbElem];
            while (rs.next() && idx < nbElem) {
                objArray[idx++] = ((OracleResultSet)rs).getInt(2);
            }
            rs.close();
            ret = objArray;
        } else if (type == 5) {
            double[] objArray = new double[nbElem];
            while (rs.next() && idx < nbElem) {
                objArray[idx++] = ((OracleResultSet)rs).getDouble(2);
            }
            rs.close();
            ret = objArray;
        } else if (type == 6) {
            float[] objArray = new float[nbElem];
            while (rs.next() && idx < nbElem) {
                objArray[idx++] = ((OracleResultSet)rs).getFloat(2);
            }
            rs.close();
            ret = objArray;
        } else if (type == 7) {
            long[] objArray = new long[nbElem];
            while (rs.next() && idx < nbElem) {
                objArray[idx++] = ((OracleResultSet)rs).getLong(2);
            }
            rs.close();
            ret = objArray;
        } else if (type == 8) {
            short[] objArray = new short[nbElem];
            while (rs.next() && idx < nbElem) {
                objArray[idx++] = ((OracleResultSet)rs).getShort(2);
            }
            rs.close();
            ret = objArray;
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toNumericArrayFromLocator: Unsupported feature. An exception is thrown.");
            }
            DBError.throwSqlException((int)23);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toNumericArrayFromLocator: return");
        }
        return ret;
    }

    Object toNumericArray(ARRAY array, long beginIdx, int count, int type, boolean saveLocalCopy) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toNumericArray( array=" + array + ", beginIdx=" + beginIdx + ", count=" + count + ", type=" + type + ", saveLocalCopy=" + saveLocalCopy + ")"));
        }
        if (!(this.getElementType() instanceof OracleTypeNUMBER) && !(this.getElementType() instanceof OracleTypeFLOAT)) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toNumericArray(ARRAY, long, int, int, boolean): Unsupported feature. An exception is thrown.");
            }
            DBError.throwSqlException((int)23);
        }
        Object objArray = null;
        if (array.m_objArray != null) {
            if (type == 4 && array.m_objArray instanceof int[]) {
                int length = ((int[])array.m_objArray).length;
                if (beginIdx > (long)length) {
                    return new int[0];
                }
                length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                int[] newOarray = new int[length];
                System.arraycopy(array.m_objArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 5 && array.m_objArray instanceof double[]) {
                int length = ((double[])array.m_objArray).length;
                if (beginIdx > (long)length) {
                    return new double[0];
                }
                length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                double[] newOarray = new double[length];
                System.arraycopy(array.m_objArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 6 && array.m_objArray instanceof float[]) {
                int length = ((float[])array.m_objArray).length;
                if (beginIdx > (long)length) {
                    return new float[0];
                }
                length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                float[] newOarray = new float[length];
                System.arraycopy(array.m_objArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 7 && array.m_objArray instanceof long[]) {
                int length = ((long[])array.m_objArray).length;
                if (beginIdx > (long)length) {
                    return new long[0];
                }
                length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                long[] newOarray = new long[length];
                System.arraycopy(array.m_objArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 8 && array.m_objArray instanceof short[]) {
                int length = ((short[])array.m_objArray).length;
                if (beginIdx > (long)length) {
                    return new short[0];
                }
                length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                short[] newOarray = new short[length];
                System.arraycopy(array.m_objArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            }
        } else {
            if (array.m_datumArray != null) {
                objArray = this.toNumericArray(array.m_datumArray, beginIdx, count, type);
            } else if (array.m_locator != null) {
                objArray = this.toNumericArrayFromLocator(array.m_locator, beginIdx, count, type);
            } else if (array.shareBytes() != null) {
                this.m_pickler.unlinearize(array.shareBytes(), array.m_imgOffset, array, beginIdx, count, type, null);
                objArray = array.m_locator != null ? this.toNumericArrayFromLocator(array.m_locator, beginIdx, count, type) : array.m_objArray;
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)64, (int)4, (String)"ArrayDescriptor.toNumericArray(ARRAY, long, int, int, boolean): Unsupported feature. An exception is thrown.");
                }
                DBError.throwSqlException((int)1);
            }
            if (!saveLocalCopy) {
                array.m_objArray = null;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toNumericArray: return");
        }
        return objArray;
    }

    private void initPickler() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.initPickler()");
        }
        try {
            OracleTypeADT adt = new OracleTypeADT(this.getName(), (Connection)this.m_conn);
            adt.init((OracleConnection)this.m_conn);
            this.m_pickler = (OracleTypeCOLLECTION)adt.cleanup();
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception e2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)("ArrayDescriptor.initPickler: Exception caught and thrown." + e2.getMessage()));
            }
            if (e2 instanceof SQLException) {
                throw (SQLException)e2;
            }
            DBError.throwSqlException((int)60, (Object)("Unable to resolve type: \"" + this.getName() + "\""));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.initPickler: return");
        }
    }

    private OracleType getElementType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.getElementType()");
        }
        OracleType ret = ((OracleTypeCOLLECTION)this.m_pickler).getElementType();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.getElementType: return");
        }
        return ret;
    }

    public int getTypeCode() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.getTypeCode()");
        }
        int ret = 2003;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.getTypeCode: return: " + ret));
        }
        return ret;
    }

    public byte[] toBytes(Datum[] attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toBytes( attributes=" + attributes + ") -- DEPRECATED --, " + "-- no return trace --"));
        }
        ARRAY s2 = new ARRAY(this, this.m_conn, attributes);
        return this.m_pickler.linearize(s2);
    }

    public byte[] toBytes(Object[] attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toBytes( attributes=" + attributes + ")"));
        }
        Datum[] datums = this.toArray(attributes);
        byte[] ret = this.toBytes(datums);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toBytes: return");
        }
        return ret;
    }

    public int length(byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.length( bytes=" + bytes + ")"));
        }
        ARRAY tmpObj = new ARRAY(this, this.m_conn, bytes);
        int ret = this.toLength(tmpObj);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.length: return: " + ret));
        }
        return ret;
    }

    public Datum[] toArray(byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toArray( bytes=" + bytes + ")"));
        }
        Datum[] ret = null;
        if (bytes != null) {
            ARRAY tmpObj = new ARRAY(this, this.m_conn, bytes);
            ret = this.toOracleArray(tmpObj, 1L, -1, false);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toArray: return");
        }
        return ret;
    }

    public Datum[] toArray(Object attributes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toArray( attributes=" + attributes + ")"));
        }
        Datum[] ret = this.toOracleArray(attributes, 1L, -1);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toArray: return");
        }
        return ret;
    }

    public ResultSet toResultSet(byte[] bytes, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toResultSet( bytes=" + bytes + ", map=" + map + ")"));
        }
        ResultSet ret = null;
        if (bytes != null) {
            ARRAY tmpObj = (ARRAY)this.m_pickler.unlinearize(bytes, 0L, null, 1, null);
            ret = this.toResultSet(tmpObj, 1L, -1, map, false);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toResultSet: return");
        }
        return ret;
    }

    public ResultSet toResultSet(byte[] bytes, long index, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.toResultSet( bytes=" + bytes + ", index=" + index + ", count=" + count + ", map=" + map + ")"));
        }
        ResultSet ret = null;
        if (bytes != null) {
            ARRAY tmpObj = (ARRAY)this.m_pickler.unlinearize(bytes, 0L, null, 1, null);
            ret = this.toResultSet(tmpObj, index, count, map, false);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ArrayDescriptor.toResultSet: return");
        }
        return ret;
    }

    public static int getCacheStyle(ARRAY array) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("ArrayDescriptor.getCacheStyle( array=" + array + ")"));
        }
        int ret = 2;
        if (array.getAutoIndexing() && (array.getAccessDirection() == 2 || array.getAccessDirection() == 3)) {
            ret = 1;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("ArrayDescriptor.getCacheStyle: return: " + ret));
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.writeObject( out=" + out + ") -- do nothing"));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ArrayDescriptor.readObject( in=" + in + ") -- do nothing"));
        }
    }

    static {
        TYPE_VARRAY = 3;
        TYPE_NESTED_TABLE = 2;
        CACHE_NONE = 0;
        CACHE_ALL = 1;
        CACHE_LAST = 2;
        serialVersionUID = 3838105394346513809L;
    }
}

