/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;

public class ARRAY
extends DatumWithConnection
implements Array {
    static final byte KOPUP_INLINE_COLL = 1;
    ArrayDescriptor m_descriptor;
    Object m_objArray;
    Datum[] m_datumArray;
    byte[] m_locator;
    byte m_prefixFlag;
    byte[] m_prefixSegment;
    int m_numElems = -1;
    boolean m_enableBuffering = false;
    boolean m_enableIndexing = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int m_accessDirection = 3;
    long m_lastIndex;
    long m_lastOffset;
    long[] m_indexArray;
    long m_imgOffset;
    long m_imgLength;

    public ARRAY(ArrayDescriptor type, Connection conn, Object elements) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.ARRAY( type=" + type + " conn=" + conn + "elements=" + elements + ")"));
        }
        DatumWithConnection.assertNotNull(type);
        DatumWithConnection.assertNotNull(conn);
        if (!type.getInternalConnection().isDescriptorSharable(OracleConnection.physicalConnectionWithin((Connection)conn))) {
            throw new SQLException("Cannot construct ARRAY instance, invalid connection");
        }
        type.setConnection(conn);
        this.m_descriptor = type;
        this.setPhysicalConnectionOf(conn);
        this.m_datumArray = elements == null ? new Datum[0] : this.m_descriptor.toOracleArray(elements, 1L, -1);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.ARRAY: return");
        }
    }

    public ARRAY(ArrayDescriptor descriptor, byte[] bytes, Connection conn) throws SQLException {
        super(bytes);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.ARRAY( descriptor=" + descriptor + " bytes=" + bytes + "conn=" + conn + ") -- after super() --"));
        }
        DatumWithConnection.assertNotNull(conn);
        DatumWithConnection.assertNotNull(descriptor);
        if (!descriptor.getInternalConnection().isDescriptorSharable(OracleConnection.physicalConnectionWithin((Connection)conn))) {
            throw new SQLException("Cannot construct ARRAY instance, invalid connection");
        }
        descriptor.setConnection(conn);
        this.setPhysicalConnectionOf(conn);
        this.m_descriptor = descriptor;
        this.m_datumArray = null;
        this.m_locator = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.ARRAY: return");
        }
    }

    public static ARRAY toARRAY(Object obj, oracle.jdbc.OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("ARRAY.toARRAY( obj=" + obj + ", conn=" + conn + ")"));
        }
        ARRAY s2 = null;
        if (obj != null) {
            if (obj instanceof ARRAY) {
                s2 = (ARRAY)obj;
            } else if (obj instanceof ORAData) {
                s2 = (ARRAY)((ORAData)obj).toDatum(conn);
            } else if (obj instanceof CustomDatum) {
                s2 = (ARRAY)((CustomDatum)obj).toDatum((OracleConnection)conn);
            } else {
                if (OracleLog.TRACE) {
                    OracleLog.print(null, (int)64, (int)2, (String)"ARRAY.toARRAY: Conversion error. 'obj' should be an instance of  ARRAY or ORAData or CustomDatum or SQLData. An exception is thrown.");
                }
                DBError.check_error((int)59, (Object)obj);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)"ARRAY.toARRAY: return");
        }
        return s2;
    }

    public synchronized String getBaseTypeName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getBaseTypeName()");
        }
        String ret = this.m_descriptor.getBaseName();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getBaseTypeName: return: " + ret));
        }
        return ret;
    }

    public synchronized int getBaseType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getBaseType() -- no return trace --");
        }
        return this.m_descriptor.getBaseType();
    }

    public synchronized Object getArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getArray() -- no return trace --");
        }
        return this.m_descriptor.toJavaArray(this, 1L, -1, this.getMap(), this.m_enableBuffering);
    }

    public synchronized Object getArray(Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getArray( map=" + map + ") -- no return trace --"));
        }
        return this.m_descriptor.toJavaArray(this, 1L, -1, map, this.m_enableBuffering);
    }

    public synchronized Object getArray(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getArray( index=" + index + ", count=" + count + ") -- no return trace --"));
        }
        if (index < 1L || count < 0) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"ARRAY.getArray: Invalid arguments, 'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"getArray()");
        }
        return this.m_descriptor.toJavaArray(this, index, count, this.getMap(), false);
    }

    public synchronized Object getArray(long index, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getArray( index=" + index + ", count=" + count + ", map=" + map + ")" + " -- no return trace --"));
        }
        if (index < 1L || count < 0) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"ARRAY.getArray: Invalid arguments, 'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"getArray()");
        }
        return this.m_descriptor.toJavaArray(this, index, count, map, false);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getResultSet() -- no return trace --");
        }
        return this.getResultSet(this.getConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getResultSet( map=" + map + ") -- no return trace --"));
        }
        return this.m_descriptor.toResultSet(this, 1L, -1, map, this.m_enableBuffering);
    }

    public synchronized ResultSet getResultSet(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getResultSet( index=" + index + ", count=" + count + ")" + " -- no return trace --"));
        }
        return this.getResultSet(index, count, this.getConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getResultSet( index=" + index + ", count=" + count + ", map=" + map + ")" + " -- no return trace --"));
        }
        if (index < 1L || count < -1) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"ARRAY.getResultSet: Invalid arguments, 'index' should be >= 1 and 'count' >= -1. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"getResultSet()");
        }
        return this.m_descriptor.toResultSet(this, index, count, map, false);
    }

    public synchronized Datum[] getOracleArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getOracleArray() -- no return trace --");
        }
        return this.m_descriptor.toOracleArray(this, 1L, -1, this.m_enableBuffering);
    }

    public synchronized int length() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.length() -- no return trace --");
        }
        return this.m_descriptor.toLength(this);
    }

    public synchronized Datum[] getOracleArray(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getOracleArray( index=" + index + ", count=" + count + ")" + " -- no return trace --"));
        }
        if (index < 1L || count < 0) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"ARRAY.getOracleArray: Invalid arguments, 'index' should be >= 1 and 'coun't >= 0. An exception is thrown.");
            }
            DBError.check_error((int)68, (Object)"getOracleArray()");
        }
        return this.m_descriptor.toOracleArray(this, index, count, false);
    }

    public synchronized String getSQLTypeName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getSQLTypeName()");
        }
        String ret = null;
        if (this.m_descriptor != null) {
            ret = this.m_descriptor.getName();
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"ARRAY.getSQLTypeName: The ArrayDescriptor object is null. An exception is thrown.");
            }
            DBError.check_error((int)61, (Object)"ARRAY");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getSQLTypeName: return: " + ret));
        }
        return ret;
    }

    public Map getMap() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getMap() -- no return trace --");
        }
        return this.getConnection().getTypeMap();
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getDescriptor(): return");
        }
        return this.m_descriptor;
    }

    public synchronized byte[] toBytes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.toBytes() -- no return trace --");
        }
        return this.m_descriptor.toBytes(this, this.m_enableBuffering);
    }

    public synchronized void setDatumArray(Datum[] darray) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setDatumArray( darray=" + darray + "): return"));
        }
        this.m_datumArray = darray;
    }

    public synchronized void setObjArray(Object oarray) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setObjArray( oarray=" + oarray + ")"));
        }
        if (oarray == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)64, (int)2, (String)"ARRAY.setObjArray: Invalid argument, 'oarray' should not be null. An exception is thrown.");
            }
            DBError.throwSqlException((int)1);
        }
        this.m_objArray = oarray;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.setObjArray: return");
        }
    }

    public synchronized void setLocator(byte[] pseg_bytes) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setLocator( pseg_bytes=" + pseg_bytes + "): return"));
        }
        if (pseg_bytes != null && pseg_bytes.length != 0) {
            this.m_locator = pseg_bytes;
        }
    }

    public synchronized void setPrefixSegment(byte[] pseg_bytes) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setPrefixSegment ( pseg_bytes=" + pseg_bytes + "): return"));
        }
        if (pseg_bytes != null && pseg_bytes.length != 0) {
            this.m_prefixSegment = pseg_bytes;
        }
    }

    public synchronized void setPrefixFlag(byte psegFlag) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setPrefixFlag ( psegFlag=" + psegFlag + "): return"));
        }
        this.m_prefixFlag = psegFlag;
    }

    public byte[] getLocator() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getLocator(): return");
        }
        return this.m_locator;
    }

    public synchronized void setLength(int len) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setLength( len=" + len + "): return"));
        }
        this.m_numElems = len;
    }

    public boolean hasDataSeg() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.hasDataSeg(): return: " + (this.m_locator == null ? "true" : "false")));
        }
        return this.m_locator == null;
    }

    public boolean isInline() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.isInline (): return: " + ((this.m_prefixFlag & 1) == 1)));
        }
        return (this.m_prefixFlag & 1) == 1;
    }

    public Object toJdbc() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.toJdbc(): return");
        }
        return this;
    }

    public boolean isConvertibleTo(Class jClass) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.isConvertibleTo( jClass=" + jClass + "): return: false (always)"));
        }
        return false;
    }

    public Object makeJdbcArray(int arraySize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.makeJdbcArray( arraysize=" + arraySize + "): return"));
        }
        return new Object[arraySize][];
    }

    public synchronized int[] getIntArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getIntArray() -- no return trace --");
        }
        return (int[])this.m_descriptor.toNumericArray(this, 1L, -1, 4, this.m_enableBuffering);
    }

    public synchronized int[] getIntArray(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getIntArray( index=" + index + ", count" + count + ") -- no return trace --"));
        }
        return (int[])this.m_descriptor.toNumericArray(this, index, count, 4, false);
    }

    public synchronized double[] getDoubleArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getDoubleArray() -- no return trace --");
        }
        return (double[])this.m_descriptor.toNumericArray(this, 1L, -1, 5, this.m_enableBuffering);
    }

    public synchronized double[] getDoubleArray(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getDoubleArray( index=" + index + ", count=" + count + ") -- no return trace --"));
        }
        return (double[])this.m_descriptor.toNumericArray(this, index, count, 5, false);
    }

    public synchronized short[] getShortArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getShortArray() -- no return trace --");
        }
        return (short[])this.m_descriptor.toNumericArray(this, 1L, -1, 8, this.m_enableBuffering);
    }

    public synchronized short[] getShortArray(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getShortArray( index=" + index + ", count=" + count + ") -- no return trace --"));
        }
        return (short[])this.m_descriptor.toNumericArray(this, index, count, 8, false);
    }

    public synchronized long[] getLongArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getLongArray() -- no return trace --");
        }
        return (long[])this.m_descriptor.toNumericArray(this, 1L, -1, 7, this.m_enableBuffering);
    }

    public synchronized long[] getLongArray(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getLongArray( index=" + index + ", count=" + count + ") -- no return trace --"));
        }
        return (long[])this.m_descriptor.toNumericArray(this, index, count, 7, false);
    }

    public synchronized float[] getFloatArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.getFloatArray() -- no return trace --");
        }
        return (float[])this.m_descriptor.toNumericArray(this, 1L, -1, 6, this.m_enableBuffering);
    }

    public synchronized float[] getFloatArray(long index, int count) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getFloatArray( index=" + index + ", count=" + count + ") -- no return trace --"));
        }
        return (float[])this.m_descriptor.toNumericArray(this, index, count, 6, false);
    }

    public synchronized void setAutoBuffering(boolean enable) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setAutoBuffering( enable=" + enable + "): return"));
        }
        this.m_enableBuffering = enable;
    }

    public boolean getAutoBuffering() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getAutoBuffering(): return: " + this.m_enableBuffering));
        }
        return this.m_enableBuffering;
    }

    public synchronized void setAutoIndexing(boolean enable, int direction) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setAutoIndexing( enable=" + enable + ", direction=" + direction + "): return"));
        }
        this.m_enableIndexing = enable;
        this.m_accessDirection = direction;
    }

    public synchronized void setAutoIndexing(boolean enable) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setAutoIndexing( enable=" + enable + "): return"));
        }
        this.m_enableIndexing = enable;
        this.m_accessDirection = 3;
    }

    public boolean getAutoIndexing() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getAutoIndexing(): return: " + this.m_enableIndexing));
        }
        return this.m_enableIndexing;
    }

    public int getAccessDirection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getAccessDirection(): return: " + this.m_accessDirection));
        }
        return this.m_accessDirection;
    }

    public void setLastIndexOffset(long index, long offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setLastIndexOffset( index=" + index + ", offset=" + offset + "): return"));
        }
        this.m_lastIndex = index;
        this.m_lastOffset = offset;
    }

    public void setIndexOffset(long index, long offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setIndexOffset( index=" + index + ", offset=" + offset + ") -- no return trace --"));
        }
        if (this.m_indexArray == null) {
            this.m_indexArray = new long[this.m_numElems];
        }
        this.m_indexArray[(int)index - 1] = offset;
    }

    public long getLastIndex() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getLastIndex(): return: " + this.m_lastIndex));
        }
        return this.m_lastIndex;
    }

    public long getLastOffset() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getLastOffset(): return: " + this.m_lastOffset));
        }
        return this.m_lastOffset;
    }

    public long getOffset(long index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getOffset( index=" + index + ")"));
        }
        long ret = -1L;
        if (this.m_indexArray != null) {
            ret = this.m_indexArray[(int)index - 1];
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getOffset: return: " + ret));
        }
        return ret;
    }

    public void setImage(byte[] image, long offset, long length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setImage( image=" + image + ", offset=" + offset + " length=" + length + ")"));
        }
        this.setShareBytes(image);
        this.m_imgOffset = offset;
        this.m_imgLength = length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)"ARRAY.setImage: return");
        }
    }

    public void setImageLength(long length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.setImageLength( length=" + length + "): return"));
        }
        this.m_imgLength = length;
    }

    public long getImageOffset() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getImageOffset(): return: " + this.m_imgOffset));
        }
        return this.m_imgOffset;
    }

    public long getImageLength() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)64, (int)16, (String)("ARRAY.getImageLength(): return: " + this.m_imgLength));
        }
        return this.m_imgLength;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }

    static {
        KOPUP_INLINE_COLL = 1;
        ACCESS_FORWARD = 1;
        ACCESS_REVERSE = 2;
        ACCESS_UNKNOWN = 3;
    }
}

