/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.ns.DataPacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetOutputStream
extends OutputStream
implements SQLnetDef {
    protected DataPacket daPkt;
    protected SessionAtts sAtts;
    private byte[] tmpBuf = new byte[1];

    public NetOutputStream(SessionAtts sessionAtts) {
        this.sAtts = sessionAtts;
        this.daPkt = new DataPacket(sessionAtts);
    }

    public NetOutputStream(SessionAtts sessionAtts, int n2) {
        this.sAtts = sessionAtts;
        this.daPkt = new DataPacket(sessionAtts, n2);
    }

    public int available() throws IOException {
        return this.daPkt.availableBytesToSend;
    }

    public void close() throws IOException {
        this.daPkt.send(64);
    }

    public void flush() throws IOException {
        if (this.daPkt.availableBytesToSend > 0) {
            this.daPkt.send(0);
        }
    }

    public void write(int n2) throws IOException {
        this.tmpBuf[0] = (byte)n2;
        this.write(this.tmpBuf);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        while (n3 > n4) {
            n4 += this.daPkt.putDataInBuffer(byArray, n2 + n4, n3 - n4);
            if (!this.daPkt.isBufferFull) continue;
            n5 = n3 > n4 ? 32 : 0;
            this.daPkt.send(n5);
        }
    }
}

