/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class ConnectPacket
extends Packet
implements SQLnetDef {
    private boolean connDataOflow;

    public ConnectPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.data = sessionAtts.cOption.conn_data.toString();
        this.dataLen = this.data == null ? 0 : this.data.length();
        this.connDataOflow = this.dataLen > 230;
        int n2 = !this.connDataOflow ? 34 + this.dataLen : 34;
        this.createBuffer(n2, 1, 0);
        this.buffer[8] = 1;
        this.buffer[9] = 52;
        this.buffer[10] = 1;
        this.buffer[11] = 44;
        this.buffer[12] = 0;
        this.buffer[13] = 0;
        this.buffer[14] = (byte)(this.sdu / 256);
        this.buffer[15] = (byte)(this.sdu % 256);
        this.buffer[16] = (byte)(this.tdu / 256);
        this.buffer[17] = (byte)(this.tdu % 256);
        this.buffer[18] = 79;
        this.buffer[19] = -104;
        this.buffer[22] = 0;
        this.buffer[23] = 1;
        this.buffer[24] = (byte)(this.dataLen / 256);
        this.buffer[25] = (byte)(this.dataLen % 256);
        this.buffer[27] = 34;
        if (!sessionAtts.anoEnabled) {
            this.buffer[33] = 4;
            this.buffer[32] = 4;
        } else {
            this.buffer[32] = this.buffer[33] = (byte)sessionAtts.getANOFlags();
        }
        if (!this.connDataOflow && this.dataLen > 0) {
            this.data.getBytes(0, this.dataLen, this.buffer, 34);
        }
    }

    protected void send() throws IOException {
        super.send();
        if (this.connDataOflow) {
            byte[] byArray = new byte[this.dataLen];
            this.data.getBytes(0, this.dataLen, byArray, 0);
            this.sAtts.nsOutputStream.write(byArray);
            this.sAtts.nsOutputStream.flush();
        }
    }
}

