/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class Util {
    static short lastCsId = (short)870;
    static CharacterSet lastCS = CharacterSet.make(870);

    public static Object convertToObject(Datum d2, int sqlType, Object f2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)2048, (int)2, (int)64, (String)("Util.convertToObject (datum = " + d2 + ", sqlType = " + sqlType + ", object = " + f2 + ")"));
        }
        Object result = Util._convertToObject(d2, sqlType, f2);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)2048, (int)2, (int)64, (String)("Util.convertToObject:return " + result));
        }
        return result;
    }

    public static Object _convertToObject(Datum d2, int sqlType, Object f2) throws SQLException {
        if (d2 == null) {
            return null;
        }
        if (d2 instanceof STRUCT) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d2, 2002);
            }
            return ((CustomDatumFactory)f2).create(d2, 2002);
        }
        if (d2 instanceof REF) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d2, 2006);
            }
            return ((CustomDatumFactory)f2).create(d2, 2006);
        }
        if (d2 instanceof ARRAY) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d2, 2003);
            }
            return ((CustomDatumFactory)f2).create(d2, 2003);
        }
        if (d2 instanceof OPAQUE) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d2, 2007);
            }
            return ((CustomDatumFactory)f2).create(d2, 2007);
        }
        if (f2 != null) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d2, sqlType);
            }
            return ((CustomDatumFactory)f2).create(d2, sqlType);
        }
        if (d2 instanceof NUMBER) {
            if (sqlType == 2 || sqlType == 3) {
                return ((NUMBER)d2).bigDecimalValue();
            }
            if (sqlType == 8 || sqlType == 6) {
                return new Double(((NUMBER)d2).doubleValue());
            }
            if (sqlType == 4 || sqlType == 5) {
                return new Integer(((NUMBER)d2).intValue());
            }
            if (sqlType == 7) {
                return new Float(((NUMBER)d2).floatValue());
            }
            throw new SQLException("Unexpected java.sql.OracleTypes type: " + sqlType);
        }
        return d2.toJdbc();
    }

    public static Datum convertToOracle(Object d2, Connection c2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)2048, (int)2, (int)64, (String)("Util.convertToOracle (datum = " + d2 + ", connection - " + c2 + ")"));
        }
        Datum result = Util._convertToOracle((Object)d2, (Connection)c2);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)2048, (int)2, (int)64, (String)("Util.convertToOracle:return " + result));
        }
        return result;
    }

    private static Datum _convertToOracle(Object d2, Connection c2) throws SQLException {
        if (d2 == null) {
            return null;
        }
        if (d2 instanceof ORAData) {
            return ((ORAData)d2).toDatum(c2);
        }
        if (d2 instanceof CustomDatum) {
            return ((CustomDatum)d2).toDatum((OracleConnection)c2);
        }
        if (d2 instanceof String) {
            short csId;
            short s2 = csId = c2 == null || !(c2 instanceof OracleConnection) ? (short)870 : (short)((OracleConnection)c2).getDbCsId();
            if (csId != lastCsId) {
                lastCsId = csId;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)d2, lastCS);
        }
        if (d2 instanceof BigDecimal) {
            return new NUMBER((BigDecimal)d2);
        }
        if (d2 instanceof Double) {
            return new NUMBER((Double)d2);
        }
        if (d2 instanceof Float) {
            return new NUMBER(((Float)d2).floatValue());
        }
        if (d2 instanceof Integer) {
            return new NUMBER((Integer)d2);
        }
        if (d2 instanceof Timestamp) {
            return new DATE((Timestamp)d2);
        }
        if (d2 instanceof byte[]) {
            return new RAW((byte[])d2);
        }
        if (d2 instanceof Datum) {
            return (Datum)d2;
        }
        throw new SQLException("Unable to convert object to oracle.sql.Datum: " + d2);
    }

    static boolean isMutable(Datum d2, ORADataFactory f2) {
        if (d2 == null) {
            return false;
        }
        return d2 instanceof BFILE || d2 instanceof BLOB || d2 instanceof CLOB || d2 instanceof STRUCT && f2 != null || d2 instanceof OPAQUE && f2 != null || d2 instanceof ARRAY && f2 != null;
    }

    static boolean isMutable(Datum d2, CustomDatumFactory f2) {
        if (d2 == null) {
            return false;
        }
        return d2 instanceof BFILE || d2 instanceof BLOB || d2 instanceof CLOB || d2 instanceof STRUCT && f2 != null || d2 instanceof OPAQUE && f2 != null || d2 instanceof ARRAY && f2 != null;
    }
}

