/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jpub.runtime.Util;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class MutableStruct {
    int length;
    STRUCT pickled;
    Datum[] datums;
    Object[] attributes;
    CustomDatumFactory[] old_factories;
    ORADataFactory[] factories;
    int[] sqlTypes;
    boolean pickledCorrect;

    public MutableStruct(STRUCT s2, int[] sqlTypes, ORADataFactory[] factories) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct (s = " + s2 + ", sqlTypes = " + sqlTypes + ", factories = " + factories + ")"));
        }
        this.length = factories.length;
        this.pickled = s2;
        this.factories = factories;
        this.sqlTypes = sqlTypes;
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] attributes, int[] sqlTypes, ORADataFactory[] factories) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct (" + attributes + ", " + sqlTypes + ", " + factories + ")"));
        }
        this.length = factories.length;
        this.attributes = attributes;
        this.factories = factories;
        this.sqlTypes = sqlTypes;
        this.pickledCorrect = false;
    }

    public MutableStruct(STRUCT s2, int[] sqlTypes, CustomDatumFactory[] factories) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct (" + s2 + ", " + sqlTypes + ", " + factories + ")"));
        }
        this.length = factories.length;
        this.pickled = s2;
        this.old_factories = factories;
        this.sqlTypes = sqlTypes;
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] attributes, int[] sqlTypes, CustomDatumFactory[] factories) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct (attributes = " + attributes + ", sqlTypes = " + sqlTypes + ", factories =" + factories + ")"));
        }
        this.length = factories.length;
        this.attributes = attributes;
        this.old_factories = factories;
        this.sqlTypes = sqlTypes;
        this.pickledCorrect = false;
    }

    public Datum toDatum(Connection c2, String sqlTypeName) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new STRUCT(StructDescriptor.createDescriptor(sqlTypeName, c2), c2, this.getDatumAttributes(c2));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection c2, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c2, sqlTypeName);
    }

    public Datum toDatum(OracleConnection c2, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c2, sqlTypeName);
    }

    public Object getAttribute(int n2) throws SQLException {
        Object attribute;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableStruct.getAttribute (n = " + n2 + ")"));
        }
        if ((attribute = this.getLazyAttributes()[n2]) == null) {
            Datum d2 = this.getLazyDatums()[n2];
            if (this.old_factories == null) {
                this.attributes[n2] = attribute = Util.convertToObject(d2, this.sqlTypes[n2], this.factories[n2]);
                if (Util.isMutable(d2, this.factories[n2])) {
                    this.resetDatum(n2);
                }
            } else {
                this.attributes[n2] = attribute = Util.convertToObject(d2, this.sqlTypes[n2], this.old_factories[n2]);
                if (Util.isMutable(d2, this.old_factories[n2])) {
                    this.resetDatum(n2);
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableStruct.getAttribute:return attribute =" + attribute));
        }
        return attribute;
    }

    public Object getOracleAttribute(int n2) throws SQLException {
        Object o2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableStruct.getOracleAttribute (n = " + n2 + ")"));
        }
        if (this.old_factories == null) {
            if (this.factories[n2] == null) {
                o2 = this.getDatumAttribute(n2, null);
                Datum d2 = this.getLazyDatums()[n2];
                if (Util.isMutable(d2, this.factories[n2])) {
                    this.pickledCorrect = false;
                }
            } else {
                o2 = this.getAttribute(n2);
            }
        } else if (this.old_factories[n2] == null) {
            o2 = this.getDatumAttribute(n2, null);
            Datum d3 = this.getLazyDatums()[n2];
            if (Util.isMutable(d3, this.old_factories[n2])) {
                this.pickledCorrect = false;
            }
        } else {
            o2 = this.getAttribute(n2);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableStruct.getOracleAttribute:return object = " + o2));
        }
        return o2;
    }

    public Object[] getAttributes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)"MutableStruct.getAttributes ()");
        }
        int i2 = 0;
        while (i2 < this.length) {
            this.getAttribute(i2);
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableStruct.getAttributes:return attributes = " + this.attributes));
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)"MutableStruct.getOracleAttributes ()");
        }
        Object[] result = new Object[this.length];
        int i2 = 0;
        while (i2 < this.length) {
            result[i2] = this.getOracleAttribute(i2);
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct.getOracleAttributes:return result = " + result));
        }
        return result;
    }

    public void setAttribute(int n2, Object attribute) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct.setAttribute (n = " + n2 + ", attribute = " + attribute + ")"));
        }
        if (attribute == null) {
            this.getLazyDatums();
        }
        this.resetDatum(n2);
        this.getLazyAttributes()[n2] = attribute;
    }

    public void setDoubleAttribute(int n2, double attribute) throws SQLException {
        this.setAttribute(n2, new Double(attribute));
    }

    public void setFloatAttribute(int n2, float attribute) throws SQLException {
        this.setAttribute(n2, new Float(attribute));
    }

    public void setIntAttribute(int n2, int attribute) throws SQLException {
        this.setAttribute(n2, new Integer(attribute));
    }

    public void setOracleAttribute(int n2, Object attribute) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct.setOracleAttribute (n = " + n2 + ", attribute = " + attribute + ")"));
        }
        if (this.old_factories == null) {
            if (this.factories[n2] == null) {
                this.setDatumAttribute(n2, (Datum)attribute);
            } else {
                this.setAttribute(n2, attribute);
            }
        } else if (this.old_factories[n2] == null) {
            this.setDatumAttribute(n2, (Datum)attribute);
        } else {
            this.setAttribute(n2, attribute);
        }
    }

    Datum getDatumAttribute(int n2, Connection c2) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct.getDatumAttribute (n = " + n2 + ", connection  = " + c2 + ")"));
        }
        if ((datum = this.getLazyDatums()[n2]) == null) {
            Object a2 = this.getLazyAttributes()[n2];
            this.datums[n2] = datum = Util.convertToOracle(a2, c2);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct.getDatumAttribute:return " + datum));
        }
        return datum;
    }

    void setDatumAttribute(int n2, Datum datum) throws SQLException {
        this.resetAttribute(n2);
        this.getLazyDatums()[n2] = datum;
        this.pickledCorrect = false;
    }

    Datum[] getDatumAttributes(Connection c2) throws SQLException {
        int i2 = 0;
        while (i2 < this.length) {
            this.getDatumAttribute(i2, c2);
            ++i2;
        }
        return (Datum[])this.datums.clone();
    }

    void resetAttribute(int n2) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n2] = null;
        }
    }

    void resetDatum(int n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableStruct.resetDatum (n = " + n2 + ")"));
        }
        if (this.datums != null) {
            this.datums[n2] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Datum[] getLazyDatums() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)"MutableStruct.getLazyDatums ()");
        }
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    int x = 0;
                    while (x < this.length) {
                        if (this.attributes[x] != null) {
                            this.datums[x] = null;
                            this.pickledCorrect = false;
                        }
                        ++x;
                    }
                }
            } else {
                this.datums = new Datum[this.length];
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableStruct.getLazyDatums:return " + this.datums));
        }
        return this.datums;
    }
}

