/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jpub.runtime.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;

public class MutableArray {
    int length;
    Object[] elements;
    Datum[] datums;
    ARRAY pickled;
    boolean pickledCorrect;
    int sqlType;
    ORADataFactory factory;
    CustomDatumFactory old_factory;

    public MutableArray(int sqlType, ARRAY s2, ORADataFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (sqlType = " + sqlType + ", struct = " + s2 + ", factory = " + factory + ")"));
        }
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = s2;
        this.pickledCorrect = true;
        this.sqlType = sqlType;
        this.factory = factory;
    }

    public MutableArray(int sqlType, Datum[] d2, ORADataFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (sqlType =" + sqlType + ", datum = " + d2 + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.factory = factory;
        this.setDatumArray(d2);
    }

    public MutableArray(int sqlType, Object[] a2, ORADataFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (sqlType = " + sqlType + ", object = " + a2 + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.factory = factory;
        this.setObjectArray(a2);
    }

    public MutableArray(int sqlType, double[] a2, ORADataFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (sqlType = " + sqlType + ", double = " + a2 + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.factory = factory;
        this.setArray(a2);
    }

    public MutableArray(int sqlType, int[] a2, ORADataFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (sqlType = " + sqlType + ", int = " + a2 + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.factory = factory;
        this.setArray(a2);
    }

    public MutableArray(int sqlType, float[] a2, ORADataFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (sqlType = " + sqlType + ", float = " + a2 + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.factory = factory;
        this.setArray(a2);
    }

    public MutableArray(int sqlType, short[] a2, ORADataFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (sqlType = " + sqlType + ", short = " + a2 + ", factory =" + factory + ")"));
        }
        this.sqlType = sqlType;
        this.factory = factory;
        this.setArray(a2);
    }

    public MutableArray(ARRAY s2, int sqlType, CustomDatumFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (array = " + s2 + ", sqlType = " + sqlType + ", factory = " + factory + ")"));
        }
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = s2;
        this.pickledCorrect = true;
        this.sqlType = sqlType;
        this.old_factory = factory;
    }

    public MutableArray(Datum[] d2, int sqlType, CustomDatumFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (datum = " + d2 + ", sqlType = " + sqlType + ", factory =" + factory + ")"));
        }
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.setDatumArray(d2);
    }

    public MutableArray(Object[] a2, int sqlType, CustomDatumFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (object = " + a2 + ", sqlType = " + sqlType + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.setObjectArray(a2);
    }

    public MutableArray(double[] a2, int sqlType, CustomDatumFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (double = " + a2 + ", sqlType = " + sqlType + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.setArray(a2);
    }

    public MutableArray(int[] a2, int sqlType, CustomDatumFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (int = " + a2 + ", sqlType = " + sqlType + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.setArray(a2);
    }

    public MutableArray(float[] a2, int sqlType, CustomDatumFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (float = " + a2 + ", sqlType = " + sqlType + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.setArray(a2);
    }

    public MutableArray(short[] a2, int sqlType, CustomDatumFactory factory) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray (short = " + a2 + ", sqlType =" + sqlType + ", factory = " + factory + ")"));
        }
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.setArray(a2);
    }

    public Datum toDatum(Connection c2, String sqlTypeName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray.toDatum( connection = " + c2 + ")"));
        }
        if (!this.pickledCorrect) {
            this.pickled = new ARRAY(ArrayDescriptor.createDescriptor(sqlTypeName, c2), c2, this.getDatumArray(c2));
            this.pickledCorrect = true;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray.toDatum:return " + this.pickled));
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection c2, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c2, sqlTypeName);
    }

    public Datum toDatum(OracleConnection c2, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c2, sqlTypeName);
    }

    public Object[] getOracleArray() throws SQLException {
        return this.getOracleArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getOracleArray(long index, int count) throws SQLException {
        Object[] a2;
        int sliceLen;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray.getOracleArray (index = " + index + ", count = " + count + ")"));
        }
        if ((sliceLen = this.sliceLength(index, count)) < 0) {
            return null;
        }
        switch (this.sqlType) {
            case -13: {
                a2 = new BFILE[sliceLen];
                break;
            }
            case 2004: {
                a2 = new BLOB[sliceLen];
                break;
            }
            case 1: 
            case 12: {
                a2 = new CHAR[sliceLen];
                break;
            }
            case 2005: {
                a2 = new CLOB[sliceLen];
                break;
            }
            case 91: {
                a2 = new DATE[sliceLen];
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                a2 = new NUMBER[sliceLen];
                break;
            }
            case -2: {
                a2 = new RAW[sliceLen];
                break;
            }
            case 0: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: {
                if (this.old_factory == null) {
                    a2 = new ORAData[sliceLen];
                    break;
                }
                a2 = new CustomDatum[sliceLen];
                break;
            }
            default: {
                throw new SQLException("Unexpected OracleTypes type code: " + this.sqlType);
            }
        }
        return this.getOracleArray(index, a2);
    }

    public Object[] getOracleArray(long index, Object[] a2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray.getOracleArray (index = " + index + ", object = " + a2 + ")"));
        }
        if (a2 == null) {
            return null;
        }
        int sliceLen = this.sliceLength(index, a2.length);
        int idx = (int)index;
        if (sliceLen != a2.length) {
            return null;
        }
        if (this.sqlType == 2002 || this.sqlType == 2007 || this.sqlType == 2003 || this.sqlType == 2006 || this.sqlType == 0) {
            if (this.old_factory == null) {
                int i2 = 0;
                while (i2 < sliceLen) {
                    a2[i2] = this.factory.create(this.getDatumElement(idx++, null), this.sqlType);
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < sliceLen) {
                    a2[i3] = this.old_factory.create(this.getDatumElement(idx++, null), this.sqlType);
                    ++i3;
                }
            }
        } else {
            int i4 = 0;
            while (i4 < sliceLen) {
                a2[i4] = this.getDatumElement(idx++, null);
                ++i4;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)32, (String)("MutableArray.getOracleArray:return " + a2));
        }
        return a2;
    }

    public Object[] getOracleArray(Object[] a2) throws SQLException {
        return this.getOracleArray(0L, a2);
    }

    public Object[] getObjectArray() throws SQLException {
        return this.getObjectArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getObjectArray(long index, int count) throws SQLException {
        Object[] a2;
        int sliceLen = this.sliceLength(index, count);
        if (sliceLen < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 1: 
            case 12: {
                a2 = new String[sliceLen];
                break;
            }
            case 91: {
                a2 = new Timestamp[sliceLen];
                break;
            }
            case 2: 
            case 3: {
                a2 = new BigDecimal[sliceLen];
                break;
            }
            case 6: 
            case 8: {
                a2 = new Double[sliceLen];
                break;
            }
            case 4: 
            case 5: {
                a2 = new Integer[sliceLen];
                break;
            }
            case 7: {
                a2 = new Float[sliceLen];
                break;
            }
            case -2: {
                a2 = (Object[])new byte[sliceLen][];
                break;
            }
            default: {
                return this.getOracleArray(index, count);
            }
        }
        return this.getObjectArray(index, a2);
    }

    public Object[] getObjectArray(long index, Object[] a2) throws SQLException {
        if (a2 == null) {
            return null;
        }
        int sliceLen = this.sliceLength(index, a2.length);
        int idx = (int)index;
        if (sliceLen != a2.length) {
            return null;
        }
        if (this.sqlType == 1 || this.sqlType == 12 || this.sqlType == 91 || this.sqlType == 3 || this.sqlType == 2 || this.sqlType == 8 || this.sqlType == 6 || this.sqlType == 4 || this.sqlType == 5 || this.sqlType == 7 || this.sqlType == -2) {
            int i2 = 0;
            while (i2 < sliceLen) {
                a2[i2] = this.getObjectElement(idx++);
                ++i2;
            }
            return a2;
        }
        return this.getOracleArray(index, a2);
    }

    public Object[] getObjectArray(Object[] a2) throws SQLException {
        return this.getObjectArray(0L, a2);
    }

    public Object getArray() throws SQLException {
        return this.getArray(0L, Integer.MAX_VALUE);
    }

    public Object getArray(long index, int count) throws SQLException {
        int sliceLen = this.sliceLength(index, count);
        int idx = (int)index;
        if (sliceLen < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 6: 
            case 8: {
                double[] a2 = new double[sliceLen];
                int i2 = 0;
                while (i2 < sliceLen) {
                    a2[i2] = (Double)this.getObjectElement(idx++);
                    ++i2;
                }
                return a2;
            }
            case 4: {
                int[] a3 = new int[sliceLen];
                int i3 = 0;
                while (i3 < sliceLen) {
                    a3[i3] = (Integer)this.getObjectElement(idx++);
                    ++i3;
                }
                return a3;
            }
            case 5: {
                short[] a4 = new short[sliceLen];
                int i4 = 0;
                while (i4 < sliceLen) {
                    a4[i4] = (short)((Integer)this.getObjectElement(idx++)).intValue();
                    ++i4;
                }
                return a4;
            }
            case 7: {
                float[] a5 = new float[sliceLen];
                int i5 = 0;
                while (i5 < sliceLen) {
                    a5[i5] = ((Float)this.getObjectElement(idx++)).floatValue();
                    ++i5;
                }
                return a5;
            }
        }
        return this.getObjectArray(index, count);
    }

    public void setOracleArray(Object[] a2) {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])a2);
        } else {
            this.setObjectArray(a2);
        }
    }

    public void setOracleArray(Object[] a2, long index) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])a2, index);
        } else {
            this.setObjectArray(a2, index);
        }
    }

    public void setObjectArray(Object[] a2) {
        if (a2 == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a2.length);
            this.elements = new Object[this.length];
            int i2 = 0;
            while (i2 < this.length) {
                this.elements[i2] = a2[i2];
                ++i2;
            }
        }
    }

    public void setObjectArray(Object[] a2, long index) throws SQLException {
        if (a2 == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a2.length);
        int idx = (int)index;
        int i2 = 0;
        while (i2 < sliceLen) {
            this.setObjectElement(a2[i2], idx++);
            ++i2;
        }
    }

    public void setArray(double[] a2) {
        if (a2 == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a2.length);
            this.elements = new Object[this.length];
            int i2 = 0;
            while (i2 < this.length) {
                this.elements[i2] = new Double(a2[i2]);
                ++i2;
            }
        }
    }

    public void setArray(double[] a2, long index) throws SQLException {
        if (a2 == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a2.length);
        int idx = (int)index;
        int i2 = 0;
        while (i2 < sliceLen) {
            this.setObjectElement(new Double(a2[i2]), idx++);
            ++i2;
        }
    }

    public void setArray(int[] a2) {
        if (a2 == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a2.length);
            this.elements = new Object[this.length];
            int i2 = 0;
            while (i2 < this.length) {
                this.elements[i2] = new Integer(a2[i2]);
                ++i2;
            }
        }
    }

    public void setArray(int[] a2, long index) throws SQLException {
        if (a2 == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a2.length);
        int idx = (int)index;
        int i2 = 0;
        while (i2 < sliceLen) {
            this.setObjectElement(new Integer(a2[i2]), idx++);
            ++i2;
        }
    }

    public void setArray(float[] a2) {
        if (a2 == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a2.length);
            this.elements = new Object[this.length];
            int i2 = 0;
            while (i2 < this.length) {
                this.elements[i2] = new Float(a2[i2]);
                ++i2;
            }
        }
    }

    public void setArray(float[] a2, long index) throws SQLException {
        if (a2 == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a2.length);
        int idx = (int)index;
        int i2 = 0;
        while (i2 < sliceLen) {
            this.setObjectElement(new Float(a2[i2]), idx++);
            ++i2;
        }
    }

    public void setArray(short[] a2) {
        if (a2 == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a2.length);
            this.elements = new Object[this.length];
            int i2 = 0;
            while (i2 < this.length) {
                this.elements[i2] = new Integer(a2[i2]);
                ++i2;
            }
        }
    }

    public void setArray(short[] a2, long index) throws SQLException {
        if (a2 == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a2.length);
        int idx = (int)index;
        int i2 = 0;
        while (i2 < sliceLen) {
            this.setObjectElement(new Integer(a2[i2]), idx++);
            ++i2;
        }
    }

    public Object getObjectElement(long n2) throws SQLException {
        Object element = this.getLazyArray()[(int)n2];
        if (element == null) {
            if (this.old_factory == null) {
                Datum d2 = this.getLazyOracleArray()[(int)n2];
                this.elements[(int)n2] = element = Util.convertToObject(d2, this.sqlType, this.factory);
                if (Util.isMutable(d2, this.factory)) {
                    this.resetOracleElement(n2);
                }
            } else {
                Datum d3 = this.getLazyOracleArray()[(int)n2];
                this.elements[(int)n2] = element = Util.convertToObject(d3, this.sqlType, this.old_factory);
                if (Util.isMutable(d3, this.old_factory)) {
                    this.resetOracleElement(n2);
                }
            }
        }
        return element;
    }

    public Object getOracleElement(long n2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            Datum d2 = this.getDatumElement(n2, null);
            if (Util.isMutable(d2, this.factory)) {
                this.pickledCorrect = false;
            }
            return d2;
        }
        return this.getObjectElement(n2);
    }

    public void setObjectElement(Object element, long n2) throws SQLException {
        OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableArray.setObjectElement( element = " + element + ",  n = " + n2 + ")"));
        if (element == null) {
            this.getLazyOracleArray();
        }
        this.resetOracleElement(n2);
        this.getLazyArray()[(int)n2] = element;
    }

    public void setOracleElement(Object o2, long n2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumElement((Datum)o2, n2);
        } else {
            this.setObjectElement(o2, n2);
        }
    }

    public String getBaseTypeName() throws SQLException {
        return this.pickled.getBaseTypeName();
    }

    public int getBaseType() throws SQLException {
        return this.pickled.getBaseType();
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.pickled.getDescriptor();
    }

    Datum[] getDatumArray(Connection c2) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (this.datums == null) {
            return null;
        }
        Datum[] result = new Datum[this.length];
        int i2 = 0;
        while (i2 < this.length) {
            result[i2] = this.getDatumElement(i2, c2);
            ++i2;
        }
        return result;
    }

    void setDatumArray(Datum[] d2) {
        if (d2 == null) {
            this.setNullArray();
        } else {
            this.length = d2.length;
            this.elements = null;
            this.datums = (Datum[])d2.clone();
            this.pickled = null;
            this.pickledCorrect = false;
        }
    }

    void setDatumArray(Datum[] d2, long index) throws SQLException {
        if (d2 == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, d2.length);
        int idx = (int)index;
        int i2 = 0;
        while (i2 < sliceLen) {
            this.setDatumElement(d2[i2], idx++);
            ++i2;
        }
    }

    Datum getDatumElement(long n2, Connection c2) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableArray.getDatumElement( n = " + n2 + ", connection = " + c2 + ")"));
        }
        if ((datum = this.getLazyOracleArray()[(int)n2]) == null) {
            Object a2 = this.getLazyArray()[(int)n2];
            this.datums[(int)n2] = datum = Util.convertToOracle(a2, c2);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableArray.getDatumElement:return " + datum));
        }
        return datum;
    }

    void setDatumElement(Datum datum, long n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableArray.setDatumElement( datum = " + datum + ", n = " + n2 + ")"));
        }
        this.resetElement(n2);
        this.getLazyOracleArray()[(int)n2] = datum;
        this.pickledCorrect = false;
    }

    void resetElement(long n2) throws SQLException {
        if (this.elements != null) {
            this.elements[(int)n2] = null;
        }
    }

    void setNullArray() {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = null;
        this.pickledCorrect = false;
    }

    void setArrayGeneric(int length) {
        this.length = length;
        this.datums = new Datum[length];
        this.pickled = null;
        this.pickledCorrect = false;
    }

    public int length() throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        return this.length;
    }

    public int sliceLength(long index, int reqLength) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (index < 0L) {
            return (int)index;
        }
        return Math.min(this.length - (int)index, reqLength);
    }

    void resetOracleElement(long n2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableArray.resetOracleElement( n = " + n2 + ")"));
        }
        if (this.datums != null) {
            this.datums[(int)n2] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyArray() throws SQLException {
        if (this.length == -1) {
            this.getLazyOracleArray();
        }
        if (this.elements == null) {
            this.elements = new Object[this.length];
        }
        return this.elements;
    }

    Datum[] getLazyOracleArray() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)"MutableArray.getLazyOracleArray()");
        }
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleArray();
                this.length = this.datums.length;
                this.pickledCorrect = true;
                if (this.elements != null) {
                    int x = 0;
                    while (x < this.length) {
                        if (this.elements[x] != null) {
                            this.datums[x] = null;
                            this.pickledCorrect = false;
                        }
                        ++x;
                    }
                }
            } else if (this.length >= 0) {
                this.datums = new Datum[this.length];
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2048, (int)2, (int)64, (String)("MutableArray.getLazyOracleArray:return " + this.datums));
        }
        return this.datums;
    }
}

