/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";

    public OracleXAResource() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"oracle.jdbc.xa.client.OracleXAResource()");
        }
    }

    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        super(pm_conn, xaconn);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("oracle.jdbc.xa.client.OracleXAResource(pm_conn = " + pm_conn + ", " + xaconn + ")"));
        }
        try {
            this.m_version = ((OracleConnection)pm_conn).getVersionNumber();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.m_version < 8160) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)4, (String)"OracleXAResource(pm_conn): Java XA not supported for this server version");
            }
            throw new XAException(-6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void start(Xid xid, int flag) throws XAException {
        int returnVal;
        block28: {
            Statement cstmt;
            block26: {
                returnVal = -1;
                cstmt = null;
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.start(xid = " + xid + ", flag = " + flag + ")"));
                }
                this.disallowLocalTxnMode(-6);
                if (xid == null) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.start(): XAER_INVAL: xid is null");
                    }
                    throw new XAException(-5);
                }
                int isolFlag = flag & 0xFF00;
                int otherFlag = (flag &= 0xFFFF00FF) & 0x10000;
                if ((flag &= 0xFFFEFFFF) != 0 && flag != 0x8000000 && flag != 0x200000 && flag != 2 || otherFlag != 0 && (otherFlag & 0x10000) != 65536) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.start(): XAER_INVAL: invalid flag");
                    }
                    throw new XAException(-5);
                }
                if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.start(): XAER_INVAL: invalid Isolation flag");
                    }
                    throw new XAException(-5);
                }
                if ((flag & 0x8200000) != 0 && ((isolFlag & 0xFF00) != 0 || (otherFlag & 0x10000) != 0)) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME");
                    }
                    throw new XAException(-5);
                }
                flag |= isolFlag | otherFlag;
                this.saveAndAlterAutoCommitModeForGlobalTransaction();
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        if (OracleLog.TRACE) {
                            OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.start(): XAER_PROTO: should use OracleXid for 8.1.6 database");
                        }
                        throw new XAException(-6);
                    }
                    cstmt = this.m_conn.prepareCall(xa_start_816);
                    cstmt.registerOutParameter(1, -2);
                    byte[] raw_bytes = OracleXAResource.getSerializedBytes(xid);
                    cstmt.setBytes(2, raw_bytes);
                    cstmt.setInt(3, this.m_timeout);
                    cstmt.setInt(4, flag);
                    cstmt.registerOutParameter(5, 2);
                    cstmt.execute();
                    byte[] txnctx = cstmt.getBytes(1);
                    ((OracleXid)xid).setTxContext(txnctx);
                    returnVal = cstmt.getInt(5);
                    break block26;
                }
                cstmt = this.m_conn.prepareCall(xa_start_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, this.m_timeout);
                cstmt.setInt(6, flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            Object var10_10 = null;
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException s2) {
                // empty catch block
            }
            cstmt = null;
            {
                break block28;
                catch (SQLException s3) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                    returnVal = s3.getErrorCode();
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.start() returnVal=" + returnVal), (Exception)s3);
                    }
                    if (returnVal == 0) {
                        throw new XAException(-6);
                    }
                    Object var10_11 = null;
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException s2) {
                        // empty catch block
                    }
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s2) {
                    // empty catch block
                }
                cstmt = null;
                throw throwable;
            }
        }
        this.checkError(returnVal);
        super.push(xid);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.start(): return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void end(Xid xid, int flag) throws XAException {
        int returnVal;
        block24: {
            returnVal = -1;
            Statement cstmt = null;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.end(xid = " + xid + ", flag = " + flag + ")"));
            }
            if (xid == null) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.end(): XAER_INVAL: xid is null");
                }
                throw new XAException(-5);
            }
            if (flag != 0x2000000 && flag != 0x4000000 && flag != 0x20000000 && (flag & 2) != 2) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.end(): XAER_INVAL: invalid flag");
                }
                throw new XAException(-5);
            }
            Xid stackedXid = super.suspendStacked(xid, flag);
            super.pop();
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.end(): XAER_PROTO: should use OracleXid for 8.1.6 database");
                    }
                    throw new XAException(-6);
                }
                cstmt = this.m_conn.prepareCall(xa_end_816);
                cstmt.registerOutParameter(1, 2);
                byte[] raw_bytes = OracleXAResource.getSerializedBytes(xid);
                cstmt.setBytes(2, raw_bytes);
                cstmt.setInt(3, flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            } else {
                cstmt = this.m_conn.prepareCall(xa_end_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            super.resumeStacked(stackedXid);
            Object var8_8 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException s2) {
                // empty catch block
            }
            cstmt = null;
            {
                break block24;
                catch (SQLException s3) {
                    returnVal = s3.getErrorCode();
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.end() returnVal=" + returnVal), (Exception)s3);
                    }
                    if (returnVal == 0) {
                        throw new XAException(-6);
                    }
                    Object var8_9 = null;
                    this.restoreAutoCommitModeForGlobalTransaction();
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException s2) {
                        // empty catch block
                    }
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.restoreAutoCommitModeForGlobalTransaction();
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s2) {
                    // empty catch block
                }
                cstmt = null;
                throw throwable;
            }
        }
        this.checkError(returnVal);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.end(): return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block28: {
            returnVal = -1;
            stateout = 0;
            cstmt = null;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.commit(xid = " + xid + ", onePhase = " + onePhase + ")"));
            }
            if (xid == null) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.commit(): XAER_INVAL: xid is null");
                }
                throw new XAException(-5);
            }
            cPhase = onePhase != false ? 1 : 0;
            stackedXid = super.suspendStacked(xid);
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.commit(): XAER_PROTO: should use OracleXid for 8.1.6 database");
                    }
                    throw new XAException(-6);
                }
                cstmt = this.m_conn.prepareCall(OracleXAResource.xa_commit_816);
                cstmt.registerOutParameter(1, 2);
                raw_bytes = OracleXAResource.getSerializedBytes(xid);
                cstmt.setBytes(2, raw_bytes);
                cstmt.setInt(3, cPhase);
                cstmt.registerOutParameter(4, 2);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
                stateout = cstmt.getInt(4);
                ((OracleXid)xid).setState(stateout);
                if (returnVal == 24780) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.commit() returnVal=" + returnVal + ", retrying"));
                    }
                    xaConnection = null;
                    xaDataSource = null;
                    try {
                        prop = this.getConnectionProperties();
                        xaDataSource = new OracleXADataSource();
                        xaDataSource.setURL((String)prop.get("connection_url"));
                        xaDataSource.setUser((String)prop.get("user"));
                        xaDataSource.setPassword((String)prop.get("password"));
                        xaConnection = xaDataSource.getXAConnection();
                        oxar = xaConnection.getXAResource();
                        oxar.commit(xid, cPhase == 1);
                        var14_14 = null;
                        ** if (xaConnection == null) goto lbl-1000
                    }
                    catch (Throwable var13_16) {
                        var14_15 = null;
                        if (xaConnection != null) {
                            xaConnection.close();
                        }
                        throw var13_16;
                    }
lbl-1000:
                    // 1 sources

                    {
                        xaConnection.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    returnVal = 0;
                }
            } else {
                cstmt = this.m_conn.prepareCall(OracleXAResource.xa_commit_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.setInt(5, cPhase);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            super.resumeStacked(stackedXid);
            var16_17 = null;
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException s) {
                // empty catch block
            }
            cstmt = null;
            {
                break block28;
                catch (SQLException s) {
                    returnVal = s.getErrorCode();
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.commit() returnVal=" + returnVal), (Exception)s);
                    }
                    if (returnVal == 0) {
                        throw new XAException(-6);
                    }
                    var16_18 = null;
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException s) {
                        // empty catch block
                    }
                    cstmt = null;
                }
            }
            catch (Throwable var15_23) {
                var16_19 = null;
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s) {
                    // empty catch block
                }
                cstmt = null;
                throw var15_23;
            }
        }
        this.checkError(returnVal);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.commit(): return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int prepare(Xid xid) throws XAException {
        int x_e;
        int returnVal;
        block23: {
            returnVal = 0;
            int stateout = 0;
            Statement cstmt = null;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.prepare(xid = " + xid + ")"));
            }
            if (xid == null) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.prepare(): XAER_INVAL: xid is null");
                }
                throw new XAException(-5);
            }
            Xid stackedXid = super.suspendStacked(xid);
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.prepare(): XAER_PROTO: should use OracleXid for 8.1.6 database");
                    }
                    throw new XAException(-6);
                }
                cstmt = this.m_conn.prepareCall(xa_prepare_816);
                cstmt.registerOutParameter(1, 2);
                byte[] raw_bytes = OracleXAResource.getSerializedBytes(xid);
                cstmt.setBytes(2, raw_bytes);
                cstmt.registerOutParameter(3, 2);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
                stateout = cstmt.getInt(3);
                ((OracleXid)xid).setState(stateout);
            } else {
                cstmt = this.m_conn.prepareCall(xa_prepare_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            super.resumeStacked(stackedXid);
            Object var8_9 = null;
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException s2) {
                // empty catch block
            }
            cstmt = null;
            {
                break block23;
                catch (SQLException s3) {
                    returnVal = s3.getErrorCode();
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.prepare() returnVal=" + returnVal), (Exception)s3);
                    }
                    if (returnVal == 0) {
                        throw new XAException(-6);
                    }
                    Object var8_10 = null;
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException s2) {
                        // empty catch block
                    }
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s2) {
                    // empty catch block
                }
                cstmt = null;
                throw throwable;
            }
        }
        int n2 = x_e = returnVal == 0 ? 0 : OracleXAException.errorConvert(returnVal);
        if (x_e != 0 && x_e != 3) {
            throw new OracleXAException(returnVal);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.prepare(): return: " + x_e));
        }
        return x_e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void forget(Xid xid) throws XAException {
        int returnVal;
        block22: {
            Statement cstmt;
            block20: {
                returnVal = 0;
                int stateout = 0;
                cstmt = null;
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.forget(xid = " + xid + ")"));
                }
                if (xid == null) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.forget(): XAER_INVAL: xid is null");
                    }
                    throw new XAException(-5);
                }
                this.saveTxnMode();
                if (this.m_version == 8160) {
                    if (!(xid instanceof OracleXid)) {
                        if (OracleLog.TRACE) {
                            OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.forget(): XAER_PROTO: should use OracleXid for 8.1.6 database");
                        }
                        throw new XAException(-6);
                    }
                    cstmt = this.m_conn.prepareCall(" begin ? := JAVA_XA.xa_forget (?,?); end; ");
                    cstmt.registerOutParameter(1, 2);
                    byte[] raw_bytes = OracleXAResource.getSerializedBytes(xid);
                    cstmt.setBytes(2, raw_bytes);
                    cstmt.registerOutParameter(3, 2);
                    cstmt.execute();
                    returnVal = cstmt.getInt(1);
                    stateout = cstmt.getInt(3);
                    ((OracleXid)xid).setState(stateout);
                    break block20;
                }
                cstmt = this.m_conn.prepareCall(xa_forget_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            Object var7_7 = null;
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException s2) {
                // empty catch block
            }
            cstmt = null;
            this.restoreTxnMode();
            {
                break block22;
                catch (SQLException s3) {
                    returnVal = s3.getErrorCode();
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.forget() returnVal=" + returnVal), (Exception)s3);
                    }
                    if (returnVal == 0) {
                        throw new XAException(-6);
                    }
                    Object var7_8 = null;
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException s2) {
                        // empty catch block
                    }
                    cstmt = null;
                    this.restoreTxnMode();
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s2) {
                    // empty catch block
                }
                cstmt = null;
                this.restoreTxnMode();
                throw throwable;
            }
        }
        this.checkError(returnVal);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.forget(): return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void rollback(Xid xid) throws XAException {
        block28: {
            returnVal = 0;
            stateout = 0;
            cstmt = null;
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.rollback(xid = " + xid + ")"));
            }
            if (xid == null) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.rollback(): XAER_INVAL: xid is null");
                }
                throw new XAException(-5);
            }
            stackedXid = super.suspendStacked(xid);
            if (this.m_version == 8160) {
                if (!(xid instanceof OracleXid)) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.rollback(): XAER_PROTO: should use OracleXid for 8.1.6 database");
                    }
                    throw new XAException(-6);
                }
                cstmt = this.m_conn.prepareCall(OracleXAResource.xa_rollback_816);
                cstmt.registerOutParameter(1, 2);
                raw_bytes = OracleXAResource.getSerializedBytes(xid);
                cstmt.setBytes(2, raw_bytes);
                cstmt.registerOutParameter(3, 2);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
                stateout = cstmt.getInt(3);
                ((OracleXid)xid).setState(stateout);
                if (returnVal == 24780) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.rollback() returnVal=" + returnVal + ", retrying"));
                    }
                    xaConnection = null;
                    xaDataSource = null;
                    try {
                        prop = this.getConnectionProperties();
                        xaDataSource = new OracleXADataSource();
                        xaDataSource.setURL((String)prop.get("connection_url"));
                        xaDataSource.setUser((String)prop.get("user"));
                        xaDataSource.setPassword((String)prop.get("password"));
                        xaConnection = xaDataSource.getXAConnection();
                        oxar = xaConnection.getXAResource();
                        oxar.rollback(xid);
                        var12_12 = null;
                        ** if (xaConnection == null) goto lbl-1000
                    }
                    catch (Throwable var11_14) {
                        var12_13 = null;
                        if (xaConnection != null) {
                            xaConnection.close();
                        }
                        throw var11_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        xaConnection.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    returnVal = 0;
                }
            } else {
                cstmt = this.m_conn.prepareCall(OracleXAResource.xa_rollback_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid.getFormatId());
                cstmt.setBytes(3, xid.getGlobalTransactionId());
                cstmt.setBytes(4, xid.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            super.resumeStacked(stackedXid);
            var14_15 = null;
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException s) {
                // empty catch block
            }
            cstmt = null;
            {
                break block28;
                catch (SQLException s) {
                    returnVal = s.getErrorCode();
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)256, (int)8, (int)32, (String)("OracleXAResource.rollback() returnVal=" + returnVal), (Exception)s);
                    }
                    if (returnVal == 0) {
                        throw new XAException(-6);
                    }
                    var14_16 = null;
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException s) {
                        // empty catch block
                    }
                    cstmt = null;
                }
            }
            catch (Throwable var13_21) {
                var14_17 = null;
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException s) {
                    // empty catch block
                }
                cstmt = null;
                throw var13_21;
            }
        }
        this.checkError(returnVal);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.rollback(): return");
        }
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException ioe) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)256, (int)8, (int)32, (String)"OracleXAResource.getSerializedBytes()", (Exception)ioe);
            }
            return null;
        }
    }
}

