/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int m_rmid = -1;

    public OracleXAHeteroResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)("oracle.jdbc.xa.client.OracleXAHeteroResource(pm_conn = " + pm_conn + ", xaconn = " + xaconn + ")"));
        }
        this.m_conn = pm_conn;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
        this.xaconnection = xaconn;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)1, (String)("OracleXAHeteroResource.start(xid = " + xid + ", flags = " + flags + ")"));
        }
        this.disallowLocalTxnMode(-6);
        if (xid == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.start(): XAER_INVAL: xid is null");
            }
            throw new XAException(-5);
        }
        int isolFlag = flags & 0xFF00;
        if ((flags &= 0xFFFF00FF) != 0 && flags != 0x8000000 && flags != 0x200000 && (flags & 2) != 2) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.start(): XAER_INVAL: invalid flag");
            }
            throw new XAException(-5);
        }
        if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAHeteroResource.start():XAER_INVAL: invalid Isolation flag");
            }
            throw new XAException(-5);
        }
        if ((isolFlag & 0xFF00) != 0 && (flags & 0x8200000) != 0) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAHeteroResource.start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME");
            }
            throw new XAException(-5);
        }
        flags |= isolFlag;
        try {
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            int status = this.do_xa_start(formatId, gTrid, bQual, this.m_rmid, flags, 0);
            this.checkStatus(status);
            super.push(xid);
        }
        catch (XAException ea) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw ea;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)"OracleXAHeteroResource.start() return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flag) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)1, (String)("OracleXAHeteroResource.end(xid = " + xid + ", flag = " + flag + ")"));
        }
        try {
            if (xid == null) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.end(): XAER_INVAL: xid is null");
                }
                throw new XAException(-5);
            }
            if (flag != 0x2000000 && flag != 0x4000000 && flag != 0x20000000 && (flag & 2) != 2) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.end(): XAER_INVAL: invalid flag");
                }
                throw new XAException(-5);
            }
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            Xid stackedXid = super.suspendStacked(xid, flag);
            super.pop();
            int status = this.do_xa_end(formatId, gTrid, bQual, this.m_rmid, flag, 0);
            super.resumeStacked(stackedXid);
            this.checkStatus(status);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.restoreAutoCommitModeForGlobalTransaction();
            throw throwable;
        }
        this.restoreAutoCommitModeForGlobalTransaction();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)"OracleXAHeteroResource.end() return");
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)1, (String)("OracleXAHeteroResource.commit(xid = " + xid + ", onePhase = " + onePhase + ")"));
        }
        if (xid == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.commit(): XAER_INVAL: xid is null");
            }
            throw new XAException(-5);
        }
        int flags = onePhase ? 0x40000000 : 0;
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        Xid stackedXid = super.suspendStacked(xid);
        int status = this.do_xa_commit(formatId, gTrid, bQual, this.m_rmid, flags, 0);
        super.resumeStacked(stackedXid);
        this.checkStatus(status);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)"OracleXAHeteroResource.commit() return");
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)1, (String)("OracleXAHeteroResource.prepare(xid = " + xid + ")"));
        }
        if (xid == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.prepare(): XAER_INVAL: xid is null");
            }
            throw new XAException(-5);
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        Xid stackedXid = super.suspendStacked(xid);
        int status = this.do_xa_prepare(formatId, gTrid, bQual, this.m_rmid, 0, 0);
        super.resumeStacked(stackedXid);
        if (status != 0 && status != 3) {
            this.checkStatus(status);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)("OracleXAHeteroResource.prepare() return: " + status));
        }
        return status;
    }

    public void forget(Xid xid) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)1, (String)("OracleXAHeteroResource.forget(xid = " + xid + ")"));
        }
        if (xid == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.forget(): XAER_INVAL: xid is null");
            }
            throw new XAException(-5);
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        int status = this.do_xa_forget(formatId, gTrid, bQual, this.m_rmid, 0, 0);
        this.checkStatus(status);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)"OracleXAHeteroResource.forget() return");
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)1, (String)("OracleXAHeteroResource.rollback(xid = " + xid + ")"));
        }
        if (xid == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)512, (int)2, (String)"OracleXAHeteroResource.rollback(): XAER_INVAL: xid is null");
            }
            throw new XAException(-5);
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        Xid stackedXid = super.suspendStacked(xid);
        int status = this.do_xa_rollback(formatId, gTrid, bQual, this.m_rmid, 0, 0);
        super.resumeStacked(stackedXid);
        this.checkStatus(status);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)"OracleXAHeteroResource.rollback() return");
        }
    }

    private native int do_xa_start(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_end(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_commit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_prepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_forget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int do_xa_rollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    synchronized void setRmid(int rmid) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)("OracleXAHeteroResource.setRmid(rmid = " + rmid + ")"));
        }
        this.m_rmid = rmid;
    }

    synchronized int getRmid() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)512, (int)16, (String)("OracleXAHeteroResource.getRmid() return: " + this.m_rmid));
        }
        return this.m_rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private void checkStatus(int status) throws XAException {
        if (status != 0) {
            throw new XAException(status);
        }
    }
}

