/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXAHeteroCloseCallback
implements OracleCloseCallback {
    public synchronized void beforeClose(OracleConnection conn, Object obj) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)256, (int)16, (String)("OracleXAHeteroCloseCallback.beforeClose(conn = " + conn + ", obj = " + obj + ")"));
        }
    }

    public synchronized void afterClose(Object privData) {
        block5: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)256, (int)16, (String)("OracleXAHeteroCloseCallback.afterClose(privData = " + privData + ")"));
            }
            int rmid = ((OracleXAHeteroConnection)privData).getRmid();
            String xaCloseString = ((OracleXAHeteroConnection)privData).getXaCloseString();
            try {
                int status = this.do_xa_close(xaCloseString, rmid, 0, 0);
                if (status != 0) {
                    DBError.throwSqlException((int)(-1 * status));
                }
            }
            catch (SQLException sqlexc) {
                if (!OracleLog.TRACE) break block5;
                OracleLog.print((Object)this, (int)256, (int)256, (int)4, (String)("OracleXAHeteroCloseCallback.afterClose(): SQLException: " + sqlexc.getMessage()));
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)256, (int)16, (String)"OracleXAHeteroCloseCallback.afterClose() return");
        }
    }

    private native int do_xa_close(String var1, int var2, int var3, int var4);
}

