/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int m_rmid = -1;
    private String m_xaOpenString = null;
    private static boolean s_libraryLoaded;
    private static final String s_dbSuffix = "HeteroXA";
    private static final String s_dllName = "heteroxa9";
    private static final char at_sign_char = '@';
    private static int s_rmidSeed;
    private static final int MAX_RMID_SEED = 65536;

    public OracleXADataSource() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)"oracle.jdbc.xa.client.OracleXADataSource() -- after super()");
        }
    }

    public XAConnection getXAConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)2, (int)1, (String)"OracleXADataSource.getXAConnection()");
        }
        return this.getXAConnection(this.m_user, this.m_password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(String user, String passwd) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)2, (int)1, (String)("OracleXADataSource.getXAConnection(user = " + user + ", passwd = " + passwd + ")"));
        }
        try {
            String url = this.getURL();
            if (this.m_nativeXA && (url.startsWith("jdbc:oracle:oci8") || url.startsWith("jdbc:oracle:oci"))) {
                long[] ociHandles = new long[]{0L, 0L};
                Properties info = new Properties();
                String tnsentry = null;
                tnsentry = this.m_tnsentry != null ? this.m_tnsentry : this.getTNSEntryFromUrl(url);
                if (tnsentry.startsWith("(DESCRIPTION") && this.m_tnsentry == null) {
                    DBError.throwSqlException((int)207);
                }
                if (!s_libraryLoaded) {
                    Class<?> clazz = this.getClass();
                    synchronized (clazz) {
                        if (!s_libraryLoaded) {
                            try {
                                System.loadLibrary(s_dllName);
                                s_libraryLoaded = true;
                            }
                            catch (Error exc) {
                                if (OracleLog.TRACE) {
                                    OracleLog.print((Object)this, (int)256, (int)2, (int)4, (String)"------ JNI JDBC XA lib not loaded properly. ------");
                                }
                                s_libraryLoaded = false;
                                throw exc;
                            }
                        }
                    }
                }
                String rmName = this.m_databaseName + s_dbSuffix + s_rmidSeed;
                this.m_rmid = s_rmidSeed;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    s_rmidSeed = (s_rmidSeed + 1) % 65536;
                }
                int trcLevel = 0;
                if (OracleLog.TRACE) {
                    trcLevel = 7;
                    OracleLog.print((Object)this, (int)256, (int)2, (int)32, (String)("getXAConnection(user, pwd): trcLevel = " + trcLevel));
                }
                this.m_xaOpenString = this.generateXAOpenString(rmName, tnsentry, this.m_user, this.m_password, 60, 2000, true, false, ".", trcLevel, false);
                String xaclsstr = this.generateXACloseString(rmName, false);
                int status = this.do_xa_open(this.m_xaOpenString, this.m_rmid, 0, 0);
                if (status != 0) {
                    DBError.throwSqlException((int)(-1 * status));
                }
                if ((status = this.convert_oci_handles(rmName, ociHandles)) != 0) {
                    DBError.throwSqlException((int)(-1 * status));
                }
                info.put("user", this.m_user);
                info.put("password", this.m_password);
                info.put("OCISvcCtxHandle", String.valueOf(ociHandles[0]));
                info.put("OCIEnvHandle", String.valueOf(ociHandles[1]));
                if (this.m_loginTimeout != 0) {
                    info.put("oracle.net.CONNECT_TIMEOUT", "" + this.m_loginTimeout * 1000);
                }
                Connection conn = this.m_od.connect(this.getURL(), info);
                OracleXAHeteroConnection xaconn = new OracleXAHeteroConnection(conn);
                xaconn.setRmid(this.m_rmid);
                xaconn.setXaCloseString(xaclsstr);
                xaconn.registerCloseCallback(new OracleXAHeteroCloseCallback(), xaconn);
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)("OracleXADataSource.getXAConnection(user, pwd) return: " + xaconn));
                }
                return xaconn;
            }
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)"OracleXADataSource.getXAConnection(user, pwd) return: non-oci");
            }
            return new OracleXAConnection(super.getPhysicalConnection(user, passwd));
        }
        catch (XAException xae) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)2, (int)4, (String)("getXAConnection(user, pwd): XAException at end " + xae));
            }
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)"OracleXADataSource.getXAConnection(user, pwd) return: null");
            }
            return null;
        }
    }

    private native int do_xa_open(String var1, int var2, int var3, int var4);

    private native int convert_oci_handles(String var1, long[] var2);

    synchronized void setRmid(int rmid) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)("OracleXADataSource.setRmid(rmid = " + rmid + ")"));
        }
        this.m_rmid = rmid;
    }

    synchronized int getRmid() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)("OracleXADataSource.getRmid() return: " + this.m_rmid));
        }
        return this.m_rmid;
    }

    synchronized void setXaOpenString(String xaOpenString) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)("OracleXADataSource.setXaOpenString(xaOpenString = " + xaOpenString + ")"));
        }
        this.m_xaOpenString = xaOpenString;
    }

    synchronized String getXaOpenString() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)2, (int)16, (String)("OracleXADataSource.getXaOpenString() return: " + this.m_xaOpenString));
        }
        return this.m_xaOpenString;
    }

    private String generateXAOpenString(String rmName, String connectString, String userName, String password, int lockTimeout, int sessionTimeout, boolean threadFlag, boolean objectFlag, String logDir, int traceLevel, boolean cacheFlag) {
        return new String("ORACLE_XA+DB=" + rmName + "+ACC=P/" + userName + "/" + password + "+SESTM=" + sessionTimeout + "+SESWT=" + lockTimeout + "+LOGDIR=" + logDir + "+SQLNET=" + connectString + (threadFlag ? "+THREADS=true" : "") + (objectFlag ? "+OBJECTS=true" : "") + "+DBGFL=0x" + traceLevel + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    private String generateXACloseString(String rmName, boolean cacheFlag) {
        return new String("ORACLE_XA+DB=" + rmName + (cacheFlag ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    private String getTNSEntryFromUrl(String url) {
        int at_sign = url.indexOf(64);
        return url.substring(at_sign + 1);
    }

    static {
        DEBUG = false;
        s_libraryLoaded = false;
        s_dbSuffix = s_dbSuffix;
        s_dllName = s_dllName;
        at_sign_char = (char)64;
        s_rmidSeed = 0;
        MAX_RMID_SEED = 65536;
    }
}

