/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;

public class OracleXid
implements Xid,
Serializable {
    private int formatId;
    private byte[] gtrid = null;
    private byte[] bqual = null;
    private byte[] txctx = null;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private int state;

    public OracleXid(int fId, byte[] gId, byte[] bId) throws XAException {
        this(fId, gId, bId, null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)16, (String)("oracle.jdbc.xa.OracleXid(fId = " + fId + ", gId = " + gId + ", bId = " + bId + ")"));
        }
    }

    public OracleXid(int fId, byte[] gId, byte[] bId, byte[] context) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)16, (String)("oracle.jdbc.xa.OracleXid(fId = " + fId + ", gId = " + gId + ", bId = " + bId + ", context = " + context + ")"));
        }
        this.formatId = fId;
        if (gId != null && gId.length > 64) {
            throw new XAException(-4);
        }
        this.gtrid = gId;
        if (bId != null && bId.length > 64) {
            throw new XAException(-4);
        }
        this.bqual = bId;
        this.txctx = context;
        this.state = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)16, (String)"oracle.jdbc.xa.OracleXid(fId, gId, bId, context) return");
        }
    }

    public void setState(int k2) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)16, (String)("OracleXid.setState(k = " + k2 + ")"));
        }
        this.state = k2;
    }

    public int getState() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)16, (String)("OracleXid.getState() return: " + this.state));
        }
        return this.state;
    }

    public int getFormatId() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)1, (String)("OracleXid.getFormatId() return: " + this.formatId));
        }
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)1, (String)("OracleXid.getGlobalTransactionId() return: " + this.gtrid));
        }
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)1, (String)("OracleXid.getBranchQualifier() return: " + this.bqual));
        }
        return this.bqual;
    }

    public byte[] getTxContext() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)1, (String)("OracleXid.getTxContext() return: " + this.txctx));
        }
        return this.txctx;
    }

    public void setTxContext(byte[] context) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)64, (int)1, (String)("OracleXid.setTxContext(context = " + context + ")"));
        }
        this.txctx = context;
    }

    static {
        MAXGTRIDSIZE = 64;
        MAXBQUALSIZE = 64;
    }
}

