/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection m_conn = null;
    protected OracleXAConnection xaconnection = null;
    protected int m_timeout = 60;
    protected String m_dblink = null;
    private Properties connectionProperties;
    private Connection l_conn = null;
    protected int m_connSavedTxnMode = 0;
    private String synchronizeBeforeRecover = "BEGIN sys.dbms_system.dist_txn_sync(0); END;";
    private String m_rcvr_sql_rows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected Xid m_stackedXid = null;

    public OracleXAResource() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"oracle.jdbc.xa.OracleXAResource()");
        }
    }

    public OracleXAResource(Connection pm_conn, OracleXAConnection _xaconn) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("oracle.jdbc.xa.OracleXAResource(pm_conn = " + pm_conn + ", " + _xaconn + " )"));
        }
        this.m_conn = pm_conn;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
        this.xaconnection = _xaconn;
    }

    public synchronized void setConnection(Connection pm_conn) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.setConnection(pm_conn = " + pm_conn + ")"));
        }
        this.m_conn = pm_conn;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    protected void push(Xid xid) {
        this.m_stackedXid = xid;
        this.enterGlobalTxnMode();
    }

    protected void pop() {
        this.m_stackedXid = null;
        this.enterNoTxnMode();
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid stackedXid = null;
        this.disallowLocalTxnMode(-3);
        this.saveTxnMode();
        if (this.m_stackedXid != null && this.m_stackedXid != xid) {
            stackedXid = this.m_stackedXid;
            this.end(stackedXid, 0x2000000);
        }
        return stackedXid;
    }

    protected Xid suspendStacked(Xid xid, int endFlags) throws XAException {
        Xid stackedXid = null;
        this.allowGlobalTxnModeOnly(-3);
        this.saveTxnMode();
        if (endFlags == 0x4000000 && this.m_stackedXid != null && xid != this.m_stackedXid) {
            stackedXid = this.m_stackedXid;
            this.end(stackedXid, 0x2000000);
            this.start(xid, 0x8000000);
        }
        return stackedXid;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        this.restoreTxnMode();
        if (xid != null) {
            this.start(xid, 0x8000000);
        }
    }

    public abstract void start(Xid var1, int var2) throws XAException;

    public abstract void end(Xid var1, int var2) throws XAException;

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    public abstract int prepare(Xid var1) throws XAException;

    public abstract void forget(Xid var1) throws XAException;

    public abstract void rollback(Xid var1) throws XAException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xid[] recover(int flag) throws XAException {
        boolean cnt = false;
        Object[] xids = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.recover(flag = " + flag + ")"));
        }
        if ((flag & 0x1800000) != flag) {
            if (!OracleLog.TRACE) throw new XAException(-5);
            OracleLog.print((Object)this, (int)256, (int)8, (int)2, (String)"OracleXAResource.recover(flag): XAER_INVAL, invalid flag");
            throw new XAException(-5);
        }
        Statement stmt = null;
        ResultSet rset = null;
        try {
            try {
                this.saveTxnMode();
                int i2 = 0;
                OracleXid xid = null;
                Vector<OracleXid> xidList = new Vector<OracleXid>(50);
                stmt = this.m_conn.createStatement();
                stmt.execute(this.synchronizeBeforeRecover);
                rset = stmt.executeQuery(this.m_rcvr_sql_rows);
                while (true) {
                    if (!rset.next()) {
                        xids = new Xid[i2];
                        xidList.copyInto(xids);
                        break;
                    }
                    xid = new OracleXid(rset.getInt(1), rset.getBytes(2), rset.getBytes(3));
                    xidList.addElement(xid);
                    ++i2;
                }
            }
            catch (SQLException sqe) {
                throw new XAException(-3);
            }
            Object var10_10 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.restoreTxnMode();
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rset == null) throw throwable;
                rset.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        this.restoreTxnMode();
        try {}
        catch (Exception ignore) {}
        if (stmt != null) {
            stmt.close();
        }
        if (rset != null) {
            rset.close();
        }
        if (!OracleLog.TRACE) return xids;
        OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.recover(flag) return: " + xids));
        return xids;
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        if (this.savedConnectionAutoCommit && ((OracleConnection)this.m_conn).getTxnMode() != 2) {
            try {
                this.m_conn.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        try {
            this.savedConnectionAutoCommit = this.m_conn.getAutoCommit();
            this.m_conn.setAutoCommit(false);
            this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
            this.xaconnection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void resume(Xid xid) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.resume(xid = " + xid + ")"));
        }
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.join(xid = " + xid + ")"));
        }
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.suspend(xid = " + xid + ")"));
        }
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int timeout) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.join(xid = " + xid + ", timeout = " + timeout + ")"));
        }
        this.m_timeout = timeout;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int timeout) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.resume(xid = " + xid + ", timeout = " + timeout + ")"));
        }
        this.m_timeout = timeout;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.getConnection()");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.getConnection() return: " + this.m_conn));
        }
        return this.m_conn;
    }

    public int getTransactionTimeout() throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)"OracleXAResource.getTransactionTimeout()");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.getTransactionTimeout() return: " + this.m_timeout));
        }
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.isSameRM(xares = " + xares + ")"));
        }
        Connection conn1 = null;
        if (!(xares instanceof OracleXAResource)) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.isSameRM(xares) return: false");
            }
            return false;
        }
        conn1 = ((OracleXAResource)xares).getConnection();
        String l_url = ((OracleConnection)this.m_conn).getURL();
        String l_prt = ((OracleConnection)this.m_conn).getProtocolType();
        if (conn1 != null) {
            boolean _returnVal;
            boolean bl = _returnVal = conn1.equals(this.m_conn) || ((OracleConnection)conn1).getURL().equals(l_url) || ((OracleConnection)conn1).getProtocolType().equals(l_prt) && l_prt.equals("kprb");
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.isSameRM(xares) return: " + _returnVal));
            }
            return _returnVal;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.isSameRM(xares) return: false");
        }
        return false;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)1, (String)("OracleXAResource.setTransactionTimeout(seconds = " + seconds + ")"));
        }
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.m_timeout = seconds;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.setTransactionTimeout(seconds) return: true");
        }
        return true;
    }

    public String getDBLink() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)"OracleXAResource.getDBLink()");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.getDBLink() return: " + this.m_dblink));
        }
        return this.m_dblink;
    }

    public void setDBLink(String dblink) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.setDBLink(dblink = " + dblink + ")"));
        }
        this.m_dblink = dblink;
    }

    public void setLogicalConnection(Connection conn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)8, (int)16, (String)("OracleXAResource.setLogicalConnection(conn = " + conn + ")"));
        }
        this.l_conn = conn;
    }

    protected void disallowLocalTxnMode(int errorCode) throws XAException {
        if (this.l_conn != null && ((OracleConnection)this.l_conn).m_txn_mode == 1) {
            throw new XAException(errorCode);
        }
        if (this.l_conn == null && ((OracleConnection)this.m_conn).m_txn_mode == 1) {
            throw new XAException(errorCode);
        }
    }

    protected void allowGlobalTxnModeOnly(int errorCode) throws XAException {
        if (((OracleConnection)this.m_conn).m_txn_mode != 2) {
            throw new XAException(errorCode);
        }
    }

    protected void allowNoTxnModeOnly(int errorCode) throws XAException {
        if (((OracleConnection)this.m_conn).m_txn_mode != 0) {
            throw new XAException(errorCode);
        }
    }

    protected void enterNoTxnMode() {
        ((OracleConnection)this.m_conn).m_txn_mode = 0;
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.m_conn).m_txn_mode = 2;
    }

    protected void saveTxnMode() {
        this.m_connSavedTxnMode = ((OracleConnection)this.m_conn).m_txn_mode;
    }

    protected void restoreTxnMode() {
        if (this.m_connSavedTxnMode == 0) {
            ((OracleConnection)this.m_conn).m_txn_mode = this.m_connSavedTxnMode;
        }
    }

    protected void checkError(int error) throws OracleXAException {
        if ((error & 0xFFFF) != 0) {
            throw new OracleXAException(error);
        }
    }

    protected final Properties getConnectionProperties() throws SQLException {
        ((OracleConnection)OracleConnection.physicalConnectionWithin((Connection)this.m_conn)).getPropertyForXAResource(this);
        return this.connectionProperties;
    }

    public final void setConnectionPropertiesInternal(Properties prop) throws SQLException {
        this.connectionProperties = prop;
    }

    static {
        XA_OK = 0;
        DEFAULT_XA_TIMEOUT = (short)60;
        TMNOFLAGS = 0;
        TMNOMIGRATE = 2;
        TMENDRSCAN = 0x800000;
        TMFAIL = 0x20000000;
        TMJOIN = 0x200000;
        TMONEPHASE = 0x40000000;
        TMRESUME = 0x8000000;
        TMSTARTRSCAN = 0x1000000;
        TMSUCCESS = 0x4000000;
        TMSUSPEND = 0x2000000;
        ORATMREADONLY = 256;
        ORATMREADWRITE = 512;
        ORATMSERIALIZABLE = 1024;
        ORAISOLATIONMASK = 65280;
        ORATRANSLOOSE = 65536;
    }
}

