/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

public abstract class OracleXAConnection
extends OraclePooledConnection
implements XAConnection {
    protected XAResource m_xarsrc = null;

    public OracleXAConnection() throws XAException {
        this((Connection)null);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)4, (int)16, (String)"oracle.jdbc.xa.OracleXAConnection()");
        }
    }

    public OracleXAConnection(Connection pc) throws XAException {
        super(pc);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)4, (int)16, (String)("oracle.jdbc.xa.OracleXAConnection(pc = " + pc + ")"));
        }
    }

    public abstract XAResource getXAResource();

    public synchronized Connection getConnection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)4, (int)1, (String)"OracleXAConnection.getConnection()");
        }
        Connection conn = super.getConnection();
        if (this.m_xarsrc != null) {
            ((OracleXAResource)this.m_xarsrc).setLogicalConnection(conn);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)256, (int)4, (int)16, (String)("OracleXAConnection.getConnection() return: " + conn));
        }
        return conn;
    }

    boolean getAutoCommit() throws SQLException {
        return this.m_autoCommit;
    }

    void setAutoCommit(boolean value) throws SQLException {
        this.m_autoCommit = value;
    }
}

