/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIoac;

public class v8TTIoac
extends TTIoac {
    public byte[] oactoid;
    int oactoidl;
    int oacvsn;

    public v8TTIoac(int type, MAREngine _mrengine, short serverVersion) {
        super(type, _mrengine, serverVersion);
    }

    public v8TTIoac(MAREngine _mrengine) {
        super(_mrengine);
    }

    public void setFieldsForBinds(int type, int nlsRatio) throws SQLException {
        this.setFieldsForBinds(type, nlsRatio, (short)1);
    }

    public void setFieldsForBinds(int type, int nlsRatio, short formOfUseType) throws SQLException {
        if (nlsRatio <= 0) {
            DBError.check_error((int)58, (Object)new Integer(nlsRatio));
        }
        switch (type) {
            case 96: {
                if (nlsRatio <= 2 || formOfUseType == 2) {
                    this.max_length = 2000;
                    break;
                }
                this.max_length = 4000 / nlsRatio;
                break;
            }
            case 1: {
                this.max_length = formOfUseType == 2 ? 4000 : 4000 / nlsRatio;
            }
        }
    }

    public void unmarshal() throws IOException, SQLException {
        super.unmarshal();
        this.oactoid = this.meg.unmarshalDALC();
        this.oactoidl = this.oactoid == null ? 0 : this.oactoid.length;
        this.oacvsn = this.meg.unmarshalUB2();
        this.ncs = this.meg.unmarshalUB2();
        this.FormOfUse = this.meg.unmarshalUB1();
    }

    public void marshal() throws IOException, SQLException {
        super.marshal();
        this.meg.marshalDALC(this.oactoid);
        this.ncs = this.isNType() ? (int)this.meg.conv.getNCharSet() : (int)this.meg.conv.getDbCharSet();
        this.meg.marshalUB2(this.oacvsn);
        this.meg.marshalUB2(this.ncs);
        this.meg.marshalUB1(this.FormOfUse);
    }

    public void init(DBType dbtype) {
        super.init(dbtype);
        this.ncs = this.meg.conv.getNCharSet();
        OracleTypeADT tmp_otype = (OracleTypeADT)dbtype.otype;
        if (tmp_otype != null) {
            this.oactoid = tmp_otype.getTOID();
            this.oacvsn = tmp_otype.getTypeVersion();
            this.ncs = tmp_otype.getCharSet();
            this.FormOfUse = (short)tmp_otype.getCharSetForm();
        }
    }

    public void print(int mod, int submod, int cat) {
    }
}

