/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIMsg;

public class v8TTILobd
extends TTIMsg {
    private static final int LOBD_STATE0 = 0;
    private static final int LOBD_STATE1 = 1;
    private static final int LOBD_STATE2 = 2;
    private static final int LOBD_STATE3 = 3;
    private static final int LOBD_STATE_EXIT = 4;
    private static final short TTCG_LNG = 254;
    private static final short LOBDATALENGTH = 252;
    private static byte[] ucs2Char;

    public v8TTILobd(MAREngine mengine) {
        super((byte)14);
        this.setMarshalingEngine(mengine);
    }

    public void marshalLobData(byte[] inBuffer, long numBytes) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILobd.marshalLobData. inBuffer is " + inBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long length = numBytes;
        boolean ttcgLong = false;
        this.marshalTTCcode();
        if (length > 252L) {
            ttcgLong = true;
            this.meg.marshalUB1((short)254);
        }
        long count = 0L;
        while (length > 252L) {
            this.meg.marshalUB1((short)252);
            this.meg.marshalB1Array(inBuffer, (int)(count * 252L), 252);
            ++count;
            length -= 252L;
        }
        if (length > 0L) {
            this.meg.marshalUB1((short)length);
            this.meg.marshalB1Array(inBuffer, (int)(count * 252L), (int)length);
        }
        if (ttcgLong) {
            this.meg.marshalUB1((short)0);
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILobd.marshalLobData.";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
    }

    public void marshalLobDataUB2(byte[] inBuffer, long numChars) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILobd.marshalLobDataUB2. inBuffer is " + inBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long numUB2 = numChars;
        boolean ttcgLong = false;
        this.marshalTTCcode();
        if (numUB2 > 84L) {
            ttcgLong = true;
            this.meg.marshalUB1((short)254);
        }
        long count = 0L;
        while (numUB2 > 84L) {
            this.meg.marshalUB1((short)252);
            int j2 = 0;
            while (j2 < 84) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(count * 168L + (long)(j2 * 2)), 2);
                ++j2;
            }
            ++count;
            numUB2 -= 84L;
        }
        if (numUB2 > 0L) {
            long length = numUB2 * 3L;
            this.meg.marshalUB1((short)length);
            int j3 = 0;
            while ((long)j3 < numUB2) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(count * 168L + (long)(j3 * 2)), 2);
                ++j3;
            }
        }
        if (ttcgLong) {
            this.meg.marshalUB1((short)0);
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILobd.marshalLobDataUB2.";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
    }

    public long unmarshalLobData(byte[] outBuffer) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILobd.unmarshalLobData. outBuffer is " + outBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long bytesRead = 0L;
        long offset = 0L;
        short length = 0;
        int state = 0;
        while (state != 4) {
            switch (state) {
                case 0: {
                    length = this.meg.unmarshalUB1();
                    if (length == 254) {
                        state = 2;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    this.meg.getNBytes(outBuffer, (int)offset, (int)length);
                    bytesRead += (long)length;
                    state = 4;
                    break;
                }
                case 2: {
                    length = this.meg.unmarshalUB1();
                    if (length > 0) {
                        state = 3;
                        break;
                    }
                    state = 4;
                    break;
                }
                case 3: {
                    this.meg.getNBytes(outBuffer, (int)offset, (int)length);
                    bytesRead += (long)length;
                    offset += (long)length;
                    state = 2;
                    break;
                }
            }
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILobd.unmarshalLobData. bytesRead is " + bytesRead;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return bytesRead;
    }

    public long unmarshalClobUB2(byte[] outBuffer) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILobd.unmarshalClobB2. outBuffer is " + outBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long bytesRead = 0L;
        long offset = 0L;
        int length = 0;
        int i2 = 0;
        int numBytes = 0;
        int state = 0;
        while (state != 4) {
            switch (state) {
                case 0: {
                    length = this.meg.unmarshalUB1();
                    if (length == 254) {
                        state = 2;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    i2 = 0;
                    while (i2 < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i2 += numBytes;
                        offset += 2L;
                    }
                    bytesRead += (long)length;
                    state = 4;
                    break;
                }
                case 2: {
                    length = this.meg.unmarshalUB1();
                    if (length > 0) {
                        state = 3;
                        break;
                    }
                    state = 4;
                    break;
                }
                case 3: {
                    i2 = 0;
                    while (i2 < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i2 += numBytes;
                        offset += 2L;
                    }
                    bytesRead += (long)length;
                    state = 2;
                    break;
                }
            }
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILobd.unmarshalClobUB2. bytesRead is " + bytesRead;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return bytesRead;
    }

    static {
        LOBD_STATE0 = 0;
        LOBD_STATE1 = 1;
        LOBD_STATE2 = 2;
        LOBD_STATE3 = 3;
        LOBD_STATE_EXIT = 4;
        TTCG_LNG = (short)254;
        LOBDATALENGTH = (short)252;
        ucs2Char = new byte[2];
    }
}

