/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIoer;
import oracle.jdbc.ttc7.v8TTILobd;
import oracle.net.ns.BreakNetException;
import oracle.sql.Datum;

public abstract class v8TTILob
extends TTIfun {
    protected static final int KPLOB_READ = 2;
    protected static final int KPLOB_WRITE = 64;
    protected static final int KPLOB_WRITE_APPEND = 8192;
    protected static final int KPLOB_PAGE_SIZE = 16384;
    protected static final int KPLOB_FILE_OPEN = 256;
    protected static final int KPLOB_FILE_ISOPEN = 1024;
    protected static final int KPLOB_FILE_EXISTS = 2048;
    protected static final int KPLOB_FILE_CLOSE = 512;
    protected static final int KPLOB_OPEN = 32768;
    protected static final int KPLOB_CLOSE = 65536;
    protected static final int KPLOB_ISOPEN = 69632;
    protected static final int KPLOB_TMP_CREATE = 272;
    protected static final int KPLOB_TMP_FREE = 273;
    protected static final int KPLOB_GET_LEN = 1;
    protected static final int KPLOB_TRIM = 32;
    protected static final int KOKL_ORDONLY = 1;
    protected static final int KOKL_ORDWR = 2;
    protected static final int KOLF_ORDONLY = 11;
    protected static final byte KOLBLOPEN = 8;
    protected static final byte KOLBLTMP = 1;
    protected static final byte KOLBLRDWR = 16;
    protected static final byte ALLFLAGS = -1;
    protected static final int DTYCLOB = 112;
    protected static final int DTYBLOB = 113;
    protected byte[] sourceLobLocator = null;
    protected byte[] destinationLobLocator = null;
    protected long sourceOffset = 0L;
    protected long destinationOffset = 0L;
    protected int destinationLength = 0;
    protected short characterSet = 0;
    protected long lobamt = 0L;
    protected boolean lobnull = false;
    protected long lobops = 0L;
    protected int[] lobscn = null;
    protected int lobscnl = 0;
    protected boolean nullO2U = false;
    protected boolean sendLobamt = false;
    protected byte[] inBuffer = null;
    protected byte[] outBuffer = null;
    public int rowsProcessed = 0;
    protected long lobBytesRead = 0L;
    protected boolean varWidthChar = false;
    protected v8TTILobd lobd = null;

    public v8TTILob(MAREngine mengine) {
        super((byte)3, 0, (byte)96);
        this.setMarshalingEngine(mengine);
        this.oer = new TTIoer(mengine);
        this.lobd = new v8TTILobd(mengine);
    }

    public long read(byte[] lobLocator, long offset, long numBytes, byte[] outBuffer) throws SQLException, IOException {
        String data;
        if (OracleLog.TRACE) {
            data = "Entering v8TTILob.read. lobLocator is " + lobLocator + ". offset is " + offset + ". numBytes is " + numBytes + ". outBuffer is " + outBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        this.initializeLobdef();
        this.lobops = 2L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = numBytes;
        this.sendLobamt = true;
        this.outBuffer = outBuffer;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        if (OracleLog.TRACE) {
            data = "Exiting v8TTILob.read -- amtRead is " + this.lobamt + ". lobBytesRead is " + this.lobBytesRead;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return this.lobBytesRead;
    }

    public long write(byte[] lobLocator, long offset, long numBytes, byte[] inBuffer) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILob.write. lobLocator is " + lobLocator + ". offset is " + offset + ". numBytes is " + numBytes + ". inBuffer is " + inBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long bytesWritten = 0L;
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = numBytes;
        this.sendLobamt = true;
        this.inBuffer = inBuffer;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.lobd.marshalLobData(inBuffer, numBytes);
        this.receiveReply();
        bytesWritten = this.lobamt;
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILob.write -- bytesWritten is " + bytesWritten;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return bytesWritten;
    }

    public long getLength(byte[] lobLocator) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILob.getLength. lobLocator is " + lobLocator;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long lobLength = 0L;
        this.initializeLobdef();
        this.lobops = 1L;
        this.sourceLobLocator = lobLocator;
        this.sendLobamt = true;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        lobLength = this.lobamt;
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILob.getLength. Lob Length is " + lobLength;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return lobLength;
    }

    public long getChunkSize(byte[] lobLocator) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILob.getChunkSize. lobLocator is " + lobLocator;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long chunkSize = 0L;
        this.initializeLobdef();
        this.lobops = 16384L;
        this.sourceLobLocator = lobLocator;
        this.marshalFunHeader();
        this.sendLobamt = true;
        this.marshalOlobops();
        this.receiveReply();
        chunkSize = this.lobamt;
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILob.getChunkSize. chunkSize is " + chunkSize;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return chunkSize;
    }

    public long trim(byte[] lobLocator, long newLength) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILob.trim. lobLocator is " + lobLocator + ". newLength is " + newLength;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        long newLengthfromServer = 0L;
        this.initializeLobdef();
        this.lobops = 32L;
        this.sourceLobLocator = lobLocator;
        this.lobamt = newLength;
        this.sendLobamt = true;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        newLengthfromServer = this.lobamt;
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILob.trim. newLengthfromServer is " + newLengthfromServer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return newLengthfromServer;
    }

    public abstract Datum createTemporaryLob(Connection var1, boolean var2, int var3) throws SQLException, IOException;

    public void freeTemporaryLob(byte[] lobLocator) throws SQLException, IOException {
        String data;
        if (OracleLog.TRACE) {
            data = "Entering v8TTILob.freeTemporaryLob. lobLocator is " + lobLocator;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        this.initializeLobdef();
        this.lobops = 273L;
        this.sourceLobLocator = lobLocator;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        if (OracleLog.TRACE) {
            data = "Exiting v8TTILob.freeTemporaryLob.";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
    }

    public abstract boolean open(byte[] var1, int var2) throws SQLException, IOException;

    protected boolean _open(byte[] lobLocator, int mode, int lobops) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILob._open. lobLocator is " + lobLocator + ". mode is " + mode + ". lobops is " + lobops;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        boolean didOpen = false;
        if ((lobLocator[7] & 1) == 1) {
            if ((lobLocator[7] & 8) == 8) {
                DBError.check_error((int)401);
            } else {
                lobLocator[7] = (byte)(lobLocator[7] | 8);
                if (mode == 2) {
                    lobLocator[7] = (byte)(lobLocator[7] | 0x10);
                }
                didOpen = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.lobamt = mode;
            this.sendLobamt = true;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
            if (this.lobamt != 0L) {
                didOpen = true;
            }
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILob._open. didOpen is " + didOpen;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return didOpen;
    }

    public abstract boolean close(byte[] var1) throws SQLException, IOException;

    protected boolean _close(byte[] lobLocator, int lobops) throws SQLException, IOException {
        String data;
        boolean isClosed = true;
        if (OracleLog.TRACE) {
            data = "Entering v8TTILob._close. lobLocator is " + lobLocator + ". lobops is " + lobops;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        if ((lobLocator[7] & 1) == 1) {
            if ((lobLocator[7] & 8) != 8) {
                DBError.check_error((int)401);
            } else {
                lobLocator[7] = (byte)(lobLocator[7] & 0xFFFFFFE7);
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
        }
        if (OracleLog.TRACE) {
            data = "Exiting v8TTILob._close. isClosed is " + isClosed;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return isClosed;
    }

    public abstract boolean isOpen(byte[] var1) throws SQLException, IOException;

    protected boolean _isOpen(byte[] lobLocator, int lobops) throws SQLException, IOException {
        String data;
        boolean lobOpen = false;
        if (OracleLog.TRACE) {
            data = "Entering v8TTILob._isOpen. lobLocator is " + lobLocator + ". lobops is " + lobops;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        if ((lobLocator[7] & 1) == 1) {
            if ((lobLocator[7] & 8) == 8) {
                lobOpen = true;
            }
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.nullO2U = true;
            this.marshalFunHeader();
            this.marshalOlobops();
            this.receiveReply();
            lobOpen = this.lobnull;
        }
        if (OracleLog.TRACE) {
            data = "Exiting v8TTILob._isOpen. lobOpen is " + lobOpen;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return lobOpen;
    }

    public void initializeLobdef() {
        String data;
        if (OracleLog.TRACE) {
            data = "Entering v8TTILob.initializeLobdef";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        this.sourceLobLocator = null;
        this.destinationLobLocator = null;
        this.sourceOffset = 0L;
        this.destinationOffset = 0L;
        this.destinationLength = 0;
        this.characterSet = 0;
        this.lobamt = 0L;
        this.lobnull = false;
        this.lobops = 0L;
        this.lobscn = null;
        this.lobscnl = 0;
        this.inBuffer = null;
        this.outBuffer = null;
        this.nullO2U = false;
        this.sendLobamt = false;
        this.varWidthChar = false;
        this.lobBytesRead = 0L;
        if (OracleLog.TRACE) {
            data = "Exiting v8TTILob.initializeLobdef";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
    }

    public void marshalOlobops() throws IOException {
        String data;
        int slength = 0;
        if (OracleLog.TRACE) {
            data = "Entering v8TTILob.marshalOlobops: lobdef contents ==> lobsrc is " + this.sourceLobLocator + ". lobdst is " + this.destinationLobLocator + ". lobsoff is " + this.sourceOffset + ". destinationLength is " + this.destinationLength + ". lobdoff is " + this.destinationOffset + ". lobchr is " + this.characterSet + ". lobamt is " + this.lobamt + ". lobnull is " + this.lobnull + ". lobops is " + this.lobops + ". sendLobamt is " + this.sendLobamt;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        if (this.sourceLobLocator != null) {
            slength = this.sourceLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(slength);
        if (this.destinationLobLocator != null) {
            this.destinationLength = this.destinationLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.destinationLength);
        this.meg.marshalUB4(this.sourceOffset);
        this.meg.marshalUB4(this.destinationOffset);
        if (this.characterSet != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.sendLobamt) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.nullO2U) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.lobops);
        if (this.lobscnl != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.lobscnl);
        if (this.sourceLobLocator != null) {
            this.meg.marshalB1Array(this.sourceLobLocator);
        }
        if (this.destinationLobLocator != null) {
            this.meg.marshalB1Array(this.destinationLobLocator);
        }
        if (this.characterSet != 0) {
            this.meg.marshalUB2((int)this.characterSet);
        }
        if (this.sendLobamt) {
            this.meg.marshalUB4(this.lobamt);
        }
        if (this.lobscnl != 0) {
            int i2 = 0;
            while (i2 < this.lobscnl) {
                this.meg.marshalUB4((long)this.lobscn[i2]);
                ++i2;
            }
        }
        if (OracleLog.TRACE) {
            data = "Exiting v8TTILob.marshalOlobops.";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
    }

    public void receiveReply() throws IOException, SQLException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTILob.receiveReply.";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        byte code = 0;
        block8: while (true) {
            try {
                code = this.meg.unmarshalSB1();
                switch (code) {
                    case 8: {
                        this.unmarshalTTIRPA();
                        continue block8;
                    }
                    case 14: {
                        if (!this.varWidthChar) {
                            this.lobBytesRead = this.lobd.unmarshalLobData(this.outBuffer);
                            continue block8;
                        }
                        this.lobBytesRead = this.lobd.unmarshalClobUB2(this.outBuffer);
                        continue block8;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.rowsProcessed = this.oer.getCurRowNumber();
                        if (this.oer.getRetCode() == 1403) break block8;
                        this.oer.processError();
                        break;
                    }
                    case 9: {
                        break;
                    }
                    default: {
                        DBError.check_error((int)401);
                        break;
                    }
                }
            }
            catch (BreakNetException ea) {
                continue;
            }
            break;
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILob.receiveReply.";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
    }

    public void unmarshalTTIRPA() throws SQLException, IOException {
        short isNull;
        String data;
        if (OracleLog.TRACE) {
            data = "Entering v8TTILob.unmarshalTTIRPA";
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        if (this.sourceLobLocator != null) {
            int length = this.sourceLobLocator.length;
            this.meg.getNBytes(this.sourceLobLocator, 0, length);
        }
        if (this.destinationLobLocator != null) {
            short length = this.meg.unmarshalSB2();
            this.destinationLobLocator = this.meg.unmarshalNBytes((int)length);
        }
        if (this.characterSet != 0) {
            this.characterSet = this.meg.unmarshalSB2();
        }
        if (this.sendLobamt) {
            this.lobamt = this.meg.unmarshalUB4();
        }
        if (this.nullO2U && (isNull = this.meg.unmarshalSB2()) != 0) {
            this.lobnull = true;
        }
        if (this.lobscnl != 0) {
            int i2 = 0;
            while (i2 < this.lobscnl) {
                this.lobscn[i2] = this.meg.unmarshalSB4();
                ++i2;
            }
        }
        if (OracleLog.TRACE) {
            data = "Exiting v8TTILob.unmarshalTTIRPA: lobdef contents ==> lobsrc is " + this.sourceLobLocator + ". lobdst is " + this.destinationLobLocator + ". lobsoff is " + this.sourceOffset + ". lobdoff is " + this.destinationOffset + ". lobchr is " + this.characterSet + ". lobamt is " + this.lobamt + ". lobnull is " + this.lobnull + ". lobops is " + this.lobops;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
    }

    static {
        KPLOB_READ = 2;
        KPLOB_WRITE = 64;
        KPLOB_WRITE_APPEND = 8192;
        KPLOB_PAGE_SIZE = 16384;
        KPLOB_FILE_OPEN = 256;
        KPLOB_FILE_ISOPEN = 1024;
        KPLOB_FILE_EXISTS = 2048;
        KPLOB_FILE_CLOSE = 512;
        KPLOB_OPEN = 32768;
        KPLOB_CLOSE = 65536;
        KPLOB_ISOPEN = 69632;
        KPLOB_TMP_CREATE = 272;
        KPLOB_TMP_FREE = 273;
        KPLOB_GET_LEN = 1;
        KPLOB_TRIM = 32;
        KOKL_ORDONLY = 1;
        KOKL_ORDWR = 2;
        KOLF_ORDONLY = 11;
        KOLBLOPEN = (byte)8;
        KOLBLTMP = 1;
        KOLBLRDWR = (byte)16;
        ALLFLAGS = (byte)-1;
        DTYCLOB = 112;
        DTYBLOB = 113;
    }
}

