/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.v8TTILob;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class v8TTIClob
extends v8TTILob {
    public v8TTIClob(MAREngine mengine) {
        super(mengine);
    }

    public long read(byte[] lobLocator, long offset, long numChars, boolean isNCLOB, char[] outBuffer) throws SQLException, IOException {
        long bytesRead = 0L;
        if (OracleLog.TRACE) {
            String data = "Entering v8TTIClob.read. lobLocator is " + lobLocator + ". offset is " + offset + ". numChars is " + numChars + ". outBuffer is " + outBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        byte[] myBuffer = null;
        this.initializeLobdef();
        if ((lobLocator[6] & 0x80) == 128) {
            this.varWidthChar = true;
        }
        myBuffer = this.varWidthChar ? new byte[(int)numChars * 2] : new byte[(int)numChars * 3];
        this.lobops = 2L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = numChars;
        this.sendLobamt = true;
        this.outBuffer = myBuffer;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        long charsRead = this.lobamt;
        long bytesConverted = 0L;
        if (this.varWidthChar) {
            TTCConversion.ucs2BytesToJavaChars((byte[])myBuffer, (int)myBuffer.length, (char[])outBuffer);
        } else if (!isNCLOB) {
            this.meg.conv.CHARBytesToJavaChars(myBuffer, (int)this.lobBytesRead, outBuffer);
        } else {
            this.meg.conv.NCHARBytesToJavaChars(myBuffer, (int)this.lobBytesRead, outBuffer);
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTIClob.read -- lobBytesRead is " + this.lobBytesRead;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return charsRead;
    }

    public long write(byte[] lobLocator, long offset, long numChars, boolean isNCLOB, char[] inBuffer) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTIClob.write. lobLocator is " + lobLocator + ". offset is " + offset + ". numChars is " + numChars + ". inBuffer is " + inBuffer;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        boolean varChar = false;
        if ((lobLocator[6] & 0x80) == 128) {
            varChar = true;
        }
        long bytesConverted = 0L;
        byte[] myBuffer = null;
        if (varChar) {
            myBuffer = new byte[(int)numChars * 2];
            TTCConversion.javaCharsToUcs2Bytes((char[])inBuffer, (int)((int)numChars), (byte[])myBuffer);
        } else {
            myBuffer = new byte[(int)numChars * 3];
            bytesConverted = !isNCLOB ? (long)this.meg.conv.javaCharsToCHARBytes(inBuffer, (int)numChars, myBuffer) : (long)this.meg.conv.javaCharsToNCHARBytes(inBuffer, (int)numChars, myBuffer);
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = numChars;
        this.sendLobamt = true;
        this.inBuffer = myBuffer;
        this.marshalFunHeader();
        this.marshalOlobops();
        if (varChar) {
            this.lobd.marshalLobDataUB2(myBuffer, numChars);
        } else {
            this.lobd.marshalLobData(myBuffer, bytesConverted);
        }
        this.receiveReply();
        long charsWritten = this.lobamt;
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTILob.write -- charsWritten is " + charsWritten;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return charsWritten;
    }

    public Datum createTemporaryLob(Connection conn, boolean cache, int duration) throws SQLException, IOException {
        return this.createTemporaryLob(conn, cache, duration, 1);
    }

    public Datum createTemporaryLob(Connection conn, boolean cache, int duration, int form) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTIClob.createTemporaryLob. cache is " + cache + ". duration is " + duration;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        CLOB clob = null;
        this.initializeLobdef();
        this.lobops = 272L;
        this.sourceLobLocator = new byte[86];
        this.sourceLobLocator[1] = 84;
        this.lobamt = 10L;
        this.sendLobamt = true;
        this.sourceOffset = form;
        this.destinationOffset = 112L;
        this.destinationLength = duration;
        this.nullO2U = true;
        this.characterSet = form == 2 ? this.meg.conv.getNCharSet() : this.meg.conv.getDbCharSet();
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        if (this.sourceLobLocator != null) {
            clob = new CLOB((OracleConnection)conn, this.sourceLobLocator, (short)form);
        }
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTIClob.createTemporaryLob. oracle.sql.CLOB is " + clob;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return clob;
    }

    public boolean open(byte[] lobLocator, int mode) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTIClob.open. lobLocator is " + lobLocator + ". mode is " + mode;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        boolean wasOpened = false;
        int kokl_mode = 2;
        if (mode == 0) {
            kokl_mode = 1;
        }
        wasOpened = this._open(lobLocator, kokl_mode, 32768);
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTIClob.open. wasOpened is " + wasOpened;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return wasOpened;
    }

    public boolean close(byte[] lobLocator) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTIClob.close. lobLocator is " + lobLocator;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        boolean wasClosed = false;
        wasClosed = this._close(lobLocator, 65536);
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTIClob.close. wasClosed is " + wasClosed;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return wasClosed;
    }

    public boolean isOpen(byte[] lobLocator) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String data = "Entering v8TTIClob.isOpen. lobLocator is " + lobLocator;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        boolean open = false;
        open = this._isOpen(lobLocator, 69632);
        if (OracleLog.TRACE) {
            String data = "Exiting v8TTIClob.isOpen. open is " + open;
            OracleLog.print((Object)this, (int)32, (int)512, (int)16, (String)data);
        }
        return open;
    }
}

