/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.Odscrarr;
import oracle.jdbc.ttc7.TTCStatement;
import oracle.jdbc.ttc7.v8TTIuds;
import oracle.net.ns.BreakNetException;

public class v8Odscrarr
extends Odscrarr {
    private v8TTIuds[] uds;
    private byte operationflags = (byte)7;
    private byte[] sqltext = new byte[0];
    private long sqlparseversion = 2L;

    v8Odscrarr(MAREngine _mrengine) throws IOException, SQLException {
        super(_mrengine);
        this.funCode = (byte)98;
        this.setMarshalingEngine(_mrengine);
    }

    public void init(TTCStatement _stmt, int _offset) throws IOException, SQLException {
        super.init(_stmt, _offset);
        this.uds = null;
        this.operationflags = (byte)7;
        this.sqltext = new byte[0];
        this.sqlparseversion = 2L;
    }

    public void marshal() throws IOException {
        this.marshalFunHeader();
        this.meg.marshalUB1((short)this.operationflags);
        this.meg.marshalSWORD(this.cursor_id);
        if (this.sqltext.length == 0) {
            this.meg.marshalNULLPTR();
        } else {
            this.meg.marshalPTR();
        }
        this.meg.marshalSB4(this.sqltext.length);
        this.meg.marshalUB4(this.sqlparseversion);
        this.meg.marshalO2U(this.udsarrayO2U);
        this.meg.marshalO2U(this.numudsO2U);
        this.meg.marshalCHR(this.sqltext);
    }

    public DBColumn[] receive(DBColumn[] _dbcols) throws SQLException, IOException {
        boolean descinfo_read = false;
        while (!descinfo_read) {
            try {
                byte code = this.meg.unmarshalSB1();
                switch (code) {
                    case 8: {
                        this.numuds = this.meg.unmarshalUB2();
                        this.uds = new v8TTIuds[this.numuds];
                        this.colnames = new String[this.numuds];
                        int i2 = 0;
                        while (i2 < this.numuds) {
                            this.uds[i2] = new v8TTIuds(this.meg);
                            this.uds[i2].unmarshal();
                            this.colnames[i2] = new String(this.decodeColName(this.uds[i2].getColumName(), this.uds[i2].getColumNameByteLength()));
                            ++i2;
                        }
                        if (_dbcols == null) {
                            _dbcols = new DBColumn[this.numuds];
                        }
                        this.fillupDBcols(_dbcols);
                        break;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        this.oer.processError();
                        descinfo_read = true;
                        break;
                    }
                    case 9: {
                        descinfo_read = true;
                    }
                }
            }
            catch (BreakNetException breakNetException) {
                // empty catch block
            }
        }
        return _dbcols;
    }

    private String decodeColName(byte[] _encodedString, short _numBytes) throws SQLException {
        String decodedString = this.meg.conv.CharBytesToString(_encodedString, (int)_numBytes);
        char[] colNameInChars = decodedString.toCharArray();
        StringBuffer colNameSB = new StringBuffer();
        int i2 = 0;
        while (i2 < colNameInChars.length) {
            if (colNameInChars[i2] != '\'') {
                colNameSB.append(colNameInChars[i2]);
            }
            ++i2;
        }
        return colNameSB.toString();
    }

    public void fillupDBcols(DBColumn[] _dbcols) throws SQLException {
        int i2 = 0;
        while (i2 < this.numuds) {
            _dbcols[this.colOffset + i2] = new DBColumn(this.colnames[i2], this.uds[i2].udsnull, (int)this.uds[i2].udsoac.oacdty, (int)this.uds[i2].udsoac.oacflg, (int)this.uds[i2].udsoac.oacpre, (int)this.uds[i2].udsoac.oacscl, this.uds[i2].udsoac.oacmxl, this.uds[i2].udsoac.oacmal, this.uds[i2].udsoac.oacfl2);
            String sql_name = new String(this.decodeColName(this.uds[i2].getTypeName(), this.uds[i2].getTypeCharLength()));
            String schema_name = new String(this.decodeColName(this.uds[i2].getSchemaName(), this.uds[i2].getSchemaCharLength()));
            _dbcols[this.colOffset + i2].setDBColumnForV8(this.uds[i2].udsoac.oactoid, this.uds[i2].udsoac.oacvsn, this.uds[i2].udsoac.ncs, this.uds[i2].udsoac.FormOfUse, schema_name + "." + sql_name);
            ++i2;
        }
    }
}

