/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTIMsg;

public class TTIpro
extends TTIMsg {
    private short svrCharSet;
    private short svrCharSetElem;
    private byte svrFlags;
    protected byte[] proSvrStr;
    protected byte proSvrVer;
    protected short oVersion = (short)-1;
    private boolean svrInfoAvailable = false;
    private byte[] proCliVerTTC7 = new byte[]{4, 3, 2, 1, 0};
    private byte[] proCliStrTTC7 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 55, 46, 50, 46, 48, 0};

    public TTIpro(MAREngine mrengine) throws SQLException, IOException {
        super((byte)1);
        this.setMarshalingEngine(mrengine);
    }

    public void receive() throws SQLException, IOException {
        if (this.meg.unmarshalSB1() != 1) {
            DBError.check_error((int)401);
        }
        this.meg.proSvrVer = this.proSvrVer = this.meg.unmarshalSB1();
        switch (this.proSvrVer) {
            case 4: {
                this.oVersion = (short)7230;
                break;
            }
            case 5: {
                this.oVersion = (short)8030;
                break;
            }
            case 6: {
                this.oVersion = (short)8100;
                break;
            }
            default: {
                DBError.check_error((int)444);
            }
        }
        this.meg.unmarshalSB1();
        this.proSvrStr = this.meg.unmarshalTEXT(50);
        this.oVersion = this.getOracleVersion();
        this.svrCharSet = (short)this.meg.unmarshalUB2();
        this.svrFlags = (byte)this.meg.unmarshalUB1();
        this.svrCharSetElem = (short)this.meg.unmarshalUB2();
        if (this.svrCharSetElem > 0) {
            this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
        }
        this.svrInfoAvailable = true;
    }

    public short getOracleVersion() {
        return this.oVersion;
    }

    public short getCharacterSet() {
        return this.svrCharSet;
    }

    public byte getFlags() {
        return this.svrFlags;
    }

    public void printServerInfo(int mod, int submod, int category) {
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)" ---- Server's Information ---- ");
        if (this.svrInfoAvailable) {
            int i2 = 0;
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)("Protocol version :" + this.proSvrVer));
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)("oVersion :" + this.oVersion));
            StringWriter s2 = new StringWriter();
            s2.write("Protocol string  :");
            while (i2 < this.proSvrStr.length) {
                s2.write((char)this.proSvrStr[i2++]);
            }
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)s2.toString());
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)("Caracter Set ID  :" + this.svrCharSet));
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)("Remote flags     :" + this.svrFlags));
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)("Number of Elements in Server's Character Set Graph :" + this.svrCharSetElem));
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)"Don't expect the graph, we threw it away :-)");
        } else {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)" Not Available !!");
        }
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)category, (String)" ---- -------------------- ---- ");
    }

    public void marshal() throws SQLException, IOException {
        this.marshalTTCcode();
        this.meg.marshalB1Array(this.proCliVerTTC7);
        this.meg.marshalB1Array(this.proCliStrTTC7);
    }
}

