/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.PlsqlTTCDataSet;
import oracle.jdbc.ttc7.TTCDataSet;
import oracle.jdbc.ttc7.TTIMsg;
import oracle.jdbc.ttc7.TTIrxd;
import oracle.jdbc.ttc7.TTIrxh;

public class TTIiov
extends TTIMsg {
    protected TTIrxh rxh;
    protected TTIrxd rxd;
    private byte bindtype = 0;
    private byte[] iovector;
    private int bindcnt = 0;
    private int inbinds = 0;
    private int outbinds = 0;
    public static final byte BV_IN_V = 32;
    public static final byte BV_OUT_V = 16;

    public TTIiov(MAREngine _mrengine) throws SQLException, IOException {
        this.setMarshalingEngine(_mrengine);
        this.rxh = (TTIrxh)this.meg.types.newTTCMsgObject((byte)3, this.meg);
        this.rxd = new TTIrxd(this.meg);
    }

    public void init() throws SQLException, IOException {
    }

    public TTIrxd processRXD(PlsqlTTCDataSet _binds) throws SQLException, IOException {
        if (this.inbinds > 0 || this.outbinds > 0) {
            this.rxd.init((TTCDataSet)_binds, null);
            if (this.inbinds == 0) {
                if (this.meg.unmarshalSB1() != 7) {
                    DBError.check_error((int)401);
                }
                if (this.rxd.unmarshal()) {
                    DBError.check_error((int)425);
                }
            } else {
                this.rxd.marshal();
            }
        }
        return this.rxd;
    }

    public void unmarshal() throws IOException, SQLException {
        this.rxh.unmarshal();
        this.bindcnt = this.rxh.numRqsts;
        this.iovector = new byte[this.bindcnt];
        int i2 = 0;
        while (i2 < this.bindcnt) {
            this.bindtype = this.meg.unmarshalSB1();
            if (this.bindtype == 0) {
                DBError.check_error((int)401);
            }
            if ((this.bindtype & 0x20) > 0) {
                int n2 = i2;
                this.iovector[n2] = (byte)(this.iovector[n2] | 0x20);
                ++this.inbinds;
            }
            if ((this.bindtype & 0x10) > 0) {
                int n3 = i2;
                this.iovector[n3] = (byte)(this.iovector[n3] | 0x10);
                ++this.outbinds;
            }
            ++i2;
        }
    }

    public byte[] getIOVector() {
        return this.iovector;
    }

    public boolean isIOVectorEmpty() {
        return this.iovector.length == 0;
    }

    static {
        BV_IN_V = (byte)32;
        BV_OUT_V = (byte)16;
    }
}

