/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.Odscrarr;
import oracle.jdbc.ttc7.TTIMsg;
import oracle.jdbc.ttc7.TTIdty;
import oracle.jdbc.ttc7.TTIfun;
import oracle.jdbc.ttc7.TTIpro;
import oracle.jdbc.ttc7.TTIrxh;
import oracle.jdbc.ttc7.TTIuds;
import oracle.jdbc.ttc7.v8Odscrarr;
import oracle.jdbc.ttc7.v8TTIdty;
import oracle.jdbc.ttc7.v8TTIpro;
import oracle.jdbc.ttc7.v8TTIrxh;
import oracle.jdbc.ttc7.v8TTIuds;

public class TTCTypeRep {
    private short oVersion;
    public static final byte PRO = 1;
    public static final byte DTY = 2;
    public static final byte RXH = 3;
    public static final byte UDS = 4;
    public static final byte OAC = 5;
    public static final byte DSC = 1;
    public static final byte DTYDTY = 20;
    public static final byte DTYRXH8 = 21;
    public static final byte DTYUDS8 = 22;
    public static final byte DTYOAC8 = 23;
    public static final byte NATIVE = 0;
    public static final byte UNIVERSAL = 1;
    public static final byte LSB = 2;
    public static final byte MAXREP = 3;
    public static final byte B1 = 0;
    public static final byte B2 = 1;
    public static final byte B4 = 2;
    public static final byte PTR = 3;
    public static final byte MAXTYPE = 3;
    public byte[] rep;
    private final byte NUMREPS = (byte)4;
    private byte conversionFlags = 0;
    private boolean serverConversion = false;

    public TTCTypeRep() {
        this.rep = new byte[4];
        this.rep[0] = 0;
        int i2 = 1;
        while (i2 < 4) {
            this.rep[i2] = 1;
            ++i2;
        }
    }

    public void setRep(byte type, byte rep) throws SQLException {
        if (type < 0 || type > 3 || rep > 3) {
            DBError.check_error((int)407);
        }
        this.rep[type] = rep;
    }

    public byte getRep(byte type) throws SQLException {
        if (type < 0 || type > 3) {
            DBError.check_error((int)408);
        }
        return this.rep[type];
    }

    public void setFlags(byte flags) {
        this.conversionFlags = flags;
    }

    public byte getFlags() {
        return this.conversionFlags;
    }

    public boolean isConvNeeded() {
        boolean result = (this.conversionFlags & 2) > 0;
        return result;
    }

    public void setServerConversion(boolean conv) {
        this.serverConversion = conv;
    }

    public boolean isServerConversion() {
        return this.serverConversion;
    }

    public void setVersion(short version) {
        this.oVersion = version;
    }

    public short getVersion() {
        return this.oVersion;
    }

    public TTIfun newTTIFunObject(byte type, MAREngine mrengine) throws SQLException, IOException {
        Odscrarr obj = null;
        if (this.oVersion < 7230) {
            DBError.check_error((int)420);
        }
        switch (type) {
            case 1: {
                if (this.oVersion < 8030) {
                    obj = new Odscrarr(mrengine);
                    break;
                }
                obj = new v8Odscrarr(mrengine);
                break;
            }
            default: {
                DBError.check_error((int)422);
            }
        }
        return obj;
    }

    public TTIMsg newTTCMsgObject(byte type, MAREngine mrengine) throws SQLException, IOException {
        TTIpro obj = null;
        if (this.oVersion < 7230) {
            DBError.check_error((int)420);
        }
        switch (type) {
            case 1: {
                if (this.oVersion < 8030) {
                    obj = new TTIpro(mrengine);
                    break;
                }
                obj = new v8TTIpro(mrengine);
                break;
            }
            case 2: {
                if (this.oVersion < 8030) {
                    obj = new TTIdty(mrengine);
                    break;
                }
                obj = new v8TTIdty(mrengine);
                break;
            }
            case 3: {
                if (this.oVersion < 8030) {
                    obj = new TTIrxh(mrengine);
                    break;
                }
                obj = new v8TTIrxh(mrengine);
                break;
            }
            case 4: {
                if (this.oVersion < 8030) {
                    obj = new TTIuds(mrengine);
                    break;
                }
                obj = new v8TTIuds(mrengine);
                break;
            }
            default: {
                DBError.check_error((int)422);
            }
        }
        return obj;
    }

    static {
        PRO = 1;
        DTY = (byte)2;
        RXH = (byte)3;
        UDS = (byte)4;
        OAC = (byte)5;
        DSC = 1;
        DTYDTY = (byte)20;
        DTYRXH8 = (byte)21;
        DTYUDS8 = (byte)22;
        DTYOAC8 = (byte)23;
        NATIVE = 0;
        UNIVERSAL = 1;
        LSB = (byte)2;
        MAXREP = (byte)3;
        B1 = 0;
        B2 = 1;
        B4 = (byte)2;
        PTR = (byte)3;
        MAXTYPE = (byte)3;
    }
}

