/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.MAREngine;

public class TTCItem
extends DBItem {
    public MAREngine meg;
    private int type;

    protected TTCItem(MAREngine _mrengine, DBType _dbtype) {
        super(_dbtype.max_length);
        this.type = _dbtype.type;
        this.meg = _mrengine;
    }

    protected void setOriginalSize(int _originalsize) {
        this.original_size = _originalsize;
    }

    public void setArrayData(boolean null_flag, byte[] array_value, boolean isAdt) throws SQLException {
        this.setArrayData(null_flag, array_value);
    }

    public void setArrayData(boolean null_flag, byte[] array_value) throws SQLException {
        this.is_null = null_flag;
        if (array_value != null) {
            if (array_value.length > DBType.max_bind_array_length && ((this.type == 96 || this.type == 1) && array_value.length > this.max_out_size || this.type == 23 && array_value.length > this.max_out_size)) {
                DBError.throwSqlException((int)70, (Object)new Integer(array_value.length));
            }
            this.data_size = array_value.length;
            this.byte_value = array_value;
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    public void setArrayData(boolean null_flag, String str, int FormOfUse) throws SQLException {
        this.is_null = null_flag;
        if (str != null) {
            this.byte_value = this.StringToBytes(str, FormOfUse);
            this.data_size = this.byte_value.length;
            if ((this.type == 96 || this.type == 1) && this.data_size > this.max_out_size) {
                DBError.throwSqlException((int)70, (Object)new Integer(this.data_size));
            }
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    protected boolean isNull() {
        return this.is_null;
    }

    protected int getDataSize() {
        return this.data_size;
    }

    protected void marshal() throws IOException, SQLException {
        if (!(this.type != 113 && this.type != 112 && this.type != 114 || this.meg.proSvrVer < 6 || this.is_null)) {
            this.meg.marshalUB2(this.data_size);
        }
        this.meg.marshalCLR(this.byte_value, this.data_size);
    }

    public byte[] StringToBytes(String str, int FormOfUse) throws SQLException {
        byte[] result = FormOfUse == 2 ? this.meg.conv.StringToNCharBytes(str) : this.meg.conv.StringToCharBytes(str);
        return result;
    }

    public char[] getChars(short fo_use) throws SQLException {
        this.char_value = new char[this.data_size];
        this.char_size = fo_use == 2 ? this.meg.conv.NCHARBytesToJavaChars(this.byte_value, this.data_size, this.char_value) : this.meg.conv.CHARBytesToJavaChars(this.byte_value, this.data_size, this.char_value);
        return this.char_value;
    }

    protected void marshalPLSQL() throws IOException, SQLException {
        this.meg.marshalCLR(new byte[0], 0);
    }

    protected void unmarshal() throws IOException, SQLException {
        boolean ind = false;
        boolean bytes = false;
        int len = 0;
        if (this.byte_value == null) {
            DBError.check_error((int)401);
        }
        if ((this.type == 113 || this.type == 112 || this.type == 114) && this.meg.proSvrVer >= 6 && (len = this.meg.unmarshalUB2()) == 0) {
            this.is_null = true;
            return;
        }
        this.original_size = 0;
        this.data_size = 0;
        this.is_null = false;
        if (this.max_out_size == 0) {
            this.is_null = true;
            return;
        }
        int[] intArray = new int[1];
        Object resBuffer = null;
        this.meg.unmarshalCLR(this, intArray);
        this.data_size = intArray[0];
        this.is_null = intArray[0] <= 0;
    }

    public void unmarshalIndicator() throws IOException, SQLException {
        this.original_size = this.meg.processIndicator(this.is_null, this.data_size);
    }

    public void print(int mod, int submod, int cat) {
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"           ---- Enter: TTCItem.print --- ");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"             +++ TTCItem.DBItem  Information +++");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("             DBItem.byte_value is: " + (this.byte_value == null ? " NULL " : "Not NULL")));
        if (this.byte_value != null) {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("             DBItem.byte_value.length = " + this.byte_value.length));
        }
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("             DBItem.stream_value is: " + (this.stream_value == null ? " NULL " : "Not NULL")));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("             DBItem.data_size = " + this.data_size));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("             DBItem.original_size = " + this.original_size));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("             DBItem.max_out_size = " + this.max_out_size));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"             +++ End of TTCItem.DBItem  Info.+++");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"           ---- Exit: TTCItem.print --- ");
    }
}

