/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.TTCColumn;

public abstract class TTCDataSet {
    protected TTCColumn[] columns;
    protected int depth;
    protected int marshaledRows;
    protected int unmarshaledRows;
    protected int unmarshaledCols;

    protected TTCDataSet(TTCColumn[] cols, int depth) {
        this.columns = cols != null ? cols : new TTCColumn[]{};
        this.depth = depth;
    }

    protected void marshalTypes() throws IOException, SQLException {
        int i2 = 0;
        while (i2 < this.columns.length) {
            this.columns[i2].marshalType();
            ++i2;
        }
    }

    protected int numberOfColumns() {
        return this.columns.length;
    }

    public void incrementeUnmarshaledRows() {
        ++this.unmarshaledRows;
    }

    public void incrementUnmarshaledcols() {
        ++this.unmarshaledCols;
    }

    public boolean isLastCol() {
        boolean result = this.unmarshaledCols == this.columns.length - 1;
        return result;
    }

    protected void print(int mod, int submod, int cat) {
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"   ---- Enter: TTCDataSet.print --- ");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"     +++ Beginning of Columns Info +++++++ ");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("         columns.length = " + this.columns.length));
        int i2 = 0;
        while (i2 < this.columns.length) {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("Column # " + i2));
            this.columns[i2].print(mod, submod, cat);
            ++i2;
        }
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"     +++ End of Columns Info +++++++ ");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("     TTCDataSet.depth          =" + this.depth));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("     TTCDataSet.marshaledRows  =" + this.marshaledRows));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("     TTCDataSet.unmarshaledRows=" + this.unmarshaledRows));
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"   ---- Exit: TTCDataSet.print --- ");
    }

    protected abstract void marshalRow() throws SQLException, IOException;

    protected abstract boolean unmarshalRow() throws SQLException, IOException;

    protected boolean unmarshalRow(int from_col, int to_col) throws SQLException, IOException {
        return false;
    }

    protected void processIndicator() throws IOException, SQLException {
    }

    protected abstract boolean next() throws SQLException, IOException;
}

