/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.sql.SQLException;
import oracle.gss.util.NLSCharacter;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.driver.OracleLog;

public class TTCConversion
extends DBConversion {
    private int isServerCSMultiByte;
    private short m_oraVersion;
    private int m_c2sNlsRatio;
    private int m_s2cNlsRatio;
    private int m_sMaxCharSize;

    public TTCConversion(short svrCharSet, short accessCharSet, short oraVersion, short svrNCharSet) throws SQLException {
        super(svrCharSet, accessCharSet, svrNCharSet);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("TTCConversion.TTCConversion( " + svrCharSet + ", accessCharSet=" + accessCharSet + ", oraVersion=" + oraVersion + ") -- after super() --"));
        }
        this.m_oraVersion = oraVersion;
        this.m_c2sNlsRatio = NLSCharacter.getRatio((int)svrCharSet, (int)accessCharSet);
        this.m_s2cNlsRatio = NLSCharacter.getRatio((int)accessCharSet, (int)svrCharSet);
        this.m_sMaxCharSize = NLSCharacter.getRatio((int)svrCharSet, (int)1);
        this.isServerCSMultiByte = NLSCharacter.getRatio((int)svrCharSet, (int)1);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)32, (String)("TTCConversion.m_c2sNlsRatio=" + this.m_c2sNlsRatio + "TTCConversion.m_s2cNlsRatio=" + this.m_s2cNlsRatio));
        }
    }

    public short getOraVersion() {
        return this.m_oraVersion;
    }

    public boolean isServerMultiByte() {
        return this.isServerCSMultiByte != 1;
    }

    public int getNLSRATIO() {
        return this.m_c2sNlsRatio;
    }

    public int getServer2ClientNlsRatio() {
        return this.m_s2cNlsRatio;
    }

    public int getMaxCharSize() {
        return this.m_sMaxCharSize;
    }

    public static short findAccessCharSet(short svrCharSet, short oraVersion) {
        int dbaccess_charset = 0;
        switch (svrCharSet) {
            case 1: 
            case 31: 
            case 873: {
                dbaccess_charset = svrCharSet;
                break;
            }
            default: {
                dbaccess_charset = oraVersion >= 8030 ? 871 : 870;
            }
        }
        return (short)dbaccess_charset;
    }

    public byte[] StringToNetworkRep(String str) throws SQLException {
        return this.StringToCharBytes(str);
    }
}

