/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.NonPlsqlTTCColumn;
import oracle.jdbc.ttc7.NonPlsqlTTCDataSet;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.PlsqlTTCDataSet;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class TTCAdapter {
    private MAREngine meg;

    public TTCAdapter(MAREngine _mrengine) {
        this.meg = _mrengine;
    }

    public PlsqlTTCDataSet createPlsqlTTCDataSet(DBType[] _inTypes, DBData[] _inValues, DBType[] _outTypes, DBData[] _outValues) throws SQLException, IOException {
        DBType[] tmp_inTypes = _inTypes != null ? _inTypes : new DBType[]{};
        DBType[] tmp_outTypes = _outTypes != null ? _outTypes : new DBType[]{};
        DBData[] tmp_inValues = _inValues != null ? _inValues : new DBData[]{};
        DBData[] tmp_outValues = _outValues != null ? _outValues : new DBData[]{};
        int numBinds = tmp_inTypes.length > tmp_outTypes.length ? tmp_inTypes.length : tmp_outTypes.length;
        byte[] userIOVector = new byte[numBinds];
        PlsqlTTCColumn[] cols = this.createBindColumns(tmp_inTypes, tmp_inValues, tmp_outTypes, tmp_outValues, userIOVector);
        PlsqlTTCDataSet result = new PlsqlTTCDataSet(cols, userIOVector);
        return result;
    }

    private PlsqlTTCColumn[] createBindColumns(DBType[] _inTypes, DBData[] _inValues, DBType[] _outTypes, DBData[] _outValues, byte[] _userIOVector) throws SQLException, IOException {
        PlsqlTTCColumn[] cols = new PlsqlTTCColumn[_userIOVector.length];
        int i2 = 0;
        while (i2 < _userIOVector.length) {
            _userIOVector[i2] = 0;
            if (i2 < _inTypes.length && _inTypes[i2] == null && i2 < _outTypes.length && _outTypes[i2] == null) {
                DBError.check_error((int)435);
            }
            if (i2 < _outTypes.length && _outTypes[i2] != null) {
                if (_outValues == null || _outValues[i2] == null) {
                    DBError.check_error((int)435);
                }
                int n2 = i2;
                _userIOVector[n2] = (byte)(_userIOVector[n2] | 0x10);
                cols[i2] = new PlsqlTTCColumn(this.newTTCType(_outTypes[i2]));
            }
            if (i2 < _inTypes.length && _inTypes[i2] != null) {
                if (_inValues[i2] == null) {
                    DBError.check_error((int)435);
                }
                int n3 = i2;
                _userIOVector[n3] = (byte)(_userIOVector[n3] | 0x20);
                if (cols[i2] == null) {
                    cols[i2] = new PlsqlTTCColumn(this.newTTCType(_inTypes[i2]));
                }
            }
            if ((_userIOVector[i2] & 0x10) > 0) {
                cols[i2].setOUT(this.newTTCItem(_outValues[i2].getItem(0), _outTypes[i2]));
            }
            if ((_userIOVector[i2] & 0x20) > 0) {
                cols[i2].setIN(this.newTTCItem(_inValues[i2].getItem(0), _inTypes[i2]));
            }
            ++i2;
        }
        return cols;
    }

    public NonPlsqlTTCDataSet createNonPlsqlTTCDataSet(DBType[] _dbtypes, DBData[] _values, int _depth, boolean _mode) throws IOException, SQLException {
        DBType[] tmp_types = _dbtypes != null ? _dbtypes : new DBType[]{};
        DBData[] tmp_values = _values != null ? _values : new DBData[]{};
        int tmp_depth = tmp_values.length == 0 ? 0 : _depth;
        NonPlsqlTTCDataSet result = new NonPlsqlTTCDataSet(this.createNonPlsqlTTCColumnArray(tmp_types, tmp_values, tmp_depth, _mode), tmp_depth);
        return result;
    }

    private NonPlsqlTTCColumn[] createNonPlsqlTTCColumnArray(DBType[] _dbtype, DBData[] _data, int _depth, boolean _mode) throws IOException, SQLException {
        int numColumns = 0;
        if (_data != null && _data.length != 0 && _dbtype != null && _depth != 0) {
            numColumns = _data.length;
        }
        NonPlsqlTTCColumn[] cols = new NonPlsqlTTCColumn[numColumns];
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2] = new NonPlsqlTTCColumn(this.newTTCType(_dbtype[i2]), _depth, _mode, this.newTTCItemArray(_data[i2], _depth, _dbtype[i2]));
            ++i2;
        }
        return cols;
    }

    private TTIoac newTTCType(DBType _dbtype) throws IOException, SQLException {
        TTIoac oac = (TTIoac)_dbtype;
        oac.init(_dbtype);
        return oac;
    }

    private TTCItem[] newTTCItemArray(DBData _dbData, int _depth, DBType _dbType) throws SQLException, IOException {
        int len = _dbData.getNItems() == 0 ? 0 : _depth;
        TTCItem[] items = new TTCItem[len];
        int i2 = 0;
        while (i2 < items.length) {
            items[i2] = this.newTTCItem(_dbData.getItem(i2), _dbType);
            ++i2;
        }
        return items;
    }

    private TTCItem newTTCItem(DBItem _dbItem, DBType _dbType) throws SQLException, IOException {
        if (_dbItem == null || _dbType == null) {
            DBError.check_error((int)440);
        }
        return (TTCItem)_dbItem;
    }
}

