/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.ttc7.LongTTCItem;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.NonPlsqlTTCDataSet;
import oracle.jdbc.ttc7.NtyTTCItem;
import oracle.jdbc.ttc7.O3log;
import oracle.jdbc.ttc7.Oall7;
import oracle.jdbc.ttc7.Oclose;
import oracle.jdbc.ttc7.Ocommoncall;
import oracle.jdbc.ttc7.Odscrarr;
import oracle.jdbc.ttc7.Okod;
import oracle.jdbc.ttc7.Oopen;
import oracle.jdbc.ttc7.Oversion;
import oracle.jdbc.ttc7.PlsqlTTCDataSet;
import oracle.jdbc.ttc7.RefCursorTTCItem;
import oracle.jdbc.ttc7.RefTTCItem;
import oracle.jdbc.ttc7.TTCAdapter;
import oracle.jdbc.ttc7.TTCConversion;
import oracle.jdbc.ttc7.TTCDataSet;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTCStatement;
import oracle.jdbc.ttc7.TTIdty;
import oracle.jdbc.ttc7.TTIoac;
import oracle.jdbc.ttc7.TTIrxd;
import oracle.jdbc.ttc7.v8TTIBfile;
import oracle.jdbc.ttc7.v8TTIBlob;
import oracle.jdbc.ttc7.v8TTIClob;
import oracle.jdbc.ttc7.v8TTIoac;
import oracle.jdbc.ttc7.v8TTIpro;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class TTC7Protocol
extends DBAccess {
    public static final short MIN_OVERSION_SUPPORTED = 7230;
    public static final short MIN_TTCVER_SUPPORTED = 4;
    public static final short V8_TTCVER_SUPPORTED = 5;
    public static final short MAX_TTCVER_SUPPORTED = 6;
    private static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    private static final int STREAM_CHUNK_SIZE = 255;
    public static final int REFCURSOR_SIZE = 5;
    protected long LOGON_MODE = 0L;
    private static final long SYSDBA = 8L;
    private static final long SYSOPER = 16L;
    protected static final byte PARSE_CALL = 1;
    protected static final byte PARSE_EXECUTE_CALL = 2;
    protected static final byte EXECUTE_FETCH_CALL = 3;
    protected static final byte PARSE_EXECUTE_FETCH_CALL = 4;
    protected static final byte FETCH_CALL = 5;
    private final byte TTC_NOTLOGGEDON = 0;
    private final byte TTC_LOGGEDON = 1;
    private byte state = 0;
    private Communication net;
    private boolean readAsNonStream;
    private MAREngine MEngine;
    private v8TTIpro pro;
    private TTIdty dty;
    private TTIrxd rxd;
    private O3log log1;
    private O3log log2;
    private Oversion ver;
    private Oopen opencall;
    private Odscrarr describe;
    private Oall7 all7;
    private Oclose close;
    private Ocommoncall commoncall;
    private v8TTIBfile bfileMsg;
    private v8TTIBlob blobMsg;
    private v8TTIClob clobMsg;
    private OracleConnection m_connection;
    private byte[] EMPTY_BYTE = new byte[0];

    public synchronized DBConversion logon(String user, String password, String connection, Properties info) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            String pw = "******";
            StringWriter props = new StringWriter();
            if (info != null) {
                info.list(new PrintWriter(props));
            }
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.logon(" + user + ", " + pw + ", " + connection + ", " + props.toString() + ")"));
        }
        try {
            if (this.state > 0) {
                DBError.check_error((int)428);
            }
            if (user == null || password == null) {
                DBError.check_error((int)433);
            }
            if (user.length() == 0 || password.length() == 0) {
                DBError.check_error((int)443);
            }
            if (connection == null) {
                connection = DEFAULT_CONNECT_STRING;
            }
            this.connect(connection, info);
            this.all7 = new Oall7(this.MEngine);
            this.commoncall = new Ocommoncall(this.MEngine);
            this.opencall = new Oopen(this.MEngine);
            this.close = new Oclose(this.MEngine);
            this.describe = (Odscrarr)this.MEngine.types.newTTIFunObject((byte)1, this.MEngine);
            this.bfileMsg = new v8TTIBfile(this.MEngine);
            this.blobMsg = new v8TTIBlob(this.MEngine);
            this.clobMsg = new v8TTIClob(this.MEngine);
            this.dty = (TTIdty)this.MEngine.types.newTTCMsgObject((byte)2, this.MEngine);
            this.dty.marshal();
            this.dty.receive();
            String logon_mode = (String)info.get("internal_logon");
            if (logon_mode != null) {
                if (logon_mode.equalsIgnoreCase("sysoper")) {
                    this.LOGON_MODE = 16L;
                } else if (logon_mode.equalsIgnoreCase("sysdba")) {
                    this.LOGON_MODE = 8L;
                }
            }
            this.log1 = new O3log(this.MEngine, user, info, this.LOGON_MODE);
            this.log1.marshal();
            this.log1.receive1st();
            this.log2 = new O3log(this.MEngine, user, password, this.log1.encryptedSK, info, this.LOGON_MODE);
            this.log2.marshal();
            while (true) {
                try {
                    this.log2.receive2nd();
                }
                catch (SQLWarning ea) {
                    this.connectionWarning = DBError.addSqlWarning((SQLWarning)this.getConnectionWarning(), (SQLWarning)ea);
                    continue;
                }
                break;
            }
            this.net.setO3logSessionKey(this.log2.getSessionKey());
            this.ver = new Oversion(this.MEngine);
            this.ver.marshal();
            this.ver.receive();
            short versionNumber = this.ver.getVersionNumber();
            if (versionNumber < 7230) {
                DBError.check_error((int)441);
            }
            this.MEngine.types.setVersion(versionNumber);
            this.state = 1;
            return this.MEngine.conv;
        }
        catch (SQLException se) {
            try {
                this.net.disconnect();
            }
            catch (Exception e2) {
                // empty catch block
            }
            this.state = 0;
            throw se;
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
            throw ioe;
        }
    }

    public synchronized void logoff() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.logoff()");
        }
        if (this.state < 1) {
            DBError.check_error((int)429);
        }
        try {
            this.commoncall.init((byte)9);
            this.commoncall.marshal();
            this.commoncall.receive();
            this.net.disconnect();
            this.state = 0;
        }
        catch (IOException ea) {
            this.handleIOException(ea);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.logoff(): return");
        }
    }

    public synchronized void commit() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.commit()");
        }
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        try {
            this.commoncall.init((byte)14);
            this.commoncall.marshal();
            this.commoncall.receive();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.commit(): return");
        }
    }

    public synchronized void rollback() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.rollback()");
        }
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        try {
            this.commoncall.init((byte)15);
            this.commoncall.marshal();
            this.commoncall.receive();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.rollback(): return");
        }
    }

    public synchronized void setAutoCommit(boolean on) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.setAutoCommit(" + on + ")"));
        }
        this.all7.autoCommitSet = on;
    }

    public synchronized DBStatement open() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.open()");
        }
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        TTCStatement stmt = null;
        try {
            this.opencall.init();
            this.opencall.marshal();
            int cursorid = this.opencall.receive();
            stmt = new TTCStatement(cursorid);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.open: return " + stmt));
        }
        return stmt;
    }

    public synchronized void closeQuery(DBStatement stmt) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.closeQuery(" + stmt + ")"));
        }
        TTCStatement ttcStmt = (TTCStatement)stmt;
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        try {
            this.close.init(ttcStmt, (byte)20);
            this.close.marshal();
            this.close.receive();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.closeQuery: return");
        }
    }

    public synchronized void close(DBStatement stmt) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.close(" + stmt + ")"));
        }
        TTCStatement ttcStmt = (TTCStatement)stmt;
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        try {
            this.close.init(ttcStmt, (byte)8);
            this.close.marshal();
            this.close.receive();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.close: return");
        }
    }

    public synchronized DBColumn[] describe(DBStatement stmt) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.describe(" + stmt + ")"));
        }
        if (stmt == null) {
            DBError.check_error((int)433);
        }
        TTCStatement ttcStmt = (TTCStatement)stmt;
        int colOffset = 0;
        DBColumn[] dbcols = null;
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        try {
            do {
                this.describe.init(ttcStmt, colOffset);
                this.describe.marshal();
            } while ((colOffset += this.describe.numuds) < (dbcols = this.describe.receive(dbcols)).length);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.describe: return: " + dbcols));
        }
        return dbcols;
    }

    public synchronized DBColumn[] parseExecuteDescribe(DBStatement dbstmt, byte[] sqlStmt, DBDataSet inDBSet) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.parseExecuteDescribe(" + dbstmt + ", " + sqlStmt + ", " + inDBSet + ")"));
        }
        DBType[] inTypes = null;
        DBData[] inValues = null;
        if (inDBSet != null) {
            inTypes = ((DBDataSetImpl)inDBSet).getDBTypes();
            inValues = ((DBDataSetImpl)inDBSet).getDBData();
        }
        if (dbstmt == null || sqlStmt == null) {
            DBError.check_error((int)433);
        }
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        try {
            try {
                this.doOall7((byte)2, (byte)0, ((TTCStatement)dbstmt).getCursor(), sqlStmt, inTypes, inValues, 1, null, null, 0);
                this.all7.release(false);
            }
            catch (SQLException e2) {
                this.all7.release(false);
                throw e2;
            }
            catch (IOException e3) {
                throw e3;
            }
            Object var9_6 = null;
            dbstmt.rows_processed = this.all7.rowsProcessed;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            dbstmt.rows_processed = this.all7.rowsProcessed;
            throw throwable;
        }
        DBColumn[] columns = this.describe(dbstmt);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.parseExecuteDescribe: return: " + columns));
        }
        return columns;
    }

    public synchronized int executeFetch(DBStatement dbstmt, byte type, DBDataSet inDBSet, int inDepth, DBDataSet outDBSet, int outDepth) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.executeFetch(" + dbstmt + ", " + type + ", " + inDBSet + ", " + inDepth + ", " + outDBSet + ", " + outDepth + ")"));
        }
        DBType[] inTypes = null;
        DBData[] inValues = null;
        DBType[] outTypes = null;
        DBData[] outValues = null;
        if (inDBSet != null) {
            inTypes = ((DBDataSetImpl)inDBSet).getDBTypes();
            inValues = ((DBDataSetImpl)inDBSet).getDBData();
        }
        if (outDBSet != null) {
            outTypes = ((DBDataSetImpl)outDBSet).getDBTypes();
            outValues = ((DBDataSetImpl)outDBSet).getDBData();
        }
        if (dbstmt == null || type < 0 || type > 4) {
            DBError.check_error((int)433);
        }
        try {
            try {
                this.doOall7((byte)3, type, ((TTCStatement)dbstmt).getCursor(), this.EMPTY_BYTE, inTypes, inValues, inDepth, outTypes, outValues, outDepth);
            }
            catch (SQLException e2) {
                this.all7.release(false);
                throw e2;
            }
            catch (IOException e3) {
                this.all7.release(false);
                this.handleIOException(e3);
                throw e3;
            }
            Object var14_11 = null;
            dbstmt.rows_processed = this.all7.rowsProcessed;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            dbstmt.rows_processed = this.all7.rowsProcessed;
            throw throwable;
        }
        int nRows = this.all7.getNumRows();
        this.all7.release(nRows == -2);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.executeFetch: return: " + nRows));
        }
        return nRows;
    }

    public synchronized int parseExecuteFetch(DBStatement dbstmt, byte type, byte[] sqlStmt, DBDataSet inDBSet, int inDepth, DBDataSet outDBSet, int outDepth) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.parseExecuteFetch(" + dbstmt + ", " + type + ", " + sqlStmt + ", " + inDBSet + ", " + inDepth + ", " + outDBSet + ", " + outDepth + ")"));
        }
        DBType[] inTypes = null;
        DBData[] inValues = null;
        DBType[] outTypes = null;
        DBData[] outValues = null;
        if (inDBSet != null) {
            inTypes = ((DBDataSetImpl)inDBSet).getDBTypes();
            inValues = ((DBDataSetImpl)inDBSet).getDBData();
        }
        if (outDBSet != null) {
            outTypes = ((DBDataSetImpl)outDBSet).getDBTypes();
            outValues = ((DBDataSetImpl)outDBSet).getDBData();
        }
        if (dbstmt == null || sqlStmt == null || type < 0 || type > 4) {
            DBError.check_error((int)433);
        }
        try {
            try {
                this.doOall7((byte)4, type, ((TTCStatement)dbstmt).getCursor(), sqlStmt, inTypes, inValues, inDepth, outTypes, outValues, outDepth);
            }
            catch (SQLException e2) {
                this.all7.release(false);
                throw e2;
            }
            catch (IOException e3) {
                this.all7.release(false);
                this.handleIOException(e3);
                throw e3;
            }
            Object var15_12 = null;
            dbstmt.rows_processed = this.all7.rowsProcessed;
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            dbstmt.rows_processed = this.all7.rowsProcessed;
            throw throwable;
        }
        int nRows = this.all7.getNumRows();
        this.all7.release(nRows == -2);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.paresExecuteFetch: return : " + nRows));
        }
        return nRows;
    }

    public synchronized int fetch(DBStatement dbstmt, DBDataSet outDBSet, int outDepth) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fetch(" + dbstmt + ", " + outDBSet + ", " + outDepth + ")"));
        }
        DBType[] outTypes = null;
        DBData[] outValues = null;
        if (outDBSet != null) {
            outTypes = ((DBDataSetImpl)outDBSet).getDBTypes();
            outValues = ((DBDataSetImpl)outDBSet).getDBData();
        }
        if (dbstmt == null) {
            DBError.check_error((int)433);
        }
        int nRows = 0;
        try {
            this.doOall7((byte)5, (byte)0, ((TTCStatement)dbstmt).getCursor(), this.EMPTY_BYTE, null, null, 0, outTypes, outValues, outDepth);
            nRows = this.all7.getNumRows();
            this.all7.release(nRows == -2);
        }
        catch (IOException ioe) {
            this.all7.release(false);
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fetch: return: " + nRows));
        }
        return nRows;
    }

    public synchronized int fetch(DBStatement dbstmt, DBDataSet outDBSet, int from_col, int to_col) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fetch(" + dbstmt + ", " + outDBSet + ", " + from_col + ", " + to_col + ")"));
        }
        int nRows = 0;
        try {
            this.all7.rxd.unmarshal(from_col - 1, to_col - 1);
            if (this.all7.rxd.rxdDataSet.isLastCol() && !this.all7.getColumnsUptoNextSream()) {
                this.all7.release(false);
            }
            nRows = 1;
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fetch: return: " + nRows));
        }
        return nRows;
    }

    public synchronized int read(DBStatement dbstmt, byte[] buffer, int length) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.read(" + dbstmt + ", " + buffer + ", " + length + ")"));
        }
        int bytesToRead = -1;
        TTCStatement stmt = (TTCStatement)dbstmt;
        try {
            if (!this.readAsNonStream) {
                if (this.state < 1) {
                    DBError.check_error((int)430);
                }
                if (this.all7 == null || length > 255 || length < 0) {
                    DBError.check_error((int)433);
                }
                if (!this.all7.streamingOn) {
                    DBError.check_error((int)433);
                }
                bytesToRead = this.all7.meg.unmarshalUB1();
                if (stmt.isHeader()) {
                    if (!this.all7.meg.escapeSequenceNull(bytesToRead)) {
                        if (bytesToRead == 254) {
                            bytesToRead = this.all7.meg.unmarshalUB1();
                        } else {
                            this.readAsNonStream = true;
                        }
                    } else {
                        bytesToRead = -1;
                    }
                    stmt.headerRead();
                }
            } else {
                this.readAsNonStream = false;
            }
            if (bytesToRead > 0) {
                this.all7.meg.unmarshalNBytes(buffer, 0, bytesToRead);
            } else {
                bytesToRead = -1;
                stmt.headerReset();
            }
            if (bytesToRead == -1) {
                this.all7.rxd.rxdDataSet.incrementUnmarshaledcols();
                this.all7.rxd.rxdDataSet.processIndicator();
                if (this.all7.rxd.rxdDataSet.isLastCol()) {
                    this.all7.getColumnsUptoNextSream();
                    this.all7.rxd.rxdDataSet.incrementeUnmarshaledRows();
                }
            }
        }
        catch (IOException ioe) {
            this.all7.rxd.rxdDataSet = null;
            this.handleIOException(ioe);
        }
        if (bytesToRead == -1 && this.all7.rxd.rxdDataSet.isLastCol()) {
            this.all7.release(false);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.read: return: " + bytesToRead));
        }
        return bytesToRead;
    }

    public synchronized byte[] getVersion() throws SQLException {
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        byte[] result = this.ver.getVersion();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getVersion(): " + result));
        }
        return result;
    }

    public synchronized short getVersionNumber() throws SQLException {
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        short result = this.ver.getVersionNumber();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getVersionNumber(): " + result));
        }
        return result;
    }

    public synchronized int getNlsRatio() {
        int result = this.MEngine.conv.getServer2ClientNlsRatio();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getNlsRatio(): " + result));
        }
        return result;
    }

    public synchronized int getC2SNlsRatio() {
        int result = this.MEngine.conv.getNLSRATIO();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getC2SNlsRatio(): " + result));
        }
        return result;
    }

    public synchronized int getDefaultPrefetch() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.getDefaultPrefetch(): 10");
        }
        return 10;
    }

    public synchronized int getDefaultStreamChunkSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.getDefaultStreamChunkSize(): 255");
        }
        return 255;
    }

    public void cancel() throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.cancel()");
        }
        try {
            this.net.sendBreak();
            this.MEngine.sentCancel = true;
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public synchronized DBStatement RefCursorBytesToDBStatement(byte[] refCursor) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.RefCursorBytesToDBStatement(" + refCursor + ")"));
        }
        TTCStatement stmt = null;
        try {
            stmt = new TTCStatement(this.MEngine.unmarshalRefCursor(refCursor));
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.RefCursorBytesToDBStatement: return: " + stmt));
        }
        return stmt;
    }

    public synchronized byte[] DBStatementToRefCursorBytes(DBStatement dbstmt) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.DBStatementToRefCursorBytes(" + dbstmt + ")"));
        }
        byte[] tmpBuffer = new byte[4];
        byte bytes = 0;
        try {
            bytes = this.MEngine.value2Buffer(((TTCStatement)dbstmt).getCursor(), tmpBuffer, (byte)2);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.DBStatementToRefCursorBytes: return: " + tmpBuffer));
        }
        return tmpBuffer;
    }

    public synchronized void initNls(OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.initNls(" + conn + ")"));
        }
        this.m_connection = conn;
        this.all7.autoCommitSet = conn.getAutoCommit();
        this.setNlsParamsClient(conn);
    }

    public int getMinAsciiStreamSize(OracleConnection conn, int min_ascii_stream_size) {
        int result = min_ascii_stream_size / this.getC2SNlsRatio();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getMinAsciiStreamSize(" + conn + ", " + min_ascii_stream_size + "): " + result));
        }
        return result;
    }

    private void connect(String connection, Properties userProperties) throws IOException, SQLException {
        if (connection == null || userProperties == null) {
            DBError.check_error((int)433);
        }
        this.net = new NSProtocol();
        try {
            this.net.connect(connection, userProperties);
        }
        catch (NetException ne) {
            throw new IOException(ne.getMessage());
        }
        this.MEngine = new MAREngine(this.net);
        this.pro = new v8TTIpro(this.MEngine);
        this.pro.marshal();
        this.pro.receive();
        short oVersion = this.pro.getOracleVersion();
        short ServerCharSet = this.pro.getCharacterSet();
        short accessCharSet = TTCConversion.findAccessCharSet((short)ServerCharSet, (short)oVersion);
        TTCConversion _conv = new TTCConversion(ServerCharSet, accessCharSet, oVersion, this.pro.getncharCHARSET());
        this.MEngine.types.setServerConversion(accessCharSet != ServerCharSet);
        this.MEngine.types.setVersion(oVersion);
        if (TTCConversion.isCharSetMultibyte((short)accessCharSet)) {
            if (TTCConversion.isCharSetMultibyte((short)this.pro.getCharacterSet())) {
                this.MEngine.types.setFlags((byte)1);
            } else {
                this.MEngine.types.setFlags((byte)2);
            }
        } else {
            this.MEngine.types.setFlags(this.pro.getFlags());
        }
        this.MEngine.conv = _conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOall7(byte call, byte type, int cursor, byte[] sqlStmt, DBType[] inTypes, DBData[] inValues, int inDepth, DBType[] outTypes, DBData[] outValues, int outDepth) throws SQLException, IOException {
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
        try {
            try {
                if (type != 1 && type != 3 && type != 4 && type != 0 && type != 2) {
                    DBError.check_error((int)439);
                }
                TTCAdapter adapter = new TTCAdapter(this.MEngine);
                PlsqlTTCDataSet binds = null;
                NonPlsqlTTCDataSet defines = null;
                if (type == 1 || type == 3) {
                    binds = adapter.createPlsqlTTCDataSet(inTypes, inValues, outTypes, outValues);
                    defines = adapter.createNonPlsqlTTCDataSet(outTypes, outValues, 0, false);
                } else {
                    binds = adapter.createNonPlsqlTTCDataSet(inTypes, inValues, inDepth, true);
                    defines = adapter.createNonPlsqlTTCDataSet(outTypes, outValues, outDepth, false);
                }
                this.all7.init(call, type, cursor, sqlStmt, (TTCDataSet)binds, (TTCDataSet)defines, inDepth);
                this.all7.marshal();
                if (call != 3) {
                    this.all7.defines.marshalTypes();
                }
                this.all7.binds.marshalTypes();
                this.all7.rxd.init((TTCDataSet)binds, (TTCDataSet)defines);
                while (this.all7.binds.next()) {
                    this.all7.rxd.marshal();
                }
                try {
                    this.all7.receive();
                }
                catch (SQLException ea) {
                    if (ea.getErrorCode() == DBError.getVendorCode((int)110)) {
                        this.statementWarning = DBError.addSqlWarning((SQLWarning)this.getStatementWarning(), (int)110);
                    }
                    throw ea;
                }
                Object var16_16 = null;
                this.MEngine.sentCancel = false;
            }
            catch (IOException ioe) {
                this.handleIOException(ioe);
                Object var16_17 = null;
                this.MEngine.sentCancel = false;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            this.MEngine.sentCancel = false;
            throw throwable;
        }
    }

    public synchronized void startup(String startup_str, int mode) throws SQLException {
    }

    public synchronized void shutdown(int mode) throws SQLException {
    }

    public synchronized void archive(int mode, int aseq, String acstext) throws SQLException {
    }

    public synchronized void getOracleTypeADT(OracleTypeADT otype) throws SQLException {
    }

    public synchronized void getObjectValueFromRef(DBItem ref_item, DBType ref_type, DBItem value_item, DBType value_type) throws SQLException {
        value_type.otype = new OracleTypeADT(((OracleTypeADT)ref_type.otype).getFullName(), (Connection)((OracleTypeADT)ref_type.otype).getConnection());
        try {
            Okod oko = new Okod(this.MEngine, ref_item, value_item);
            oko.marshal();
            oko.receive();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public synchronized void setObjectValueFromRef(DBItem ref_item, DBType ref_type, DBItem value_item, DBType value_type) throws SQLException {
    }

    public synchronized DBType createDBType(int type, boolean isBind, short formOfUseType) throws SQLException {
        v8TTIoac obj = null;
        short oVersion = this.MEngine.types.getVersion();
        if (oVersion < 8030) {
            if (formOfUseType == 2) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)32, (int)4, (String)"You can not use the NCHAR form with a database older than 8i. An exception is thrown");
                }
                DBError.throwSqlException((int)5);
            }
            TTIoac oac = new TTIoac(type, this.MEngine, 7230);
            if (isBind) {
                oac.setFieldsForBinds(type, this.getC2SNlsRatio());
            }
            obj = oac;
        } else {
            v8TTIoac v8oac = new v8TTIoac(type, this.MEngine, 8030);
            if (isBind) {
                v8oac.setFieldsForBinds(type, this.getC2SNlsRatio(), formOfUseType);
            }
            obj = v8oac;
        }
        return obj;
    }

    public synchronized DBType createDBType(int type, boolean isBind) throws SQLException {
        return this.createDBType(type, isBind, (short)1);
    }

    public synchronized DBType createDBType(int type, boolean isInBind, boolean isPlsql) throws SQLException {
        TTIoac obj = (TTIoac)this.createDBType(type, true);
        if (isPlsql) {
            obj.setPlsqlMaxLength();
        }
        return obj;
    }

    public synchronized DBItem createDBItem(DBType _dbType) {
        LongTTCItem item;
        int type = _dbType.is_stream ? 8 : _dbType.type;
        switch (type) {
            case 8: {
                item = new LongTTCItem(this.MEngine, _dbType);
                break;
            }
            case 109: {
                item = new NtyTTCItem(this.MEngine, _dbType);
                break;
            }
            case 111: {
                item = new RefTTCItem(this.MEngine, _dbType);
                break;
            }
            case 102: {
                item = new RefCursorTTCItem(this.MEngine, _dbType);
                break;
            }
            default: {
                item = new TTCItem(this.MEngine, _dbType);
            }
        }
        return item;
    }

    protected void assertLoggedIn(String caller) throws SQLException {
        if (this.state < 1) {
            DBError.check_error((int)430);
        }
    }

    protected void assertNotNull(byte[] bytes, String caller) throws NullPointerException {
        if (this.state < 1) {
            throw new NullPointerException("lob locator bytes are null");
        }
    }

    public synchronized long lobWrite(BLOB blob, long offset, byte[] buffer, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobWrite(oracle.sql.BLOB blob, " + offset + ", byte[] buffer, " + length + ")"));
            OracleLog.print((Object)this, (int)32, (int)256, (int)32, (String)("TTC7Protocol.lobWrite(blob=" + blob + ", offset=" + offset + ", " + OracleLog.bytesToPrintableForm("buffer[]=", buffer) + ", length=" + length + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobWrite");
        this.assertNotNull(blob.shareBytes(), "TTC7Protocol.lobWrite");
        try {
            result = this.blobMsg.write(blob.shareBytes(), offset, (long)length, buffer);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobWrite: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobWrite:return: " + result));
        }
        return result;
    }

    public synchronized long lobWrite(CLOB clob, long offset, char[] buffer, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobWrite(oracle.sql.CLOB clob, " + offset + ", char[] buffer, " + length + ")"));
            OracleLog.print((Object)this, (int)32, (int)256, (int)64, (String)("TTC7Protocol.lobWrite(clob=" + clob + ", offset=" + offset + ", " + OracleLog.bytesToPrintableForm("buffer[]=", OracleLog.charsToUcs2Bytes(buffer)) + ", length=" + length + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobWrite");
        this.assertNotNull(clob.shareBytes(), "TTC7Protocol.lobWrite");
        try {
            boolean isNCLOB = clob.isNCLOB();
            result = this.clobMsg.write(clob.shareBytes(), offset, (long)length, isNCLOB, buffer);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobWrite: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobWrite:return: " + result));
        }
        return result;
    }

    public synchronized long lobRead(BLOB blob, long offset, long amount, byte[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobRead(oracle.sql.BLOB blob, offset=" + offset + ", amount=" + amount + ", byte[] buffer)"));
            OracleLog.print((Object)this, (int)32, (int)256, (int)64, (String)("TTC7Protocol.lobRead(blob=" + blob + ", offset, amount, " + OracleLog.bytesToPrintableForm("byte[] buffer=", buffer) + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobRead");
        this.assertNotNull(blob.shareBytes(), "TTC7Protocol.lobRead");
        try {
            result = this.blobMsg.read(blob.shareBytes(), offset, amount, buffer);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobRead: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobRead:return: " + result));
        }
        return result;
    }

    public synchronized long lobRead(BFILE bfile, long offset, long amount, byte[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobRead(oracle.sql.BFILE bfile, offset=" + offset + ", amount=" + amount + ", byte[] buffer)"));
            OracleLog.print((Object)this, (int)32, (int)256, (int)64, (String)("TTC7Protocol.lobRead(bfile=" + bfile + ", offset, amount, " + OracleLog.bytesToPrintableForm("byte[] buffer=", buffer) + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobRead");
        this.assertNotNull(bfile.shareBytes(), "TTC7Protocol.lobRead");
        try {
            result = this.bfileMsg.read(bfile.shareBytes(), offset, amount, buffer);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobRead: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobRead:return: " + result));
        }
        return result;
    }

    public synchronized long lobRead(CLOB clob, long offset, long amount, char[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobRead(oracle.sql.CLOB clob, offset=" + offset + ", amount=" + amount + ", char[] buffer)"));
            OracleLog.print((Object)this, (int)32, (int)256, (int)64, (String)("TTC7Protocol.lobRead(clob=" + clob + ", offset, amount, " + OracleLog.bytesToPrintableForm("buffer[]=", OracleLog.charsToUcs2Bytes(buffer)) + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobRead");
        this.assertNotNull(clob.shareBytes(), "TTC7Protocol.lobRead");
        try {
            boolean isNCLOB = clob.isNCLOB();
            result = this.clobMsg.read(clob.shareBytes(), offset, amount, isNCLOB, buffer);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobRead: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobRead:return: " + result));
        }
        return result;
    }

    public synchronized long lobLength(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobLength(" + blob + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobLength");
        this.assertNotNull(blob.shareBytes(), "TTC7Protocol.lobLength");
        try {
            result = this.blobMsg.getLength(blob.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobLength: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobLength:return: " + result));
        }
        return result;
    }

    public synchronized long lobLength(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobLength(" + bfile + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobLength");
        this.assertNotNull(bfile.shareBytes(), "TTC7Protocol.lobLength");
        try {
            result = this.bfileMsg.getLength(bfile.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobLength: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobLength:return: " + result));
        }
        return result;
    }

    public synchronized long lobLength(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobLength(" + clob + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.lobLength");
        this.assertNotNull(clob.shareBytes(), "TTC7Protocol.lobLength");
        try {
            result = this.clobMsg.getLength(clob.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.lobLength: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.lobLength:return: " + result));
        }
        return result;
    }

    public synchronized void fileOpen(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fileOpen(" + bfile + ")"));
        }
        this.assertLoggedIn("TTC7Protocol.fileOpen");
        this.assertNotNull(bfile.shareBytes(), "TTC7Protocol.fileOpen");
        try {
            this.bfileMsg.open(bfile.shareBytes(), 11);
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.fileOpen: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.fileOpen:return");
        }
    }

    public synchronized boolean fileIsOpen(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fileIsOpen(" + bfile + ")"));
        }
        boolean result = false;
        this.assertLoggedIn("TTC7Protocol.fileIsOpen");
        this.assertNotNull(bfile.shareBytes(), "TTC7Protocol.fileIsOpen");
        try {
            result = this.bfileMsg.isOpen(bfile.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.fileIsOpen: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fileIsOpen:return: " + result));
        }
        return result;
    }

    public synchronized boolean fileExists(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fileExists(" + bfile + ")"));
        }
        boolean result = false;
        this.assertLoggedIn("TTC7Protocol.fileExists");
        this.assertNotNull(bfile.shareBytes(), "TTC7Protocol.fileExists");
        try {
            result = this.bfileMsg.doesExist(bfile.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.fileExists: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fileExists:return: " + result));
        }
        return result;
    }

    public synchronized void fileClose(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.fileClose(" + bfile + ")"));
        }
        this.assertLoggedIn("TTC7Protocol.fileClose");
        this.assertNotNull(bfile.shareBytes(), "TTC7Protocol.fileClose");
        try {
            this.bfileMsg.close(bfile.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.fileClose: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.fileClose:return");
        }
    }

    public synchronized long getLobChunkSize(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getLobChunkSize(" + blob + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.getLobChunkSize");
        this.assertNotNull(blob.shareBytes(), "TTC7Protocol.getLobChunkSize");
        try {
            result = this.blobMsg.getChunkSize(blob.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.getLobChunkSize: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getLobChunkSize:return: " + result));
        }
        return result;
    }

    public synchronized long getLobChunkSize(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getLobChunkSize(" + clob + ")"));
        }
        long result = 0L;
        this.assertLoggedIn("TTC7Protocol.getLobChunkSize");
        this.assertNotNull(clob.shareBytes(), "TTC7Protocol.getLobChunkSize");
        try {
            result = this.clobMsg.getChunkSize(clob.shareBytes());
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.getLobChunkSize: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.getLobChunkSize:return: " + result));
        }
        return result;
    }

    public synchronized void trimLob(Connection conn, Datum lob, int type, long newlen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.trimLob(Connection conn, oracle.sql.Datum lob, type=" + type + ", newlen=" + newlen + ")"));
            OracleLog.print((Object)this, (int)32, (int)256, (int)64, (String)("TTC7Protocol.trimLob(conn=" + conn + ", lob=" + lob + ", type=" + type + ", newlen=" + newlen + ")"));
        }
        this.assertLoggedIn("TTC7Protocol.trimLob");
        this.assertNotNull(lob.shareBytes(), "TTC7Protocol.trimLob");
        try {
            switch (type) {
                case -13: {
                    this.bfileMsg.trim(lob.shareBytes(), newlen);
                    break;
                }
                case 2004: {
                    this.blobMsg.trim(lob.shareBytes(), newlen);
                    break;
                }
                case 2005: {
                    this.clobMsg.trim(lob.shareBytes(), newlen);
                    break;
                }
                default: {
                    DBError.check_error((int)438);
                    break;
                }
            }
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.trimLob: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.trimLob:return");
        }
    }

    public synchronized Datum createTemporaryLob(Connection conn, boolean cache, int duration, int type, short form) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.createTemporaryLob(conn=" + conn + ", cache=" + cache + ", duration=" + duration + ", type=" + type + ", form=" + form + ")"));
        }
        Datum result = null;
        this.assertLoggedIn("TTC7Protocol.createTemporaryLob");
        try {
            switch (type) {
                case -13: {
                    result = this.bfileMsg.createTemporaryLob(conn, cache, duration);
                    break;
                }
                case 2004: {
                    result = this.blobMsg.createTemporaryLob(conn, cache, duration);
                    break;
                }
                case 2005: {
                    result = this.clobMsg.createTemporaryLob(conn, cache, duration, (int)form);
                    break;
                }
                default: {
                    DBError.check_error((int)438);
                    break;
                }
            }
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.createTemporaryLob: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.createTemporaryLob:return: " + result));
        }
        return result;
    }

    public synchronized void freeTemporaryLob(Connection conn, Datum temp_lob, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.freeTemporaryLob(conn=" + conn + ", temp_lob=" + temp_lob + ", type=" + type + ")"));
        }
        this.assertLoggedIn("TTC7Protocol.freeTemporaryLob");
        this.assertNotNull(temp_lob.shareBytes(), "TTC7Protocol.freeTemporaryLob");
        try {
            switch (type) {
                case -13: {
                    this.bfileMsg.freeTemporaryLob(temp_lob.shareBytes());
                    break;
                }
                case 2004: {
                    this.blobMsg.freeTemporaryLob(temp_lob.shareBytes());
                    break;
                }
                case 2005: {
                    this.clobMsg.freeTemporaryLob(temp_lob.shareBytes());
                    break;
                }
                default: {
                    DBError.check_error((int)438);
                    break;
                }
            }
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.freeTemporaryLob: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.freeTemporaryLob:return");
        }
    }

    public synchronized void openLob(Connection conn, Datum lob, int mode, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.openLob(conn=" + conn + ", oracle.sql.Datum lob=" + lob + ", mode=" + mode + ", type=" + type + ")"));
        }
        this.assertLoggedIn("TTC7Protocol.openLob");
        this.assertNotNull(lob.shareBytes(), "TTC7Protocol.openLob");
        try {
            switch (type) {
                case -13: {
                    this.bfileMsg.open(lob.shareBytes(), mode);
                    break;
                }
                case 2004: {
                    this.blobMsg.open(lob.shareBytes(), mode);
                    break;
                }
                case 2005: {
                    this.clobMsg.open(lob.shareBytes(), mode);
                    break;
                }
                default: {
                    DBError.check_error((int)438);
                    break;
                }
            }
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.openLob: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.openLob:return");
        }
    }

    public synchronized void closeLob(Connection conn, Datum lob, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.closeLob(conn=" + conn + ", oracle.sql.Datum lob=" + lob + ", type=" + type + ")"));
        }
        this.assertLoggedIn("TTC7Protocol.closeLob");
        this.assertNotNull(lob.shareBytes(), "TTC7Protocol.closeLob");
        try {
            switch (type) {
                case -13: {
                    this.bfileMsg.close(lob.shareBytes());
                    break;
                }
                case 2004: {
                    this.blobMsg.close(lob.shareBytes());
                    break;
                }
                case 2005: {
                    this.clobMsg.close(lob.shareBytes());
                    break;
                }
                default: {
                    DBError.check_error((int)438);
                    break;
                }
            }
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.closeLob: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)"TTC7Protocol.closeLob:return");
        }
    }

    public synchronized boolean isLobOpen(Connection conn, Datum lob, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.isLobOpen(conn=" + conn + ", oracle.sql.Datum lob=" + lob + ", type=" + type + ")"));
        }
        boolean result = false;
        this.assertLoggedIn("TTC7Protocol.isLobOpen");
        this.assertNotNull(lob.shareBytes(), "TTC7Protocol.isLobOpen");
        try {
            switch (type) {
                case -13: {
                    result = this.bfileMsg.isOpen(lob.shareBytes());
                    break;
                }
                case 2004: {
                    result = this.blobMsg.isOpen(lob.shareBytes());
                    break;
                }
                case 2005: {
                    result = this.clobMsg.isOpen(lob.shareBytes());
                    break;
                }
                default: {
                    DBError.check_error((int)438);
                    break;
                }
            }
        }
        catch (IOException ex) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)32, (int)256, (int)4, (String)"TTC7Protocol.isLobOpen: IOException");
            }
            this.handleIOException(ex);
            DBError.throwSqlException((IOException)ex);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)32, (int)256, (int)16, (String)("TTC7Protocol.isLobOpen:return: " + result));
        }
        return result;
    }

    public synchronized Properties getDBAccessProperties() throws SQLException {
        return null;
    }

    public int getMaxCharSize() throws SQLException {
        return this.MEngine.conv.getMaxCharSize();
    }

    public Class safelyGetClassForName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    void handleIOException(IOException ea) throws SQLException {
        try {
            if (this.m_connection != null) {
                this.m_connection.internalClose((DBAccess)this);
            }
            if (this.net != null) {
                this.net.disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DBError.throwSqlException((IOException)ea);
    }

    static {
        MIN_OVERSION_SUPPORTED = (short)7230;
        MIN_TTCVER_SUPPORTED = (short)4;
        V8_TTCVER_SUPPORTED = (short)5;
        MAX_TTCVER_SUPPORTED = (short)6;
        DEFAULT_CONNECT_STRING = DEFAULT_CONNECT_STRING;
        STREAM_CHUNK_SIZE = 255;
        REFCURSOR_SIZE = 5;
        SYSDBA = 8L;
        SYSOPER = 16L;
        PARSE_CALL = 1;
        PARSE_EXECUTE_CALL = (byte)2;
        EXECUTE_FETCH_CALL = (byte)3;
        PARSE_EXECUTE_FETCH_CALL = (byte)4;
        FETCH_CALL = (byte)5;
    }
}

