/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class PlsqlTTCDataSet
extends TTCDataSet {
    private PlsqlTTCColumn[] columns;
    private byte[] userIOVector;
    private byte[] realIOVector;

    protected PlsqlTTCDataSet(PlsqlTTCColumn[] cols, byte[] iov) {
        super((TTCColumn[])cols, cols.length == 0 ? 0 : 1);
        this.columns = cols != null ? cols : new PlsqlTTCColumn[]{};
        this.userIOVector = iov;
    }

    protected void marshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error((int)423);
        }
        int i2 = 0;
        while (i2 < this.realIOVector.length) {
            if ((this.realIOVector[i2] & 0x20) != 0) {
                this.columns[i2].marshal();
            }
            ++i2;
        }
        this.marshaledRows = 1;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error((int)423);
        }
        int i2 = 0;
        while (i2 < this.realIOVector.length) {
            if ((this.realIOVector[i2] & 0x10) != 0) {
                this.columns[i2].unmarshal();
            }
            ++i2;
        }
        this.unmarshaledRows = 1;
        return false;
    }

    protected boolean next() {
        return this.realIOVector != null;
    }

    protected void setIOVector(byte[] iov) {
        this.realIOVector = iov;
    }

    protected void print(int mod, int submod, int cat) {
        int i2;
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)" \n   ---- Enter: PlsqlTTCDataSet.print --- ");
        super.print(mod, submod, cat);
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"\n      +++ userIOVector info +++++++ ");
        if (this.userIOVector == null) {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)" User IOVector is NULL ");
        } else {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("      userIOVector.length = " + this.userIOVector.length));
            i2 = 0;
            while (i2 < this.userIOVector.length) {
                OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("      userIOVector[" + i2 + "] = " + this.userIOVector[i2]));
                ++i2;
            }
        }
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"      +++ End of userIOVector Info +++++++");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"\n      +++ realIOVector info +++++++");
        if (this.realIOVector == null) {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)" Real IOVector is NULL ");
        } else {
            OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("      realIOVector.length = " + this.realIOVector.length));
            i2 = 0;
            while (i2 < this.realIOVector.length) {
                OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)("       realIOVector[" + i2 + "] = " + this.realIOVector[i2]));
                ++i2;
            }
        }
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"      +++ End of realIOVector Info +++++++ ");
        OracleLog.print((Object)this, (int)mod, (int)submod, (int)cat, (String)"    ---- Exit: PlsqlTTCDataSet.print --- \n");
    }
}

